<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Room Booking Request</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background-color: #f4f4f4;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }
        .container {
            background-color: #f1f4eb;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            max-width: 600px;
            width: 100%;
        }
        p {
            line-height: 1.6;
        }
        a {
            color: #0066cc;
            text-decoration: none;
        }
        a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="container">
        <p>Dear Concern,</p>

        <p><?php echo e($description); ?>, we need the <?php echo e($room_no); ?> as per below schedule:</p>

        <p>Date: <?php echo e(date('d-M-Y',strtotime($meeting_date))); ?><br>
        Time: <?php echo e($start_time); ?> to <?php echo e($end_time); ?></p>

        <p>Thank you for your support.</p>

        <p>Thanks & Regards,</p>

        <p><?php echo e($name); ?><br>
        <?php echo e($designation_name); ?><br>
        <?php echo e($department_name); ?><br>
        E-mail: <a href="<?php echo e($email_address); ?>"><?php echo e($email_address); ?></a><br>
        Mobile: <?php echo e($contact_no); ?></p>
    </div>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\npoly-ticketing-system\resources\views/emails/admin_meeting_mail.blade.php ENDPATH**/ ?>