<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Vehicle Booking Request</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background-color: #f4f4f4;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }
        .container {
            background-color: #f1f4eb;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            max-width: 600px;
            width: 100%;
        }
        p {
            line-height: 1.6;
        }
        a {
            color: #0066cc;
            text-decoration: none;
        }
        a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="container">
        <p>Dear Concern,</p>

        <p>I am sorry to notify you that your request for a vehicle has been denied. Below are the details of the request.</p>

        <p>Request Date: <?php echo e(date('d-M-Y',strtotime($from_date))); ?> To <?php echo e(date('d-M-Y',strtotime($to_date))); ?></p>
        <p>Visit Place: <?php echo e($visit_place); ?></p>
        <p>Pickup Time: <?php echo e(gmdate('h:i A',$start_time)); ?></p>

        <p>If you have any questions or need further clarification, please reach out me or submit a new request if required.</p>
        <p>Best Regards,</p>

        <p><?php echo e($name); ?><br>
        <?php echo e($designation_name); ?><br>
        <?php echo e($department_name); ?></p>
    </div>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\npoly-ticketing-system\resources\views/emails/vehicle_cancel_hod.blade.php ENDPATH**/ ?>