

<?php $__env->startSection('content'); ?>
<?php $__env->startSection('title'); ?>
<?php $__env->stopSection(); ?>
<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Map View</title>
    <script src="https://code.jquery.com/jquery-3.4.1.js"></script>
    <style type="text/css">
        #map {
            height: 400px;
        }
    </style>
</head>

<body>
    <div class="container mt-5">
        <div id="map"></div>
    </div>

    <script type="text/javascript">
    function initMap() {
        // Default center of the map
        const defaultCenter = { lat: 23.810331, lng: 90.412521 }; // Central point in Dhaka

        // Initialize the map
        const map = new google.maps.Map(document.getElementById("map"), {
            zoom: 10,
            center: defaultCenter,
        });

        try {
            // Array of locations from the server
            const locations = <?php echo json_encode($locations, 15, 512) ?>;

            if (!Array.isArray(locations)) {
                console.error("Locations data is not an array:", locations);
                return;
            }

            // Add markers for each location
            locations.forEach(location => {
                // Ensure latitude and longitude are valid numbers
                const lat = parseFloat(location.latitude);
                const lng = parseFloat(location.longitude);

                if (isNaN(lat) || isNaN(lng)) {
                    console.warn("Invalid coordinates for location:", location);
                    return;
                }

                const marker = new google.maps.Marker({
                    position: { lat, lng },
                    map: map,
                    title: `Employee: ${location.employee_number || 'Unknown'}`,
                });

                // Content for the info window
                const infoWindowContent = `
                    <div style="max-width: 200px;">
                        <h6>Employee: ${location.full_name + '(' + location.employee_number + ')' || 'N/A'}</h6>
                        ${location.img_url ? `<img src="${location.img_url}" alt="Employee Image" style="width: 100%; height: auto;" />` : ''}<br><br>
                        <p>
                        <strong>Mobile No:</strong> ${location.phone || 'N/A'}<br>
                        <strong>Card No:</strong> ${location.office_id_card || 'N/A'}<br>
                        <strong>Designation:</strong> ${location.designation
                         || 'N/A'}<br>
                        <strong>Attendance Type:</strong> ${location.attendance_type || 'N/A'}<br>
                        <strong>Date:</strong> ${moment(location.attendance_date).format("DD-MM-YYYY HH:mm:ss A") || 'N/A'}<br></p>
                    </div>
                `;

                const infoWindow = new google.maps.InfoWindow({
                    content: infoWindowContent,
                });

                marker.addListener("click", () => {
                    infoWindow.open(map, marker);
                });
            });
        } catch (error) {
            console.error("Error initializing map:", error);
        }
    }

    // Initialize the map
    window.initMap = initMap;
</script>

    <script type="text/javascript"
        src="https://maps.googleapis.com/maps/api/js?key=<?php echo e(config('app.google_map_key')); ?>&callback=initMap" async defer>
    </script>
</body>

</html>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\npoly-ticketing-system\resources\views/googleMapView.blade.php ENDPATH**/ ?>