<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Controller;
use App\Http\Controllers\BotManController;
use Illuminate\Http\Request;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

# Add this to header
//...
Route::get('/get_company_policy/{employeeNumber}', 'App\Http\Controllers\FontHomeController@getPolicy');
Route::post('company_handbook_status_change','App\Http\Controllers\FontHomeController@handbookStatusChange');
Route::match(['get', 'post'], '/botman', [BotManController::class,'handel']);
        Route::get('login', [LoginController::class, 'login'])->name('login');
        Route::get('home', [LoginController::class, 'home']);
        Route::get('logout', [LoginController::class, 'logout'])->name('logout');
        Route::get('/', 'App\Http\Controllers\FontHomeController@home');

        // change password ...
        Route::get('/changePassword',[App\Http\Controllers\custom_auth\ForgotPasswordController::class,'changePassword'])->name('changePassword');
        Route::post('/saveChangePassword',[App\Http\Controllers\custom_auth\ForgotPasswordController::class,'saveChangePassword'])->name('saveChangePassword');

          //Email
          Route::get('/forgetPassword',[App\Http\Controllers\custom_auth\ForgotPasswordController::class,'getEmail'])->name('forgetPassword');
          Route::post('/forgetPassword',[App\Http\Controllers\custom_auth\ForgotPasswordController::class,'postEmail'])->name('forgetPassword');
          Route::get('/resetPassword/{token}', [App\Http\Controllers\custom_auth\ResetPasswordController::class,'getPassword'])->name('resetPassword');
          Route::post('/resetPassword', [App\Http\Controllers\custom_auth\ResetPasswordController::class,'PostPassword'])->name('resetPassword');

        //start backend route
        Auth::routes();
        Route::group(['middleware' => ['auth'],['prevent-back-history']], function(){

        Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
        Route::get('/support_home', [App\Http\Controllers\HomeController::class, 'support_index'])->name('support_home');


        //start Modules route
        Route::get('/moduleSetup', [App\Http\Controllers\security_access\ModulesController::class, 'index'])->name('moduleSetup');
        Route::get('/creatModuleSetup', [App\Http\Controllers\security_access\ModulesController::class, 'create'])->name('creatModuleSetup');

        Route::post('/storemoduleSetup', [App\Http\Controllers\security_access\ModulesController::class, 'store'])->name('storeModuleSetup');
        Route::get('/editemoduleSetup/{id}', [App\Http\Controllers\security_access\ModulesController::class, 'edit'])->name('edit');
        Route::post('/updatemoduleSetup/{id}', [App\Http\Controllers\security_access\ModulesController::class, 'update'])->name('update');
        //start Modules links route

        //start mobile apps Modules route
        Route::get('/mobileModuleSetup', [App\Http\Controllers\security_access\MobileModulesController::class, 'index'])->name('mobileModuleSetup');
        Route::get('/creatMobileModuleSetup', [App\Http\Controllers\security_access\MobileModulesController::class, 'create'])->name('creatMobileModuleSetup');
        Route::post('/storeMobileModuleSetup', [App\Http\Controllers\security_access\MobileModulesController::class, 'store'])->name('storeMobileModuleSetup');
        Route::get('/editMobileModuleSetup/{id}', [App\Http\Controllers\security_access\MobileModulesController::class, 'edit'])->name('editMobileModuleSetup');
        Route::post('/updateMobileModuleSetup/{id}', [App\Http\Controllers\security_access\MobileModulesController::class, 'update'])->name('updateMobileModuleSetup');
      
        //start mobile apps Modules Screen route
        Route::get('/mobileModuleScreenSetup', [App\Http\Controllers\security_access\MobileModulesScreenController::class, 'index'])->name('mobileModuleScreenSetup');
        Route::get('/creatMobileModuleScreenSetup', [App\Http\Controllers\security_access\MobileModulesScreenController::class, 'create'])->name('creatMobileModuleScreenSetup');
        Route::post('/storeMobileModuleScreenSetup', [App\Http\Controllers\security_access\MobileModulesScreenController::class, 'store'])->name('storeMobileModuleScreenSetup');
        Route::get('/editMobileModuleScreenSetup/{id}', [App\Http\Controllers\security_access\MobileModulesScreenController::class, 'edit'])->name('editMobileModuleScreenSetup');
        Route::post('/updateMobileModuleScreenSetup/{id}', [App\Http\Controllers\security_access\MobileModulesScreenController::class, 'update'])->name('updateMobileModuleScreenSetup');
       
        Route::get('/moduleLinkSetup', [App\Http\Controllers\security_access\ModuleLinksController::class, 'index'])->name('moduleLinkSetup');
        Route::get('/createModuleLinkSetup', [App\Http\Controllers\security_access\ModuleLinksController::class, 'create'])->name('createModuleLinkSetup');
        Route::post('/storeModuleLinkSetup', [App\Http\Controllers\security_access\ModuleLinksController::class, 'store'])->name('storeModuleLinkSetup');
        Route::get('/editModuleLinkSetup/{id}', [App\Http\Controllers\security_access\ModuleLinksController::class, 'edit'])->name('edit');
        Route::post('/updateModuleLinkSetup/{id}', [App\Http\Controllers\security_access\ModuleLinksController::class, 'update'])->name('update');
        //end Modules links route
        //start Modules Manage route
        Route::get('/moduleManage', [App\Http\Controllers\security_access\ModuleManageController::class, 'index'])->name('moduleManage');
        Route::get('/createGroup/{id}', [App\Http\Controllers\security_access\ModuleManageController::class, 'createGroup'])->name('createGroup');
        Route::get('/createUser/{id}', [App\Http\Controllers\security_access\ModuleManageController::class, 'createUser'])->name('createUser');
        Route::get('/assignModul', [App\Http\Controllers\security_access\ModuleManageController::class, 'assignModul'])->name('assignModul');
        Route::get('/addPage/{id}', [App\Http\Controllers\security_access\ModuleManageController::class, 'addPage'])->name('addPage');
        Route::post('/addModulesInsert', [App\Http\Controllers\security_access\ModuleManageController::class, 'addModules'])->name('addModules');
        Route::post('/deleteModules', [App\Http\Controllers\security_access\ModuleManageController::class, 'deleteModules'])->name('deleteModules');

        //end Modules Manage route

        // Modules Manage  New User
        Route::get('/userIndex', [App\Http\Controllers\security_access\ModuleManageController::class, 'userIndex'])->name('userIndex');
        Route::get('/searchUser/{type}/{dept}/{course}', [App\Http\Controllers\security_access\ModuleManageController::class, 'searchUser'])->name('searchUser');
        Route::get('/createUser', [App\Http\Controllers\security_access\ModuleManageController::class, 'createUser'])->name('createUser');
        Route::post('/storeUser', [App\Http\Controllers\security_access\ModuleManageController::class, 'store'])->name('store');
        Route::match(array('get','post'),'/updateUser/{userId}', [App\Http\Controllers\security_access\ModuleManageController::class, 'updateUser'])->name('updateUser');
        Route::match(array('get','post'),'/updateMobileUser/{userId}', [App\Http\Controllers\security_access\ModuleManageController::class, 'updateMobileUser'])->name('updateMobileUser');

        Route::post('/userGroupLevel', [App\Http\Controllers\security_access\ModuleManageController::class, 'userGroupLevel'])->name('userGroupLevel');
        Route::get('/approveMobileUser', [App\Http\Controllers\security_access\ModuleManageController::class, 'approveMobileUser'])->name('approveMobileUser');

        //  Modules Manage group
        Route::get('/groupIndex', [App\Http\Controllers\security_access\ModuleManageController::class, 'groupIndex'])->name('groupIndex');
        Route::get('/createGroup', [App\Http\Controllers\security_access\GroupController::class, 'createGroup'])->name('createGroup');
        Route::post('/storeGroup', [App\Http\Controllers\security_access\ModuleManageController::class, 'storeGroup'])->name('storeGroup');

        //  Modules Manage user group level
        Route::get('/createLevel/{id}', [App\Http\Controllers\security_access\ModuleManageController::class, 'createLevel'])->name('createLevel');
        Route::post('/storeLevel', [App\Http\Controllers\security_access\ModuleManageController::class, 'storeLevel'])->name('storeLevel');
        Route::get('/editLevel/{id}', [App\Http\Controllers\security_access\ModuleManageController::class, 'editLevel'])->name('editLevel');
        Route::post('/updateLevel/{id}', [App\Http\Controllers\security_access\ModuleManageController::class, 'updateLevel'])->name('updateLevel');
        Route::post('/insertPageLinkStatus', [App\Http\Controllers\security_access\ModuleManageController::class, 'insertPageLinkStatus'])->name('insertPageLinkStatus');

        // Modules Manage  add page
        Route::get('/addPage', [App\Http\Controllers\security_access\ModuleManageController::class, 'addPage'])->name('addPage');
        Route::get('/createPage', [App\Http\Controllers\security_access\ModuleManageController::class, 'createPage'])->name('createPage');
        Route::post('/addPageLink', [App\Http\Controllers\security_access\ModuleManageController::class, 'addPageLink'])->name('addPageLink');


        Route::post('/changePageLinkStatus', [App\Http\Controllers\security_access\ModuleManageController::class, 'changePageLinkStatus'])->name('changePageLinkStatus');
        Route::post('/changePageLinkRead', [App\Http\Controllers\security_access\ModuleManageController::class, 'changePageLinkRead'])->name('changePageLinkRead');
        Route::post('/changePageLinkDelete', [App\Http\Controllers\security_access\ModuleManageController::class, 'changePageLinkDelete'])->name('changePageLinkDelete');

        Route::post('/addPageLink', [App\Http\Controllers\security_access\ModuleManageController::class, 'addPageLink'])->name('addPageLink');
        Route::post('/changePageLinkCreate', [App\Http\Controllers\security_access\ModuleManageController::class, 'changePageLinkCreate'])->name('changePageLinkCreate');


        Route::post('/updatePageLink', [App\Http\Controllers\security_access\ModuleManageController::class, 'updatePageLink'])->name('updatePageLink');
// Mobile Screen Manage add page

Route::get('/addScreen', [App\Http\Controllers\security_access\MobileModuleManageController::class, 'addScreen'])->name('addScreen');
Route::post('/assingScreenLinkUsergroup', [App\Http\Controllers\security_access\MobileModuleManageController::class, 'assingScreenLinkUsergroup'])->name('assingScreenLinkUsergroup');
Route::post('/assingScreenLinkUserLevel', [App\Http\Controllers\security_access\MobileModuleManageController::class, 'assingScreenLinkUserLevel'])->name('assingScreenLinkUserLevel');
Route::post('/insertScreenLinkStatus', [App\Http\Controllers\security_access\MobileModuleManageController::class, 'insertScreenLinkStatus'])->name('insertScreenLinkStatus');
Route::post('/moduleScreenLinkUpdate', [App\Http\Controllers\security_access\MobileModuleManageController::class, 'moduleScreenLinkUpdate'])->name('moduleScreenLinkUpdate');
Route::post('/moduleScreenLinkCreate', [App\Http\Controllers\security_access\MobileModuleManageController::class, 'moduleScreenLinkCreate'])->name('moduleScreenLinkCreate');
Route::get('/createPage', [App\Http\Controllers\security_access\ModuleManageController::class, 'createPage'])->name('createPage');
Route::post('/addPageLink', [App\Http\Controllers\security_access\ModuleManageController::class, 'addPageLink'])->name('addPageLink');


Route::post('/changePageLinkStatus', [App\Http\Controllers\security_access\ModuleManageController::class, 'changePageLinkStatus'])->name('changePageLinkStatus');
Route::post('/changePageLinkRead', [App\Http\Controllers\security_access\ModuleManageController::class, 'changePageLinkRead'])->name('changePageLinkRead');
Route::post('/changePageLinkDelete', [App\Http\Controllers\security_access\ModuleManageController::class, 'changePageLinkDelete'])->name('changePageLinkDelete');

Route::post('/addPageLink', [App\Http\Controllers\security_access\ModuleManageController::class, 'addPageLink'])->name('addPageLink');
Route::post('/changePageLinkCreate', [App\Http\Controllers\security_access\ModuleManageController::class, 'changePageLinkCreate'])->name('changePageLinkCreate');


Route::post('/updatePageLink', [App\Http\Controllers\security_access\ModuleManageController::class, 'updatePageLink'])->name('updatePageLink');

        // Modules Manage  add page Module
        Route::get('/createPageModule', [App\Http\Controllers\security_access\ModuleManageController::class, 'createPageModule'])->name('createPageModule');

                //Start Topic Setup Route

         //Security Access Assing Link To Group
        Route::post('/assingLinkGroupLevel', [App\Http\Controllers\security_access\ModuleManageController::class, 'assingLinkGroupLevel'])->name('assingLinkGroupLevel');
        Route::post('/assingLinkUserLevel', [App\Http\Controllers\security_access\ModuleManageController::class, 'assingLinkUserLevel'])->name('assingLinkUserLevel');
        Route::post('/assingLinkUsergroup', [App\Http\Controllers\security_access\ModuleManageController::class, 'assingLinkUsergroup'])->name('assingLinkUsergroup');

        //Security Access Assing Link To Group
        Route::post('/assingLinkGroupLevel', [App\Http\Controllers\security_access\ModuleManageController::class, 'assingLinkGroupLevel'])->name('assingLinkGroupLevel');
        Route::post('/assingLinkUserLevel', [App\Http\Controllers\security_access\ModuleManageController::class, 'assingLinkUserLevel'])->name('assingLinkUserLevel');
        Route::post('/assingLinkUsergroup', [App\Http\Controllers\security_access\ModuleManageController::class, 'assingLinkUsergroup'])->name('assingLinkUsergroup');

        //Lookup  group and data
        Route::get('/lookupIndex', [App\Http\Controllers\lookup\LookupController::class, 'index'])->name('lookupIndex');
        Route::get('/createLookupGrpup', [App\Http\Controllers\lookup\LookupController::class, 'create'])->name('createLookupGrpup');
        Route::post('/storeLookupGroup', [App\Http\Controllers\lookup\LookupController::class, 'store'])->name('storeLookupGroup');
        Route::get('/createLookupGroupItem/{GROUP_ID}/{USE_CHAR_NUMB}', [App\Http\Controllers\lookup\LookupController::class, 'createLookupGroupItem'])->name('createLookupGroupItem');
        Route::post('/storeLookupGroupItem', [App\Http\Controllers\lookup\LookupController::class, 'storeLookupGroupItem'])->name('storeLookupGroupItem');
        Route::get('/editLookupGroupItem/{id}/{USE_CHAR_NUMB}', [App\Http\Controllers\lookup\LookupController::class, 'editLookupGroupItem'])->name('editLookupGroupItem');
        Route::post('/updateLookupGroupItem/{id}', [App\Http\Controllers\lookup\LookupController::class, 'updateLookupGroupItem'])->name('updateLookupGroupItem');

        // Start Department Setup Route
        Route::get('/departmentSetupIndex', [App\Http\Controllers\setup\DepartmentSetupController::class, 'index'])->name('departmentSetupIndex');
        Route::get('/createclientSetup', [App\Http\Controllers\support\ClientSetupController::class, 'create'])->name('createclientSetup');
        Route::post('/storeClient', [App\Http\Controllers\support\ClientSetupController::class, 'store'])->name('storeClient');
        Route::get('/updateClient/{id}', [App\Http\Controllers\support\ClientSetupController::class, 'edit'])->name('updateClient');
        Route::post('/updateClientInfo', [App\Http\Controllers\support\ClientSetupController::class, 'update'])->name('updateClientInfo');

        // Start Depo Setup Route
        Route::get('/depoSetupIndex', [App\Http\Controllers\support\DepoSetupController::class, 'index'])->name('depoSetupIndex');
        Route::get('/createDepoSetup', [App\Http\Controllers\support\DepoSetupController::class, 'create'])->name('createDepoSetup');
        Route::post('/storeDepo', [App\Http\Controllers\support\DepoSetupController::class, 'store'])->name('storeDepo');
        Route::get('/updateDepo/{id}', [App\Http\Controllers\support\DepoSetupController::class, 'edit'])->name('updateDepo');
        Route::post('/updateDepoInfo', [App\Http\Controllers\support\DepoSetupController::class, 'update'])->name('updateDepoInfo');

        // Start Driver Setup Route
        Route::get('/driverSetupIndex', [App\Http\Controllers\support\DriverSetupController::class, 'index'])->name('driverSetupIndex');
        Route::get('/createDriverSetup', [App\Http\Controllers\support\DriverSetupController::class, 'create'])->name('createDriverSetup');
        Route::post('/storeDriver', [App\Http\Controllers\support\DriverSetupController::class, 'store'])->name('storeDriver');
        Route::get('/updateDriver/{id}', [App\Http\Controllers\support\DriverSetupController::class, 'edit'])->name('updateDriver');
        Route::post('/updateDriverInfo', [App\Http\Controllers\support\DriverSetupController::class, 'update'])->name('updateDriverInfo');

         // Start Vehicel Setup Route
         Route::get('/vehicelSetupIndex', [App\Http\Controllers\support\VehicelSetupController::class, 'index'])->name('vehicelSetupIndex');
         Route::get('/createVehicelSetup', [App\Http\Controllers\support\VehicelSetupController::class, 'create'])->name('createVehicelSetup');
         Route::post('/storeVehice', [App\Http\Controllers\support\VehicelSetupController::class, 'store'])->name('storeVehice');
         Route::get('/updateVehice/{id}', [App\Http\Controllers\support\VehicelSetupController::class, 'edit'])->name('updateVehice');
         Route::post('/updateVehiceInfo', [App\Http\Controllers\support\VehicelSetupController::class, 'update'])->name('updateVehiceInfo');

         // Start Vehicel Route
         
         // Start Vehicel Route
         
        //  Route::get('vehicelIndex', [App\Http\Controllers\vehicle\VehicleController::class, 'index'])->name('vehicelIndex');
        //  Route::get('createVehicelRequest', [App\Http\Controllers\vehicle\VehicleController::class, 'create'])->name('createVehicelRequest');
        //  Route::get('multiReqApprove/{ids}', [App\Http\Controllers\vehicle\VehicleController::class, 'multiReqApprove'])->name('multiReqApprove');
        //  Route::post('storeVehicleRequest', [App\Http\Controllers\vehicle\VehicleController::class, 'store'])->name('storeVehicleRequest');
        //  Route::get('approveRequestByAdmin/{reqId}', [App\Http\Controllers\vehicle\VehicleController::class, 'approveRequest'])->name('approveRequestByAdmin');
        //  Route::get('updateVehiceRequest/{reqId}', [App\Http\Controllers\vehicle\VehicleController::class, 'updateRequest'])->name('updateVehiceRequest');
        //  Route::post('updateRequest', [App\Http\Controllers\vehicle\VehicleController::class, 'update'])->name('updateRequest');
        //  Route::post('approveRequestByAdmin', [App\Http\Controllers\vehicle\VehicleController::class, 'approveByAdmin'])->name('approveRequestByAdmin');
        //  Route::post('apprMultiReqByAdmin', [App\Http\Controllers\vehicle\VehicleController::class, 'apprMultiReqByAdmin'])->name('apprMultiReqByAdmin');
        //  // vehicle info
        //  Route::get('vehicelInfo', [App\Http\Controllers\vehicle\VehicleController::class, 'vehiceBookedlInfo'])->name('vehicelInfo');
        //  Route::get('participant_list/{ids}', [App\Http\Controllers\vehicle\VehicleController::class, 'participantList'])->name('participant_list');

        Route::get('vehicelIndex', [App\Http\Controllers\vehicle\VehicleController::class, 'index'])->name('vehicelIndex');
        Route::get('approvalIndex', [App\Http\Controllers\vehicle\VehicleController::class, 'approvalIndex'])->name('approvalIndex');
        Route::get('createVehicelRequest', [App\Http\Controllers\vehicle\VehicleController::class, 'create'])->name('createVehicelRequest');
        Route::get('multiReqApprove/{ids}', [App\Http\Controllers\vehicle\VehicleController::class, 'multiReqApprove'])->name('multiReqApprove');
        Route::get('participant_list/{ids}', [App\Http\Controllers\vehicle\VehicleController::class, 'participantList'])->name('participant_list');
        Route::post('storeVehicleRequest', [App\Http\Controllers\vehicle\VehicleController::class, 'store'])->name('storeVehicleRequest');
        Route::get('approveRequestByAdmin/{reqId}', [App\Http\Controllers\vehicle\VehicleController::class, 'approveRequest'])->name('approveRequestByAdmin');
        Route::get('updateVehiceRequest/{reqId}', [App\Http\Controllers\vehicle\VehicleController::class, 'updateRequest'])->name('updateVehiceRequest');
        Route::post('updateRequest', [App\Http\Controllers\vehicle\VehicleController::class, 'update'])->name('updateRequest');
        Route::post('approveRequestByAdmin', [App\Http\Controllers\vehicle\VehicleController::class, 'approveByAdmin'])->name('approveRequestByAdmin');
        Route::post('apprMultiReqByAdmin', [App\Http\Controllers\vehicle\VehicleController::class, 'apprMultiReqByAdmin'])->name('apprMultiReqByAdmin');
        Route::get('vehicleReport', [App\Http\Controllers\vehicle\VehicleController::class, 'vehicleReport'])->name('vehicleReport');
         Route::get('search_vehicle_report', [App\Http\Controllers\vehicle\VehicleController::class, 'searchVehicleReport'])->name('search_vehicle_report');
        // vehicle info
        Route::get('vehicelInfo', [App\Http\Controllers\vehicle\VehicleController::class, 'vehiceBookedlInfo'])->name('vehicelInfo');
        Route::get('/getTotalVehicleRequest', [App\Http\Controllers\vehicle\VehicleController::class, 'getTotalVehicleRequest'])->name('getTotalVehicleRequest');


        // Meeting Particular setup
        Route::get('/meetingParticularSetupIndex', [App\Http\Controllers\meeting_room\MeetingRoomController::class, 'meetingParticular'])->name('meetingParticularSetupIndex');
        Route::get('/createMeetingParticular', [App\Http\Controllers\meeting_room\MeetingRoomController::class, 'createParticular'])->name('createMeetingParticular');
        Route::post('/storeParticular', [App\Http\Controllers\meeting_room\MeetingRoomController::class, 'storeParticular'])->name('storeParticular');
        Route::match(array('get','post'),'/updateParticular/{id}', [App\Http\Controllers\meeting_room\MeetingRoomController::class, 'editParticular'])->name('updateParticular');
        

        // Start Client Setup Route
        Route::get('/clientSetupIndex', [App\Http\Controllers\support\ClientSetupController::class, 'index'])->name('clientSetupIndex');
        Route::get('/createclientSetup', [App\Http\Controllers\support\ClientSetupController::class, 'create'])->name('createclientSetup');
        Route::post('/storeClient', [App\Http\Controllers\support\ClientSetupController::class, 'store'])->name('storeClient');
        Route::get('/updateClient/{id}', [App\Http\Controllers\support\ClientSetupController::class, 'edit'])->name('updateClient');
        Route::post('/updateClientInfo', [App\Http\Controllers\support\ClientSetupController::class, 'update'])->name('updateClientInfo');

        // Start Project setup Route
        Route::get('/projectSetupIndex', [App\Http\Controllers\support\ProjectSetupController::class, 'index'])->name('projectSetupIndex');
        Route::get('/createProjectSetup', [App\Http\Controllers\support\ProjectSetupController::class, 'create'])->name('createProjectSetup');
        Route::post('/storeProject', [App\Http\Controllers\support\ProjectSetupController::class, 'store'])->name('storeProject');
        Route::get('/updateProject/{id}', [App\Http\Controllers\support\ProjectSetupController::class, 'edit'])->name('updateProject');
        Route::post('/updateProjectInfo', [App\Http\Controllers\support\ProjectSetupController::class, 'update'])->name('updateProjectInfo');
        Route::get('/documentationIndex', [App\Http\Controllers\support\ProjectSetupController::class, 'documentIndex'])->name('documentationIndex');

        // Start News Setup Route
        Route::get('/newsSetupIndex', [App\Http\Controllers\support\NewsSetupController::class, 'index'])->name('newsSetupIndex');
        Route::get('/createNewsSetup', [App\Http\Controllers\support\NewsSetupController::class, 'create'])->name('createNewsSetup');
        Route::post('/storeNews', [App\Http\Controllers\support\NewsSetupController::class, 'store'])->name('storeNews');
        Route::get('/updateNews/{id}', [App\Http\Controllers\support\NewsSetupController::class, 'edit'])->name('updateNews');
        Route::post('/updateNewsInfo', [App\Http\Controllers\support\NewsSetupController::class, 'update'])->name('updateNewsInfo');

        // Support Module Setup Route
        Route::get('/supportModuleIndex', [App\Http\Controllers\support\SupportModuleSetupController::class, 'index'])->name('supportModuleIndex');
        Route::get('/createModuleSetup', [App\Http\Controllers\support\SupportModuleSetupController::class, 'create'])->name('createModuleSetup');
        Route::post('/storeSupportModule', [App\Http\Controllers\support\SupportModuleSetupController::class, 'store'])->name('storeSupportModule');
        Route::get('/updateSupportModule/{id}', [App\Http\Controllers\support\SupportModuleSetupController::class, 'edit'])->name('updateSupportModule');
        Route::post('/updateSupportModuleInfo', [App\Http\Controllers\support\SupportModuleSetupController::class, 'update'])->name('updateSupportModuleInfo');

        // kpi setup
        Route::get('/kpiIndex', [App\Http\Controllers\support\KpiSetupController::class, 'index'])->name('kpiIndex');
        Route::get('/createKpi', [App\Http\Controllers\support\KpiSetupController::class, 'create'])->name('createKpi');
        Route::get('/createKpi/{deptId}', [App\Http\Controllers\support\KpiSetupController::class, 'createKpi'])->name('createKpi/{deptId}');
        Route::post('/storeKpi', [App\Http\Controllers\support\KpiSetupController::class, 'store'])->name('storeKpi');
        Route::post('/storeAllDeptKpi', [App\Http\Controllers\support\KpiSetupController::class, 'storeAllDept'])->name('storeAllDeptKpi');
        Route::get('/updateKpi/{id}', [App\Http\Controllers\support\KpiSetupController::class, 'edit'])->name('updateKpi');
        Route::post('/updateKpiInfo', [App\Http\Controllers\support\KpiSetupController::class, 'update'])->name('updateKpiInfo');

        Route::get('/kpiAssign/{id}', [App\Http\Controllers\support\KpiSetupController::class, 'kpiAssign'])->name('kpiAssign');
        Route::post('/storeKpiAssignToEmp', [App\Http\Controllers\support\KpiSetupController::class, 'storeKpiAssign'])->name('storeKpiAssignToEmp');

        // KPI Approve
        Route::get('/kpiIApprovendex', [App\Http\Controllers\support\KpiSetupController::class, 'kpiIApprovendex'])->name('kpiIApprovendex');
        Route::get('/createApproveKpi', [App\Http\Controllers\support\KpiSetupController::class, 'createApprove'])->name('createApproveKpi');
        Route::get('/update_approve_kpi/{id}', [App\Http\Controllers\support\KpiSetupController::class, 'updateApproveKpiPath'])->name('update_approve_kpi/{id}');
        Route::post('/storeKpiApprove', [App\Http\Controllers\support\KpiSetupController::class, 'storeKpi'])->name('storeKpiApprove');
        Route::post('/updateKpiApprove', [App\Http\Controllers\support\KpiSetupController::class, 'updateKpiApprove'])->name('updateKpiApprove');
        Route::post('/approve_all_kpi_info', [App\Http\Controllers\support\KpiSetupController::class, 'approveAllKpiInfo'])->name('approve_all_kpi_info');
        Route::post('/approve_kpi_info/{deptId}', [App\Http\Controllers\support\KpiSetupController::class, 'approveKpiInfo'])->name('approve_kpi_info/{deptId}');
        Route::get('/edit_kpi_approval_path_innfo/{id}', [App\Http\Controllers\support\KpiSetupController::class, 'editApprovalPathInfo'])->name('edit_kpi_approval_path_innfo/{id}');

        //Start Ticket Route
        Route::get('/ticketIndex', [App\Http\Controllers\support\TicketController::class, 'index'])->name('ticketIndex');
        Route::get('/deptTicket', [App\Http\Controllers\support\TicketController::class, 'deptTicket'])->name('deptTicket');
        Route::get('/ticket_serach_date_wise', [App\Http\Controllers\support\TicketController::class, 'serachDateWiseTicket'])->name('ticket_serach_date_wise');
        Route::get('/createTicket', [App\Http\Controllers\support\TicketController::class, 'create'])->name('createTicket');
        Route::post('/storeTicket', [App\Http\Controllers\support\TicketController::class, 'store'])->name('storeTicket');
        Route::get('/updateTicketAssign/{id}', [App\Http\Controllers\support\TicketController::class, 'edit'])->name('updateTicketAssign');
        Route::get('/updateDeptTicketAssign/{id}', [App\Http\Controllers\support\TicketController::class, 'editDeptTicket'])->name('updateDeptTicketAssign');
        Route::match(array('get','post'),'/fordwardTicketAssign/{id}', [App\Http\Controllers\support\TicketController::class, 'fordwardTicket'])->name('fordwardTicketAssign');
        Route::match(array('get','post'),'/fordwardTicket', [App\Http\Controllers\support\TicketController::class, 'ticketForward'])->name('fordwardTicket');
        Route::post('/updateTaskAssign', [App\Http\Controllers\support\TicketController::class, 'update'])->name('updateTaskAssign');
        Route::post('/getTicketInfo', [App\Http\Controllers\support\TicketController::class, 'ticketInfo'])->name('getTicketInfo');
        Route::post('/getTicketStatus', [App\Http\Controllers\support\TicketController::class, 'getTicketStatus'])->name('getTicketStatus');
        Route::post('/getTicketAssignInfo', [App\Http\Controllers\support\TicketController::class, 'getTicketAssignInfo'])->name('getTicketAssignInfo');
        Route::post('/editTicketInfo', [App\Http\Controllers\support\TicketController::class, 'editTicketInfo'])->name('editTicketInfo');
        Route::post('/editTicketForwardInfo', [App\Http\Controllers\support\TicketController::class, 'editTicketForwardInfo'])->name('editTicketForwardInfo');
        Route::post('/editStatusInfo', [App\Http\Controllers\support\TicketController::class, 'editStatusInfo'])->name('editStatusInfo');
        Route::post('/editAssignInfo', [App\Http\Controllers\support\TicketController::class, 'editAssignInfo'])->name('editAssignInfo');
        Route::post('/editReAssignInfo', [App\Http\Controllers\support\TicketController::class, 'editReAssignInfo'])->name('editReAssignInfo');
        Route::post('/updateTicketBasicInfo', [App\Http\Controllers\support\TicketController::class, 'updateBasicInfo'])->name('updateTicketBasicInfo');
        Route::post('/updateTicketForwardDeptInfo', [App\Http\Controllers\support\TicketController::class, 'updateTicketForwardDeptInfo'])->name('updateTicketForwardDeptInfo');
        Route::post('/updateTicketStatusInfo', [App\Http\Controllers\support\TicketController::class, 'updateStatusInfo'])->name('updateTicketStatusInfo');
        Route::post('/updateTicketAssignInfo', [App\Http\Controllers\support\TicketController::class, 'updateAssignInfo'])->name('updateTicketAssignInfo');
        Route::post('/updateTicketReAssignInfo', [App\Http\Controllers\support\TicketController::class, 'updateTicketReAssignInfo'])->name('updateTicketReAssignInfo');
        Route::get('/ticket/getProject/{clientId}', [App\Http\Controllers\support\TicketController::class, 'getPorject']);
        Route::get('/getEmployee/{departmentId}', [App\Http\Controllers\support\TicketController::class, 'getEmployee']);
        Route::get('/getIssueGroup/{departmentId}', [App\Http\Controllers\support\TicketController::class, 'getIssueGroup']);

        // Schedule route 
        Route::get('/scheduleIndex', [App\Http\Controllers\schedule\ScheduleController::class, 'index'])->name('scheduleIndex');
        Route::get('/createSchedule', [App\Http\Controllers\schedule\ScheduleController::class, 'create'])->name('createSchedule');
        Route::post('/storeSchedule', [App\Http\Controllers\schedule\ScheduleController::class, 'store'])->name('storeSchedule');
        // Meeting room booking route
        // Route::get('/meetingIndex', [App\Http\Controllers\meeting_room\MeetingRoomController::class, 'index'])->name('meetingIndex');
        // Route::get('/createMeeting', [App\Http\Controllers\meeting_room\MeetingRoomController::class, 'create'])->name('createMeeting');
        // Route::match(array('get','post'),'/updateMeeting/{id}', [App\Http\Controllers\meeting_room\MeetingRoomController::class, 'update'])->name('updateMeeting');
        // Route::post('/storeMeeting', [App\Http\Controllers\meeting_room\MeetingRoomController::class, 'store'])->name('storeMeeting');
        // Route::post('/checkMeetingRoom', [App\Http\Controllers\meeting_room\MeetingRoomController::class, 'checkRoom'])->name('checkMeetingRoom');
        // Route::post('/checkEmpMeeting', [App\Http\Controllers\meeting_room\MeetingRoomController::class, 'checkEmpMeeting'])->name('checkEmpMeeting');
        // Route::post('/checkAvailableTimeSlot', [App\Http\Controllers\meeting_room\MeetingRoomController::class, 'availableTimeSlot'])->name('checkAvailableTimeSlot');

        Route::get('/meetingIndex', [App\Http\Controllers\meeting_room\MeetingRoomController::class, 'index'])->name('meetingIndex');
        Route::get('/meetingReport', [App\Http\Controllers\meeting_room\MeetingRoomController::class, 'meetingReport'])->name('meetingReport');
        Route::get('/meeting_room_report', [App\Http\Controllers\meeting_room\MeetingRoomController::class, 'meetingRoomReport'])->name('meeting_room_report');
        Route::get('/selfMeetingIndex', [App\Http\Controllers\meeting_room\MeetingRoomController::class, 'selfMeetingIndex'])->name('selfMeetingIndex');
        Route::get('/createMeeting', [App\Http\Controllers\meeting_room\MeetingRoomController::class, 'create'])->name('createMeeting');
        Route::match(array('get','post'),'/updateMeeting/{id}', [App\Http\Controllers\meeting_room\MeetingRoomController::class, 'update'])->name('updateMeeting');
        Route::match(array('get','post'),'/updateMeetingStatus/{id}', [App\Http\Controllers\meeting_room\MeetingRoomController::class, 'updateMeetingStatus'])->name('updateMeetingStatus');
        Route::get('/meetingDetails/{meetingId}', [App\Http\Controllers\meeting_room\MeetingRoomController::class, 'meetingDetails']);
        Route::post('/storeMeeting', [App\Http\Controllers\meeting_room\MeetingRoomController::class, 'store'])->name('storeMeeting');
        Route::post('/checkMeetingRoom', [App\Http\Controllers\meeting_room\MeetingRoomController::class, 'checkRoom'])->name('checkMeetingRoom');
        Route::post('/checkEmpMeeting', [App\Http\Controllers\meeting_room\MeetingRoomController::class, 'checkEmpMeeting'])->name('checkEmpMeeting');
        Route::post('/checkAvailableTimeSlot', [App\Http\Controllers\meeting_room\MeetingRoomController::class, 'availableTimeSlot'])->name('checkAvailableTimeSlot');
        Route::post('/checkStaffPrePlan', [App\Http\Controllers\meal\MealController::class, 'checkStaffPrePlan'])->name('checkStaffPrePlan');
        // Meal route
        Route::get('/mealIndex', [App\Http\Controllers\meal\MealController::class, 'index'])->name('mealIndex');
        Route::get('meal-notification', [App\Http\Controllers\meal\MealController::class, 'notificationIndex'])->name('meal-notification');
        Route::match(array('get','post'),'/sendMealNotification', [App\Http\Controllers\meal\MealController::class, 'sendMealNotification'])->name('sendMealNotification');
        Route::get('/getEmpolyeeMealStatus', [App\Http\Controllers\meal\MealController::class, 'getEmpolyeeMealStatus'])->name('getEmpolyeeMealStatus');
        Route::get('/search_meal_status', [App\Http\Controllers\meal\MealController::class, 'searchMealStatus'])->name('search_meal_status');
        Route::get('/search_meal_meal_report', [App\Http\Controllers\meal\MealController::class, 'searchMealReport'])->name('search_meal_meal_report');
        Route::post('/getEmpolyeeMealStatusByDate', [App\Http\Controllers\meal\MealController::class, 'getEmpolyeeMealStatusByDate'])->name('getEmpolyeeMealStatusByDate');// need to add oracle
        Route::post('/updateSelfMealStatus', [App\Http\Controllers\meal\MealController::class, 'updateSelfMealStatus'])->name('updateSelfMealStatus');// need to add oracle
        Route::match(array('get','post'),'/updateMealInfo/{mealId}', [App\Http\Controllers\meal\MealController::class, 'updateMealInfo'])->name('updateMealInfo');
        Route::get('/staffMealIndexModify', [App\Http\Controllers\meal\MealController::class, 'staffMealIndexModify'])->name('staffMealIndexModify');
        Route::post('/getStaffEmpMealStatusByDate', [App\Http\Controllers\meal\MealController::class, 'getStaffEmpMealStatusByDate'])->name('getStaffEmpMealStatusByDate');
        Route::post('/updateStaffMealStatus', [App\Http\Controllers\meal\MealController::class, 'updateStaffMealStatus'])->name('updateStaffMealStatus');// meal_route_new
        //Route::post('/checkStaffPrePlan', [App\Http\Controllers\meal\MealController::class, 'checkStaffPrePlan'])->name('checkStaffPrePlan');
        Route::post('/staffMealCreateAdmin', [App\Http\Controllers\meal\MealController::class, 'staffMealCreateAdmin'])->name('staffMealCreateAdmin');
        Route::get('/search_staff_meal_status_change', [App\Http\Controllers\meal\MealController::class, 'searchStaffMealStatus'])->name('search_staff_meal_status_change');
        // Employee Self Meal
        Route::get('/selfMealIndex', [App\Http\Controllers\meal\MealController::class, 'selfMealIndex'])->name('selfMealIndex');
        Route::get('/selfMealIndexModify', [App\Http\Controllers\meal\MealController::class, 'selfMealIndexModify'])->name('selfMealIndexModify');
        Route::post('/changeMealStatus', [App\Http\Controllers\meal\MealController::class, 'changeMealStatus'])->name('changeMealStatus');
        Route::match(array('get','post'),'/updatEmpSelfMealSetting', [App\Http\Controllers\meal\MealController::class, 'updatEmpSelfMealSetting'])->name('updatEmpSelfMealSetting');
        // Guest meal route
        Route::get('/guestMealIndex', [App\Http\Controllers\meal\MealController::class, 'guestMealIndex'])->name('guestMealIndex');// need to add
        Route::get('/guestMealCreate', [App\Http\Controllers\meal\MealController::class, 'guestMealCreate'])->name('guestMealCreate');// need to add
        Route::post('/storeGuestMeal', [App\Http\Controllers\meal\MealController::class, 'storeGuestMeal'])->name('storeGuestMeal');// need to add
        Route::match(array('get','post'),'/request_approve/{reqId}', [App\Http\Controllers\meal\MealController::class, 'requestApprove'])->name('request_approve');// need to add
        // Staff Meal
        Route::get('/staffMealIndex', [App\Http\Controllers\meal\MealController::class, 'staffMealIndex'])->name('staffMealIndex');// need to add
        Route::match(array('get','post'),'/staffMealCreate', [App\Http\Controllers\meal\MealController::class, 'staffMealCreate'])->name('staffMealCreate');// need to add
        Route::match(array('get','post'),'/update_staff_meal/{mealId}', [App\Http\Controllers\meal\MealController::class, 'updateStaffMeal'])->name('update_staff_meal');// need to add
       
        // Meal Settiing 
        Route::get('/mealSettingIndex', [App\Http\Controllers\meal\MealController::class, 'mealSettingIndex'])->name('mealSettingIndex');
        Route::match(array('get','post'),'/createMealSetting', [App\Http\Controllers\meal\MealController::class, 'createMealSetting'])->name('createMealSetting');
        Route::match(array('get','post'),'/updateMealSetting/{id}', [App\Http\Controllers\meal\MealController::class, 'updateMealSetting'])->name('updateMealSetting');
        Route::match(array('get','post'),'/updatEmpSelfMealSetting', [App\Http\Controllers\meal\MealController::class, 'updatEmpSelfMealSetting'])->name('updatEmpSelfMealSetting');
        // meal status route 
        Route::get('/mealStatusIndex', [App\Http\Controllers\meal\MealController::class, 'mealStatusIndex'])->name('mealStatusIndex');
        Route::get('/mealReportIndex', [App\Http\Controllers\meal\MealController::class, 'mealReportIndex'])->name('mealReportIndex');
        Route::post('/checkPrePlan', [App\Http\Controllers\meal\MealController::class, 'checkPrePlan'])->name('checkPrePlan');
        Route::post('/selfMealCreate', [App\Http\Controllers\meal\MealController::class, 'selfMealCreate'])->name('selfMealCreate');
        // Support User Ticket Route
        Route::get('/createSupportTicket', [App\Http\Controllers\support\SupportTicketController::class, 'create'])->name('createSupportTicket');
        Route::post('/storeSupportTicket', [App\Http\Controllers\support\SupportTicketController::class, 'store'])->name('storeSupportTicket');
        Route::get('/supportTicketInfo', [App\Http\Controllers\support\SupportTicketController::class, 'supportTicketInfo'])->name('supportTicketInfo');
        Route::get('/getCloseTicket/{id}', [App\Http\Controllers\support\SupportTicketController::class, 'getCloseTicket'])->name('getCloseTicket');
        Route::get('/getTicketDetailsInfo/{id}', [App\Http\Controllers\support\SupportTicketController::class, 'getTicketDetailsInfo'])->name('getTicketDetailsInfo');
        Route::match(array('get','post'),'/updateTicketDetails/{id}', [App\Http\Controllers\support\SupportTicketController::class, 'updateTicketDetails'])->name('updateTicketDetails');
        Route::match(array('get','post'),'/updateTicketAttachment/{id}', [App\Http\Controllers\support\SupportTicketController::class, 'updateTicketAttachment'])->name('updateTicketAttachment');
        Route::match(array('get','post'),'/updateCloseTicket/{id}', [App\Http\Controllers\support\SupportTicketController::class, 'updateCloseTicket'])->name('updateCloseTicket');

        Route::post('storeSupportTicketInfo', [App\Http\Controllers\support\SupportTicketController::class, 'storeSupportTicketInfo'])->name('storeSupportTicketInfo');
        


        // Start Task Assign Route
        Route::get('/taskAssignIndex', [App\Http\Controllers\task_report\TaskReportController::class, 'index'])->name('taskAssignIndex');
        Route::get('/createTaskAssign', [App\Http\Controllers\task_report\TaskReportController::class, 'create'])->name('createTaskAssign');
        Route::post('/storeTaskAssign', [App\Http\Controllers\task_report\TaskReportController::class, 'store'])->name('storeTaskAssign');
        Route::get('/updateTaskAssign/{id}', [App\Http\Controllers\task_report\TaskReportController::class, 'edit'])->name('updateTaskAssign');
        Route::post('/updateTaskAssignInfo', [App\Http\Controllers\task_report\TaskReportController::class, 'update'])->name('updateTaskAssignInfo');

        // Task Report Route
        Route::get('/taskReportIndex', [App\Http\Controllers\task_report\TaskReportController::class, 'taskReportIndex'])->name('taskReportIndex');
        Route::get('/createTask', [App\Http\Controllers\task_report\TaskReportController::class, 'createTask'])->name('createTask');
        Route::post('/storeTask', [App\Http\Controllers\task_report\TaskReportController::class, 'storeTask'])->name('storeTask');
        Route::get('/updateTask/{id}', [App\Http\Controllers\task_report\TaskReportController::class, 'editTask'])->name('updateTask');
        Route::post('/updateTaskInfo', [App\Http\Controllers\task_report\TaskReportController::class, 'updateTask'])->name('updateTaskInfo');
        Route::get('/check_task_start_or_stop_status', [App\Http\Controllers\task_report\TaskReportController::class, 'checkStartStopStatus'])->name('check_task_start_or_stop_status');
        Route::get('/update_task_status', [App\Http\Controllers\task_report\TaskReportController::class, 'updateTaskStatus'])->name('update_task_status');
        Route::match(array('get','post'),'/assignTicketFordward/{taskId}', [App\Http\Controllers\task_report\TaskReportController::class, 'assignTicketFordward'])->name('assignTicketFordward');

        //Route::get('/studentInfo', [App\Http\Controllers\student_portal\StudentInfoController::class, 'index'])->name('studentInfo');
        //Route::post('storeStudentInfo', [App\Http\Controllers\student_portal\StudentInfoController::class, 'storeStudentInfo'])->name('storeStudentInfo');

        // Dept wises Task Report Route
        Route::get('/deptWiseTaskReportIndex', [App\Http\Controllers\task_report\TaskReportController::class, 'deptWiseTaskReportIndex'])->name('deptWiseTaskReportIndex');
        Route::get('/department_wise_task_report', [App\Http\Controllers\task_report\TaskReportController::class, 'deptWiseTaskReport'])->name('department_wise_task_report');

        // Month Wise Task Report
        Route::get('/monthWiseTaskReportIndex', [App\Http\Controllers\task_report\TaskReportController::class, 'monthWiseTaskReportIndex'])->name('monthWiseTaskReportIndex');
        Route::get('/month_wise_task_report', [App\Http\Controllers\task_report\TaskReportController::class, 'monthWiseTaskReport'])->name('month_wise_task_report');
        // department wise dashboard
        Route::get('/get_department_wise_dashboard', [App\Http\Controllers\DashboardController::class, 'deptWiseDashboard'])->name('get_department_wise_dashboard');
        Route::get('/get_total_task_dashboard_info', [App\Http\Controllers\DashboardController::class, 'getTotalTaskDashboardInfo'])->name('get_total_task_dashboard_info');
        Route::get('/get_dashboard_kpi_info', [App\Http\Controllers\DashboardController::class, 'getDashboardKpiInfo'])->name('get_dashboard_kpi_info');
        Route::get('/it_dept_task_info/{deptId}', [App\Http\Controllers\DashboardController::class, 'deptTaskInfo'])->name('it_dept_task_info/{deptId}');
        Route::get('/get_mis_kpi_info/{deptId}', [App\Http\Controllers\DashboardController::class, 'getMisItKpiInfo'])->name('get_mis_kpi_info/{deptId}');
        Route::get('/show_kpi_details_info/{empId}', [App\Http\Controllers\support\KpiSetupController::class, 'showKpiDetailsInfo'])->name('show_kpi_details_info/{empId}');
        Route::get('/get_working_kpi_info/{empId}', [App\Http\Controllers\support\KpiSetupController::class, 'workingKpiDetailsInfo'])->name('get_working_kpi_info/{empId}');
        Route::get('/get_pending_kpi_info/{empId}', [App\Http\Controllers\support\KpiSetupController::class, 'pendingKpiDetailsInfo'])->name('get_pending_kpi_info/{empId}');
        Route::get('/get_expire_kpi_info/{empId}', [App\Http\Controllers\support\KpiSetupController::class, 'expireKpiDetailsInfo'])->name('get_expire_kpi_info/{empId}');
        Route::get('/get_active_or_closed_kpi_info/{id}', [App\Http\Controllers\support\KpiSetupController::class, 'getActiveKpiInfo'])->name('get_active_or_closed_kpi_info/{id}');
        Route::get('/get_total_kpi_info', [App\Http\Controllers\DashboardController::class, 'getTotalKpiInfo'])->name('get_total_kpi_info');
        Route::get('/get_support_task_info/{ticket_status}', [App\Http\Controllers\DashboardController::class, 'getTicketStatusInfo'])->name('get_ticket_info');
        Route::get('/get_today_total_task_info', [App\Http\Controllers\DashboardController::class, 'getTodayTotalTaskInfo'])->name('get_today_total_task_info');
        Route::get('/get_today_running_task_info', [App\Http\Controllers\DashboardController::class, 'getTodayRunningTaskInfo'])->name('get_today_running_task_info');
        Route::get('/show_task_details_info/{empId}', [App\Http\Controllers\DashboardController::class, 'showTaskDetailsInfo'])->name('show_task_details_info/{empId}');
        Route::get('/show_pending_task_info/{empId}', [App\Http\Controllers\DashboardController::class, 'showPendingTaskInfo'])->name('show_pending_task_info/{empId}');
        Route::get('/show_complete_task_info/{empId}', [App\Http\Controllers\DashboardController::class, 'showCompleteTaskInfo'])->name('show_complete_task_info/{empId}');
        Route::get('/show_running_task_details_info/{empId}', [App\Http\Controllers\DashboardController::class, 'showTaskRunningDetailsInfo'])->name('show_running_task_details_info/{empId}');
        Route::get('/get_all_pending_task_details', [App\Http\Controllers\DashboardController::class, 'getAllPendingTaskDetails'])->name('get_all_pending_task_details');
        Route::get('/get_dept_wise_pending_task/{id}', [App\Http\Controllers\DashboardController::class, 'getDeptWisePendingTask'])->name('get_dept_wise_pending_task/{id}');

        Route::get('/today_dept_wise_task/{deptId}', [App\Http\Controllers\DashboardController::class, 'getTodayDeptTaskInfo'])->name('today_dept_wise_task/{deptId}');
        Route::get('/today_dept_wise_running_task/{deptId}', [App\Http\Controllers\DashboardController::class, 'getTodayDeptRunningTaskInfo'])->name('today_dept_wise_running_task/{deptId}');
        Route::get('/show_pending_task_details_info/{empId}', [App\Http\Controllers\DashboardController::class, 'showPendingTaskDetailsInfo'])->name('show_pending_task_details_info/{empId}');
        Route::get('/get_all_schedule_info', [App\Http\Controllers\DashboardController::class, 'getScheduleInfo'])->name('get_all_schedule_info');
        Route::get('/get_all_schedule_info_dept_wise/{id}', [App\Http\Controllers\DashboardController::class, 'getAllScheduleInfoDeptWise'])->name('get_all_schedule_info_dept_wise/{id}');
        Route::get('/get_schedule_info_dept_wise', [App\Http\Controllers\DashboardController::class, 'getSchleeduInfoDeptWise'])->name('get_schedule_info_dept_wise');
        Route::get('/show_schedule_details_info/{empId}', [App\Http\Controllers\DashboardController::class, 'getScheduleDetailsInfo'])->name('show_schedule_details_info/{empId}');

        // Task Report Mail Route
        Route::get('/taskReportMailIndex', [App\Http\Controllers\task_report\TaskReportController::class, 'taskReportMailIndex'])->name('taskReportMailIndex');
        Route::get('/createTaskMail', [App\Http\Controllers\task_report\TaskReportController::class, 'createTaskMail'])->name('createTaskMail');
        Route::post('/storeTaskReportMail', [App\Http\Controllers\task_report\TaskReportController::class, 'storeTaskReportMail'])->name('storeTaskReportMail');
        Route::get('/updateTaskMail/{id}', [App\Http\Controllers\task_report\TaskReportController::class, 'editTaskMail'])->name('updateTaskMail');
        Route::post('/updateTaskMailInfo', [App\Http\Controllers\task_report\TaskReportController::class, 'updateTaskMail'])->name('updateTaskMailInfo');

        // Task Report Send Mail
        Route::match(array('get','post'),'/createTaskMailSend', [App\Http\Controllers\task_report\TaskReportController::class, 'createTaskMailSend'])->name('createTaskMailSend');
        Route::match(array('get','post'),'/ticketAssignTrackInfo/{ticketId}', [App\Http\Controllers\task_report\TaskReportController::class, 'ticketAssignTrackInfo'])->name('ticketAssignTrackInfo');

        // News Route
         Route::get('/newsDetails/{id}', [App\Http\Controllers\HomeController::class, 'newsDetails'])->name('newsDetails');

         // Employee Info Route get_employee_info
         Route::get('/get_employee_info', [App\Http\Controllers\CommonController::class, 'getEmployeeInfo'])->name('get_employee_info');
         Route::get('/get_all_employee', [App\Http\Controllers\DashboardController::class, 'getAllEmployee'])->name('get_all_employee');
         Route::get('/get_present_employee', [App\Http\Controllers\DashboardController::class, 'getPresentEmployee'])->name('get_present_employee');
         Route::get('/get_absent_employee', [App\Http\Controllers\DashboardController::class, 'getAbsentEmployee'])->name('get_absent_employee');

        // Start Employee Route
        Route::get('/allEmployeeIndex', [App\Http\Controllers\support\EmployeeController::class, 'index'])->name('allEmployeeIndex');
        Route::get('/createEmployee', [App\Http\Controllers\support\EmployeeController::class, 'create'])->name('createEmployee');
        Route::post('/storeEmployee', [App\Http\Controllers\support\EmployeeController::class, 'store'])->name('storeEmployee');
        Route::get('/updateEmployee/{id}', [App\Http\Controllers\support\EmployeeController::class, 'edit'])->name('updateEmployee');
        Route::post('/updateEmployeeInfo', [App\Http\Controllers\support\EmployeeController::class, 'update'])->name('updateEmployeeInfo');

         // Dashboard Route
         Route::get('/get_ticket_info/{ticket_status}', [App\Http\Controllers\DashboardController::class, 'getTicketStatusInfo'])->name('get_ticket_info');
         Route::get('/total_present_employee', [App\Http\Controllers\DashboardController::class, 'totalPresentEmployee'])->name('total_present_employee');
         Route::get('/total_absent_employee', [App\Http\Controllers\DashboardController::class, 'totalAbsentEmployee'])->name('total_absent_employee');
         Route::get('/total_working_hour', [App\Http\Controllers\DashboardController::class, 'totalWorkingHour'])->name('total_working_hour');
         Route::get('/get_last_seven_days_task', [App\Http\Controllers\DashboardController::class, 'getLastSevenDaysTask'])->name('get_last_seven_days_task');
         Route::get('/task_details_specific_emp/{empId}', [App\Http\Controllers\DashboardController::class, 'taskDetailsSpecificEmp'])->name('task_details_specific_emp');
         Route::get('/task_details_last_seven_days/{empId}', [App\Http\Controllers\DashboardController::class, 'taskDetailsLast7Days'])->name('task_details_last_seven_days');
         // company handbook
         Route::get('/handbookCheckList', [App\Http\Controllers\CompanyHandbook::class, 'HandbookCheckList'])->name('handbookCheckList');
         Route::get('/viewEmpWiseCheckHandbook/{handbookId}', [App\Http\Controllers\CompanyHandbook::class, 'viewEmpWiseCheckHandbook'])->name('viewEmpWiseCheckHandbook');

          // request approved permission
        Route::get('permissionIndex', [App\Http\Controllers\RequestApprovedController::class, 'index'])->name('permissionIndex');
        Route::get('permissionCreate', [App\Http\Controllers\RequestApprovedController::class, 'create'])->name('permissionCreate');
        Route::post('storePermission', [App\Http\Controllers\RequestApprovedController::class, 'store'])->name('storePermission');
        Route::get('editPermissionSetup/{id}', [App\Http\Controllers\RequestApprovedController::class, 'edit'])->name('editPermissionSetup');
        Route::post('updatePermission', [App\Http\Controllers\RequestApprovedController::class, 'update'])->name('updatePermission');

         ##################################### SALES ROUTE ############################################
        // do
        Route::get('salesIndex', [App\Http\Controllers\sales\SalesController::class, 'index'])->name('salesIndex');
        Route::get('/search_sales_report', [App\Http\Controllers\sales\SalesController::class, 'searchReport'])->name('search_sales_report');

        // collection
        Route::get('collectionIndex', [App\Http\Controllers\sales\SalesController::class, 'collectionIndex'])->name('collectionIndex');
        Route::get('loactionIndex', [App\Http\Controllers\sales\SalesController::class, 'loaction'])->name('loactionIndex');
        Route::get('/search_collection_report', [App\Http\Controllers\sales\SalesController::class, 'searchCollection'])->name('search_collection_report');
        // google map api
        // Route::get('google-map', [App\Http\Controllers\google_map\GoogleMapController::class, 'mapView'])->name('google-map');
        // Route::get('search-emp-location', [App\Http\Controllers\google_map\GoogleMapController::class, 'searchEmpLocation'])->name('search-emp-location');
        Route::get('attendance-report', [App\Http\Controllers\google_map\GoogleMapController::class, 'attendanceReport'])->name('attendance-report');
        Route::get('seareh-today-attendance', [App\Http\Controllers\google_map\GoogleMapController::class, 'searchTodayAttendance'])->name('seareh-today-attendance');
        Route::get('google-map', [App\Http\Controllers\google_map\GoogleMapController::class, 'mapView'])->name('google-map');
        Route::get('search-emp-location', [App\Http\Controllers\google_map\GoogleMapController::class, 'searchEmpLocation'])->name('search-emp-location');

        // dealer app notification 
        Route::get('dealer-offer-notification', [App\Http\Controllers\sales\SalesController::class, 'notificationIndex'])->name('dealer-offer-notification');
        Route::get('createNotificationSetup', [App\Http\Controllers\sales\SalesController::class, 'createNotificationSetup'])->name('createNotificationSetup');
        Route::post('sendNotificaiton', [App\Http\Controllers\sales\SalesController::class, 'sendNotificaiton'])->name('sendNotificaiton');
        });


        //end backend route
