<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

use App\Http\Controllers\API\AppLoginController;
use App\Http\Controllers\API\LoginController;

use App\Http\Controllers\API\TicketController;
use App\Http\Controllers\API\MeetingController;
use App\Http\Controllers\API\MealController;
use App\Http\Controllers\API\VehicleController;
use App\Http\Controllers\API\SalesController;
use App\Http\Controllers\API\AttendanceController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
*/

//Route::post('login', [LoginController::class, 'signin']);
//Route::post('register', [LoginController::class, 'signup']);

Route::post('login', [AppLoginController::class, 'signin']);
Route::post('userRegister', [AppLoginController::class, 'userRegister']);
Route::post('updatePassword', [AppLoginController::class, 'updatePassword']);
Route::get('getUserInfo', [AppLoginController::class, 'getUserInfo']);
Route::get('getModuleScreen', [AppLoginController::class, 'getModuleScreen']);
Route::post('getModuleScreenByUser', [AppLoginController::class, 'getModuleScreenByUser']);
Route::post('getModuleScreenByUserCheck', [AppLoginController::class, 'getModuleScreenByUserCheck']);
Route::post('sendNotification', [AppLoginController::class, 'sendNotification']);
// ticket route
Route::post('ticketInfo', [TicketController::class, 'ticketInfo']);
Route::post('deptTicketInfo', [TicketController::class, 'deptTicketInfo']);
Route::get('ticketInfoById/{ticketId}', [TicketController::class, 'ticketInfoById']);
Route::post('ticketCreateInfo', [TicketController::class, 'ticketCreateInfo']);
Route::post('ticketAssignInfo', [TicketController::class, 'ticketAssignInfo']);
Route::post('empTicketAssign', [TicketController::class, 'empTicketAssign']);
Route::post('ticketCreate', [TicketController::class, 'ticketCreate']);
Route::post('getTicketInfoByStatus', [TicketController::class, 'getTicketInfoByStatus']);
Route::post('getDeptTicketInfoByStatus', [TicketController::class, 'getDeptTicketInfoByStatus']);
Route::post('ticketStatusChange', [TicketController::class, 'ticketStatusChange']);
Route::post('closedTicketList', [TicketController::class, 'closedTicketList']);
Route::post('deptClosedTicketList', [TicketController::class, 'deptClosedTicketList']);
Route::post('getIssueGroup', [TicketController::class, 'getIssueGroup']);
Route::post('ticketCreateOtherInfo', [TicketController::class, 'ticketCreateOtherInfo']);
// meal route 
Route::post('getSeflMealInfo', [MealController::class, 'getSeflMealInfo']);
Route::post('getMealInfo', [MealController::class, 'getMealInfo']);
Route::post('mealReport', [MealController::class, 'mealReport']);
Route::post('monthWiseMeal', [MealController::class, 'monthWiseMeal']);
Route::get('getTomorrowMeal', [MealController::class, 'getTomorrowMeal']);
Route::post('getMealStatus', [MealController::class, 'getMealStatus']);
Route::post('changeMealStatus', [MealController::class, 'changeMealStatus']);
Route::post('searchEmpMealByDate', [MealController::class, 'searchEmpMealByDate']); 
Route::post('selfMealCreate', [MealController::class, 'selfMealCreate']);
Route::post('checkEmpMealStatusByDate', [MealController::class, 'checkEmpMealStatusByDate']);
Route::post('checkPrePlan', [MealController::class, 'checkPrePlan']);
Route::post('updateSelfMealStatus', [MealController::class, 'updateSelfMealStatus']);
Route::post('storeGuestMeal', [MealController::class, 'storeGuestMeal']);
Route::post('guestMealIndex', [MealController::class, 'guestMealIndex']);
Route::post('guestMealEdit', [MealController::class, 'guestMealEdit']);
Route::post('guestMealUpdate', [MealController::class, 'guestMealUpdate']);
Route::post('guestMealStatusChange', [MealController::class, 'guestMealStatusChange']);
Route::post('serachGuestMeal', [MealController::class, 'serachGuestMeal']);

Route::post('register', [AppLoginController::class, 'signup']);

// meeting route 
Route::post('meetingInfoByDate', [MeetingController::class, 'meetingInfoByDate']);
Route::post('meetingInfoByRoomWise', [MeetingController::class, 'meetingInfoByRoomWise']);
Route::post('meetingClosed', [MeetingController::class, 'meetingClosed']);
Route::post('getAvailableTimeSlot', [MeetingController::class, 'getAvailableTimeSlot']);
Route::post('getEmployeeByDept', [MeetingController::class, 'getEmployeeByDept']);
Route::post('checkEmpMeeting', [MeetingController::class, 'checkEmpMeeting']);
Route::post('meetingCreate', [MeetingController::class, 'meetingCreate']);
Route::post('getSelfMeeting', [MeetingController::class, 'getSelfMeeting']);
Route::post('getMeetingInfoById', [MeetingController::class, 'getMeetingInfoById']); // nedd to add in oracle
Route::post('meetingUpdate', [MeetingController::class, 'meetingUpdate']); // nedd to add in oracle
Route::post('checkMeetingRoorm', [MeetingController::class, 'checkMeetingRoorm']); // nedd to add in oracle
Route::post('meeting_status_change', [MeetingController::class, 'meetingStatusChange']); // nedd to add in oracle
// meeting particular icon
Route::get('getMeetingParticular', [MeetingController::class, 'getMeetingParticular']);
Route::get('getMeetingCreateInfo', [MeetingController::class, 'getMeetingCreateInfo']);

// vehicle route
Route::post('vehicleCreateInfo', [VehicleController::class, 'vehicleCreateInfo']);
Route::post('vehicleCreate', [VehicleController::class, 'vehicleCreate']);
Route::post('vehicleCreate1', [VehicleController::class, 'vehicleCreate1']);
Route::post('vechileRequestList', [VehicleController::class, 'vechileRequestList']);
Route::post('deptVehicleReqList', [VehicleController::class, 'deptVehicleReqList']);
Route::get('vehicleRequestInfoById/{requestId}', [VehicleController::class, 'vehicleRequestInfoById']);
Route::get('vehicleRequestInfoById/{requestId}/{userId}', [VehicleController::class, 'vehicleReqInfoById']);
Route::get('deptVehicleReqInfoById/{requestId}/{userId}', [VehicleController::class, 'deptVehicleReqInfoById']);
Route::get('vehicleReqInfoByIdUpdate/{requestId}/{userId}', [VehicleController::class, 'vehicleReqInfoByIdUpdate']);
Route::post('vechileRequestStatus', [VehicleController::class, 'vechileRequestStatus']);
Route::post('getRequestInfoByStatus', [VehicleController::class, 'getRequestInfoByStatus']);
Route::post('vehicle_status_change', [VehicleController::class, 'vehicleStatusChange']); // nedd to add in oracle
Route::post('vechileRequestAdmin', [VehicleController::class, 'vechileRequestAdmin']); // nedd to add in oracle
Route::get('vehicleReqApproveInfo/{requestId}/{userId}', [VehicleController::class, 'vehicleReqApproveInfo']); 
Route::post('multiReqApprove', [VehicleController::class, 'multiReqApprove']); 
Route::post('multiReqByAdmin', [VehicleController::class, 'multiReqByAdmin']); 
Route::post('approveByAdmin', [VehicleController::class, 'approveByAdmin']); 
Route::post('createCurrentLoaction', [VehicleController::class, 'createCurrentLoaction']); 
Route::post('getLoaction', [VehicleController::class, 'getLoaction']); 


################################## Sales ######################################
Route::post('getSearchInfo', [SalesController::class, 'getSearchInfo']); 
Route::post('searchCollection', [SalesController::class, 'searchCollection']); 
Route::post('salesInfo', [SalesController::class, 'salesInfo']); 
Route::post('searchSalesInfo', [SalesController::class, 'searchSalesInfo']); 

################################## Attendance ##############################
Route::post('attendance', [AttendanceController::class, 'attendanceStore']); 

