@extends('layouts.master')

@section('content')
@section('title')
@endsection
<style>
    ul li.active,
    a.active {
        color: #3fbbc0;
    }

</style>

<div class="" role="main">
    <div class="">
        <div class="page-title">
            <div class="title_left">
                <h5>{{$header['pageTitle']}} </h5>
            </div>
           
        </div>
        <div class="clearfix"></div>
        <div class="row">
            <div class="col-md-12 col-sm-12 col-lg-12">
                <div class="x_panel">
                    <div class="x_title" style="border:none;">
                        <h2>{{$header['tableTitle']}} </h2>
                    </div>
                    <div class="x_content">
                        <div class="row">
                                <div class="col-sm-12 col-md-12 col-lg-12">
                                    <div class="col-sm-2 col-md-2 col-lg-2">
                                        <div class="form-group">
                                            <label for="exampleInputFormDate">Form</label>
                                            <input type="text" class="form-control datepickerMonthYearAppend" value="{{date('01-m-Y')}}" id="fromDate" aria-describedby="" placeholder="">
                                        </div>
                                    </div>
                                    <div class="col-sm-2 col-md-2 col-lg-2">
                                        <div class="form-group">
                                            <label for="exampleInputFormDate">To</label>
                                            <input type="text" class="form-control datepickerMonthYearAppend" value="{{date('d-m-Y')}}" id="toDate" aria-describedby="" placeholder="">
                                        </div>
                                    </div>
                                    <div class="col-sm-2 col-md-2 col-lg-2">
                                        <div class="form-group">
                                            <label for="exampleFormControlSelectDepartment">Visit Type</label>
                                            <select class="form-control select2" id="visitId">
                                                <option value="">Select</option>
                                                @foreach($visitType as $vType)
                                                    <option value="{{$vType->LOOKUP_DATA_ID}}">{{$vType->LOOKUP_DATA_NAME}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-2 col-md-2 col-lg-2">
                                        <div class="form-group">
                                            <label for="exampleFormControlStatus">Vehicle</label>
                                            <select class="form-control select2" id="vehicleId">
                                                <option value="">Select</option>
                                                @foreach($vehicleList as $vehicle)
                                                <option value="{{$vehicle->id}}">{{$vehicle->vehicel_no}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-2 col-md-2 col-lg-2">
                                        <div class="form-group">
                                            <label for="exampleFormControlStatus">Diver</label>
                                            <select class="form-control select2" id="driverId">
                                                <option value="">Select</option>
                                                @foreach($driverList as $driver)
                                                <option value="{{$driver->id}}">{{$driver->name}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-2 col-md-2 col-lg-2" style="margin-top: 3%">
                                        <div class="field item form-group">
                                            <label class="col-form-label col-md-3 col-sm-3  label-align"></label>
                                            <div class="col-md-9 col-sm-9">
                                                <button type="button" id="searchID" class="btn btn-info">Search</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="card-box table-responsive searchResult">
                                    <table id="datatable-buttons" class="table table-striped table-bordered dataTable"
                                        role="grid" aria-describedby="data-table-info" width="100%">
                                        <thead style="background-color: #0b58a2; color: white">
                                            <tr>
                                                <th>Sl</th>
                                                <th>Visit Type</th>
                                                <th>Visit Date_Time</th>
                                                <th>Trip Type</th>
                                                <th >Visit Place</th>
                                                <th>Vehicle</th>
                                                <th>Driver</th>
                                                <th>Reqest By</th>
                                                <th>Status</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($results as $key=> $result)
                                            <tr>
                                                <td>{{$key+1}}</td>
                                                <td>{{$result->visit_type}} </td>
                                                <td>{{date('d-M-y',strtotime($result->from_date))}} {{gmdate('h:i: A',$result->start_time)}} To {{date('d-M-y',strtotime($result->to_date))}} {{gmdate('h:i: A',$result->end_time)}}</td>
                                                <td>{{$result->trip_type_id =='1' ? "Single Trip":"Round Trip"}}</td>
                                                <td>{{$result->visit_place}} </td>
                                                <td>
                                                    @php 
                                                        $vehicleInfo = DB::table('npoly_vehicel')->select('name','vehicel_no')->where('id',$result->vehicle_id)->first();
                                                       if(!empty($vehicleInfo)){
                                                        echo $vehicleInfo->name.' ('.$vehicleInfo->vehicel_no. ')' ;
                                                       }
                                                    @endphp
                                                   
                                                </td>
                                                <td>
                                                    @php 
                                                        $driverInfo = DB::table('npoly_driver')->select('name','mobile')->where('id',$result->driver_id)->first();
                                                       if(!empty($driverInfo)){
                                                        echo $driverInfo->name.' ('.$driverInfo->mobile. ')' ;
                                                       }
                                                    @endphp
                                                   
                                                </td>
                                                
                                                <td>
                                                    @php 
                                                    $creatorInfo = DB::table('users')->select('name','department_name','designation_name')->where('id',$result->created_by)->first();
                                                    echo $creatorInfo->name.' '. $creatorInfo->department_name.' , '.$creatorInfo->designation_name;
                                                    @endphp
                                                </td>
                                                <td>{{$result->status}}</td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
  $(document).ready(function() {
        $('.select2').select2();
    });
    $('#searchID').click(function (){
        var fromDate = $('#fromDate').val();
        var toDate = $('#toDate').val();
        var visitId = $('#visitId').val();
        var vehicleId = $('#vehicleId').val();
        var driverId = $('#driverId').val();

        if(fromDate ==""){
            alert('Please Select Form Date');
        }else if(toDate ==""){
            alert('Please Select To Date');
        }else{
            var _token = '{{csrf_token()}}'
            $.ajax({
                type: 'GET',
                url: '{{url("/search_vehicle_report")}}',
                data: { fromDate: fromDate,toDate:toDate,visitId:visitId,vehicleId:vehicleId,driverId:driverId },
                success: function (data) {
                    $('.searchResult').html(data);
                    $("#datatable-buttons").DataTable({
                        dom: "Blfrtip",
                        buttons: [
                            /*{
                                extend: "copy",
                                className: "btn-sm"
                            },
                            {
                                extend: "csv",
                                className: "btn-sm"
                            },
                            {
                                extend: "excel",
                                className: "btn-sm"
                            },
                            {
                                extend: "pdfHtml5",
                                className: "btn-sm"
                            },
                            {
                                extend: "print",
                                className: "btn-sm"
                            },*/
                            'colvis', // line was not here - rony778
                            { // line block was not here - rony778
                                extend: 'collection',
                                text: 'Export',
                                className: 'btn-sm',
                                buttons: [
                                    'copy',
                                    'excel',
                                    'csv',
                                    'pdf',
                                    'print'
                                ]
                            },
                        ],
                        //responsive: true
                    });
                    
                }
            });
        }
    })
</script>
@endsection
