@extends('layouts.master')

@section('content')
@section('title')
@endsection
<style>
    ul li.active,
    a.active {
        color: #3fbbc0;
    }

</style>
<div class="" role="main">
    <div class="">
        <div class="page-title">
            <div class="title_left">
                <h5>{{$header['pageTitle']}} </h5>
            </div>
            <!-- USER LEVEL SUPERVISOR=10 WILL LOGIN -->
            {{-- @if(Auth::user()->USERLVL_ID==10) --}}
            <div class="title_right">
                <div class="item form-group">
                    <div class="col-md-3 col-sm-3 offset-md-9">
                        <button type="button" class="btn btn-primary dynamicModal" pageTitle="Vechile Request"
                            pageLink="{{URL::route('createVehicelRequest')}}" data-toggle="tooltip" data-placement="left"
                            title="Vechile Request" data-target=".bs-example-modal-lg" data-modal-size="modal-lg">Add
                            New</button>
                    </div>
                </div>
            </div>
            {{-- @endif --}}
        </div>
        <div class="clearfix"></div>
        <div class="row">
            <div class="col-md-12 col-sm-12 col-lg-12">
                <div class="x_panel">
                    <div class="x_title" style="border:none;">
                        <h2>{{$header['tableTitle']}} </h2>
                    </div>
                    <div class="x_content">
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="card-box table-responsive">
                                    <table id="datatable" class="table table-striped table-bordered dataTable"
                                        role="grid" aria-describedby="data-table-info" width="100%">
                                        <thead style="background-color: #0b58a2; color: white">
                                            <tr>
                                                <th>Sl</th>
                                                <th>Employee Name</th>
                                                <th>Visit Type</th>
                                                <th>Trip Type</th>
                                                <th>Form Date</th>
                                                <th>To Date</th>
                                                <th>Pickup Point</th>
                                                <th>Status</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($results as $key=> $result)
                                            <tr>
                                                <td>{{$key+1}}</td>
                                                <td>{{$result->employee_name}}</td>
                                                <td>{{$result->visit_type}}</td>
                                                <td>{{$result->trip_type_id =='1' ? "Single Trip":"Round Trip"}}</td>
                                                <td>{{date('d-M-Y',strtotime($result->form_date))}}</td>
                                                <td>{{date('d-M-Y',strtotime($result->end_date))}}</td>
                                                <td>{{$result->pick_up_point}}</td>
                                                <td>{{$result->status}}</td>
                                                    <td class="text-center">
                                                        @php 
                                                        $userLvlId = Auth::user()->USERLVL_ID;
                                                        $actionUrl = "";
                                                        if($userLvlId == '16'){
                                                            $actionUrl .=url('/approveRequestByAdmin/'.$result->id);
                                                        }else{
                                                            $actionUrl .=url('/updateVehiceRequest/'.$result->id);
                                                        }
                                                        @endphp
                                                        <button type="button" class="btn btn-info btn-sm dynamicModal"
                                                            pageTitle="Update Request"
                                                           @if($result->status_id=='298') disabled @endif
                                                            pageLink="{{ $actionUrl }}"
                                                            data-modal-size="modal-lg" data-toggle="tooltip"
                                                            data-placement="top" title="Update Request">
                                                            <i class="glyphicon glyphicon-edit"></i>
                                                        </button>
                                                    </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
