@extends('layouts.master')

@section('content')
@section('title')
@endsection
<style>
    ul li.active,
    a.active {
        color: #3fbbc0;
    }

</style>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/css/toastr.min.css">
  <!-- <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script> -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
  <script src="https://js.pusher.com/8.2.0/pusher.min.js"></script>
<div class="" role="main">
    <div class="">
        <div class="page-title">
            <div class="title_left">
                <h5>{{$header['pageTitle']}} </h5>
            </div>
        </div>
        <div class="clearfix"></div>
        <div class="row">
            <div class="col-md-12 col-sm-12 col-lg-12">
                <div class="x_panel">
                    <div class="x_title" style="border:none;">
                        <h2>{{$header['tableTitle']}} </h2>
                    </div>
                    <div class="x_content">
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="card-box table-responsive">
                                    <table id="datatable" class="table table-striped table-bordered dataTable"
                                        role="grid" aria-describedby="data-table-info" width="100%">
                                        <thead style="background-color: #0b58a2; color: white">
                                            <tr>
                                                <th>Sl</th>
                                                <th>Visit Type</th>
                                                <th>Date</th>
                                                <th>Visit Place</th>
                                                <th>Reqest By</th>
                                                <th>Status</th>
                                                <th>Approver</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($results as $key=> $result)
                                            <tr>
                                                <td>{{$key+1}}</td>
                                                <td>{{$result->visit_type}} </td>
                                                <td>{{date('d-M-y',strtotime($result->from_date))}} {{gmdate('h:i: A',$result->start_time)}} To {{date('d-M-y',strtotime($result->to_date))}} {{gmdate('h:i: A',$result->end_time)}}</td>
                                                <td>{{$result->visit_place}} </td>
                                                <td>
                                                    @php 
                                                    $creatorInfo = DB::table('users')->select('name','department_name','designation_name')->where('id',$result->created_by)->first();
                                                    echo $creatorInfo->name.' '. $creatorInfo->department_name;
                                                    @endphp
                                                </td>
                                                <td>{{$result->status}}</td>
                                                <td>
                                                @php 
                                                    $creatorInfo = DB::table('users')->select('name','department_name','designation_name')->where('department_id',$result->created_dept)->where('is_dept_head',1)->first();
                                                    if($creatorInfo->name){
                                                        echo $creatorInfo->name.' '. $creatorInfo->department_name;
                                                    }
                                                @endphp
                                                </td>
                                                <td class="text-center">
                                                        @php 
                                                        $actionUrl = " url('/updateVehiceRequest/'.$result->id)";
                                                        @endphp

                                                        <button type="button" class="btn btn-info btn-sm dynamicModal"
                                                                pageTitle="Update Request"
                                                                pageLink="{{ url('/updateVehiceRequest/'.$result->id) }}"
                                                                data-modal-size="modal-lg" data-toggle="tooltip"
                                                                data-placement="top" title="Update Request">
                                                                <i class="glyphicon glyphicon-edit"></i>
                                                        </button>
                                                    </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function() {
    $('#datatable').DataTable({
        "columnDefs": [
            { "orderable": false, "targets": 7 } // Disable sorting on the second column
        ]
    });
});
</script>
@endsection
