@extends('layouts.master')

@section('content')
    @section('title')
    @endsection
    <style>
        ul li.active,
        a.active {
            color: #3fbbc0;
        }

        tr:nth-child(even) tr {background: #ffffff !important;}

    </style>
    <div class="" role="main">
        <div class="">
            <div class="page-title">
                <div class="title_left">
                    <h3>{{$header['pageTitle']}}  <a href="{{url('/home')}}">Dashboard</a></h3>
                </div>
            </div>
            <div class="clearfix"></div>
            <div class="row">
                <div class="col-md-12 col-sm-12 col-lg-12">
                    <div class="x_panel">
                        <div class="x_title" style="border:none;">
                            <h2>{{$header['tableTitle']}} </h2>
                        </div>
                        <div class="x_content">
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="card-box table-responsive">
                                        <table id="datatable" class="table table-striped table-bordered dataTable"
                                               role="grid" aria-describedby="data-table-info" width="100%">
                                            <thead style="background-color: #0b58a2; color: white">
                                            <tr>
                                                <th>Sl</th>
                                                <th>Name</th>
                                                <th>Department</th>
                                                <th>Designation</th>
                                                <th>Total</th>
                                                <th title='Total Pending'>T. Pending</th>
                                                <th title='Total Complete'>T. Complete</th>

                                            </tr>
                                            </thead>
                                            <tbody>
                                            @foreach($employees as $key=> $emp)
                                                <tr>
                                                    <td>{{$key+1}}</td>
                                                    <td>
                                                        <a class="dynamicModal" href="#" pageLink="{{url('show_task_details_info/'.$emp->employee_id)}}" pageTitle="Schedule Details" data-toggle="tooltip" data-placement="left" data-target=".bs-example-modal-lg" data-modal-size="modal-xl">  {{$emp->employee_name}} </a>
                                                    </td>
                                                    <td>{{$emp->department_name}}</td>
                                                    <td>{{$emp->designation_name}}</td>
                                                    <td>
                                                        @php
                                                        $totalTaskCount = DB::table('npoly_task_report')
                                                                        ->select('task_id')
                                                                        ->where('active_status',1)
                                                                        ->where('employee_id',$emp->employee_id)
                                                                        ->where('task_create_date',date('Y-m-d'))
                                                                        ->count();

                                                         
                                                        @endphp
                                                        @if($totalTaskCount > 0)
                                                        <a class="dynamicModal" href="#" pageLink="{{url('show_task_details_info/'.$emp->employee_id)}}" pageTitle="Schedule Details" data-toggle="tooltip" data-placement="left" data-target=".bs-example-modal-lg" data-modal-size="modal-xl">  {{$totalTaskCount}} </a>
                                                        @endif
                                                    </td>
                                                    <td>
                                                    @php
                                                        $totalPendingTaskCount = DB::table('npoly_task_report')
                                                                        ->select('task_id')
                                                                        ->where('active_status',1)
                                                                        ->where('task_complete',0)
                                                                        ->where('task_running',0)
                                                                        ->where('employee_id',$emp->employee_id)
                                                                        ->where('task_create_date',date('Y-m-d'))
                                                                        ->count();
                                                        
                                                        
                                                        @endphp
                                                        @if($totalPendingTaskCount > 0)
                                                        <a class="dynamicModal" href="#" pageLink="{{url('show_pending_task_info/'.$emp->employee_id)}}" pageTitle="Schedule Details" data-toggle="tooltip" data-placement="left" data-target=".bs-example-modal-lg" data-modal-size="modal-xl">  {{$totalPendingTaskCount}} </a>
                                                        @endif
                                                    </td>
                                                    <td>
                                                    @php
                                                        $totalCompleteTaskCount = DB::table('npoly_task_report')
                                                                        ->select('task_id')
                                                                        ->where('active_status',1)
                                                                        ->where('task_complete',100)
                                                                        ->where('task_running',0)
                                                                        ->where('employee_id',$emp->employee_id)
                                                                        ->where('task_create_date',date('Y-m-d'))
                                                                        ->count();
                                                       
                                                        @endphp
                                                        @if($totalCompleteTaskCount > 0)
                                                        <a class="dynamicModal" href="#" pageLink="{{url('show_complete_task_info/'.$emp->employee_id)}}" pageTitle="Schedule Details" data-toggle="tooltip" data-placement="left" data-target=".bs-example-modal-lg" data-modal-size="modal-xl">  {{$totalCompleteTaskCount}} </a>
                                                        @endif
                                                    </td>
                                                </tr>
                                            @endforeach

                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
