@extends('layouts.master')

@section('content')
@section('title')
@endsection
<style>
    ul li.active,
    a.active {
        color: #3fbbc0;
    }

</style>
<div class="" role="main">
    <div class="">
        <div class="page-title">
            <div class="title_left">
                <h5>{{$header['pageTitle']}} </h5>
            </div>
            <!-- USER LEVEL SUPERVISOR=10 WILL LOGIN -->
            {{-- @if(Auth::user()->USERLVL_ID==10) --}}
            <div class="title_right">
                <div class="item form-group">
                    <div class="col-md-3 col-sm-3 offset-md-9">
                        <button type="button" class="btn btn-primary dynamicModal" pageTitle="Add Task Assign"
                            pageLink="{{URL::route('createTaskAssign')}}" data-toggle="tooltip" data-placement="left"
                            title="Add Task Assign" data-target=".bs-example-modal-lg" data-modal-size="modal-xl">Add
                            New</button>
                    </div>
                </div>
            </div>
            {{-- @endif --}}
        </div>
        <div class="clearfix"></div>
        <div class="row">
            <div class="col-md-12 col-sm-12 col-lg-12">
                <div class="x_panel">
                    <div class="x_title" style="border:none;">
                        <h2>{{$header['tableTitle']}} </h2>
                    </div>
                    <div class="x_content">
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="card-box table-responsive">
                                    <table id="datatable" class="table table-striped table-bordered dataTable"
                                        role="grid" aria-describedby="data-table-info" width="100%">
                                        <thead style="background-color: #0b58a2; color: white">
                                            <tr>
                                                <th>Sl</th>
                                                <th>Project Name</th>
                                                <th>Task Title</th>
                                                <th>Task Description</th>
                                                <th>Department</th>
                                                <th>Assign To</th>
                                                <th>Assign Date</th>
                                                <th>Forecast Date</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($results as $key=> $result)
                                            <tr>
                                                <td>{{$key+1}}</td>
                                                <td>{{$result->project_name}}</td>
                                                <td>{{$result->task_title}}</td>
                                                <td>{{$result->task_desc}}</td>
                                                @if(empty($result->multi_dept_id))
                                                <td>{{$result->DEPT_NAME}}</td>
                                                @else
                                                <td>
                                                    @php 
                                                    $deptName = DB::selectOne("SELECT GROUP_CONCAT(lookup_data_name ORDER BY lookup_data_name SEPARATOR ' & ') as department_name FROM sa_lookup_data WHERE lookup_data_id in($result->multi_dept_id)");
                                                    echo $deptName->department_name;
                                                    @endphp
                                                </td>
                                                @endif
                                                <td>{{$result->employee_name}}</td>
                                                <td>{{date('d-M-Y',strtotime($result->assign_date))}}</td>
                                                <td>{{date('d-M-Y',strtotime($result->forecast_date))}}</td>
                                                    <td class="text-center">
                                                        <button type="button" @if($result->start_time > 0) disabled @endif class="btn btn-info btn-sm dynamicModal"
                                                            pageTitle="Update Task Assign"
                                                            pageLink="{{url('/updateTaskAssign/'.$result->task_id)}}"
                                                            data-modal-size="modal-xl" data-toggle="tooltip"
                                                            data-placement="top" title="@if($result->start_time > 0) The task is already start you can not edit @else Update Task Assign  @endif">
                                                            <i class="glyphicon glyphicon-edit"></i>
                                                        </button>
                                                    </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
