@extends('layouts.master')

@section('content')
@section('title')
@endsection
<style>
    ul li.active,
    a.active {
        color: #3fbbc0;
    }

    td input[type="checkbox"] {
    float: left;
    margin: 0 auto;
    width: 100%;
}

</style>
<div class="" role="main">
    <div class="">
        <div class="page-title">
            <div class="title_left">
                <h5>{{$header['pageTitle']}} </h5>
            </div>
            <!-- USER LEVEL SUPERVISOR=10 WILL LOGIN -->
            @php 
            $empId = Auth::user()->employee_id;
            @endphp
            <div class="title_right">
                <div class="item form-group">
                    <div class="col-md-3 col-sm-3 offset-md-9">
                        <button type="button" class="btn btn-primary dynamicModal" pageTitle="Meal Setting"
                            pageLink="{{URL::route('updatEmpSelfMealSetting')}}" data-toggle="tooltip" data-placement="left"
                            title="Meal Setting" data-target=".bs-example-modal-lg" data-modal-size="modal-lg">
                            Meal Setting</button>
                    </div>
                </div>
            </div>
        </div>
        <div class="clearfix"></div>
        <div class="row">
            <div class="col-md-12 col-sm-12 col-lg-12">
                <div class="x_panel">
                    <div class="x_title" style="border:none;">
                        <h2>{{$header['tableTitle']}} </h2>
                    </div>
                    <div class="x_content">
                    <div class="row">
                            <div class="col-sm-12">
                                <div class="card-box table-responsive searchResult">
                                    <table id="datatable" class="table table-striped table-bordered dataTable "
                                        role="grid" aria-describedby="data-table-info" width="100%">
                                        <thead style="background-color: #0b58a2; color: white">
                                            <tr>
                                                <th>Sl</th>
                                                <th>Employee Name</th>
                                                <th>Department</th>
                                                <th>Designation</th>
                                                <th>Meal Date</th>
                                                <th>Status</th>
                                                <!-- <th>Action</th> -->
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($results as $key=> $result)
                                            <tr>
                                                <td>{{$key+1}}</td>
                                                <td>{{$result->employee_name}}</td>
                                                <td>{{$result->department_name}}</td>
                                                <td>{{$result->designation_name}}</td>
                                                <td>{{date("d-M-Y", strtotime($result->meal_date))}}</td>
                                                <td>
                                                @if($result->meal_status =='1')
                                                      <b><span style="color:green;">{{"on"}}</sapn></b>
                                                      @else 
                                                      <b><span style="color:red;">{{"Off"}}</sapn></b>
                                                      @endif</td>
                                                </td>
                                               <!-- <td class="text-center">
                                                @php
                                                    $mealDateTime = \Carbon\Carbon::parse($result->meal_date);
                                                @endphp
                                                @if($mealDateTime->isFuture() || ($mealDateTime->isToday() && now()->lt($mealDateTime->startOfDay()->addHours(8))))
                                                    <button type="button" class="btn btn-primary btn-sm dynamicModal"
                                                        pageTitle="Update Meal"
                                                        pageLink="{{url('/updateMealInfo/'.$result->meal_id)}}"
                                                        data-modal-size="modal-lg" data-toggle="tooltip"
                                                        data-placement="top" title="Update Meeting">
                                                        <i class="glyphicon glyphicon-edit"></i>
                                                    </button>
                                                     @endif
                                                </td> -->
                                                <td>
                                                @php
                                                    $mealDateTime = \Carbon\Carbon::parse($result->meal_date);
                                                @endphp
                                                @if($mealDateTime->isFuture() || ($mealDateTime->isToday() && now()->lt($mealDateTime->startOfDay()->addHours(8))))
                                                <input type="checkbox" id="mealId" name="mealStatus" @if($result->meal_status =='1') checked @endif value="{{$result->meal_status}}"/>
                                                <input type="hidden" class="meal_id" value="{{$result->meal_id}}"/>
                                                @endif
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $('#mealId').click(function(){
        let mealStatus = $(this).val();
        if(mealStatus =='1'){
            let isConfirm = confirm('Are you want to stop meal !');
            if(isConfirm ==true){
               let mealId = $('.meal_id').val();
               let mealStatus ='0';
               if(mealId !=""){
                    $.ajaxSetup({
                        headers: {
                        'X-CSRF-TOKEN': '{{csrf_token()}}'
                        }
                    });
                    $.ajax({
                        type: 'POST',
                        url: '{{url("/changeMealStatus")}}',
                        data:{mealId:mealId,mealStatus:mealStatus},
                        success: function (data) {
                        //$('.availableSlot').html(data);
                        //$('.slotDiv').css('display','block')
                        window.location.href = 'http://192.168.250.17/npoly-ticketing-system/selfMealIndex';
                        }
                    });
                    }
            }else{
                $(this).prop('checked',false);
                return false;
            }
        }else{
            let isConfirm = confirm('Are you want to start meal !');
            if(isConfirm ==true){
                let mealId = $('.meal_id').val();
                let mealStatus ='1';
                if(mealId !=""){
                    $.ajaxSetup({
                        headers: {
                        'X-CSRF-TOKEN': '{{csrf_token()}}'
                        }
                    });
                    $.ajax({
                        type: 'POST',
                        url: '{{url("/changeMealStatus")}}',
                        data:{mealId:mealId,mealStatus:mealStatus},
                        success: function (data) {
                        //$('.availableSlot').html(data);
                        //$('.slotDiv').css('display','block')
                        window.location.href = 'http://192.168.250.17/npoly-ticketing-system/selfMealIndex';
                        }
                    });
                    }
               
            }else{
                $(this).prop('checked',false);
                return false;
            }
        }
    })
</script>
@endsection
