@extends('layouts.master')

@section('content')
@section('title')
@endsection
<style>
    ul li.active,
    a.active {
        color: #3fbbc0;
    }

</style>
<div class="" role="main">
    <div class="">
        <div class="page-title">
            <div class="title_left">
                <h5>{{$header['pageTitle']}} </h5>
            </div>
            <!-- USER LEVEL SUPERVISOR=10 WILL LOGIN -->
            <div class="title_right">
                <div class="item form-group">
                    <div class="col-md-3 col-sm-3 offset-md-9">
                        <button type="button" class="btn btn-primary dynamicModal" pageTitle="Add Schedule"
                            pageLink="{{URL::route('createSchedule')}}" data-toggle="tooltip" data-placement="left"
                            title="Add Schedule" data-target=".bs-example-modal-lg" data-modal-size="modal-lg">Add
                            New</button>
                    </div>
                </div>
            </div>
        </div>
        <div class="clearfix"></div>
        <div class="row">
            <div class="col-md-12 col-sm-12 col-lg-12">
                <div class="x_panel">
                    <div class="x_title" style="border:none;">
                        <h2>{{$header['tableTitle']}} </h2>
                    </div>
                    <div class="x_content">
                    <div class="row">
                            <div class="col-sm-12">
                                <div class="card-box table-responsive searchResult">
                                    <table id="datatable" class="table table-striped table-bordered dataTable "
                                        role="grid" aria-describedby="data-table-info" width="100%">
                                        <thead style="background-color: #0b58a2; color: white">
                                            <tr>
                                                <th>Sl</th>
                                                <th>Employee Name</th>
                                                <th>Department</th>
                                                <th>Schedule Date</th>
                                                <th>Schedule Time</th>
                                                <th>Place</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($results as $key=> $result)
                                            <tr>
                                                <td>{{$key+1}}</td>
                                                <td>{{$result->employee_name}}</td>
                                                <td>{{$result->dept_name}}</td>
                                                <td>@if(!empty($result->schedule_date)){{date('d-M-Y',strtotime($result->schedule_date))}} @endif</td>
                                                <td>{{gmdate("h:i:A", $result->schedule_start_time)}} - {{gmdate("h:i:A", $result->schedule_end_time)}}</td>
                                                <td>{{$result->schedule_place}}</td>
                                                <td class="text-center">
                                                    <button type="button" class="btn btn-info btn-sm dynamicModal"
                                                        pageTitle="Update Ticket Assign"
                                                        pageLink="{{url('/updateTicketAssign/'.$result->schedule_id)}}"
                                                        data-modal-size="modal-lg" data-toggle="tooltip"
                                                        data-placement="top" title="Update Ticket Assign">
                                                        <i class="glyphicon glyphicon-edit"></i>
                                                    </button>
                                                    
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
