
<style>
    ul li.active,
    a.active {
        color: #3fbbc0;
    }

</style>
<div class="" role="main">
    <div class="">
        <div class="clearfix"></div>
        <div class="row">
            <div class="col-md-12 col-sm-12 col-lg-12">
                <div class="x_panel">
                    <div class="x_content">
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="card-box table-responsive">
                                    <table id="datatable" class="table table-striped table-bordered dataTable"
                                        role="grid" aria-describedby="data-table-info" width="100%">
                                        <thead style="background-color: #0b58a2; color: white">
                                        <tr>
                                                <th>Sl</th>
                                                <th>Product</th>
                                                <th>Mother Cat</th>
                                                <th>Item</th>
                                                <th>Do Qty</th>
                                                <th>Do Amt</th>
                                                <th>Shipped Qty</th>
                                                <th>Shipped Amt</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        @php
                                            function formatBangladeshiNumber($number) {
                                                    $number = (string) $number;
                                                    $lastThree = substr($number, -3);
                                                    $restUnits = substr($number, 0, -3);

                                                    // Only add a comma if there are rest units
                                                    if (strlen($restUnits) > 0) {
                                                        $restUnits = preg_replace("/\B(?=(\d{2})+(?!\d))/", ",", $restUnits);
                                                        return $restUnits . ',' . $lastThree;
                                                    }
                                                    
                                                    // If no rest units, just return the last three digits (or the full number)
                                                    return $lastThree;
                                            }
                                        @endphp

                                        @php 
                                            $doQty = 0;
                                            $doAmt = 0;
                                            $shpQty = 0;
                                            $shpAmt = 0;
                                        @endphp
                                        
                                        @foreach($results as $key=> $result)

                                            @php 
                                            $doQty += $result->do_qty;
                                            $doAmt += $result->do_amount;
                                            $shpQty += $result->shipped_quantity;
                                            $shpAmt += $result->shipped_amount;
                                            @endphp
                                            
                                            <tr>
                                                <td>{{$key+1}}</td>
                                                <td>{{$result->product}}</td>
                                                <td>{{$result->mother_cat}}</td>
                                                <td>{{$result->item_code}}</td>
                                                <td style="text-align:right">{{$result->do_qty}}</td>
                                                <td style="text-align:right">{{formatBangladeshiNumber(ceil($result->do_amount))}}</td>
                                                <td style="text-align:right">{{$result->shipped_quantity}}</td>
                                                <td style="text-align:right">{{formatBangladeshiNumber(ceil($result->shipped_amount))}}</td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                        <tfoot>
                                            <tr style="font-weight: bold; background-color: #f2f2f2;">
                                                <td colspan="4" style="text-align:right">Total</td>
                                                <td style="text-align:right">{{formatBangladeshiNumber(ceil($doQty))}}</td>
                                                <td style="text-align:right">{{formatBangladeshiNumber(ceil($doAmt))}}</td>
                                                <td style="text-align:right">{{formatBangladeshiNumber(ceil($shpQty))}}</td>
                                                <td style="text-align:right">{{formatBangladeshiNumber(ceil($shpAmt))}}</td>
                                            </tr>
                                            </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
