@extends('layouts.master')

@section('content')
@section('title')
@endsection
<style>
    ul li.active,
    a.active {
        color: #3fbbc0;
    }

</style>
<div class="" role="main">
    <div class="">
        <div class="page-title">
            <div class="title_left">
                <h5>{{$header['pageTitle']}} </h5>
            </div>
            <!-- USER LEVEL SUPERVISOR=10 WILL LOGIN -->
            <div class="title_right">
                <div class="item form-group">
                    <div class="col-md-3 col-sm-3 offset-md-9">
                        <button type="button" class="btn btn-primary dynamicModal" pageTitle="Meeting Room Booking"
                            pageLink="{{URL::route('createMeeting')}}" data-toggle="tooltip" data-placement="left"
                            title="Add Meeting" data-target=".bs-example-modal-lg" data-modal-size="modal-lg">Add
                            New</button>
                    </div>
                </div>
            </div>
        </div>
        <div class="clearfix"></div>
        <div class="row">
            <div class="col-md-12 col-sm-12 col-lg-12">
                <div class="x_panel">
                    <div class="x_title" style="border:none;">
                        <h2>{{$header['tableTitle']}} </h2>
                    </div>
                    <div class="x_content">
                    <div class="row">
                            <div class="col-sm-12">
                                <div class="card-box table-responsive searchResult">
                                    <table id="datatable" class="table table-striped table-bordered dataTable "
                                        role="grid" aria-describedby="data-table-info" width="100%">
                                        <thead style="background-color: #0b58a2; color: white">
                                            <tr>
                                                <th>Sl</th>
                                                <th>Room No</th>
                                                <th>Metting Title</th>
                                                <th>Date</th>
                                                <th>Start Time</th>
                                                <th>End Time</th>
                                                <!-- <th>Participent</th> -->
                                                <th>Status</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($results as $key=> $result)
                                            <tr>
                                                <td>{{$key+1}}</td>
                                                <td>{{$result->room_no}}</td>
                                                <td>{{$result->meeting_title}}</td>
                                                <td>@if(!empty($result->meeting_date)){{date('d-M-Y',strtotime($result->meeting_date))}} @endif</td>
                                                <td>{{$result->start_time}}</td>
                                                <td>{{$result->end_time }}</td>
                                                <td>
                                                    @if($result->meeting_status == '0')
                                                    {{"Pending"}}
                                                    @elseif($result->meeting_status == '1')
                                                    {{"Approved"}}
                                                    @else
                                                    {{"Cancel"}}
                                                    @endif
                                                </td>
                                                <td class="text-center">
                                                    @php 
                                                    $today = date('Y-m-d');
                                                    $time = date('h:i:s A');
                                                    $currentTime = strtotime($time) - strtotime('today');
                                                    @endphp
                                                    @php
                                                    $disable = false;
                                                    if($result->meeting_status == '1' || $result->meeting_status == '2'){
                                                        $disable .=true;
                                                    }else if($result->created_by == Auth::user()->id){
                                                        $disable .=true;
                                                    }
                                                    @endphp
                                                    <button type="button" class="btn btn-primary btn-sm dynamicModal"   @if($result->created_by != Auth::user()->id) disabled @endif @if($result->meeting_status =='1' || $result->meeting_status =='2') disabled @endif
                                                        pageTitle="Update Meeting"
                                                        pageLink="{{url('/updateMeeting/'.$result->meeting_id)}}"
                                                        data-modal-size="modal-lg" data-toggle="tooltip"
                                                        data-placement="top" title="Update Meeting">
                                                        <i class="glyphicon glyphicon-edit"></i>
                                                    </button>
                                                    <button type="button" class="btn btn-success btn-sm dynamicModal"
                                                        pageTitle="Meeting Details"
                                                        pageLink="{{url('/meetingDetails/'.$result->meeting_id)}}"
                                                        data-modal-size="modal-lg" data-toggle="tooltip"
                                                        data-placement="top" title="Meeting Details">
                                                        <i class="glyphicon glyphicon-eye-open"></i>
                                                    </button>
                                                    
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
