@extends('layouts.master')

@section('content')
@section('title')
@endsection
<style>
    ul li.active,
    a.active {
        color: #3fbbc0;
    }

</style>
<div class="" role="main">
    <div class="">
        <div class="page-title">
            <div class="title_left">
                <h5>{{$header['pageTitle']}} </h5>
            </div>
        </div>
        <div class="clearfix"></div>
        <div class="row">
            <div class="col-md-12 col-sm-12 col-lg-12">
                <div class="x_panel">
                    <div class="x_title" style="border:none;">
                        <h2>{{$header['tableTitle']}} </h2>
                    </div>
                    <div class="x_content">
                    <div class="row">
                            <div class="col-sm-12 col-md-12 col-lg-12">
                                <div class="col-sm-2 col-md-2 col-lg-2">
                                    <div class="form-group">
                                        <label for="exampleInputFormDate">Form</label>
                                        <input type="text" class="form-control datepickerMonthYearAppend" value="{{date('01-m-Y')}}" id="fromDate" aria-describedby="" placeholder="">
                                    </div>
                                </div>
                                <div class="col-sm-2 col-md-2 col-lg-2">
                                    <div class="form-group">
                                        <label for="exampleInputFormDate">To</label>
                                        <input type="text" class="form-control datepickerMonthYearAppend" value="{{date('d-m-Y')}}" id="toDate" aria-describedby="" placeholder="">
                                    </div>
                                </div>
                                <div class="col-sm-2 col-md-2 col-lg-2">
                                    <div class="form-group">
                                        <label for="exampleFormControlSelectDepartment">Room No</label>
                                        <select class="form-control select2" id="roomId">
                                            <option value="">Select</option>
                                            @foreach($roomInfo as $rm)
                                                <option value="{{$rm->LOOKUP_DATA_ID}}">{{$rm->LOOKUP_DATA_NAME}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-2 col-md-2 col-lg-2">
                                    <div class="form-group">
                                        <label for="exampleFormControlStatus">Status</label>
                                        <select class="form-control select2" id="statusId">
                                            <option value="">Select</option>
                                            <option value="1">Approved</option>
                                            <option value="2">Cancelled</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-2 col-md-2 col-lg-2" style="margin-top: 3%">
                                    <div class="field item form-group">
                                        <label class="col-form-label col-md-3 col-sm-3  label-align"></label>
                                        <div class="col-md-9 col-sm-9">
                                            <button type="button" id="searchID" class="btn btn-info">Search</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <div class="row">
                            <div class="col-sm-12">
                                <div class="card-box table-responsive searchResult">
                                    <table id="datatable-buttons" class="table table-striped table-bordered dataTable "
                                        role="grid" aria-describedby="data-table-info" width="100%">
                                        <thead style="background-color: #0b58a2; color: white">
                                            <tr>
                                                <th>Sl</th>
                                                <th>Room No</th>
                                                <th>Metting Title</th>
                                                <th>Date</th>
                                                <th>Start Time</th>
                                                <th>End Time</th>
                                                <th>Created By</th>
                                                <th>Status</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($results as $key=> $result)
                                            <tr>
                                                <td>{{$key+1}}</td>
                                                <td>{{$result->room_name}}</td>
                                                <td>{{$result->meeting_title}}</td>
                                                <td>@if(!empty($result->meeting_date)){{date('d-M-Y',strtotime($result->meeting_date))}} @endif</td>
                                                <td>{{gmdate("h:i A", $result->start_time)}}</td>
                                                <td>{{gmdate("h:i A", $result->end_time)}}</td>
                                                <td>
                                                    @php 
                                                        $createrInfo = DB::table('users')->select('*')->where('id',$result->created_by)->first();
                                                    @endphp
                                                    {{$createrInfo->name}} {{$createrInfo->department_name}}, {{$createrInfo->designation_name}}
                                                </td>
                                                <td>
                                                    @if($result->meeting_status == '0')
                                                    <span class="text-warning"> {{"Pending"}}</span>
                                                    @elseif($result->meeting_status == '1')
                                                    <span class="text-success">{{"Approved"}}</span>
                                                    @else
                                                    <span class="text-danger">{{"Cancel"}}</span>
                                                    @endif
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
     $(document).ready(function() {
        $('.select2').select2();
    });
    $('#searchID').click(function (){
        var fromDate = $('#fromDate').val();
        var toDate = $('#toDate').val();
        var roomId = $('#roomId').val();
        var statusId = $('#statusId').val();

        if(fromDate ==""){
            alert('Please Select Form Date');
        }else if(toDate ==""){
            alert('Please Select To Date');
        }else{
            var _token = '{{csrf_token()}}'
            $.ajax({
                type: 'GET',
                url: '{{url("/meeting_room_report")}}',
                data: { fromDate: fromDate,toDate:toDate,roomId:roomId,statusId:statusId },
                success: function (data) {
                    $('.searchResult').html(data);
                    $("#datatable-buttons").DataTable({
                        dom: "Blfrtip",
                        buttons: [
                            /*{
                                extend: "copy",
                                className: "btn-sm"
                            },
                            {
                                extend: "csv",
                                className: "btn-sm"
                            },
                            {
                                extend: "excel",
                                className: "btn-sm"
                            },
                            {
                                extend: "pdfHtml5",
                                className: "btn-sm"
                            },
                            {
                                extend: "print",
                                className: "btn-sm"
                            },*/
                            'colvis', // line was not here - rony778
                            { // line block was not here - rony778
                                extend: 'collection',
                                text: 'Export',
                                className: 'btn-sm',
                                buttons: [
                                    'copy',
                                    'excel',
                                    'csv',
                                    'pdf',
                                    'print'
                                ]
                            },
                        ],
                        //responsive: true
                    });
                    
                }
            });
        }
    })
</script>
@endsection
