@extends('layouts.master')

@section('content')
@section('title')
@endsection
<style>
    ul li.active,
    a.active {
        color: #3fbbc0;
    }

</style>
<div class="" role="main">
    <div class="">
        <div class="page-title">
            <div class="title_left">
                <h5>{{$header['pageTitle']}} </h5>
            </div>
            <!-- USER LEVEL SUPERVISOR=10 WILL LOGIN -->
            <div class="title_right">
                <div class="item form-group">
                    <div class="col-md-3 col-sm-3 offset-md-9">
                        <button type="button" class="btn btn-primary dynamicModal" pageTitle="Add Meeting Particular"
                            pageLink="{{URL::route('createMeetingParticular')}}" data-toggle="tooltip" data-placement="left"
                            title="Add Meeting Particular" data-target=".bs-example-modal-lg" data-modal-size="modal-lg">Add
                            New</button>
                    </div>
                </div>
            </div>
        </div>
        <div class="clearfix"></div>
        <div class="row">
            <div class="col-md-12 col-sm-12 col-lg-12">
                <div class="x_panel">
                    <div class="x_title" style="border:none;">
                        <h2>{{$header['tableTitle']}} </h2>
                    </div>
                    <div class="x_content">
                    <div class="row">
                            <div class="col-sm-12">
                                <div class="card-box table-responsive searchResult">
                                    <table id="datatable" class="table table-striped table-bordered dataTable "
                                        role="grid" aria-describedby="data-table-info" width="100%">
                                        <thead style="background-color: #0b58a2; color: white">
                                            <tr>
                                                <th>Sl</th>
                                                <th>Name</th>
                                                <th>Icon</th>
                                                <th>Status</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($results as $key=> $result)
                                            <tr>
                                                <td>{{$key+1}}</td>
                                                <td>{{ucfirst($result->name)}}</td>
                                                <td>{{$result->icon}}</td>
                                                <td>
                                                    @if($result->active_status=='1')
                                                    <button class="btn btn-sm btn-success">Active</button>
                                                    @else
                                                    <button class="btn btn-sm btn-warning">InActive</button>
                                                    @endif
                                                </td>
                                                <td class="text-center">
                                                    <button type="button" class="btn btn-primary btn-sm dynamicModal"
                                                        pageTitle="Update Particular"
                                                        pageLink="{{url('/updateParticular/'.$result->particular_id)}}"
                                                        data-modal-size="modal-lg" data-toggle="tooltip"
                                                        data-placement="top" title="Update Particular">
                                                        <i class="glyphicon glyphicon-edit"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
