@extends('layouts.master')

@section('content')
@section('title')
@endsection
<style>
    ul li.active,
    a.active {
        color: #3fbbc0;
    }
</style>
<style>
    th, td {
        white-space: nowrap;
    }
    th:nth-child(1), td:nth-child(1), tfoot td:nth-child(1) {
        width: 50px; /* Adjust width as needed */
    }
    th:nth-child(2), td:nth-child(2), tfoot td:nth-child(2) {
        width: 200px; /* Adjust width as needed */
    }
</style>
<div class="" role="main">
    <div class="">
        <div class="page-title">
            <div class="title_left">
                <h5>{{$header['pageTitle']}} </h5>
            </div>
            <!-- USER LEVEL SUPERVISOR=10 WILL LOGIN -->
        </div>
        <div class="clearfix"></div>
        <div class="row">
         <div class="col-sm-12 col-md-12 col-lg-12">
            <div class="col-sm-2 col-md-2 col-lg-2">
               <div class="form-group">
                  <label for="exampleInputFormDat">Date</label>
                  <input name="startDat" id="startDate" class="check" />
                  <!-- <input type="text" class="form-control datepickerMonthYearAppend1" value="{{date('01-m-Y')}}" id="fromDate" aria-describedby="" placeholder=""> -->
               </div>
            </div>
            <div class="col-sm-2 col-md-2 col-lg-2" style="margin-top: 2%">
               <div class="field item form-group">
                  <label class="col-form-label col-md-3 col-sm-3  label-align"></label>
                  <div class="col-md-9 col-sm-9">
                     <button type="button" id="searchID" class="btn btn-info btn-sm">Search</button>
                  </div>
               </div>
            </div>
         </div>
      </div>
        <div class="row">
            <div class="col-md-12 col-sm-12 col-lg-12">
                <div class="x_panel">
                    <div class="x_title" style="border:none;">
                        <h2>{{$header['tableTitle']}} </h2>
                    </div>
                    <div class="x_content">
                    <div class="row">
                            <div class="col-sm-12">
                                <div class="card-box table-responsive searchResult">
                                    <table id="datatable" class="table table-striped table-bordered dataTable "
                                        role="grid" aria-describedby="data-table-info" width="100%">
                                        <thead style="background-color: #0b58a2; color: white">
                                            <tr>
                                                <th data-orderable="false">Sl</th>
                                                <th data-orderable="false">Employee Info</th>
                                                @for ($i = 1; $i <= $totalDaysInMonth; $i++)
                                                    <th data-orderable="false" style="min-width:22px !important;">{{ $i }}</th>
                                                @endfor
                                                <th data-orderable="false">Total</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                                // Initialize an array to store daily meal totals
                                                $dailyTotals = array_fill(1, $totalDaysInMonth, 0);
                                            ?>
                                            @foreach($employees as $key => $emp)
                                            <tr>
                                                <td style="background-color:#e4f0e9;">{{ $key+1 }}</td>
                                                <td style="background-color:#e4f0e9;">
                                                    <div style="width:200px !important;">
                                                        {{ $emp->employee_name }}
                                                    </div>
                                                </td>
                                                <?php
                                                $totalMeal = 0;
                                                for($i = 1; $i <= $totalDaysInMonth; $i++){
                                                    $mealDate = date('Y-m-' . str_pad($i, 2, '0', STR_PAD_LEFT)); // Ensure two-digit day format
                                                    $mealStatus = isset($meals[$emp->employee_id]) ? $meals[$emp->employee_id]->firstWhere('meal_date', $mealDate) : null;

                                                    if ($mealStatus) {
                                                        // Show check if meal status is 1, otherwise show cross
                                                        if ($mealStatus->meal_status == '1') {
                                                            $totalMeal += 1;
                                                            $dailyTotals[$i]++; // Increment daily total
                                                            echo '<td class=""style="text-align:center;"><span style="color:green;">&#x2714</span></td>';
                                                        } else {
                                                            echo '<td class="" style="text-align:center;"><span style="color:black;">&#x2716;</span></td>';
                                                        }
                                                    } else {
                                                        // No output if no meal data exists for this date
                                                        echo '<td class=""></td>';
                                                    }
                                                }
                                                ?>
                                                <td><b>{{ $totalMeal }}</b></td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                        <tfoot>
                                        <tr>
                                                <th data-orderable="false" colspan="2"></th>
                                                @for ($i = 1; $i <= $totalDaysInMonth; $i++)
                                                    <th data-orderable="false"><b>{{ $dailyTotals[$i] }}</b></th>
                                                @endfor
                                                <th data-orderable="false"></th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function() {
        $('.dataTable').dataTable({
            fixedColumns: {
                left: 2,
            },
            fixedHeader: {
                header: true,
                footer: true
            },
            scrollCollapse: true,
            scrollX: true,
            scrollY: 400
        });
    });
</script>

<script>
     $('#searchID').click(function (){
         var startDate = $('#startDate').val();
   
         if(startDate ==""){
             alert('Please Select Form Date');
         }else{
             var _token = '{{csrf_token()}}'
             
             $.ajax({
                 type: 'GET',
                 url: '{{url("/search_meal_status")}}',
                 data: { startDate: startDate},
                 success: function (data) {
                     $('.searchResult').html(data);
                     $(".dataTable").dataTable({
                        fixedColumns: {
               left: 2,
           },
           fixedHeader: {
               header: true,
               footer: true
           },
           scrollCollapse: true,
           scrollX: true,
           scrollY: 400
                    });
                 }
             });
         }
     })
</script>
<script type="text/javascript">
   $(function() {
       $('.check').datepicker( {
       changeMonth: true,
       changeYear: true,
       showButtonPanel: true,
       dateFormat: 'MM yy',
       onClose: function(dateText, inst) { 
           $(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
       }
       });
   });
</script>
<style>
   .ui-datepicker-calendar {
   display: none;
   }
</style>
@endsection
