@extends('layouts.master')

@section('content')
@section('title')
@endsection
<style>
    ul li.active,
    a.active {
        color: #3fbbc0;
    }

</style>
<div class="" role="main">
    <div class="">
        <div class="page-title">
            <div class="title_left">
                <h5>{{$header['pageTitle']}} </h5>
            </div>
            <!-- USER LEVEL SUPERVISOR=10 WILL LOGIN -->
            <div class="title_right">
                <div class="item form-group">
                    <div class="col-md-3 col-sm-3 offset-md-9">
                        <button type="button" class="btn btn-primary dynamicModal" pageTitle="Guest Meal Request"
                            pageLink="{{URL::route('guestMealCreate')}}" data-toggle="tooltip" data-placement="left"
                            title="Add Request" data-target=".bs-example-modal-lg" data-modal-size="modal-lg">Add
                            New</button>
                    </div>
                </div>
            </div>
        </div>
        <div class="clearfix"></div>
        <div class="row">
            <div class="col-md-12 col-sm-12 col-lg-12">
                <div class="x_panel">
                    <div class="x_title" style="border:none;">
                        <h2>{{$header['tableTitle']}} </h2>
                    </div>
                    <div class="x_content">
                    <div class="row">
                            <div class="col-sm-12">
                                <div class="card-box table-responsive searchResult">
                                    <table id="datatable" class="table table-striped table-bordered dataTable "
                                        role="grid" aria-describedby="data-table-info" width="100%">
                                        <thead style="background-color: #0b58a2; color: white">
                                            <tr>
                                                <th>Sl</th>
                                                <th>Employee Name</th>
                                                <th>Department</th>
                                                <th>Date</th>
                                                <th>Total Meal</th>
                                                <th>Meal Title</th>
                                                <th>Status</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($results as $key=> $result)
                                            <tr>
                                                <td>{{$key+1}}</td>
                                                <td>{{$result->employee_name}}</td>
                                                <td>{{$result->department_name}}</td>
                                                <td>{{date("d-M-Y", strtotime($result->meal_date))}}</td>
                                                <td>{{$result->total_meal}}</td>
                                                <td>{{$result->request_reason}}</td>
                                                <td>
                                                    @if($result->request_status =='1')
                                                      <b><span style="color:orange;">{{"Pending"}}</sapn></b>
                                                      @elseif($result->request_status =='2') 
                                                      <b><span style="color:tomato;">{{"Submitted"}}</sapn></b>
                                                      @elseif($result->request_status =='3') 
                                                      <b><span style="color:green;">{{"Approved"}}</sapn></b>
                                                      @else
                                                      <b><span style="color:red;">{{"Cancled"}}</sapn></b>
                                                      @endif</td>
                                                <td class="text-center">
                                                    <button type="button" class="btn btn-primary btn-sm dynamicModal"
                                                        pageTitle="Update Meal"
                                                        @if($result->request_status =='3') disabled @endif
                                                        pageLink="{{url('/request_approve/'.$result->id)}}"
                                                        data-modal-size="modal-lg" data-toggle="tooltip"
                                                        data-placement="top" title="Update Meeting">
                                                        <i class="glyphicon glyphicon-edit"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
