<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Room Booking Request</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background-color: #f4f4f4;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }
        .container {
            background-color: #f1f4eb;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            max-width: 600px;
            width: 100%;
        }
        p {
            line-height: 1.6;
        }
        a {
            color: #0066cc;
            text-decoration: none;
        }
        a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="container">
        <p>Dear Concern,</p>

        <p>{{$description}}, we need the {{$room_no}} as per below schedule:</p>

        <p>Date: {{date('d-M-Y',strtotime($meeting_date))}}<br>
        Time: {{$start_time}} to {{$end_time}}</p>

        <p>Thank you for your support.</p>

        <p>Thanks & Regards,</p>

        <p>{{$name}}<br>
        {{$designation_name}}<br>
        {{$department_name}}<br>
        E-mail: <a href="{{$email_address}}">{{$email_address}}</a><br>
        Mobile: {{$contact_no}}</p>
    </div>
</body>
</html>
