<!doctype html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://getbootstrap.com/docs/5.3/assets/css/docs.css" rel="stylesheet">
    <title>Company Policy</title>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  </head>
  <body class="p-3 m-0 border-0 bd-example m-0 border-0">

    <!-- Example Code -->
    <style>
        .chapter {
            //padding: 10px;
            //border: 3px solid rgb(86, 123, 241);
            margin: 1px;
        }

        .section {
            margin-bottom: 20px;
        }

        h1,
        h2,
        h3 {
            margin: 10px 0;
        }

        ol,
        ul {
            margin: 0;
            padding-left: 20px;
        }

        .subsection {
            margin-top: 10px;
            padding-left: 20px;
        }

        .subsection h3 {
            margin-top: 0;
        }

        .subsection ul,
        .subsection ol {
            margin-top: 5px;
        }


        .subsubsection {
            margin-top: 15px;
            padding-left: 25px;
        }

        .subsubsection h3 {
            margin-top: 0;
        }

        .subsubsection ul,
        .subsubsection ol {
            margin-top: 10px;
        }

        .roman-list {
            list-style-type: none;
            counter-reset: roman-counter;
        }

        .roman-list li::before {
            content: counter(roman-counter, lower-roman) ". ";
            counter-increment: roman-counter;
            margin-right: 5px;
        }

        ul {
            list-style: none;
        }

        ul li:before {
            content: '✓ ';
        }

        table,
        th,
        td {
            border: 1px solid black;
            border-collapse: collapse;
            padding-left: 5px;
        }

        .head-style {
            background-color: rgb(70, 128, 236);
            text-align: left;
        }

        .md-info {
            line-height: .2;
        }
        .line-space{
            line-height: 1;
        }
    </style>
   
  <div class="accordion" id="accordionExample">
  <div class="accordion-item">
  <div class="chapter">
        <div style="padding:2px;">
            <h3>Employee Handbook for Corporate Office
                National Polymer Group
            </h1>
            <!-- <input type='checkbox' name='checkbox' class='getCheckboxValue' value='1'> -->
        </div>
    </div>
    <div class="chapter">
        <div style="padding:2px;">
            <h4 style="text-align: center;">Message from Managing Director</h2><br>
            <div>
                Welcome to NPOLY!
            </div><br>
            <div>
                Our roots start from humble beginnings, through the import and trading of petrochemical
                products in Bangladesh, since 1978. However, the greatest strength of our Group is the ability
                to show flexibility with changing markets, and convert market changes into high growth.
                Today, 95% of all products manufactured by NPOLY occupy either 1st or 2nd position in the
                Bangladesh market. Starting from its pioneering and leadership position, the NPOLY name
                stands as a symbol of high quality products. NPOLY also exports its manufactured products to
                four continents, including footwear, thus establishing itself as a strong export earner for the
                company. We believe that if our employees are happy, they are able to perform. If they are able
                to perform, then we will be able to fulfill our commitment to the rest of our stakeholders. We
                actively promote a structured corporate culture as well as a performance based reward system.
                We shall also ensure our entry into new markets where we are able to keep our position as one
                of top three. We welcome you to grow with us.
            </div><br><br><br>
            <div>
                <p class="md-info">Riad Mahmud</p>
                <p class="md-info">Managing Director</p>
                <p class="md-info">National Polymer Group</p>
            </div>
        </div>
    </div>
  </div>
  <div class="accordion-item">
    <h2 class="accordion-header" id="headingOne">
      <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
      <h6>CHAPTER - 1: INTRODUCTION</h6>
      </button>
    </h2>
    <div id="collapseOne" class="accordion-collapse collapse" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
      <div class="accordion-body">
      <div class="chapter"><br>
        <div class="section">
            <h6><b>1.1 TITLE OF THE HANDBOOK</b></h6>
            <p>This handbook shall be referred to as <b>“Employee Handbook of National Polymer
                    Group, Corporate Office”.</b></p>
        </div><br>
        <div class="section">
            <h6><b>1.2 APPLICABILITY</b></h6>
            <p>These rules shall be applicable to all employees of corporate head office sister concerns of
                National Polymer Industries except for non-management staff of manufacturing unit where a
                separate HR Manual has been incorporated. </p>
        </div><br>
        <div class="section">
            <h6><b>1.3 REVISION OF THE HANDBOOK</b></h6>
            <p>The Employee Handbook can be updated or amended as needed time to time to reflect changes
                in company policies, procedures, and industry regulations or best practices. The Management
                keeps the sole discretion to change/amend/revise the policies, procedures and practices
                mentioned in this handbook as and when deemed applicable. All such amends made from time
                to time upon approval from the Management will be treated as integral part of the handbook. </p>
        </div><br>
        <div class="section">
            <h6><b>1.4 COMPANY PROFILE</b></h6>
            <p><b>National Polymer Group</b> is one of the premier conglomerates in Bangladesh and started
                its business officially in June 1987 and now it is growing successfully in multiple sectors.
                Striving to implement the practical initiatives required for achieving its vision and guided by
                a relentless focus on values, the group maintains close relations with its target customer
                thereby guaranteeing quality uPVC, PP-R, CPVC pipes and fittings, PVC Doors, Sheet, and
                Ceiling along with Plastic Household and Furniture products and efficient service to their
                valued customers. National Polymer Group (NPOLY Group) believes in delivering operational
                excellence to meet commitments. For the progression of its mission, it has diversified its
                products and grown to be one of the largest industrial conglomerates in the country. With
                diversification and a rich variation of products, it has earned a reputation among Bangladeshi
                people and abroad as a manufacturer of premium and quality products and services.
                The Company maintains high standards of quality and is able to guarantee highly professional
                service to meet the customers' demands. The Company's product quality has attained a level
                that paved the way for the Company to receive internationally acknowledged quality
                management system certification <b>ISO 9001:2008</b>.</p>
            <div class="subsection">
                <h6>1.4.1. Vision</h6>
                <p>To establish itself as a role model in the plastic industry in Bangladesh with its innovative
                    products, services, and solutions.
                </p>
            </div>
            <div class="subsection">
                <h6>1.4.2. Mission</h6>
                <p>To be the eminent manufacturer of best quality products for its existing and potential
                    customers through product leadership, excellent values, and superior quality.</p>
            </div>
            <div class="subsection">
                <h6>1.4.3. Objectives</h6>
                <ol class="roman-list">
                    <li>To promote quality products with the objective of setting a benchmark for industry
                        practice.
                    </li>
                    <li>To promote and develop standards, specifications, and practices that help to ensure the
                        proper use of plastic products.</li>
                    <li>To enhance knowledge and awareness of contemporary plastic pipeline technologies
                        amongst installers and users.
                    </li>
                    <li>To achieve excellence in people through creativity, research, and development.</li>
                </ol>
            </div><br>
            <div class="subsection">
                <h6>1.4.4. Core Values</h6>
                <ul> &#10146; <b>Commitment:</b>
                    <ol class="roman-list">
                        <li><b>Shareholders:</b> Create sustainable value for the shareholders by utilizing an honest
                            and
                            efficient business methodology.
                        </li>
                        <li><b>Customers:</b> Render quality services to the customers by using the state-of-the-art
                            technology, offering diversified quality products to fulfill their needs to the best of its
                            abilities.</li>
                        <li> <b>Employees:</b> Be reliant on the inherent talents of the employees. Work together to
                            celebrate and reward the skills and talents of everyone at the work place.
                        </li>
                        <li> <b>Community:</b> To serve the society through employment generation with equal
                            opportunities, support the community events and be a responsible corporate citizen.
                        </li>
                    </ol>
                </ul>
                <ul style="margin-top:15px !important;"> &#10146; <b>Accountability:</b>
                    <p>The company is accountable for providing quality products and services to its valued
                        customers along with meeting the regulatory requirements and ethical business practices.</p>
                </ul>
                <ul> &#10146; <b>Respectfulness:</b>
                    <p>The Company is always respectful to its customers, shareholders, and other stakeholders. It
                        always appreciates comments and suggestions from its stakeholders.</p>
                </ul>
            </div>
        </div>
        <div>
            <input type="checkbox" @if(!empty($policyInfo->chap1_status) && $policyInfo->chap1_status =='1') disabled checked @endif class="agree_policy" name="chapter_one" vale="0"> <span style="color:red;">Are you Agree Chapter 1 ?</span>
        </div>
    </div>
      </div>
    </div>
  </div>
  <div class="accordion-item">
    <h2 class="accordion-header" id="headingTwo">
      <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
      <h6>CHAPTER - 2: CORPORATE POLICY AND PROCEDURE<h6>
      </button>
    </h2>
    <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo" data-bs-parent="#accordionExample">
      <div class="accordion-body">
      <div class="chapter">
        <div>
            Corporate policies govern and guide business conduct for National Polymer Group and its
            employees. These policies cover important aspects of NPOLY business and every employee shall
            conform to and abide by these guidelines and shall observe, comply with and obey orders and
            directions of his/her Superiors under whose supervision or control he/she may be placed. Strict
            observance of rules and regulations as enforced from time to time is a primary condition of the
            employment.
        </div> <br>
        <div class="section">
            <h6><b>2.1 CODE OF CONDUCT (COC)</b></h6>
            <p>National Polymer Group conducts its business with honesty and integrity and in compliance
                with all applicable legal and regulatory requirements. This Code of Conduct (COC) sets out the
                fundamental standards to be followed by employees in their everyday actions both as individuals and as
                an employee of the company. Further guidance on the company’s standards
                in specific areas will be provided through related corporate policies and guidelines.
                This COC applies to all its directors, employees, officers, partners, vendors, and beneficiaries
                of NPOLY Group and we expect everyone to adhere to its principles and uphold the highest
                business standards in all activities. </p>
        </div>
        <div class="section">
            <h6><b>2.2 PROFESSIONAL ETHICS</b></h6>

            <p>NPOLY employees must:</p>
            <p class="line-space"><b>2.2.1</b> Conduct the company's business with honesty and integrity.</p>
            <p class="line-space"><b>2.2.2</b> Protects the company's image and reputation.</p>
            <p class="line-space"><b>2.2.3</b> Build relationships based on trust, respect and dignity.</p>
            <p class="line-space"><b>2.2.4</b> Practice fair competition.</p>
            <p class="line-space"><b>2.2.5</b> Comply with all applicable laws, regulations, and industry standards.</p>
            <p class="line-space"><b>2.2.6</b> Safeguard the company's confidential information, trade secrets</p>
            <p class="line-space"><b>2.2.7</b> Cooperate fully in any audit, inquiry review, or investigation by the company.</p>
            <p class="line-space"><b>2.2.8</b> Avoid hypocrisy and double standards.</p>
            <p class="line-space"><b>2.2.9</b> Failure by any employee to comply with COC is subject to disciplinary action up to and
                including separation from employment with the company. </p>
        </div><br>
        <style>
            .margin-bottom{
                margin-bottom:1px !important;
            }
        </style>
        <div class="section">
            <h6><b>2.3 EMPLOYMENT SERVICE CONDUCT</b></h6>
            <p>As an employee of NPOLY Group:</passthru>
            <p class="margin-bottom"><b>2.3.1</b> No employee shall, directly or indirectly, engage himself, without prior written
                permission of the Management of the Company.</p>
            <p class="margin-bottom"><b>2.3.2</b> Any direct/ indirect/ part-time engagement/ stake holding with any other organization
                should not lead to any Conflict of Interest.</p>
            <p class="margin-bottom"><b>2.3.3</b> The employee shall always assure and ensure service to the company faithfully and
                diligently as entrusted to her/him.</p>
            <p class="margin-bottom"><b>2.3.4</b> Services of an employee shall be liable to be transferred to any office/ department/
                section/ unit as per the decision of the management.</p>
            <p class="margin-bottom"><b>2.3.5</b> An employee shall neither be absent from her/his duties nor leave the station without
                informing her/his HOD. The employee shall inform the HOD as soon as possible but
                not more than 03 (three) days of his absence. </p>
            <p class="margin-bottom"><b>2.3.6</b> In case of sudden sickness or accident or any unavoidable reason, anyone on her/his
                behalf should inform the HOD within 03 (three) days. </p>
            <p class="margin-bottom"><b>2.3.7</b> No employee shall be involved in any criminal and/or subversive political activity.</p>
            <p class="margin-bottom"><b>2.3.8</b> No employee shall, without prior permission of the management, contribute to any
                print or electronic media nor shall make public or publish any document, paper, or
                information of the company which may come into her/his custody.</p>
            <p class="margin-bottom"><b>2.3.9</b> No employee shall sign any business, contract, or document, making any financial
                commitment on behalf of the company unless he/she is specifically authorized to do
                so.
            </p>
            <p class="margin-bottom"><b>2.3.10</b> No employee, during her/his employment, shall disclose any information relating to
                the company or its clients or any trade secrets to any person or to any organization. If
                this is done by the employee, the company may take legal action.
            </p>
        </div><br>
        <div class="section">
            <h6><b>2.4 PERSONAL APPEARANCE AND ATTIRE POLICY</b></h6>
            <div>
                It is the policy of NPOLY that each employee’s dress, grooming, and personal hygiene should
                be appropriate to the work situation complementing an environment that reflects an efficient,
                orderly, and professionally operated organization.
                It is intended to define appropriate “personal appearance and attire” for business days from
                Saturday to Thursday.

            </div>
            <div class="subsection"><br>
                <h6>2.4.1 Business Attire:</h6>
                <ul> &#10146; <b>Men:</b>
                    <span>
                        Employees are expected at all times to present a professional, businesslike image
                        to customers, prospects, and other external business associates. Employees at corporate
                        office and other offices must comply with t h e following personal appearance
                        standards:
                    </span>
                    <ol class="roman-list">
                        <li>Employees are expected to wear formal attire, i.e., formal shirt and trousers, and polished
                            shoes. Wearing of suit or blazer is advised in the appropriate external meetings.
                        </li>
                        <li>Employees should not wear suggestive attire, i.e., jeans, shorts, t-shirt, half sleeve
                            shirt,
                            slippers/ sandal, and similar items.</li>
                        <li>Employees should maintain good personal hygiene. Hair should be clean and welltrimmed,
                            moustaches and the beards should be well-trimmed.

                        </li>
                        <li> All Support Staff (Peon, Cleaner, Messenger), Security Guards, and Drivers shall be
                            provided with dress to be given in each calendar year. This shall be strictly used for
                            official
                            purposes as per the rules of the Company.

                        </li>
                    </ol>
                </ul>
                <ul> &#10146; <b>Women:</b>
                    <span>
                        Any attire that is socially and culturally acceptable and does not hurt/offend
                        anyone’s religious values or sentiments. If unclear about whether or not a particular dress
                        complies with these guidelines, employees should contact HR or their supervisor for
                        guidance.

                    </span>
                    <ol class="roman-list">
                        <li>Employees are expected to wear formal attire, i.e., decent three pieces/ saree/ borka.

                        </li>
                        <li>Employees should not wear suggestive attire, i.e., jeans, sleeveless, leggings, shoe with
                            more than 3" hill t-shirt, sandal, and similar items.</li>
                        <li>Avoid heavy makeup and jewelry.

                        </li>

                    </ol>
                </ul>
            </div>
            <div class="subsection"><br>
                <h6>2.4.2 Enforcement:</h6>
                <p>HODs and supervisors are responsible for monitoring and enforcing this policy guideline. It
                    will be administered according to the following action steps:</p>
                <ol class="roman-list">
                    <li>If an obvious policy violation occurs,the HOD/ supervisor will hold a private discussion
                        with the employee and depending on the level of inappropriateness of attire, may ask the
                        employee to go home and change her/his attire immediately.
                    </li>
                    <li>Repeated policy violations will result in disciplinary action, up to and including
                        termination.
                    </li>
                </ol>
            </div>
            <div class="subsection"><br>
                <h6><b>2.5 INTERNAL REPORTING OF MISCONDUCT AND UNLAWFUL CONDUCT</b></h6>
                <div>
                    In accordance with the NPOLY COC, the company seeks to deter and detect misconduct and
                    to ensure that any genuine concerns about misconduct or unlawful conduct, which an
                    individual believes may be taking place are raised at an early stage in a responsible and
                    confidential manner. Examples of such concerns may include, but are not limited to:

                </div>
                <ol class="roman-list">
                    <li>Corruption, bribery, blackmail or other criminal offenses.
                    </li>
                    <li>Willful disobedience to any lawful or reasonable order of a superior.</li>
                    <li>Theft, fraud, dishonesty in connection with the Company’s business or property.
                    </li>
                    <li>Absence from duty without permission/information or absence without leave.
                    </li>
                    <li>Late attendance, habitual absence, negligence of work, and improper dressing.</li>
                    <li>Riotous or disorderly behavior in the Company offices.</li>
                    <li>Unauthorized use of the Company’s property.</li>
                    <li>.Falsifying, tampering with, damaging, or causing loss of the official records.</li>
                    <li>Causing internal damage to or loss of the Company’s goods or property</li>
                    <li>Undignified, rude, or indifferent dealing with any customer or fellow employee or any
                        act subversive of discipline.</li>
                    <li>Discrimination or harassment.
                    </li>
                    <li>Conflicts of interest.</li>
                    <li>Divulging official secrets of the company</li>
                    <li>Fraud and financial irregularity.</li>
                    <li>Failure to comply with NPOLY policies or procedures</li>
                    <li>Endangering the health and safety of any individual.</li>
                    <li>Damage to the environment.</li>
                </ol><br>
                <div>The company will address any genuine concerns raised about misconduct or unlawful conduct
                    with proper measures through a grievance handling process, investigation, or disciplinary
                    process as applicable to that particular incident. </div>
            </div><br>
            <div class="subsection">
                <h6><b>2.6. DIVERSITY</b></h6>
                <div>
                    NPOLY is conducting business in diverse cultures, environments, and communities. Managers
                    are therefore expected to promote and effectively manage diversity within the company to
                    increase overall productivity, market share, and enhance employee loyalty.
                    Managers are also expected to embrace diversity as an integral part of business strategy and
                    ensure that harassing, discriminatory, or offensive behavior based on differences of
                    background, culture, belief, or characteristics is not permitted or tolerated. Managers must
                    also ensure that others with whom NPOLY has dealings (internal and external stakeholders)
                    are aware of and will respect this policy.

                </div>
            </div><br>
            <div class="subsection">
                <h6><b>2.7. EQUALITY OF TREATMENT</b></h6>
                <div>
                    NPOLY is committed to the principles of equal opportunity and equality of treatment. Each
                    employee is entitled to equal respect and dignity.
                </div>
            </div><br>
            <div class="subsection" style="margin-bottom:30px !important;">
                <h6><b>2.8 GENDER EQUITY</b></h6>
                <div>
                    This policy is established to emphasize NPOLY’s unwavering commitment to fostering gender
                    equity within the workplace. It aims to ensure that all employees, irrespective of gender, are
                    treated fairly and equitably. The policy spans across recruitment, hiring, promotions,
                    compensation, training opportunities, and work assignments. By adhering to this policy,
                    NPOLY aims to create an inclusive environment that values diversity and provides equal
                    opportunities for professional growth. This policy refers to the fair and impartial treatment of
                    all employees, irrespective of gender, across various aspects of employment.
                </div><br>
                <div class="subsbusection" style="margin-bottom:30px !important;">
                    <h6>2.8.1 Discrimination:</h6>
                    <p>Discrimination involves any unjust or prejudicial treatment based on gender, including but
                        not limited to recruitment, promotions, compensation, and work assignments. </p>
                </div>
                <div class="subsbusection">
                    <h6>2.8.2 Harassment:</h6>
                    <p>Harassment is any inappropriate conduct which has the purpose or effect of: </p>

                    <ol class="roman-list">
                        <li>Creating an intimidating, hostile, or offensive work environment;</li>
                        <li>Unreasonably interfering with an individual's work performance and personal issues; or</li>
                        <li>Affecting an individual's employment opportunity.</li>
                        <li>Unwelcome verbal or physical advances and sexually, racially, or otherwise offensive or
                            discriminatory materials, statements or remarks. </li>
                        <br>
                        <div>
                            Every employee has the right to work in an environment free from harassment, intimidation,
                            or offensive behavior and in which issues of harassment will be resolved without fear of
                            reprisal. Harassment, in any form, toward employees, contractors, suppliers, customers or
                            persons associated in business relation with NPOLY are STRICTLY PROHIBITED.
                        </div>
                    </ol>
                </div><br>
                <div class="subsbusection" style="margin-bottom:30px !important;">
                    <h6>2.8.3 NPOLY’s Commitment:</h6>
                    <p>NPOLY is committed to providing equal opportunities for professional development and
                        advancement, irrespective of gender. </p>
                </div>
                <div class="subsbusection">
                    <h6>2.8.4 Reporting Discrimination or Harassment:</h6>
                    <p>Employees are encouraged to report any instances of gender-based discrimination or
                        harassment promptly. The company will ensure confidentiality and protection for individuals
                        reporting in good faith. </p>
                </div>
            </div>
            <div class="subsection">
                <h6><b>2.9 CONFLICT OF INTEREST</b></h6>
                <div>
                    NPOLY prioritizes transparency and ethical conduct. A situation in which a person is in a
                    position to derive personal benefit from actions or decisions made in their official capacity:
                </div>
                <ol class="roman-list">
                    <li>to approve or control contractors between the company and a member of his/her
                        immediate family under the employee’s administrative control; </li>
                    <li>to give or release any data or information of a confidential nature; </li>
                    <li>to accept commissions, gifts, and/or any other personal favors;</li>
                    <li>to use company personnel, facilities, equipment for personal benefit.
                    </li>
                </ol>
                <br>
                <div class="subsbusection">
                    <h6>2.9.1 Management of Conflict of Interest </h6>
                    <ol class="roman-list">
                        <li>Disclosure and Resolution: Employees or Directors must promptly report potential
                            conflicts of interest to the Head of Internal Audit and Compliance (HOA) for ethical
                            resolution.</li>
                        <li>Investigation: The HOA will investigate disclosed conflicts and refer matters violating the
                            policy to the Management Committee if necessary. </li>
                        <li>Documentation and Review: A conflict of interest register will record identified conflicts,
                            reviewed annually to prevent future issues.
                        </li>

                    </ol>
                </div>
                <br>
                <div class="subsbusection">
                    <h6>2.9.2 Reporting of Violations</h6>
                    <div>NPOLY mandates compliance with the policy and requires reporting of any policy violations
                        through Audit and Compliance Department and Violations may lead to disciplinary actions,
                        including termination of employment.
                    </div>
                </div>
            </div><br>
            <div class="subsection">
                <h6><b>2.10 GIFT, GRATITUDE & BUSINESS COURTESIES</b></h6>
                <div>
                    This policy is established to ensure employees integrity & uphold the commitment to ethical
                    business practices.

                </div>
                <ol class="roman-list">
                    <li>Employees are discourage to give & receive gift. If value exceeding BDT. 500/=, should be
                        reported to supervisor or HR.
                    </li>
                    <li>Expression of gratitude such as thank you notes, tokens of appreciation or non-material
                        acknowledgement.</li>
                    <li>Business courtesies such as meals, entertainment, or invitation should be reasonable &
                        directly related to business activities.</li>
                    <li>Violation of this policy may result in disciplinary action, depending on the nature and
                        severity.

                    </li>
                </ol>
            </div><br>
            <div class="subsection">
                <h6><b>2.11 ANTI-CORRUPTION</b></h6>
                <div>
                    This Anti-corruption Policy is established to outline the principles and guidelines that all
                    employees must adhere to, in order to prevent corruption, bribery, and unethical practices.

                </div><br>
                <p class="margin-bottom"><b>2.11.1 Corruption: </b>Corruption includes but is not limited to bribery, extortion, fraud,
                    collusion, and any other unethical practices aimed at obtaining an undue advantage.</p>
                <p class="margin-bottom"><b>2.11.2 Bribery: </b>Bribery involves the offering, giving, receiving, or soliciting of anything of
                    value to influence the actions of an official or other person in a position of trust.</p>
                <p class="margin-bottom"><b>2.11.3 Facilitation Payments: </b>Facilitation payments are small payments or gifts made to
                    expedite routine government actions.</p>
                    <br>
                <div class="subsbusection">
                    <h6>2.11.4 General Guidelines:</h6>
                    <div>NPOLY has a zero-tolerance policy towards corruption in any form. Employees are strictly
                        prohibited from engaging in corrupt practices.</div>
                    <ol class="roman-list">
                        <li>Gifts and entertainment should be reasonable, transparent, and in compliance with the
                            company's Gifts, Gratitude, and Business Courtesies policy.</li>
                        <li>Employees must not offer, give, receive, or solicit bribes or engage in extortion in any
                            business dealings.</li>
                        <li>Facilitation payments are strictly prohibited, and employees should report any requests
                            for such payments to HR.
                        </li>
                        <li>Employees should avoid situations where personal interests conflict with their duty to act
                            in the best interests of the company.</li>
                        <li>Employees are encouraged to report any suspected or observed acts of corruption
                            promptly.
                        </li>
                        <li>Violations of this policy may result in disciplinary action.</li>

                    </ol>
                </div>
            </div><br>
            <div class="subsection">
                <h6><b>2.12 DATA INTEGRITY AND COMPLIANCE POLICY</b></h6>
                <div>
                    NPOLY is commitment to upholding the highest standards of data integrity and compliance.
                    It is designed to instill a culture where all employees are dedicated to handling company data
                    with precision, confidentiality, and strict adherence to applicable laws and regulations.

                </div>
<br>
                <div class="subsbusection">
                    <h6>2.12.1 Data Integrity:</h6>
                    <div>Data integrity pertains to the accuracy, consistency, and reliability of data throughout its
                        lifecycle. Employees are entrusted with maintaining the quality and trustworthiness of the
                        data they handle.</div>
                </div><br>
                <div class="subsbusection">
                    <h6>2.12.2 Confidential Information:</h6>
                    <div>Confidential information encompasses any data or records that are not publicly available and
                        could potentially harm the company or individuals if disclosed without proper authorization.
                        Employees are obligated to treat such information with the highest level of confidentiality.
                    </div>
                </div><br>
                <div class="subsbusection">
                    <h6>2.12.3 Data Compliance:</h6>
                    <div>Data compliance involves the rigorous adherence to all applicable laws, regulations, and
                        internal policies related to data handling and protection.
                    </div>
                    <h6><b>The general guidelines of the policy are as follows:</b></h6>
                    <ol class="roman-list">
                        <li>All employees bear the responsibility of ensuring the accuracy and completeness of the
                            data they handle.</li>
                        <li>Unauthorized access, sharing, or disclosure of such data is strictly prohibited, and
                            employees should be aware of the sensitive nature of the information they encounter in
                            their roles.</li>
                        <li>Employees are expected to comply with security protocols, including password protection,
                            encryption, and secure file transmission, and report any security concerns promptly.
                        </li>
                        <li>Employees must familiarize themselves with these laws and integrate compliance into
                            their daily activities involving data.</li>
                        <li>Employees must be vigilant in recognizing and promptly reporting any actual or suspected
                            data breaches or incidents, to the IT department or relevant authorities as required by law.
                        </li>
                    </ol>
                </div><br>
                <div class="subsbusection">
                    <h6>2.12.5 Violations of this Policy:</h6>
                    <div>Violations of this policy may result in disciplinary action, ranging from counseling and
                        education to more severe consequences, depending on the nature and severity of the violation.
                    </div>
                </div>
            </div><br>
            <div class="subsection">
                <h6><b>2.13 OPEN DOOR COMMUNICATION POLICY</b></h6>
                <div>
                    This comprehensive Open Door Communication Policy is established to cultivate a workplace
                    environment at NPOLY that ensures transparency, trust, and open dialogue among all
                    employees and the management. The primary objective is to provide a structured mechanism
                    for employees to voice concerns, share innovative ideas, seek guidance, and address workplace
                    issues without the fear of retaliation, thereby contributing to a culture of continuous
                    improvement and employee satisfaction.
                </div>
                <ol class="roman-list">
                    <li>To encourage employees to discuss and resolve their concerns, problems, and ideas with
                        the supervisors and/or management.</li>
                    <li>Employees are assured that their feedback will be treated with utmost confidentiality and
                        will not affect their employment or career. </li>
                    <li>Managers and supervisors are responsible to establish open door communication with
                        highest degree of confidentiality.
                    </li>
                </ol>
            </div><br>
            <div class="subsection" style="margin-bottom:30px !important;">
                <h6><b>2.14 ALCOHOL & DRUG USE POLICY</b></h6>
                <div>
                    This policy is established to maintain a safe, healthy, and productive work environment at
                    NPOLY by outlining the company's expectations regarding alcohol and drug use. The purpose
                    is to ensure the well-being of employees, promote workplace safety, and protect the reputation
                    of the company.
                </div><br>
                <div class="subsbusection">
                    <h6>2.14.1 General Guidelines:</h6>
                    <div>
                        <ol class="roman-list">
                            <li>The use, possession, sale, or distribution of illegal drugs during working hours or on
                                company premises is strictly prohibited.
                            </li>
                            <li>Employees using prescription drugs that may impact job performance must inform their
                                supervisor and HR.</li>
                            <li>NPOLY reserves the right to conduct drug tests under applicable laws and regulations,
                                including pre-employment screenings, random testing, or testing based on reasonable
                                suspicion.</li>
                        </ol>
                    </div><br>
                    <p><b>2.14.2 Reporting Incident:</b>Employees are encouraged to report concerns/ incidents
                        related to alcohol or drug use impacting workplace safety or performance to HR. NPOLY
                        provides an Employee Assistance Program offering confidential support, counseling, and
                        rehabilitation resources for employees.</p>
                    <p><b>2.14.3 Violation of this Policy:</b>Violation of this policy may lead to disciplinary action,
                        ranging from counseling and education to suspension or termination of employment, based
                        on the nature and severity of the violation.
                    </p>
                </div>

            </div>
            <div class="subsection">
                <h6><b>2.17 Harassment:</b></h6>
                <div>Npoly is committed to ensure a work environment that fosters mutual employee respect and
                    working relationships free of harassment. Harassment is any inappropriate conduct which has
                    the purpose or effect of:
                </div>
                <div>
                    <ol class="roman-list">
                        <li>creating an hostile or offensive work environment;</li>
                        <li>unreasonably interfering with an individual's work performance and personal issues;
                        </li>
                        <li>affecting an individual's employment opportunity.</li>
                        <li>Unwelcome verbal or physical advances and sexually, racially, or otherwise offensive or
                            discriminatory materials, statements or remarks. </li>
                        <li>Harassment, in any form, toward employees, contractors, suppliers, customers or persons
                            associated in business relation with Npoly are strictly prohibited and subject to
                            disciplinary action.
                        </li>
                    </ol>
                </div>
            </div><br>
            <div class="subsection">
                <h6><b>2.18 CONFIDENTIALITY</b></h6>
                <div>Confidential information encompasses any data or records that are not publicly available and
                    could potentially harm the organization or individuals if disclosed without proper authorization.
                    Employees are obligated to treat such information with the highest level of
                    confidentiality. Such information includes, but is not limited to:
                </div>
                <div>
                    <ol class="roman-list">
                        <li>Any information (written, verbal or other form) which the employee’s becomes to privy to
                            in the course of performing his/her duties with the company must remain confidential. </li>
                        <li>Confidential Information includes all business ethics, methods, models, policies,
                            procedures, techniques, financial information, personnel data etc.</li>
                        <li>Employees shall not disclose or permit any Confidential Information to be made available
                            without the consent of the management.</li>
                        <li>Violation of confidentiality policy is subject to disciplinary action.</li>
                    </ol><br>
                    <p><b><u>Exceptions:</u></b> Confidential information may occasionally have to be disclosed for
                        legitimate
                        reasons. Examples are:</p>
                    <div>
                        <ol class="roman-list">
                            <li>If a regulatory body request it as part of an investigation or audit.</li>
                            <li>If our organization examines a venture or partnership that requires disclosing some
                                information (within legal boundaries).</li>
                            <li>In such cases, employees involved should document their disclosure procedure and collect
                                all needed authorizations. NPOLY is bound to avoid disclosing more information than
                                needed.</li>
                        </ol>
                    </div>
                </div>
            </div><br>
            <div class="subsection">
                <h6><b>2.19 HEALTH, SAFETY AND ENVIRONMENT POLICY</b></h6>
                <div>NPOLY will strive to prevent all accidents, incidents, injuries, and occupational illnesses. And
                    also committed to identify and eliminate or manage safety risks associated with below
                    activities:</div>
                <div>
                    <ol class="roman-list">
                        <li>To design and maintain facilities, establish management systems, provide training and
                            conduct operations in a manner that safeguards people and property.</li>
                        <li>To respond quickly, effectively, and with care to emergencies or accidents, incidents. </li>
                        <li>Undertake appropriate reviews and evaluations of its operations to measure progress and
                            to ensure compliance. </li>
                    </ol>
                </div>
            </div><br>
            <div class="subsection">
                <h6><b>2.20 INTELLECTUAL PROPERTY</b></h6>
                <div>Any intellectual property, such as trademarks, copyrights and patents, logo and any work
                    created by an employee in the course of employment at NPOLY shall be the property of NPOLY
                    and the employee is deemed to have waived all rights in favour of the company. Work, for the
                    purpose of this policy refers to written, creative or media work. All source material used in
                    presentation or written documents must be acknowledged.</div>
                <div>
                    <ol class="roman-list">
                        <li>Any kind of documents like project plan, SOP, Audit are NPOLY intellectual property and
                            should not be shared outside of NPOLY without prior permission.</li>
                        <li>Any type of reports/statements generated through the organization’s digital media should
                            be kept safe and should not be disclosed too outside.
                        </li>
                        <li>Any kind of software design documents, envision design documents formatted in
                            virtual/printed media are organizations' intellectual property.
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        <div>
            <input type="checkbox" @if(!empty($policyInfo->chap2_status) && $policyInfo->chap2_status =='1') disabled checked @endif class="agree_policy" name="chapter_two" id="chapter_two" vale="0"> <span style="color:red;">Are you Agree Chapter 2 ?</span>
        </div>
    </div>
      </div>
    </div>
  </div>
  <div class="accordion-item">
    <h2 class="accordion-header" id="headingThree">
      <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
      <h6>CHAPTER - 3: ADMINISTRATIVE POLICY GUIDELINE</h6>
      </button>
    </h2>
    <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#accordionExample">
      <div class="accordion-body">
      <div class="chapter">
        <div>Administrative policy guidelines are set out to establish disciplined processes and procedures,
            promoting efficiency in daily operations for creating a structured and organized work
            environment. </div>
        <div class="section"><br>
            <h6><b>3.1 ATTENDANCE & LEAVE POLICY</b></h6>
            <div  class="section" style="margin-bottom:30px !important;">NPOLY Group values the punctuality and attendance of our employees, which ensures high quality output
                from them for our customers. With this view in mind, NPOLY has established
                an attendance policy to ensure that all employees are aware of the expectations of the company
                and to provide guidelines for managing absences and tardiness.</div>
        </div>
        <div class="section" style="margin-bottom:30px !important;">
            <h6>3.1.1 Attendance Policy:</h6>
            <div>The normal office starts from 9:00 AM and ends at 6:00 PM from Saturday till Thursday.
                Friday is the weekend holiday. Attendance has 4 patterns, which are as follows:</div>
            <div>
                <ol class="roman-list">
                    <li>For all executives below the General Manager (GM) level, there is a flexible time of 15
                        minutes for office entry without being late.</li>
                    <li>For GM or above level employees, there is a flexible time of 60 minutes for entry without
                        being late.
                    </li>
                    <li>For support staff level employees, there is a flexible time of 15 minutes for office entry
                        without being late. Support staff needs to make entry at 8:30 AM for all administrative
                        works like cleaning and housekeeping.</li>
                    <li>For driver-level employees, it is mandatory to punch their entry after completing the staff trip.</li>
                </ol>
            </div>
        </div>
        <div class="section">
            <h6>3.1.2 Late Entry Policy: </h6>
            <div>
                <ol class="roman-list">
                    <li><b>For All Level Employees Below GM:</b><br>
                        <ol>&#x2713; For the first 03 (three) late attendance up to 9:30 AM, no late adjustment has to
                            be given
                            by the employee.</ol>
                        <ol>&#x2713; For the 4th (fourth) late attendance/ any late attendance beyond 9:30 AM but not
                            later
                            than 1:00 PM, half-day leave has to be applied by the employee.
                        </ol>
                    </li><br>
                    <li>
                        <b>For GM or Above Level Employees:</b><br>

                        <ol>&#x2713; For any late attendance beyond 10:00 AM but not later than 1:00 PM, half-day leave
                            has
                            to be applied by the employee.</ol>
                    </li>
                </ol>

            </div>
        </div>
        <div class="subsection">
            <h6>3.1.3 Leave Policy:</h6>
            <div>
                <h6><b>a. Types of Leaves:</b></h6>
                <h6><b>There are 05 (five) kinds of leaves:</h6></b>
                <div>
                    <ol class="roman-list">
                        <li>Casual leave (CL) - 10 days</li>
                        <li>Sick leave (SL) – 14 days</li>
                        <li>Earned leave (EL) – 21 days</li>
                        <li>Maternity leave – 112 days</li>
                        <li>Leave without pay – 90 days*
                        </li>
                    </ol>
                </div>
            </div>
            <div><br>
                <h6><b>b. Earned leave will be applicable after one year of the joining date of the
                        employee.
                    </b></h6>
                <div>
                    <ol class="roman-list">
                        <li>If a non-confirmed employee faces and emergency, they may only avail leave from their accrued Casual Leave or Sick Leave on a pro-rata basis, as per BLR 2015.
                        </li>
                        <li>Star (*) marked leave should be discussed with HR and special permission should be taken
                            from the management.</li>
                    </ol>
                </div>
            </div>
            <div><br>
                <h6><b>c. Half Day Leave Policy:</b></h6>
                <div>
                    <ol class="roman-list">
                        <li>An employee can avail of only 04 (four) half-day leaves in a month.
                        </li>
                        <li>Half-day leave is either from 9:00 AM to 1:00 PM or from 1:00 PM to 6:00 PM.</li>
                        <li>If any employee takes half day leave in the first half of the day but for some unavoidable
                            reason, s/he comes after 1:00 PM then s/he has to apply for full day leave.
                        </li>
                        <li>
                            During the month or Ramadan, HR will fix the timing of half-day leave.
                        </li>
                    </ol>
                </div>
            </div>
            <div><br>
                <h6><b>d. Attendance Policy During Official Tour: </b></h6>
                <div>
                    <h6>&#10146; For Officer level employees:</h6>
                    <div>Before going on a tour, an employee has to email her/his supervisor about the tour and
                        keep HR in CC for keeping an attendance record. If email is unavailable, then the outdoor
                        duty slip will also be considered.</div><br>
                    <h6>&#10146; For Driver level employees:</h6>
                    <div>
                        After coming from the tour, the driver has to fill up a slip and take the signature from the
                        employee (with whom he has completed the tour), and Admin and send that slip to HR to
                        keep the attendance record.
                    </div>
                </div>
            </div>
        </div><br>
        <div class="subsection">
            <h6>3.1.4 Movement Policy:</h6>
            <div>
                <ol class="roman-list">
                    <li>If any employee moves outside the office after coming to the office due to official purpose,
                        s/he has to email to supervisor informing about this and keep HR operations in CC before leaving the
                        office. If email is unavailable, then outdoor duty slips will also be considered. If an email/
                        slip cannot be given before movement, then it has to be submitted immediately after
                        reaching the office.
                    </li>
                    <li>If any employee moves outside the office after coming to the office due to personal
                        purposes, s/he has to apply for full day leave no matter what the duration. If s/he doesn’t
                        have any remaining leave then salary will be deducted accordingly.
                    </li>
                    <li>
                      <span><b>Personal Movement Policy</b></span>  Employees can request up to three personal movement periods per month, each lasting up to two hours, with their supervisor's approval. If the leave exceeds two hours but is less than four, it will considered as half-day leave, and over four hours it will be considered as full-day leave.
                    </li>
                    <li><b>This personal movement policy will be allowed only when and employee will entry office permises and shall not applied before 2 hours of ending office.</b></li>
                </ol>
            </div>
        </div><br>
        <div class="subsection">
            <h6><b>3.2 ISSUANCE OF ID CARD</b></h6>
            <p class="margin-bottom"><b>3.2.1 ID Card: </b>All employees shall be provided with identity cards (ID card) free of cost,
                which will be used as the office entry pass. ID card is not transferable to anybody. The
                validity of a card shall be for the employment period of an employee. </p>
            <p class="margin-bottom"><b>3.2.2 Loss of ID Card: </b>In case of loss/ damage of an ID card an employee must inform the
                admin within 24 (twenty-four) hours and has to make a general diary (GD) entry to the
                nearest Police Station within 24 (twenty-four) hours. Admin will re-issue the ID card
                charging BDT.100/= (one hundred only) for the re-issue duly recommended by HR.</p>
            <p class="margin-bottom"><b>3.2.3 Surrender ID Card: </b>An Employee shall surrender her/his ID card upon transfer/
                separation of service from the Company.</p>
            <p class="margin-bottom"><b>3.2.4 Forget to Bring ID Card:</b>If an employee forgets to bring her/his ID card, then HR
                will adjust BDT.25/= (twenty-five only) as a token from her/his salary per day.</p>
        </div><br>
        <div class="subsection">
            <h6><b>3.3 ISSUANCE OF BUSINESS CARD</b></h6>
            <div>
                Officers from E–1 to M–1 shall be eligible to use a visiting card. Admin shall make the
                necessary arrangements to provide a visiting card to the Executive/ Officer after her/his
                joining.
            </div>
        </div><br>
        <div class="subsection">
            <h6><b>3.4 HOURS OF WORKS AND HOLIDAYS</b></h6>
            <div>
                Normal working hours for the Company shall be from 9.00 am to 6.00 pm except in the month
                of Ramadan when it shall be 9.00 am to 4.00 pm or as decided by the Management. Working
                days shall be Saturday to Thursday.

            </div>
        </div><br>
        <div class="subsbusection" style="margin-bottom:30px !important;">
            <h6>3.4.1 Weekly Holidays: </h6>
            <p>Friday will be observed as weekly holiday. </p>
            <h6><b>Gazette Public Holidays: </b></h6>

            <div>
                <table width="100%">
                    <thead>
                        <tr>
                            <th class="head-style">SL</th>
                            <th class="head-style">Occasions</th>
                            <th class="head-style">Leave Days</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>1</td>
                            <td>Eid-e-Miladunnabi</td>
                            <td>1 Day</td>
                        </tr>
                        <tr>
                            <td>2</td>
                            <td>International Mother Language Day </td>
                            <td>1 Day</td>
                        </tr>
                        <tr>
                            <td>3</td>
                            <td>Birth Day of Sheikh Mujibur Rahman</td>
                            <td>1 Day</td>
                        </tr>
                        <tr>
                            <td>4</td>
                            <td>Independence Day </td>
                            <td>1 Day</td>
                        </tr>
                        <tr>
                            <td>5</td>
                            <td>Bangla Nobo Borsho</td>
                            <td>1 Day</td>
                        </tr>
                        <tr>
                            <td>6</td>
                            <td>May Day</td>
                            <td>1 Day</td>
                        </tr>
                        <tr>
                            <td>7</td>
                            <td>Budha Purnima</td>
                            <td>1 Day</td>
                        </tr>
                        <tr>
                            <td>8</td>
                            <td>Shab e Barat</td>
                            <td>1 Day</td>
                        </tr>
                        <tr>
                            <td>9</td>
                            <td>Shab e Qadre</td>
                            <td>1 Day</td>
                        </tr>
                        <tr>
                            <td>10</td>
                            <td>Eid ul Fitr</td>
                            <td>3 Days</td>
                        </tr>
                        <tr>
                            <td>11</td>
                            <td>Eid ul Azha</td>
                            <td>3 Days</td>
                        </tr>
                        <tr>
                            <td>12</td>
                            <td>Ashura</td>
                            <td>1 Day</td>
                        </tr>
                        <tr>
                            <td>13</td>
                            <td>Durga Puja</td>
                            <td>1 Day</td>
                        </tr>
                        <tr>
                            <td>14</td>
                            <td>Victory Day</td>
                            <td>1 Day</td>
                        </tr>
                        <tr>
                            <td>15</td>
                            <td>Christmas Day</td>
                            <td>1 Day</td>
                        </tr>
                        <tr>
                            <td>16</td>
                            <td>Janmastomi</td>
                            <td>1 Day</td>
                        </tr>
                        <tr>
                            <td>17</td>
                            <td>National Mourning Day </td>
                            <td>1 Day</td>
                        </tr>
                    </tbody>
                </table>
                <h6>Figure 1: Gazetteed Public Holidays: 21 Days</h6>
                    <p>*** In addition to the above, Management may declare any other optional holidays, as general
                        holidays.
                    </p>
            </div>

        </div>
        <div class="subsection">
            <h6><b>3.5 INTERNET USE</b></h6>
            <p class="margin-bottom"><b>3.5.1 </b>Internet access to global electronic information resources on the Website is provided
                by NPOLY to assist employees in obtaining work-related data and technology. The
                following guidelines have been established to help ensure responsible and productive
                Internet usage.</p>
            <p class="margin-bottom"><b>3.5.2 </b>All Internet data that is composed, transmitted, or received via our computer
                communications systems is considered to be part of the official records of NPOLY and,
                as such, is subject to disclosure to law enforcement or other third parties. </p>
            <p class="margin-bottom"><b>3.5.3 </b>NPOLY reserves the right to monitor Internet traffic, and retrieve and read any data
                composed, sent, or received through our online connections and stored in our
                computer systems.
            </p>
            <p class="margin-bottom"><b>3.5.4 </b>Data that is composed, transmitted, accessed, or received via the Internet must not
                contain content that could be considered discriminatory, offensive, obscene,
                threatening, harassing, intimidating, or disruptive to any employee or other person.
                Examples of unacceptable content may include, but are not limited to, sexual
                comments or images, racial slurs, gender-specific comments, or any other comments
                or images that could reasonably offend someone on the basis of race, age, sex, religious
                or political beliefs, national origin, disability, sexual orientation, or any other
                characteristic protected by law.</p>
            <p class="margin-bottom"><b>3.5.5 </b>The unauthorized use, installation, copying, or distribution of copyrighted,
                trademarked, or patented material on the Internet is expressly prohibited.</p>
            <p class="margin-bottom"><b>3.5.6 </b>Abuse of the Internet access provided by NPOLY in violation of law or NPOLY policies
                will result in disciplinary action, up to and including termination of employment. </p>
            <p class="margin-bottom"><b>3.5.7 </b>Employees may also be held personally liable for any violations of this policy. The
                following behaviors are examples of previously stated or additional actions and
                activities that are prohibited and can result in disciplinary action:</p>
            <div>
                <ol class="roman-list">
                    <li>Sending or posting discriminatory, harassing, or threatening messages or images;</li>
                    <li>Using the organization's time and resources for personal gain;
                    </li>
                    <li>Stealing, using, or disclosing someone else's code or password without authorization;</li>
                    <li>Copying, pirating, or downloading software and electronic files without permission;
                    </li>
                    <li>Sending or posting confidential material, trade secrets, or proprietary information
                        outside of the organization;
                    </li>
                    <li>Violating copyright law;
                    </li>
                    <li>Engaging in unauthorized transactions that may incur a cost to the organization;
                    </li>
                    <li>Sending or posting messages or material that could damage the organization's image or
                        reputation;
                    </li>
                    <li>Participating in the viewing or exchange of pornography or obscene materials;</li>
                    <li>Refusing to cooperate with a security investigation;</li>
                    <li>Using the Internet for political causes or activities, religious activities, or any sort of
                        gambling;
                    </li>
                    <li>Jeopardizing the security of the organization's electronic communications systems;</li>
                    <li>Engaging in any other illegal activities.</li>
                </ol>
            </div>
        </div><br>
        <div class="subsection">
            <h6><b>3.6 MOBILE PHONE AND DATA USAGE POLICY</b></h6>
            <div>Mobile phone data usage policy offers general guidelines during work hours, including
                how we minimize distractions and allow our normal workflow to continue with
                concentration.</div>
            <br>
           <!-- <div class="subsbusection">
                <h6>3.6.1 Mobile Phone Usage:</h6>
                <div>
                    <ol class="roman-list">
                        <li>While at work, employees are expected to exercise discretion in using mobile phones.
                            Employees should attend personal calls during scheduled breaks or lunch periods. In an
                            emergency that requires immediate attention, the mobile phone can be used for personal
                            calls at any time.</li>
                        <li>It is preferred that the mobile phone is kept in silent/ vibration mode during an official
                            meeting/ discussion/ training.</li>
                        <li>Employees are strictly told not to use their mobile phones for non-emergency text, phone
                            calls, playing games, doing online activities (i.e., Facebook, YouTube, TikTok, X,
                            Instagram, etc.), or taking photos.
                        </li>
                        <li>Employees are strictly asked not to download or upload inappropriate, illegal, or obscene
                            material using a corporate internet connection. Recording confidential information is also
                            prohibited.</li>
                        <li>The Company is not liable for the loss of personal mobile phones brought into the
                            workplace.</li>
                    </ol>
                </div>
            </div><br>
            <div class="subsection">
                <h6>3.6.2 Mobile Bill & Data Ceiling:</h6>
                <div>
                    <table width="100%">
                        <thead>
                            <tr>
                                <th>Position</th>
                                <th>Mobile Bill & Data Ceiling (Max) </th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>Above General Manager</td>
                                <td>At Actual</td>
                            </tr>
                            <tr>
                                <td>Asst. General Manager to General Manager</td>
                                <td>BDT. 1,500 /= to 2,000/=</td>
                            </tr>
                            <tr>
                                <td>Manager to Sr. Manager</td>
                                <td>BDT. 1,000 /= to 1,500/=</td>
                            </tr>
                            <tr>
                                <td>Asst. Manager to Sr. Deputy Manager</td>
                                <td>BDT. 600 /= to 1,000/=
                                </td>
                            </tr>
                            <tr>
                                <td>Asst. Executive to Sr. Mgt. Executive</td>
                                <td>BDT. 300 /= to 600/=</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <p>Figure 2: Mobile Bill & Data Ceiling</p>
            </div><br> -->
            <div class="subsection">
                <h6>3.6.1 Pack Segments and Pricing:</h6>
                <h6>Three Combo Packs are available for allocation:</h6>
                <div>
                    <table width="100%">
                        <thead>
                            <tr>
                                <th>Pack</th>
                                <th>Grameenphone</th>
                                <th>Robi</th>
                                <th>Banglalink</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>Pack-1: Taka 500</td>
                                <td>10 GB, 500 Min, 500 SMS</td>
                                <td>12 GB, 720 Min, 100 SMS</td>
                                <td>8 GB, 700 Min, 100 SMS</td>
                            </tr>
                            <tr>
                                <td>Pack-2: Taka 300</td>
                                <td>5 GB, 250 Min, 100 SMS</td>
                                <td>6 GB, 350 Min, 100 SMS</td>
                                <td>5 GB, 500 Min, 100 SMS</td>
                            </tr>
                            <tr>
                                <td>Pack-3: Taka 150</td>
                                <td>1 GB, 100 Min, 50 SMS</td>
                                <td>2 GB, 150 Min, 50 SMS</td>
                                <td>2 GB, 150 Min, 300 SMS</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div><br>
            <style>
                ol.custom-bullets {
            list-style-type: disc;
        }
            </style>
            <div class="subsection">
                <h6>3.6.2 Eligibility Criteria and Allocation </h6>
                <h6>3.6.2.1 Factory & Depot Level Allocation</h6>
                <div>
                <ol class="custom-bullets">
                    <li>Pack-3 (Taka 150): Employees up to the Senior Assistant Manager level.</li>
                    <li>Pack-2 (Taka 300): Employees from Deputy Manager to Manager level. But all Heads of Department (HODs) are entitled to Pack-1 by default. </li>
                    <li>Pack-1 (Taka 500): Senior Manager and above levels. </li>
                </ol>
                </div>
            </div>
            <div class="subsection">
                <h6>3.6.2.2 Corporate Level Allocation</h6>
                <div>
                <ol class="custom-bullets">
                    <li>Pack-2 (Taka 300): Employees up to the Manager level. But all Heads of Department (HODs) are entitled to Pack-1 by default.</li>
                    <li>Pack-1 (Taka 500): Senior Manager and above levels. </li>
                </ol>
                </div>
            </div>
            <div class="subsection">
                <h6>3.6.2.3 Sales Force Allocation</h6>
                <div>
                <ol class="custom-bullets">
                    <li>Pack-2 (Taka 300): Sales Officers Level .</li>
                    <li>Pack-1 (Taka 500): Zonal Manager and above levels.</li>
                </ol>
                </div>
            </div><br>
            <div class="subsection">
                <h6><b>3.7 SAFETY REGULATIONS</b></h6>
                <div>
                    The Company subscribes to the highest standard of safety at work. Due to the nature of our
                    work, it is sometimes necessary for certain employees to work at the Customer site or at our
                    own manufacturing unit. In such cases, the employee will be provided with appropriate
                    protective equipment. These items are provided for personal safety and all are strongly advised
                    to ensure that all reasonable safety precautions are adhered to in the performance of
                    individual’s duties.
                </div><br>
                <div class="subsbusection">
                    <h6>3.7.1 General Rules of Safety</h6>
                    <div>
                        <ol class="roman-list">
                            <li>Check your work station, electrical appliances regular basis.</li>
                            <li>Be vigilant of any hazardous condition and report it to Admin immediately or to your
                                Line
                                Manager/ Department Head.
                            </li>
                            <li>Report any injury immediately to your Line Manager / Department Head.</li>
                            <li>Use the required safety devices and proper protective safety equipment.
                            </li>
                            <li>If a fire breaks out in the office, immediately push the fire alarm switch.</li>
                            <li>If the condition escalates beyond your control, immediately inform the Floor Fire
                                Warden/Admin/Department Head and simultaneously call fire brigade.</li>
                        </ol><br>
                        <h6>&#10146; <b>Some areas of obvious concern:</b></h6>
                        <div>
                            <ol class="roman-list">
                                <li>Emergency Preparedness (emergency evacuation plan).</li>
                                <li>Fire Safety (Firefighting equipment).</li>
                                <li>First Aid (First Aid box and certified first aid provider).
                                </li>
                                <li>Electrical Safety (Electrical System & Equipment).</li>
                                <li>Slips, Trips & Falls (workplace free of obstacles & spills).</li>
                                <li>Housekeeping (cleaning up of mess and proper storage).
                                </li>
                                <li>Ergonomics (Workstation and Body Posture).</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div>
            <input type="checkbox" @if(!empty($policyInfo->chap3_status) && $policyInfo->chap3_status =='1') disabled checked @endif name="chapter_three" class="agree_policy" id="chapter_three" vale="0"> <span style="color:red;">Are you Agree Chapter 3 ?</span>
        </div>
    </div>
      </div>
    </div>
  </div>
  <div class="accordion-item">
    <h2 class="accordion-header" id="headingThree">
      <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseThree">
      <h6>CHAPTER-4: Employment Service</h6>
      </button>
    </h2>
    <div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#accordionExample">
      <div class="accordion-body">
      <div class="chapter"><br>
        <div class="section">
            <h6><b>4.1 NEW EMPLOYEE ORIENTATION</b></h6>
            <div>An employee orientation program is a structured process designed to familiarize new
                appointees with their roles, the company culture, policies, and procedures. It typically includes
                a mix of onboarding activities, such as introductions to team members, an overview of
                company history and values, training on job responsibilities, and guidance on navigating
                company systems and resources. The orientation program aims to help new employees have a
                smooth and effective onboarding experience and feel comfortable in their new work
                environment.</div>
        </div><br>
        <div class="section">
            <h6><b>4.2 EMPLOYEE PROBATION</b></h6>
            <div>
                The purpose of the probation period is to assess the employee’s performance, attitude and
                overall fit within the company. This is a time period set for the new employee to evaluate
                whether he/she meets job requirement and company culture. All terms and conditions during
                the probation are outlined in the appointment letter at the time of joining as per the company
                policy.

            </div><br>
            <p><b>4.2.1 Duration:</b>The duration of probation shall be four to six months in all cases, which
                may be extended for further period if the performance of the employee is not found
                satisfactory. But the provision period for an experienced professional may be relaxed or
                exempted as decided by the HR department / Management.</p>
        </div><br>
        <div class="section">
            <h6><b>4.3 CONFIRMATION OF SERVICE</b></h6>
            <div>
                After successful completion of six months’ probation period with the company, employee’s
                performance evaluation is done and on the basis of satisfactory report received from the Line
                Manger / Supervisor, employee then gets his/ her job confirmation. The HR Department issue
                letter to the employee with necessary information regarding job confirmation date, salary
                change, position /grade change and other benefits as appropriate. Length of service shall be
                counted from the date of joining. After confirmation of service, employees will be entitled to
                all kinds of company benefits as per the policy of the company.
            </div>
        </div>
        <div>
            <input type="checkbox" @if(!empty($policyInfo->chap4_status) && $policyInfo->chap4_status =='1') disabled checked @endif name="chapter_four" class="agree_policy" id="chapter_four" vale="0"> <span style="color:red;">Are you Agree Chapter 4 ?</span>
        </div>
    </div>
      </div>
    </div>
  </div>
  <div class="accordion-item">
    <h2 class="accordion-header" id="headingThree">
      <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseThree">
      <h6>CHAPTER-5: COMPENSATION AND BENEFITS</h6>
      </button>
    </h2>
    <div id="collapseFive" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#accordionExample">
      <div class="accordion-body">
      <div class="chapter">
        <div>
            Compensation and benefit guideline has been designed to establish a comprehensive
            framework that ensures fair salary, benefits that are competitive to the market and promoting
            employee satisfaction.

        </div><br>
        <div class="section">
            <h6><b>5.1 GRADING POLICY</b></h6>
            <div>NPOLY shall follow the Grading Scale during employment. There shall be many designations
                but Employee’s Grading shall determine his/her status. This will help employees to develop
                synchronization and mutual respect between and among the employees for a good corporate
                culture.</div>
            <div><br>
                <table width="100%">
                    <thead>
                        <tr>
                            <th>Sl. No.</th>
                            <th colspan="2">Grade</th>
                            <th>Designation</th>
                            <!-- <th>Functional Designation</th> -->
                            <th>Band</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td rowspan="2">1</td>
                            <td rowspan="2">M-5</td>
                            <td>A</td>
                            <td>Top Senior Most Level</td>
                            <!-- <td rowspan="2">Unit MD, CEO, COO, Director, Advisor(Proposed)</td> -->
                            <td rowspan="2">Senior Management</td>
                        </tr>
                        <tr>
                            <td>B</td>
                            <td>ED</td>
                        </tr>
                        <tr>
                            <td rowspan="4">2</td>
                            <td rowspan="4">M-4</td>
                            <td>A</td>
                            <td>General Manager</td>
                            <!-- <td>Chief Financial Officer, Head of HR & Admin, Head of Commercial (Dept. Head)</td> -->
                            <td rowspan="4">General Manager</td>
                        </tr>
                        <tr>
                            <td>B</td>
                            <td>Senior Deputy General Manager</td>
                            <!-- <td>Financial Controller (Dept. Head)</td> -->
                        </tr>
                        <tr>
                            <td>C</td>
                            <td>Deputy General Manager</td>
                            <!-- <td>Head of International Procurement,Head Of Institutional Sales</td> -->
                        </tr>
                        <tr>
                            <td>D</td>
                            <td>Assistant General Manager</td>
                            <!-- <td>Head of Corporate Finance, Reporting Head, Head of Commercial (Dept. Head)</td> -->
                        </tr>
                        <tr>
                            <td rowspan="2">3</td>
                            <td rowspan="2">M-3</td>
                            <td>A</td>
                            <td>Senior Manager</td>
                            <!-- <td>Head of Local Procurement, Head of Land & Legal, Head Of Sales Accounts (Dept. Head)</td> -->
                            <td rowspan="6">Manager</td>
                        </tr>
                        <tr>
                            <td>B</td>
                            <td>Manager</td>
                            <!-- <td>Head of Accounts, Head of Corporate Affairs, Head of Admin, Head of Brand, Contractor Sales Manager</td> -->
                        </tr>
                        <tr>
                            <td rowspan="4">4</td>
                            <td rowspan="2">M-2</td>
                            <td>A</td>
                            <td>Senior Deputy Manager</td>
                            <!-- <td>Head of Documentation</td> -->
                        </tr>
                        <tr>
                            <td>B</td>
                            <td>Deputy Manager</td>
                            <!-- <td>Head of Tax & VAT</td> -->
                        </tr>
                        <tr>
                            <td rowspan="2">M-1</td>
                            <td>A</td>
                            <td>Senior Assistant Manager</td>
                            <!-- <td>Senior Assistant Manager</td> -->
                        </tr>
                        <tr>
                            <td>B</td>
                            <td>Assistant Manager</td>
                            <!-- <td>Assistant Manager</td> -->
                        </tr>
                        <tr>
                            <td rowspan="4">5</td>
                            <td rowspan="2">E-2</td>
                            <td>A</td>
                            <td>Senior Executive</td>
                            <!-- <td>Senior System Engineer/Transport Maintenance Officer</td> -->
                            <td rowspan="4">Executive</td>
                        </tr>
                        <!-- <tr>
                            <td>A</td>
                            <td>Senior Executive</td>
                            <td>Senior System Engineer/Transport Maintenance Officer</td>
                        </tr> -->
                        <tr>
                            <td>B</td>
                            <td>Executive</td>
                            <!-- <td>System Enginner</td> -->
                        </tr>
                        <tr>
                            <td rowspan="2">E-1</td>
                            <td>A</td>
                            <td>Junior Executive</td>
                            <!-- <td>Junior System Engineer</td> -->
                        </tr>
                        <tr>
                            <td>B</td>
                            <td>Assistant Executive</td>
                            <!-- <td>Assistant System Engineer/ Security Inspector</td> -->
                        </tr>
                    </tbody>
                </table>
                <h6>Figure 3: Grading Policy of Head Office Level Employees
                    </h6>
            </div><br>
            <div class="section">
                <h6><b>5.2 PAY FIXATION</b></h6>
                <div>
                    The Company shall maintain the following principles while fixing salaries of employees:
                    The long-term economic competitiveness and potential of performance of the Company;
                    Competitive package compared to the industrial average of similar industry in Bangladesh.
                    Competitive pay in the market of Bangladesh irrespective of nationality, gender, race or
                    religion but it should be commensurate with qualification & experience required for the post.
                    The Grade of each employee shall be fixed at the time of employment and his/her pay structure
                    shall be specified at the time of issuance of his/her appointment letter. All future benefits shall
                    be calculated on the basis of “Gross Salary (documented and undocumented)”
                    The Company requires different types of people with different attributes to serve its positional
                    purpose as per the nature of business. Therefore, NPOLY follows a comprehensive pay
                    structure as per employment grades. In an exceptional case, it is the Management’s discretion
                    to decide on the salary of an employee whose service is essential for the Company. But that
                    shall not conflict with the status / Grades of existing employees.
                    The Company shall review and adjust employees’ remunerations every year to retain
                    experienced resources and to prevent and minimize employees’ grievances.
                </div><br>
                <div class="section">
                    <h6><b>5.3 PERSONAL INCOME TAX</b></h6>
                    <div>
                        Employee will be responsible for his own income tax. However, income tax will be deducted
                        at source prior to salary payment as per Income Tax Law.
                    </div>
                </div>
            </div><br>
            <div class="section">
                <h6><b>5.4 INCREMENT:</b></h6>
                <div>Yearly Increment will be given to each employee on the basis of their performance of the
                    previous year and financial performance of the Unit/Department. The confirmed employee
                    serving the Company for a period of minimum nine months shall be eligible for the yearly
                    increment.</div>
            </div><br>
            <div class="section">
                <h6><b>5.5 FESTIVAL BONUS</b> </h6>
                <div>Two “Festival Bonus” shall be paid to each employee of the Company in a year, each bonus one
                    basic salary.</div>
            </div><br>
            <div class="section">
                <h6><b>5.6 GROUP LIFE INSURANCE</b></h6>
                <div>A group life insurance policy is designed to provide cost-efficient life insurance coverage to
                    provide financial protection and support to the employees or members of National Polymer
                    Group (NPOLYS), in the event of the insured employee’s death. The primary objectives of this
                    type of insurance policy include offering employee benefits, ensuring financial security for the
                    beneficiaries, helping them cope with the financial challenges that may arise due to the loss of
                    the primary earner, mitigating financial risk coverage as a part of employer’s cost-efficient
                    solution to enhance employee retention. All confirmed employees and workers except casual
                    workers are eligible and enrolled in the group life insurance policy.
                </div><br>
                <div class="subsbusection">
                    <h6>5.6.1 Coverage Details:</h6>
                    <div>
                        <ol class="roman-list">
                            <li>For officer-level employees, the insurance coverage is BDT.100,000/= (one lac only).
                            </li>
                            <li>For worker-level employees, the insurance coverage is BDT.50,000/= (fifty thousand
                                only).
                            </li>
                            <li>The coverage is effective after the death of the employee.
                            </li>
                            <li>Insurance coverage is applicable for employees aged up to 65.
                            </li>
                        </ol>
                    </div>
                </div>
            </div><br>
            <div class="section">
                <h6><b>5.7 PROVIDENT FUND</b></h6>
                <div>All permanent employees shall be entitled to participate in the scheme of Provident Fund as
                    per rules of the Company. Contribution of Employee and Company shall be as follows based
                    on employment Grade. Both employee and the employer shall contribute equally @10% of the
                    concerned employee’s basic. This will be governed by the PROVIDENT FUND RULES.
                    An employee shall be eligible to receive Company Contribution in the provident fund after
                    completion of 2 years of continues services with the company.
                </div><br>
                <div class="subsection">
                    <h6>5.7.1 Loan from Provident Fund:</h6>
                    <div>
                        An employee is eligible for PF loan after his/her confirmation. But he/she may apply for loan
                        only when he/she has significant amount in PF fund. Member of provident fund may apply for
                        75℅ loans from his/her own contribution in PF fund. Loan amount will be adjusted from his/
                        her salary in 12 equal installments @ 10% interest rate.
                    </div>
                </div>
            </div><br>
            <div class="section">
                <h6><b>5.8 CORPORATE TRANSPORT POLICY</b></h6>
                <div>
                    The objectives of a transport policy are to outline clear guidelines and strategies to ensure
                    efficient, safe, and sustainable transportation practices within the organization. This policy
                    outlines our guidelines and expectations for transportation-related activities to minimize
                    environmental impact, enhance safety, and promote responsible commuting and travel. It also
                    provides a standard procedure for the acquisition, enhancement, use, control, maintenance,
                    and repair of the vehicles.
                </div><br>
                <div class="subsubsection">
                    <h6>5.8.1 Officers Pick & Drop Service:</h6>
                    <div>
                        <ol class="roman-list">
                            <li>All Head Office (HO) vehicles will be used for carrying officers on staff trips (pick
                                and drop)
                                to attend the place of work and to meet any official commitment.
                            </li>
                            <li>Slab for regular pick and drop will be (both ways) BDT. 55/= (fifty-five only), BDT.
                                75/=
                                (seventy-five only), and BDT. 85/= (eighty-five only).</li>
                            <li>If anyone is not in regular enrollment in an official staff trip but she/he wants to use
                                a staff
                                trip (subject to availability) then s/he will pay BDT.40/= (forty only), BDT.60/= (sixty
                                only), and BDT.70/= (seventy only) according to the slab for one way.
                            </li>
                        </ol>
                    </div>
                </div>
            </div><br>
            <div class="section">
                <h6><b>5.9 DINING MANAGEMENT POLICY</b></h6>
                <div>A designated dining is a place where the employees can take food facility without leaving their
                    workstation/ office premises. The Administration is responsible for arranging hygienic and
                    healthy food for the employees from various sources at reasonable prices, monitoring the
                    quality of the food and the operations of the dining, and implementing and reviewing the
                    dining policy.</div><br>
                <p class="margin-bottom"><b>5.9.1 Food Price: </b> The lunch facility is a paid service. The Administration will collect
                    various offers from local vendors to provide lunch (monthly) facilities for employees.
                    After discussion with the concerned department/section (Internal Audit &
                    Compliance, Procurement, and Accounts & Finance), the Administration should get
                    proper approval regarding meal prices from the Management.
                </p><br>
                <p class="margin-bottom"><b>5.9.2 Schedule: </b> The dining schedule is essential to clean the designated area to maintain a
                    tidy and safe working environment. The schedule will be as 0follows:</p>
                <div>
                    <ol class="roman-list">
                        <li><b>Breakfast:</b> The dining facility is open for taking breakfast till 9:15 AM. Every
                            employee is asked to have breakfast (if required) within that time.</li>
                        <li><b>Lunch:</b> The dining facility is open for lunch from 12:30 PM to 3:30 PM.
                        </li>
                    </ol>
                </div><br>
                <p><b>5.9.3 Payment: </b>The Administration will collect monthly bills from the vendors and settle
                    them according to the existing payment policy of the organization. At the end of the
                    month, the Administration will submit a status to HR to adjust the amount from the
                    employee's monthly salary.</p>
            </div>
        </div>
        <div>
            <input type="checkbox" @if(!empty($policyInfo->chap5_status) && $policyInfo->chap5_status =='1') disabled checked @endif name="chapter_five" class="agree_policy" id="chapter_five" vale="0"> <span style="color:red;">Are you Agree Chapter 5 ?</span>
        </div>
    </div>
      </div>
    </div>
  </div>
  <div class="accordion-item">
    <h2 class="accordion-header" id="headingThree">
      <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSix" aria-expanded="false" aria-controls="collapseThree">
      <h6>CHAPTER-6: TRAINING & DEVELOPMENT POLICY</h6>
      </button>
    </h2>
    <div id="collapseSix" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#accordionExample">
      <div class="accordion-body">
      <div class="chapter">
        <div>
            The company recognizes the importance of training and conducts internal and external
            training programs to build organizational capabilities through effective training plans and
            training needs assessments (TNA) for its manpower resources. It helps employees to become
            more efficient and effective as more improvement and additional skill development are needed
            for career growth and to cope with the growing scope of work and span of responsibility.
        </div><br>
        <div class="section" style="margin-bottom:35px !important;">
            <h6><b>6.1 TRAINING CATEGORIES</b></h6>
        </div>
        <div class="subsection">
            <h6>6.1.1 Internal Training Program</h6>
            <div>
                It refers to training programs or sessions that are arranged by the company, often using its
                own resources, trainers, or subject matter experts. In-house training programs can be
                customized as per the specific skill development needs and requirements of the employees.
                The training content, examples, and case studies can be tailored to address the unique
                challenges and goals of the company. In-house training contents are designed by the
                concerned departmental resource/s which are arranged and supported by the training section
                under the HR department of the company.
            </div>
        </div><br>
        <div class="subsection">
            <h6>6.1.2 External Training Program</h6>
            <div>
                External training program refers to the training programs or sessions that are recommended
                by the line managers/ departmental Heads through ATP or anytime during the year usually
                arranged and supported by the training section under the HR department of the company.
                External training programs are offered by the different training institutes of the country.
                Among those, the organization will select the renowned ones based on the reputation of that
                particular training institute.
            </div>
        </div><br>
        <div class="subsection">
            <h6><b>6.2 EXTERNAL TRAINING REQUEST BY INDIVIDUAL EMPLOYEE</b></h6>
            <div>
                An employee can personally request his/her work-related training other than her/his ATP and
                approach HR only once a year subject to the approval of the line manager/ department Head/
                HR Head/ MD that refers to the following guidelines:
            </div>
            <p><b>6.2.1</b>The total cost of the training program should not exceed BDT.30,000/= (thirty
                thousand only). The employee will get the full amount from the company. If the amount
                exceeds the limit, the interested employee may bear the excess amount by herself/ himself.</p>
            <p><b>6.2.2</b>After completing such training an employee has to serve the company for a particular
                time shown in Table. If any employee decides to leave the company within this time frame, the
                training amount will be deducted from her/ his final settlement. The amount will be calculated
                on 03 (three) monthly basis.</p><br>
            <table width="100%">
                <thead>
                    <tr>
                        <th class="head-style">Amount</th>
                        <th class="head-style">Time</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>BDT.2,500/= to BDT.5,000/=(Two thousand five hundred to five thousand only)</td>
                        <td>03 (three) months</td>
                    </tr>
                    <tr>
                        <td>BDT.5,001/= to BDT.7,500/= (Five thousand one to seven thousand five hundred only)</td>
                        <td>06 (six) months</td>
                    </tr>
                    <tr>
                        <td>BDT.7,501/= to BDT.10,000/=
                            (Seven thousand five hundred one to ten thousand only)</td>
                        <td>09 (nine) months</td>
                    </tr>
                    <tr>
                        <td>BDT.10,001/= to BDT.15,000/=
                            (Ten thousand one to fifteen thousand only)</td>
                        <td>12 (twelve) months</td>
                    </tr>
                    <tr>
                        <td>BDT. 15,001/= to BDT.20,000/=
                            (Fifteen thousand one to twenty thousand only)</td>
                        <td>15 (fifteen) months</td>
                    </tr>
                    <tr>
                        <td>BDT. 20,001/= to BDT.30,000/=
                            (Twenty thousand one to thirty thousand only) </td>
                        <td>18 (eighteen) months</td>
                    </tr>
                </tbody>
            </table>
            <h6>Figure 4: Training Cost & Mandatory Tenure</h6>
        </div><br>
        <div class="subsection">
            <h6><b>6.3 PROFESSIONAL TRAINING</b></h6>
            <div>
                The Company may bear the cost of any professional training that arises from specific job
                attachments or due to meet special assignments that are technical in nature. Such training
                needs will be proposed by the relevant department. Approval, budget, and content will be
                taken from management by HR along with necessary arrangements. In these cases, a service
                bond agreement may take place as decided by HR.

            </div>
        </div><br>
        <div class="subsection">
            <h6><b>6.4 FOREIGN TRAINING</b></h6>
            <div>
                Where and when required, the Company may send employee/s for foreign training for which
                employees are required to sign a Service Bond as per the requirements of the Company, which
                will be more elaborately defined prior to the departure for foreign training. Employees are
                required to sign an acknowledgment indicating their understanding and acceptance of the
                terms of the service bond before commencing the training. This will be coordinated and
                arranged by HR or delegated authority.

            </div>
        </div><br>
        <div class="subsection">
            <h6><b>6.5 SERVICE BOND</b></h6>
            <div>
                The service bond will be required for both the professional training and the foreign training
                respectively. The service bond may include:
            </div>
            <p><b>6.5.1 </b> If any employee decides to leave the company by voluntarily resigning, being
                terminated for cause, or engaging in any behavior that constitutes a breach of the terms and
                conditions of the Service Bond, the employee may be required to reimburse the company for
                the total cost of the training program as per the following manner:</p><br>

            <table width="100%">
                <thead>
                    <tr>
                        <th class="head-style">Training Cost</th>
                        <th class="head-style">Time duration of Bond</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>BDT.50,000/= to BDT.1,00,000/= (Fifty thousand to one lac only) </td>
                        <td>2 (two) years</td>
                    </tr>
                    <tr>
                        <td>BDT.100,001/= to BDT.2,00,000/= (One lac one to two lac only)</td>
                        <td>2.5 (two and a half) years</td>
                    </tr>
                    <tr>
                        <td>BDT.200,001/= to BDT.3,00,000/= (Two lac one to three lac only) </td>
                        <td>3 (three) years</td>
                    </tr>
                    <tr>
                        <td>BDT.300,001/= to BDT.400,000/= (Three lac one to four lac only) </td>
                        <td>3.5 (three) and a half) years</td>
                    </tr>
                    <tr>
                        <td>Above BDT.400,000/= (Any amount more than four lac only) </td>
                        <td>5 (five) years</td>
                    </tr>
                </tbody>
            </table>
            <h6>Figure 5: Training Cost and Time Duration of Bond</h6>

        </div>
        <div>
            <input type="checkbox" @if(!empty($policyInfo->chap6_status) && $policyInfo->chap6_status =='1') disabled checked @endif name="chapter_six" class="agree_policy" id="chapter_six" vale="0"> <span style="color:red;">Are you Agree Chapter 6 ?</span>
        </div>
    </div>
      </div>
    </div>
  </div>
  <div class="accordion-item">
    <h2 class="accordion-header" id="headingThree">
      <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSeven" aria-expanded="false" aria-controls="collapseThree">
      <h6>CHAPTER-7: EMPLOYEE SEPARATION & EXIT PROCEDURE</h6>
      </button>
    </h2>
    <div id="collapseSeven" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#accordionExample">
      <div class="accordion-body">
      <div class="chapter">
        <div>
            The purpose of the separation policy of National Polymer Group (NPOLY) is to establish clear,
            standardized procedures and guidelines to ensure a smooth and organized transition of
            employees from the company. The policy is designed to ensure that employee transitions are
            handled with fairness, professionalism, and consistency while aligning with legal
            requirements and protecting the interests of both the company and departing employees. This
            policy applies to all employees, regardless of their employment status or level within the
            company.
        </div><br>
        <div class="section" style="margin-bottom:35px !important;">
            <h6><b>7.1 RESIGNATION</b></h6>
            <div>A permanent employee of the company can submit a resignation from her/his employment
                service by giving written notice as outlined in her/his appointment letter. Which will be
                processed in the following manner for the permanent employee:
            </div>
        </div>
        <div class="subsection">
            <h6>7.1.1 Assistant Executive to Senior Assistant Manager:</h6>
            <div>01 (one) month/ 30 (thirty) days prior notice to the employer/ Head of HR or 01 (one) month
                gross salary in lieu of notice. In case of a notice period of less than 30 (thirty) days, the full 01
                (one) month gross salary will be deducted during the final settlement.</div>
        </div><br>
        <div class="subsection">
            <h6>7.1.2 Deputy Manager & Above:</h6>
            <div>02 (two) months/ 60 (sixty) days prior notice to the employer/ Head of HR or 02 (two) months
                gross salary in lieu of notice. If the position is below Deputy Manager but holds the position
                as the head of the department/ section, HR can assign her/him 02 (two) month notice period
                in her/his appointment letter. In case of a notice period of less than 60 (sixty) days, for the
                first 30 (thirty) days, 4.1 will be followed. For the second 30 days, the gross salary will be
                deducted on a pro-rata basis during the final settlement.</div>
        </div><br>
        <div class="subsection">
            <h6>7.1.3 Non-Confirmed Employee: </h6>
            <div>During the probation period, an employee may resign and leave the organization by giving 07
                (seven) days’ notice or seven days gross salary in lieu of notice.</div>
            <p><b>7.1.4 </b>After the resignation of the employee, s/he will not be eligible for any leave. If any leave
                is taken, it will be without pay. In case of sickness or any special case, HOD can approve leave
                with pay, which has to be agreed upon by the HR.</p>
        </div>
        <div>
            <input type="checkbox" @if(!empty($policyInfo->chap7_status) && $policyInfo->chap7_status =='1') disabled checked @endif name="chapter_seven" class="agree_policy" id="chapter_seven" vale="0"> <span style="color:red;">Are you Agree Chapter 7 ?</span>
        </div>
    </div>
      </div>
    </div>
  </div>
  <div class="accordion-item">
    <h2 class="accordion-header" id="headingThree">
      <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseEight" aria-expanded="false" aria-controls="collapseThree">
      <h6>CHAPTER - 8: EMPLOYEE DISCIPLINARY PROCEDURE</h6>
      </button>
    </h2>
    <div id="collapseEight" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#accordionExample">
      <div class="accordion-body">
      <div class="chapter">
        <div>
            The management believes in the goodwill, commitment, and dedication of employees.
            However, in exceptional cases, the following disciplinary action (under section 23 of
            Bangladesh Labor Law) may be applied.
        </div>
        <p class="margin-bottom"><b>8.1 </b>Notwithstanding anything contained elsewhere in the Bangladesh Labor Act relating
            to lay-offs, retrenchments, discharges, and terminations of employment, an employee may be
            dismissed from employment without notice or without pay in lieu of notice, if he/she is
            convicted of-</p>
        <p class="margin-bottom"><b>8.1.1 </b>Any criminal offence; or</p>
        <p class="margin-bottom"><b>8.1.2 </b>An offence of misconduct under subsection 5.</p>
        <p class="margin-bottom"><b>8.2 </b> In lieu of dismissal from service under subsection 2.1, an employee convicted of an
            offense of misconduct shall, in exceptional circumstances, be punished with any of the
            following punishments, namely-</p>
        <p class="margin-bottom"><b>8.2.1 </b>Removal;</p>
        <p class="margin-bottom"><b>8.2.2 </b>Demotion to a lower post, grade, or scale of pay by more than one year;
        </p>
        <p class="margin-bottom"><b>8.2.3 </b>Withholding of promotion for more than one year;
        </p>
        <p class="margin-bottom"><b>8.2.4 </b>Suspension of wage increase for more than one year;
        </p>
        <p class="margin-bottom"><b>8.2.5 </b>Penalty;</p>
        <p class="margin-bottom"><b>8.2.6 </b>Suspension without pay or without food for a period not exceeding seven days;
        </p>
        <p class="margin-bottom"><b>8.2.7 </b>Censure and warnings.</p>
        <p class="margin-bottom"><b>8.3 </b>To an employee dismissed under subsection 3.1, if his period of continuous service is
            more than one year, the employer shall pay as compensation 15 days' wages for every
            completed year of service.
            Provided that an employee shall not be entitled to any compensation if s/he is dismissed for
            misconduct. But in such case, the employee concerned shall get his other statutory dues as per
            the act.</p>
        <p class="margin-bottom"><b>8.4 </b>The following acts and omissions shall be treated as misconduct-</p>
        <p class="margin-bottom"><b>8.4.1 </b>Willful disobedience, either singly or in concert with others, of obeying any lawful or
            reasonable order aforesaid</p>
        <p class="margin-bottom"><b>8.4.2 </b>Theft, misappropriation, fraud, or dishonesty in relation to the owner's business or
            property;
        </p>
        <p class="margin-bottom"><b>8.4.3 </b>Accepting or paying a bribe in connection with his or any other employee's
            employment under the owner;</p>
        <p class="margin-bottom"><b>8.4.4 </b>Habitual absence without leaves or absence for more than ten consecutive days without
            taking leave;
        </p>
        <p class="margin-bottom"><b>8.4.5 </b>Habitual late attendance;
        </p>
        <p class="margin-bottom"><b>8.4.6 </b>Habitual violation of any law, rule, or regulation applicable to the Company;
        </p>
        <p class="margin-bottom"><b>8.4.7 </b>Disorderly conduct, rioting, arson, or vandalism in establishments;
        </p>
        <p class="margin-bottom"><b>8.4.8 </b>Habitual negligence;
        </p>
        <p class="margin-bottom"><b>8.4.9 </b>Habitual contravention of any rule of employment, including discipline or conduct,
            approved by the Chief Inspector;</p>
        <p class="margin-bottom"><b>8.4.10 </b>Altering, falsifying, wrongfully altering, damaging, or losing official records of the
            owner.</p>
        <p class="margin-bottom"><b>8.5 </b>If any employee dismissed under sub-section 2.1 is acquitted on appeal, he shall be
            reinstated in his former post, or appointed to a suitable new post, and if neither of these is
            possible, in that case, he will have to be paid compensation at the rate equal to the
            compensation payable to any discharged worker, but the amount of compensation already
            received on account of dismissal shall be deducted from it.
        </p>
    </div>
      </div>
      <div>
            <input type="checkbox" @if(!empty($policyInfo->chap8_status) && $policyInfo->chap8_status =='1') disabled checked @endif name="chapter_eight" class="agree_policy" id="chapter_eight" vale="0"> <span style="color:red;">Are you Agree Chapter 8 ?</span>
        </div>
    </div>
  </div>
  <div class="accordion-item">
    <h2 class="accordion-header" id="headingThree">
      <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseNine" aria-expanded="false" aria-controls="collapseThree">
      <h6>CHAPTER - 9: RETIREMENT POLICY</h6>
      </button>
    </h2>
    <div id="collapseNine" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#accordionExample">
      <div class="accordion-body">
      <div class="chapter">
        <div>The company intends to maintain clear policy guidelines for the administration and control of
            an employee’s retirement from the company. In this regard, the policy has been designed to
            ensure a robust retirement benefit plan for the employee with available options in the
            procedure. In addition, the company recognizes the contribution made by the employee
            throughout her/his employment years with the company and offers benefits as a privilege
            provided by the employer but not as an employee’s right.
        </div><br>
        <div class="section">
            <h6><b>9.1 RETIREMENT AGE AND EARLY RETIREMENT CRITERIA</b></h6>
            <div>
                <ol class="roman-list">
                    <li>The general retirement age of the employee is 62 (sixty-two) years determined from the
                        employee's personal file maintained with the HR department. However, an employee who
                        has reached 62 years of age or has served 32 years in the company will be eligible for
                        mandatory retirement whichever comes first.</li>
                    <li>An employee who has reached 55 (fifty-five) years of age or has served 25 (twenty-five)
                        years in the company can also decide on early retirement, whichever comes first.</li>
                    <li>An employee who is unable to serve the company due to any form of physical or mental
                        infirmity before reaching retirement age can decide on early retirement. The decision of
                        the company in this regard shall be final and binding on the employee.
                    </li>
                    <li>The company may in special circumstances and at its sole discretion offer its employee a
                        further period of employment beyond the age of sixty-two (62) years. Any such re-employment
                        shall be on a six-month contract basis and subject to the employee being
                        certified medically fit by the competent authority. This re-employment can be utilized for
                        the highest 10 (ten) times for an employee, not more than that and there must be a 01 (one)
                        week gap between two re-employments.
                    </li>
                    <li>Once an employee goes into re-employment after retirement, the company will issue a new
                        appointment letter under a six-month contractual appointment and her/his salary and
                        benefits along with other terms and conditions will be determined as decided and advised
                        by the Management, mutually agreed upon. </li>
                </ol>
            </div>
        </div><br>
        <div class="section">
            <h6><b>9.2 NOTICE OF RETIREMENT</b></h6><br>
            <div class="subsection">
                <h6>9.1.2 To Unit/Department/Reporting Head</h6>
                <div>
                    <ol class="roman-list">
                        <li>The HR department will initiate the process by notifying the retiring employee’s unit/
                            department/ reporting head 03 (three) months in advance of the date of impending
                            retirement.</li>
                        <li>The unit/ department/ reporting head will drive the transition plan for at least 02/ 03
                            (two/ three) months in advance of the retirement date keeping the HRBP informed.
                        </li>
                    </ol>
                </div>
            </div><br>
            <div class="subsection">
                <h6>9.1.3 To Retiring Employee</h6>
                <div>
                    <ol class="roman-list">
                        <li>The HR department will notify the retiring employee/s 03 (three) months in advance from
                            the date of the impending retirement.</li>
                        <li>The HR department will explain the exit formalities to the retiring employee including the
                            closing date of retirement and any other process involved 02 (two) months in advance
                            from the retirement date.

                        </li>
                    </ol>
                </div>
            </div>
        </div><br>
        <div class="section">
            <h6><b>9.2 ENTITLEMENT OF BENEFITS</b></h6>
            <p class="margin-bottom"><b>9.2.2 </b>All retiring employees are entitled to get regular benefits which are admissible as per
                the company policy.
            </p>
            <p class="margin-bottom"><b>9.2.3 </b>In case of early retirement, the employee may get the additional benefit of 06 (six)
                months' basic salary or fixed cash incentive in addition to usual service benefits
                according to the company policy. Management keeps the sole discretion to decide on
                the matter.</p>
        </div>
        <div>
            <input type="checkbox" @if(!empty($policyInfo->chap9_status) && $policyInfo->chap9_status =='1') disabled checked @endif class="agree_policy" name="chapter_nine" id="chapter_nine" vale="0"> <span style="color:red;">Are you Agree Chapter 9 ?</span>
        </div>
        <input type="hidden" value="{{$employeeNumber}}" id="employeeNumber">
    </div>
      </div>
    </div>
  </div>
</div>
    
      
    <!-- End Example Code -->
    <script type="text/javascript" src="{{ URL::asset('assets/vendors/jquery/dist/jquery.min.js') }}"></script>
    <script>
        $(document).ready(function(){
           //let employeeNumber = $('#employeeNumber').val();
           //alert('ok'); 
         });
         $(document).on('change','.agree_policy',function(){
            var msg = confirm("Are you agree this policy ? ");
            if(msg ==true){
                if($(this).prop('checked')){
                let chapterName = $(this).attr('name');
                let employeeNumber = $('#employeeNumber').val();

                $.ajaxSetup({
                        headers: {
                        'X-CSRF-TOKEN': '{{csrf_token()}}'
                        }
                    });
                    $.ajax({
                        type: 'POST',
                        url: '{{url("/company_handbook_status_change")}}',
                        data:{employeeNumber:employeeNumber,chapterName:chapterName},
                        success: function (data) {
                        alert('Policy aggred')
                        }
                    });

             }else{
                $(this).prop('checked',false)
                return false
             }
            }else{
                $(this).prop('checked',false)
                return false
            }
         })
    </script>
  </body>
</html>