<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
use Auth;
use Mail;
use App\Jobs\SendNotification;

class VehicleModel extends Model
{
    use HasFactory;
    protected $table = 'vehicel_request_mst';
    protected $primaryKey = 'id';

    /**
     * This method use for save class routine
     * @param Request $request
     *
     */
    public static function createVechile1($request){

        $requestData = array(
            "employee_number"    =>Auth::user()->employee_number,
            "department_id"      => Auth::user()->department_id,
            "visit_type_id"      => $request->visit_type,
            "trip_type_id"       => $request->trip_type,
            "form_date"          => $request->visit_form_date ? date('Y-m-d',strtotime($request->visit_form_date)):"",
            "end_date"           => $request->visit_to_date ? date('Y-m-d',strtotime($request->visit_to_date)):"",
            "start_time"         => $request->start_time ? strtotime($request->start_time) - strtotime('today'):"",
            "end_time"           => $request->end_time ? strtotime($request->end_time) - strtotime('today'):"",
            "visit_place"      => $request->visit_place,
            "pick_up_point"      => $request->pickup_point,
            "status"             => 296,
            "active_status"      => 1,
            "created_by"         => Auth::user()->id,
            "created_at"         => date('Y-m-d H:i:s'),
        );

        DB::beginTransaction();
        try {
            $data = DB::table('vehicel_request')->insert($requestData);
            DB::commit();
        } catch (\Throwable $e) {
            DB::rollback();
            throw $e;
            exit;
        }

    }
   
    public static function createVechile($request){
        $requestMstData = array(
            "visit_type_id"      => $request->visit_type,
            "trip_type_id"       => $request->trip_type,
            "visit_place"        => $request->visit_place,
            "from_date"          => $request->visit_form_date ? date('Y-m-d', strtotime($request->visit_form_date)) : "",
            "to_date"            => $request->visit_to_date ? date('Y-m-d', strtotime($request->visit_to_date)) : "",
            "start_time"         => $request->start_time ? strtotime($request->start_time) - strtotime('today'):"",
            "end_time"           => $request->end_time ? strtotime($request->end_time) - strtotime('today'):"",
            "status"             => Auth::user()->id == '363' ? 301 : 300,
            "active_status"      => 1,
            "created_dept"       => Auth::user()->department_id,
            "group_request"      => $request->group_request ? $request->group_request:"0",
            "created_by"         => Auth::user()->id,
            "created_at"         => date('Y-m-d H:i:s'),
        );

        DB::beginTransaction();
        try {
            $masterInsertedId = DB::table('vehicel_request_mst')->insertGetId($requestMstData);
            DB::commit();
            $deptHeadMail = DB::table('users')->select('email_address','employee_number')->where('is_dept_head',1)->where('department_id',Auth::user()->department_id)->first();
            if ($request->group_request) {
                $employeesList = $request->employees_id;
                foreach ($employeesList as $key => $value) {
                    $requestChaid = array(
                        "request_id"         => $masterInsertedId,
                        "employee_number"    => DB::table('npoly_employees')->select('employee_number')->where('employee_id', $value)->first()->employee_number,
                        "department_id"      => DB::table('npoly_employees')->select('department_id')->where('employee_id', $value)->first()->department_id,
                        "pickup_time"         => $request->start_times ? strtotime($request->start_times[$key]) - strtotime('today') : strtotime($request->start_time) - strtotime('today'),
                        "start_time"         => $request->start_time ? strtotime($request->start_time) - strtotime('today'):"",
                        "end_time"           => $request->end_time ? strtotime($request->end_time) - strtotime('today'):"",
                        "pick_up_point"      => $request->pickup_points[$key],
                        "active_status"      => 1,
                        "created_by"         => Auth::user()->id,
                        "created_at"         => date('Y-m-d H:i:s'),
                    );
                    DB::table('vehicel_request_chd')->insert($requestChaid);
                }
                $data['visit_place'] = $request->visit_place;
                $data['name'] = Auth::user()->name;
                $data['department_name'] = Auth::user()->department_name;
                $data['designation_name'] = Auth::user()->designation_name;
                $data['from_date'] = date('d-M-Y',strtotime($request->visit_form_date));
                $data['to_date'] = date('d-M-Y',strtotime($request->visit_to_date));
                $data['title'] = 'Vehicle Request';
                $data['request_type'] = 2;
                $data['to_email'] = $deptHeadMail->email_address;

                $sent = Mail::send('emails.vehicle_req_dept', $data, function ($email) use ($data) {
                    $email->subject($data['title']);
                    $email->from('ticket@nationalpolymer.net','Vehicle Request');
                    $email->to([$data['to_email']]);
                    //$email->to(['azam.ali@nationalpolymer.net']);
                   // $email->cc([$data['req_email']]);
                    //$email->bcc('azam.ali@nationalpolymer.net');
                });

                $employeeNumber =$deptHeadMail->employee_number;
                $empName = Auth::user()->name;
                $title = 'Vehicle Request';
                $body = 'A new vehicle request has been submitted by '.$empName. ' . Please review and approve the request.';
                dispatch(new sendNotification((object)$request->all(),$employeeNumber,$title,$body));

            } else {
                $requestChaid = array(
                    "request_id"         => $masterInsertedId,
                    "employee_number"    => Auth::user()->employee_number,
                    "department_id"      => Auth::user()->department_id,
                    "start_time"         => $request->start_time ? strtotime($request->start_time) - strtotime('today') : "",
                    "pickup_time"         => $request->start_time ? strtotime($request->start_time) - strtotime('today') : "",
                    "end_time"           => $request->end_time ? strtotime($request->end_time) - strtotime('today') : "",
                    "pick_up_point"      => $request->pickup_point ? $request->pickup_point : "",
                    "active_status"      => 1,
                    "created_by"         => Auth::user()->id,
                    "created_at"         => date('Y-m-d H:i:s'),
                );
                DB::table('vehicel_request_chd')->insertGetId($requestChaid);

                $data['visit_place'] = $request->visit_place;
                $data['name'] = Auth::user()->name;
                $data['department_name'] = Auth::user()->department_name;
                $data['designation_name'] = Auth::user()->designation_name;
                $data['from_date'] = date('d-M-Y',strtotime($request->visit_form_date));
                $data['to_date'] = date('d-M-Y',strtotime($request->visit_to_date));
                $data['title'] = 'Vehicle Request';
                $data['request_type'] = 1;
                $data['to_email'] = $deptHeadMail->email_address;

                $sent = Mail::send('emails.vehicle_req_dept', $data, function ($email) use ($data) {
                    $email->subject($data['title']);
                    $email->from('ticket@nationalpolymer.net','Vehicle Request');
                    $email->to([$data['to_email']]);
                   // $email->to(['azam.ali@nationalpolymer.net']);
                   // $email->cc([$data['req_email']]);
                    //$email->bcc('azam.ali@nationalpolymer.net');
                });

                $employeeNumber =$deptHeadMail->employee_number;
                $empName = Auth::user()->name;
                $title = 'Vehicle Request';
                $body = 'A new vehicle request has been submitted by '.$empName. ' . Please review and approve the request.';
                dispatch(new sendNotification((object)$request->all(),$employeeNumber,$title,$body));
            }
            
        } catch (\Throwable $e) {
            DB::rollback();
            throw $e;
            exit;
        }
    }


    /**
     * This method use for update class routine
     * @param Request $request
     *
     */
    public static function updateVechileRequest($request){


        $id = $request->id;

        if($request->status=='301'){
            if($id && $datas = DB::table('vehicel_request_mst')->where('id', $id)->first()){
                $requestData = array(
                "status"             => $request->status ? $request->status : $datas->status,
                "updated_by"         => Auth::user()->id,
                "updated_at"         => date('Y-m-d H:i:s'),
                );
    
                DB::beginTransaction();
                try {
                    DB::table('vehicel_request_mst')
                        ->where('id', $id)
                        ->update($requestData);
    
                    DB::commit();
                $requestData = DB::table('vehicel_request_mst')->select('*')->where('id',$id)->first();

                $creatorInfo = DB::table('users')->select('name','department_name','designation_name')->where('id',$requestData->created_by)->first();

                $data['visit_place'] = $requestData->visit_place;
                $data['name'] = Auth::user()->name;
                $data['department_name'] = Auth::user()->department_name;
                $data['designation_name'] = Auth::user()->designation_name;
                $data['from_date'] = date('d-M-Y',strtotime($requestData->from_date));
                $data['to_date'] = date('d-M-Y',strtotime($requestData->to_date));
                $data['title'] = 'Vehicle Request';
                $data['to_email'] = 'mahdi.hasan@nationalpolymer.net';

                // requester info
                $data['req_name'] = $creatorInfo->name;
                $data['req_dept'] = $creatorInfo->department_name;
                $data['req_desig'] = $creatorInfo->designation_name;

                $sent = Mail::send('emails.vehicle_req_admin', $data, function ($email) use ($data) {
                    $email->subject($data['title']);
                    $email->from('ticket@nationalpolymer.net','Vehicle Request');
                   // $email->to([$data['to_email']]);
                    $email->to('admnpil@nationalpolymer.net');
                    //$email->to(['azam.ali@nationalpolymer.net']);
                   // $email->cc([$data['req_email']]);
                    //$email->bcc('azam.ali@nationalpolymer.net');
                });

                $employeeNumber = '10454';
                $title = 'Vehicle Request';
                $body = 'A new vehicle request has been submitted From '.Auth::user()->department_name. ' Department. Please review and approve the request.';
                dispatch(new sendNotification((object)$request->all(),$employeeNumber,$title,$body));

                } catch (\Throwable $e) {
                    DB::rollback();
                    throw $e;
                }
    
            }
        }else{
           // dd($_POST);
            if($id && $data = DB::table('vehicel_request_mst')->where('id', $id)->first()){
                $requestData = array(
                "visit_type_id"      => $request->visit_type ? $request->visit_type : $data-> visit_type_id,
                "trip_type_id"       => $request->trip_type ? $request->trip_type : $data-> trip_type_id,
                "from_date"          => $request->visit_form_date ? date('Y-m-d',strtotime($request->visit_form_date)):$data->form_date,
                "to_date"           => $request->visit_to_date ? date('Y-m-d',strtotime($request->visit_to_date)):$data->end_date,
                "start_time"         => $request->start_time ? strtotime($request->start_time) - strtotime('today'):$data->start_time,
                "end_time"           => $request->start_time ? strtotime($request->end_time) - strtotime('today'):$data->end_time,
                "visit_place"        => $request->visit_place ? $request->visit_place : $data->visit_place,
                //"pick_up_point"      => $request->pickup_point ? $request->pickup_point: $data->pick_up_point,
                "status"             => $request->status ? $request->status : $data->status,
               // "active_status"      => $request->active_status ? $request->active_status : $data->active_status ,
                "active_status"      => $request->active_status,
                "updated_by"         => Auth::user()->id,
                "updated_at"         => date('Y-m-d H:i:s'),
                );
    
                DB::beginTransaction();
                try {
                    DB::table('vehicel_request_mst')
                        ->where('id', $id)
                        ->update($requestData);

                        if ($request->group_request =='2') {
                            $deletePre = DB::table('vehicel_request_chd')->where('request_id',$id)->delete();
                            $employeesList = $request->employees_id;
                            foreach ($employeesList as $key => $value) {
                                $requestChaid = array(
                                    "request_id"         => $id,
                                    "employee_number"    => DB::table('npoly_employees')->select('employee_number')->where('employee_id', $value)->first()->employee_number,
                                    "department_id"      => DB::table('npoly_employees')->select('department_id')->where('employee_id', $value)->first()->department_id,
                                    "pickup_time"         => $request->start_times ? strtotime($request->start_times[$key]) - strtotime('today') : strtotime($request->start_time) - strtotime('today'),
                                    "start_time"         => $request->start_time ? strtotime($request->start_time) - strtotime('today'):"",
                                    "end_time"           => $request->end_time ? strtotime($request->end_time) - strtotime('today'):"",
                                    "pick_up_point"      => $request->pickup_points[$key],
                                    "active_status"      => $request->active_status ? $request->active_status : 1,
                                    "created_by"         => Auth::user()->id,
                                    "created_at"         => date('Y-m-d H:i:s'),
                                );
                                DB::table('vehicel_request_chd')->insert($requestChaid);
                            }
                        } else {
                            $requestChaid = array(
                                "request_id"         => $id,
                                "employee_number"    => Auth::user()->employee_number,
                                "department_id"      => Auth::user()->department_id,
                                "start_time"         => $request->start_time ? strtotime($request->start_time) - strtotime('today') : "",
                                "end_time"           => $request->end_time ? strtotime($request->end_time) - strtotime('today') : "",
                                "pick_up_point"      => $request->pickup_point,
                                "active_status"      => $request->active_status ? $request->active_status : 1,
                                "created_by"         => Auth::user()->id,
                                "created_at"         => date('Y-m-d H:i:s'),
                            );
                            DB::table('vehicel_request_chd')->where('request_id',$id)->update($requestChaid);
                        }
    
                    DB::commit();
                    // cancel email start here
                    if($request->status=='303'){
                        $requestData = array(
                            "status"         => '303',
                            "canceled_by"         => Auth::user()->id,
                            "canceled_at"         => date('Y-m-d H:i:s'), 
                        );
                        DB::table('vehicel_request_mst')
                        ->where('id', $id)
                        ->update($requestData);

                        $userId = DB::table('vehicel_request_mst')->select('*')->where('id', $id)->first();
                        $emailTo = DB::table('users')->select('email_address','employee_number')->where('id',$userId->created_by)->first();
                        //dd($emailTo->email_address);
                       // $data['visit_place'] = $requestData->visit_place;
                        $datas['name'] = Auth::user()->name;
                        $datas['department_name'] = Auth::user()->department_name;
                        $datas['designation_name'] = Auth::user()->designation_name;
                       // $data['from_date'] = date('d-M-Y',strtotime($requestData->from_date));
                       // $data['to_date'] = date('d-M-Y',strtotime($requestData->to_date));
                        $datas['title'] = 'Vehicle Request has been Cancelled';
                        $datas['to_email'] = $emailTo->email_address;

                        $datas['from_date'] =  $userId->from_date;
                        $datas['to_date'] =  $userId->to_date;
                        $datas['start_time'] =  $userId->start_time;
                        $datas['visit_place'] =  $userId->visit_place ? $userId->visit_place:"";
    
                        $sent = Mail::send('emails.vehicle_cancel_hod', $datas, function ($email) use ($datas) {
                            $email->subject($datas['title']);
                            $email->from('ticket@nationalpolymer.net','Vehicle Request');
                            $email->to([$datas['to_email']]);
                            //$email->to(['azam.ali@nationalpolymer.net']);
                        // $email->cc([$data['req_email']]);
                            //$email->bcc('azam.ali@nationalpolymer.net');
                        });

                        $employeeNumber =  $emailTo->employee_number;
               
                        $title = 'Vehicle Request';
                        $body = 'Your vehicle request for '.date('d-M-Y',strtotime($userId->from_date)).' to '. date('d-M-Y',strtotime($userId->to_date)) .' visit place ' . $userId->visit_place . ' has been canceled.';
                        dispatch(new sendNotification((object)$request->all(),$employeeNumber,$title,$body));

                    }
                   
                    // cancel email end here
                } catch (\Throwable $e) {
                    DB::rollback();
                    throw $e;
                }
    
            }
        }

    }
    public static function approveReqByAdmin1($request){
        $id = $request->request_id;

         // cancel mail start here
         if($request->status=='303'){
            $updateinfo = array(
                "status"=> $request->status,
                "canceled_by"=>Auth::user()->id,
                "canceled_at"=> date('Y-m-d h:i A'),
            );
            $update = DB::table('vehicel_request_mst')->where('id', $id)->update($updateinfo);
            
            $userId = DB::table('vehicel_request_mst')->select('*')->where('id', $id)->first();
            $reqInfo = DB::table('users')->select('email_address','department_id','employee_number')->where('id',$userId->created_by)->first();
            $deptEmail = DB::table('users')->select('email_address')->where('is_dept_head',1)->where('department_id',$reqInfo->department_id)->first();
            $data['title'] = 'Vehicle Request';
            $data['to_email'] =  $reqInfo->email_address;
            $data['cc_email'] =  $deptEmail->email_address;
            $data['from_date'] =  $userId->from_date;
            $data['to_date'] =  $userId->to_date;
            $data['start_time'] =  $userId->start_time;
            $data['visit_place'] =  $userId->visit_place ? $userId->visit_place:"";

            $sent = Mail::send('emails.vehicle_cancel_admin', $data, function ($email) use ($data) {
                $email->subject($data['title']);
                $email->from('ticket@nationalpolymer.net','Vehicle Request');
                $email->to([$data['to_email']]);
               // $email->to(['azam.ali@nationalpolymer.net']);
                $email->cc([$data['cc_email']]);
                $email->bcc('admnpil@nationalpolymer.net');
            });

            $employeeNumber =  $reqInfo->employee_number;
            $title = 'Vehicle Request';
            $body = 'Your vehicle request for '.date('d-M-Y',strtotime($userId->from_date)).' to '. date('d-M-Y',strtotime($userId->to_date)) .' visit place ' . $userId->visit_place . ' has been canceled.';
            dispatch(new sendNotification((object)$request->all(),$employeeNumber,$title,$body));

        }
        // cancel mail end here
        else{
            if($id && $datas = DB::table('vehicel_request_mst')->where('id', $id)->first()){
                $requestData = array(
                //"start_time"         => $request->start_time ? strtotime($request->start_time) - strtotime('today'):$data->start_time,
                //"end_time"           => $request->start_time ? strtotime($request->end_time) - strtotime('today'):$data->end_time,
                "status"             => $request->status ? $request->status : $datas->status,
                "vehicle_id"         => $request->vehicle_id,
                "driver_id"          => $request->driver_id,
                "approved_by"         => Auth::user()->id,
                "approved_at"         => date('Y-m-d H:i:s'),
                );
    
                DB::beginTransaction();
                try {
                    DB::table('vehicel_request_mst')
                        ->where('id', $id)
                        ->update($requestData);
    
                        //$deletePre = DB::table('vehicel_request_chd')->where('request_id',$id)->delete();
                        $child = $request->request_child_id;
                        foreach ($child as $key => $chId) {
                            DB::table('vehicel_request_chd')->where('id',$chId)->update([
                                "pick_up_point"      => $request->pickup_points[$key],
                                "pickup_time"        => $request->start_times ? strtotime($request->start_times[$key]) - strtotime('today') : "",
                            ]);
                        }
    
                    DB::commit();
                    // email start here
                    $reqMstInfo = DB::table('vehicel_request_mst')->select('*')->where('id',$id)->first();
                    $toMail = DB::table('users')->select('email_address','department_id','employee_number')->where('id',$reqMstInfo->created_by)->first();
                    $ccMail = DB::table('users')->select('email_address')->where('is_dept_head',1)->where('active_status',1)->where('department_id',$toMail->department_id)->first();
                    if($reqMstInfo->group_request !='2'){
                        $driverInfo = DB::table('npoly_driver')->select('*')->where('id',$request->driver_id)->first();
                        $vehicleInfo = DB::table('npoly_vehicel')->select('*')->where('id',$request->vehicle_id)->first();
                        $data['vehicel_no'] = $vehicleInfo->vehicel_no;
                        $data['vehicle_name'] = $vehicleInfo->name;
                        $data['driver_name'] = $driverInfo->name;
                        $data['driver_mobile'] = $driverInfo->mobile;
                        $data['title'] = 'Vehicle Request';
                        $data['to_email'] = $toMail->email_address;
                        $data['cc_mail'] = $ccMail->email_address;
        
                        $sent = Mail::send('emails.approve_vehicle', $data, function ($email) use ($data) {
                            $email->subject($data['title']);
                            $email->from('ticket@nationalpolymer.net','Vehicle Request');
                            $email->to([$data['to_email']]);
                            //$email->to(['azam.ali@nationalpolymer.net']);
                            $email->cc([$data['cc_mail']]);
                            //$email->bcc('azam.ali@nationalpolymer.net');
                            $email->bcc('admnpil@nationalpolymer.net');
                        });

                        $employeeNumber =  $toMail->employee_number;
                        $title = 'Vehicle Request';
                        $body = 'Your vehicle request for '.date('d-M-Y',strtotime($reqMstInfo->from_date)).' to '. date('d-M-Y',strtotime($reqMstInfo->to_date)) .' visit place ' . $reqMstInfo->visit_place . ' has been approved. For more details please login application.';
                        dispatch(new sendNotification((object)$request->all(),$employeeNumber,$title,$body));
            

                    }else{
                    $participant = DB::select("SELECT chd.pick_up_point,emp.employee_name,emp.mobile_no,emp.email,chd.employee_number,
                                                TIME_FORMAT(SEC_TO_TIME( chd.pickup_time), '%h:%i %p') as pickup_time
                                                FROM vehicel_request_chd chd, npoly_employees emp
                                                WHERE chd.employee_number = emp.employee_number
                                                AND chd.request_id = $id");
                    $driverInfo = DB::table('npoly_driver')->select('*')->where('id',$request->driver_id)->first();
                    $vehicleInfo = DB::table('npoly_vehicel')->select('*')->where('id',$request->vehicle_id)->first();
                   
                    $array_values= [];
                    foreach($participant as $array)
                    {
                        $array_values[]=$array->email;

                        $employeeNumber =  $array->employee_number;
                        $title = 'Vehicle Request';
                        $body = 'Your vehicle request for '.date('d-M-Y',strtotime($reqMstInfo->from_date)).' to '. date('d-M-Y',strtotime($reqMstInfo->to_date)) .' visit place ' . $reqMstInfo->visit_place . ' has been approved. For more details please login application.';
                        dispatch(new sendNotification((object)$request->all(),$employeeNumber,$title,$body));
                    }
        
                    $ccToMail =  array_values($array_values);
                        

                    $data['vehicel_no'] = $vehicleInfo->vehicel_no;
                    $data['vehicle_name'] = $vehicleInfo->name;
                    $data['driver_name'] = $driverInfo->name;
                    $data['driver_mobile'] = $driverInfo->mobile;
                    $data['title'] = 'Vehicle Request';
                    $data['participants'] = $participant;
                    $data['to_email'] = $ccMail->email_address;
                    $sent = Mail::send('emails.approve_vehicle_group', $data, function ($email) use ($data,$ccToMail) {
                        $email->subject($data['title']);
                        $email->from('ticket@nationalpolymer.net','Vehicle Request');
                        $email->to([$data['to_email']]);
                        //$email->to(['azam.ali@nationalpolymer.net']);
                        $email->cc($ccToMail);
                        $email->bcc('admnpil@nationalpolymer.net');
                        //$email->bcc('azam.ali@nationalpolymer.net');
                    });
                    }
                   
                    
                    // email end here
                } catch (\Throwable $e) {
                    DB::rollback();
                    throw $e;
                }
    
            }
        }

       
    }
    public static function approveReqByAdmin($request){
        $id = $request->request_id;

         // cancel mail start here
         if($request->status=='303'){
            $updateinfo = array(
                "status"=> $request->status,
                "canceled_by"=>Auth::user()->id,
                "canceled_at"=> date('Y-m-d h:i A'),
            );

            $update = DB::table('vehicel_request_mst')->where('id', $id)->update($updateinfo);
            
            $userId = DB::table('vehicel_request_mst')->select('*')->where('id', $id)->first();

            $prevDriver = "";
            $prevVehicle = "";

            if(!empty($userId->vehicle_id)){
                $prevDriver = DB::table('npoly_driver')->select('*')->where('id',$userId->driver_id)->first();
                $prevVehicle = DB::table('npoly_vehicel')->select('*')->where('id',$userId->vehicle_id)->first();
            }


            $reqInfo = DB::table('users')->select('email_address','department_id','employee_number')->where('id',$userId->created_by)->first();
            $deptEmail = DB::table('users')->select('email_address')->where('is_dept_head',1)->where('department_id',$reqInfo->department_id)->first();
            $data['title'] = 'Vehicle Request';
            $data['to_email'] =  $reqInfo->email_address;
            $data['cc_email'] =  $deptEmail->email_address;
            $data['from_date'] =  $userId->from_date;
            $data['to_date'] =  $userId->to_date;
            $data['start_time'] =  $userId->start_time;
            $data['visit_place'] =  $userId->visit_place ? $userId->visit_place:"";

            $data['dirver_info'] = $prevDriver ? $prevDriver : "";
            $data['vehicle_info'] = $prevVehicle ? $prevVehicle : "";

            $sent = Mail::send('emails.vehicle_cancel_admin', $data, function ($email) use ($data) {
                $email->subject($data['title']);
                $email->from('ticket@nationalpolymer.net','Vehicle Request');
                $email->to([$data['to_email']]);
                $email->cc([$data['cc_email']]);
                $email->bcc('admnpil@nationalpolymer.net');
            });

            $employeeNumber =  $reqInfo->employee_number;
            $title = 'Vehicle Request';
            $body = 'Your vehicle request for '.date('d-M-Y',strtotime($userId->from_date)).' to '. date('d-M-Y',strtotime($userId->to_date)) .' visit place ' . $userId->visit_place . ' has been canceled.';
            dispatch(new sendNotification((object)$request->all(),$employeeNumber,$title,$body));

        }
        // cancel mail end here
        else{
            if($id && $datas = DB::table('vehicel_request_mst')->where('id', $id)->first()){

                $setVehicleId = $datas->vehicle_id;
                $setDirverId = $datas->driver_id;
                $setDriverInfo = "";
                $setVehicleInfo = "";
                if(!empty($setVehicleId)){
                    $setDriverInfo = DB::table('npoly_driver')->select('*')->where('id',$setDirverId)->first();
                    $setVehicleInfo = DB::table('npoly_vehicel')->select('*')->where('id',$setVehicleId)->first();
                }

                $requestData = array(
                //"start_time"         => $request->start_time ? strtotime($request->start_time) - strtotime('today'):$data->start_time,
                //"end_time"           => $request->start_time ? strtotime($request->end_time) - strtotime('today'):$data->end_time,
                "status"             => $request->status ? $request->status : $datas->status,
                "vehicle_id"         => $request->vehicle_id,
                "driver_id"          => $request->driver_id,
                "approved_by"         => Auth::user()->id,
                "approved_at"         => date('Y-m-d H:i:s'),
                );
    
                DB::beginTransaction();
                try {
                    DB::table('vehicel_request_mst')
                        ->where('id', $id)
                        ->update($requestData);
    
                        //$deletePre = DB::table('vehicel_request_chd')->where('request_id',$id)->delete();
                        $child = $request->request_child_id;
                        foreach ($child as $key => $chId) {
                            DB::table('vehicel_request_chd')->where('id',$chId)->update([
                                "pick_up_point"      => $request->pickup_points[$key],
                                "pickup_time"        => $request->start_times ? strtotime($request->start_times[$key]) - strtotime('today') : "",
                            ]);
                        }
    
                    DB::commit();
                    // email start here
                    $reqMstInfo = DB::table('vehicel_request_mst')->select('*')->where('id',$id)->first();
                    $toMail = DB::table('users')->select('email_address','department_id','employee_number')->where('id',$reqMstInfo->created_by)->first();
                    $ccMail = DB::table('users')->select('email_address')->where('is_dept_head',1)->where('active_status',1)->where('department_id',$toMail->department_id)->first();
                   
                    if($reqMstInfo->group_request !='2'){

                        $driverInfo = DB::table('npoly_driver')->select('*')->where('id',$request->driver_id)->first();
                        $vehicleInfo = DB::table('npoly_vehicel')->select('*')->where('id',$request->vehicle_id)->first();
                        $data['vehicel_no'] = $vehicleInfo->vehicel_no;
                        $data['vehicle_name'] = $vehicleInfo->name;
                        $data['driver_name'] = $driverInfo->name;
                        $data['driver_mobile'] = $driverInfo->mobile;
                        $data['title'] = 'Vehicle Request';
                        $data['to_email'] = $toMail->email_address;
                        $data['cc_mail'] = $ccMail->email_address;
                        
                        $data['set_dirver_info'] = $setDriverInfo ? $setDriverInfo : "";
                        $data['set_vehicle_info'] = $setVehicleInfo ? $setVehicleInfo : "";
        
                        $sent = Mail::send('emails.approve_vehicle', $data, function ($email) use ($data) {
                            $email->subject($data['title']);
                            $email->from('ticket@nationalpolymer.net','Vehicle Request');
                            $email->to([$data['to_email']]);
                            $email->cc([$data['cc_mail']]);
                            $email->bcc('admnpil@nationalpolymer.net');
                        });

                        $employeeNumber =  $toMail->employee_number;
                        $title = 'Vehicle Request';
                        $body = 'Your vehicle request for '.date('d-M-Y',strtotime($reqMstInfo->from_date)).' to '. date('d-M-Y',strtotime($reqMstInfo->to_date)) .' visit place ' . $reqMstInfo->visit_place . ' has been approved. For more details please login application.';
                       // dispatch(new sendNotification((object)$request->all(),$employeeNumber,$title,$body));
            

                    }else{
                    $participant = DB::select("SELECT chd.pick_up_point,emp.employee_name,emp.mobile_no,emp.email,chd.employee_number,
                                                TIME_FORMAT(SEC_TO_TIME( chd.pickup_time), '%h:%i %p') as pickup_time
                                                FROM vehicel_request_chd chd, npoly_employees emp
                                                WHERE chd.employee_number = emp.employee_number
                                                AND chd.request_id = $id");
                    $driverInfo = DB::table('npoly_driver')->select('*')->where('id',$request->driver_id)->first();
                    $vehicleInfo = DB::table('npoly_vehicel')->select('*')->where('id',$request->vehicle_id)->first();
                   
                    $array_values= [];
                    foreach($participant as $array)
                    {
                        $array_values[]=$array->email;

                        $employeeNumber =  $array->employee_number;
                        $title = 'Vehicle Request';
                        $body = 'Your vehicle request for '.date('d-M-Y',strtotime($reqMstInfo->from_date)).' to '. date('d-M-Y',strtotime($reqMstInfo->to_date)) .' visit place ' . $reqMstInfo->visit_place . ' has been approved. For more details please login application.';
                        dispatch(new sendNotification((object)$request->all(),$employeeNumber,$title,$body));
                    }
        
                    $ccToMail =  array_values($array_values);
                        

                    $data['vehicel_no'] = $vehicleInfo->vehicel_no;
                    $data['vehicle_name'] = $vehicleInfo->name;
                    $data['driver_name'] = $driverInfo->name;
                    $data['driver_mobile'] = $driverInfo->mobile;
                    $data['title'] = 'Vehicle Request';
                    $data['participants'] = $participant;
                    $data['to_email'] = $ccMail->email_address;

                    $data['set_dirver_info'] = $setDriverInfo;
                    $data['set_vehicle_info'] = $setVehicleInfo;

                    $sent = Mail::send('emails.approve_vehicle_group', $data, function ($email) use ($data,$ccToMail) {
                        $email->subject($data['title']);
                        $email->from('ticket@nationalpolymer.net','Vehicle Request');
                        $email->to([$data['to_email']]);
                        $email->cc($ccToMail);
                        $email->bcc('admnpil@nationalpolymer.net');
                    });
                    }
                   
                    
                    // email end here
                } catch (\Throwable $e) {
                    DB::rollback();
                    throw $e;
                }
    
            }
        }

       
    }

    public static function multiReqByAdmin1($request){
        $id = $request->multi_request_id;
        
        if($request->status =='303'){
            $idArray = explode(",",$id);
            $requestData = array(
            "status"             => $request->status,
            "canceled_by"         => Auth::user()->id,
            "canceled_at"         => date('Y-m-d H:i:s'),
            );

        
            foreach($idArray as $reqId){
                DB::table('vehicel_request_mst')
                ->where('id', $reqId)
                ->update($requestData);
            }

            $multiCreatedBy = DB::select("select u.email_address,u.employee_number,m.from_date,m.to_date,m.visit_place from 
            vehicel_request_mst m, users u
            where m.created_by = u.id
            and m.id in ($id)
            ");
            
            $array_values= [];
            foreach($multiCreatedBy as $array)
            {
                $array_values[]=$array->email_address;

                $employeeNumber =  $array->employee_number;
                $title = 'Vehicle Request';
                $body = 'Vehicle request for '.date('d-M-Y',strtotime($array->from_date)).' to '. date('d-M-Y',strtotime($array->to_date)) .' visit place ' . $array->visit_place . ' has been canceled.';
                dispatch(new sendNotification((object)$request->all(),$employeeNumber,$title,$body));
            }

            $ccToMail =  array_values($array_values);
            //dd($ccToMail);

            $data['title'] = 'Cancel Request';

            $data['from_date'] =  '';
            $data['to_date'] = '';
            $data['start_time'] =  '';
            $data['visit_place'] = "";

            $sent = Mail::send('emails.vehicle_cancel_admin', $data, function ($email) use ($data,$ccToMail) {
                $email->subject($data['title']);
                $email->from('ticket@nationalpolymer.net','Vehicle Request');
                $email->to([$data['to_email']]);
               // $email->to(['azam.ali@nationalpolymer.net']);
                $email->cc($ccToMail);
                //$email->bcc('azam.ali@nationalpolymer.net');
                $email->bcc('admnpil@nationalpolymer.net');
            });


        }
        if($id){
            $idArray = explode(",",$id);
            $requestData = array(
            "status"             => $request->status,
            "vehicle_id"         => $request->vehicle_id,
            "driver_id"          => $request->driver_id,
            "multi_req_ids"          => $id,
            "multi_req_appr_status" => 1,
            "approved_by"         => Auth::user()->id,
            "approved_at"         => date('Y-m-d H:i:s'),
            );

            DB::beginTransaction();
            try {
                    foreach($idArray as $reqId){
                        DB::table('vehicel_request_mst')
                        ->where('id', $reqId)
                        ->update($requestData);
                    }

                    //$deletePre = DB::table('vehicel_request_chd')->where('request_id',$id)->delete();
                    $child = $request->request_child_id;
                    foreach ($child as $key => $chId) {
                        DB::table('vehicel_request_chd')->where('id',$chId)->update([
                            "pick_up_point"      => $request->pickup_points[$key],
                            "pickup_time"        => $request->start_times ? strtotime($request->start_times[$key]) - strtotime('today') : "",
                        ]);
                    }

                DB::commit();
                // email start here
                $participant = DB::select("SELECT chd.pick_up_point,emp.employee_name,emp.mobile_no,emp.email,chd.employee_number,
                                            TIME_FORMAT(SEC_TO_TIME( chd.pickup_time), '%h:%i %p') as pickup_time
                                            FROM vehicel_request_chd chd, npoly_employees emp
                                            WHERE chd.employee_number = emp.employee_number
                                            AND chd.request_id in ($id)");

                $array_values= [];
                foreach($participant as $array)
                {
                    $array_values[]=$array->email;

                    $employeeNumber =  $array->employee_number;
                    $title = 'Vehicle Request';
                    $body = 'Vehicle request for has been approved.';
                    dispatch(new sendNotification((object)$request->all(),$employeeNumber,$title,$body));
                }

                $ccToMail =  array_unique(array_values($array_values));
                $ccToMail1 =  array_values($ccToMail);
                

                $driverInfo = DB::table('npoly_driver')->select('*')->where('id',$request->driver_id)->first();
                $vehicleInfo = DB::table('npoly_vehicel')->select('*')->where('id',$request->vehicle_id)->first();
                $data['vehicel_no'] = $vehicleInfo->vehicel_no;
                $data['vehicle_name'] = $vehicleInfo->name;
                $data['driver_name'] = $driverInfo->name;
                $data['driver_mobile'] = $driverInfo->mobile;
                $data['title'] = 'Vehicle Request';
                $data['participants'] = $participant;
                $data['to_email'] = 'mahdi.hasan@nationalpolymer.net';

                $sent = Mail::send('emails.approve_vehicle_group', $data, function ($email) use ($data,$ccToMail1) {
                    $email->subject($data['title']);
                    $email->from('ticket@nationalpolymer.net','Vehicle Request');
                    //$email->to([$data['to_email']]);
                    $email->bcc('admnpil@nationalpolymer.net');
                   // $email->to(['azam.ali@nationalpolymer.net']);
                     $email->to($ccToMail1);
                    //$email->bcc('azam.ali@nationalpolymer.net');
                });
                // email end here
            } catch (\Throwable $e) {
                DB::rollback();
                throw $e;
            }

        }
    }

    public static function multiReqByAdmin($request){
        $id = $request->multi_request_id;
        
        if($request->status =='303'){
            $idArray = explode(",",$id);
            $requestData = array(
            "status"             => $request->status,
            "canceled_by"         => Auth::user()->id,
            "canceled_at"         => date('Y-m-d H:i:s'),
            );

        
            foreach($idArray as $reqId){
                DB::table('vehicel_request_mst')
                ->where('id', $reqId)
                ->update($requestData);
            }

            $multiCreatedBy = DB::select("select u.email_address,u.employee_number,m.from_date,m.to_date,m.visit_place from 
            vehicel_request_mst m, users u
            where m.created_by = u.id
            and m.id in ($id)
            ");
            
            $array_values= [];
            foreach($multiCreatedBy as $array)
            {
                $array_values[]=$array->email_address;

                $employeeNumber =  $array->employee_number;
                $title = 'Vehicle Request';
                $body = 'Vehicle request for '.date('d-M-Y',strtotime($array->from_date)).' to '. date('d-M-Y',strtotime($array->to_date)) .' visit place ' . $array->visit_place . ' has been canceled.';
                dispatch(new sendNotification((object)$request->all(),$employeeNumber,$title,$body));
            }

            $ccToMail =  array_values($array_values);
            //dd($ccToMail);

            $data['title'] = 'Cancel Request';

            $data['from_date'] =  '';
            $data['to_date'] = '';
            $data['start_time'] =  '';
            $data['visit_place'] = "";

            $sent = Mail::send('emails.vehicle_cancel_admin', $data, function ($email) use ($data,$ccToMail) {
                $email->subject($data['title']);
                $email->from('ticket@nationalpolymer.net','Vehicle Request');
                $email->to([$data['to_email']]);
                $email->cc($ccToMail);
                $email->bcc('admnpil@nationalpolymer.net');
            });

        }
        if($id){
            $idArray = explode(",",$id);
            $requestData = array(
            "status"             => $request->status,
            "vehicle_id"         => $request->vehicle_id,
            "driver_id"          => $request->driver_id,
            "multi_req_ids"          => $id,
            "multi_req_appr_status" => 1,
            "approved_by"         => Auth::user()->id,
            "approved_at"         => date('Y-m-d H:i:s'),
            );

            $requestInfo = DB::selectOne(" select vehicle_id,driver_id from vehicel_request_mst where id in ($id) ");
            
            $setVehicleId = $requestInfo->vehicle_id;
            $setDirverId = $requestInfo->driver_id;
            $setDriverInfo = "";
            $setVehicleInfo= "";
            
            if(!empty($setVehicleId)){
                $setDriverInfo = DB::table('npoly_driver')->select('*')->where('id',$setDirverId)->first();
                $setVehicleInfo = DB::table('npoly_vehicel')->select('*')->where('id',$setVehicleId)->first();
            }

            DB::beginTransaction();
            try {
                    foreach($idArray as $reqId){
                        DB::table('vehicel_request_mst')
                        ->where('id', $reqId)
                        ->update($requestData);
                    }

                    //$deletePre = DB::table('vehicel_request_chd')->where('request_id',$id)->delete();
                    $child = $request->request_child_id;
                    foreach ($child as $key => $chId) {
                        DB::table('vehicel_request_chd')->where('id',$chId)->update([
                            "pick_up_point"      => $request->pickup_points[$key],
                            "pickup_time"        => $request->start_times ? strtotime($request->start_times[$key]) - strtotime('today') : "",
                        ]);
                    }

                DB::commit();
                // email start here
                $participant = DB::select("SELECT chd.pick_up_point,emp.employee_name,emp.mobile_no,emp.email,chd.employee_number,
                                            TIME_FORMAT(SEC_TO_TIME( chd.pickup_time), '%h:%i %p') as pickup_time
                                            FROM vehicel_request_chd chd, npoly_employees emp
                                            WHERE chd.employee_number = emp.employee_number
                                            AND chd.request_id in ($id)");

                $array_values= [];
                foreach($participant as $array)
                {
                    $array_values[]=$array->email;

                    $employeeNumber =  $array->employee_number;
                    $title = 'Vehicle Request';
                    $body = 'Vehicle request for has been approved.';
                    dispatch(new sendNotification((object)$request->all(),$employeeNumber,$title,$body));
                }

                $ccToMail =  array_unique(array_values($array_values));
                $ccToMail1 =  array_values($ccToMail);
                

                $driverInfo = DB::table('npoly_driver')->select('*')->where('id',$request->driver_id)->first();
                $vehicleInfo = DB::table('npoly_vehicel')->select('*')->where('id',$request->vehicle_id)->first();
                $data['vehicel_no'] = $vehicleInfo->vehicel_no;
                $data['vehicle_name'] = $vehicleInfo->name;
                $data['driver_name'] = $driverInfo->name;
                $data['driver_mobile'] = $driverInfo->mobile;
                $data['title'] = 'Vehicle Request';
                $data['participants'] = $participant;
                $data['to_email'] = 'mahdi.hasan@nationalpolymer.net';

                $data['set_dirver_info'] = $setDriverInfo;
                $data['set_vehicle_info'] = $setVehicleInfo;

                $sent = Mail::send('emails.approve_vehicle_group', $data, function ($email) use ($data,$ccToMail1) {
                    $email->subject($data['title']);
                    $email->from('ticket@nationalpolymer.net','Vehicle Request');
                    $email->bcc('admnpil@nationalpolymer.net');
                     $email->to($ccToMail1);
                });
                // email end here
            } catch (\Throwable $e) {
                DB::rollback();
                throw $e;
            }

        }
    }
}
