<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
use Auth;

class VehicelSetupModel extends Model
{
    use HasFactory;
    protected $table = 'npoly_vehicel';
    protected $primaryKey = 'id';

    /**
     * This method use for save class routine
     * @param Request $request
     *
     */
    public static function createVechile($request){
        $driverData = array(
            "name"               => $request->name,
            "vehicel_no"         => $request->vehicel_no,
            "seat_capicity"      => $request->seat_capicity,
            "active_status"      => 1,
            "created_by"         => Auth::user()->id,
            "created_at"         => date('Y-m-d H:i:s'),
        );

        DB::beginTransaction();
        try {
            $data = DB::table('npoly_vehicel')->insert($driverData);
            DB::commit();
        } catch (\Throwable $e) {
            DB::rollback();
            throw $e;
            exit;
        }

    }

    /**
     * This method use for update class routine
     * @param Request $request
     *
     */
    public static function updateVechile($request){


        $id = $request->id;


        if($id && DB::table('npoly_vehicel')->where('id', $id)->first()){
            $driverData = array(
                "name"              => $request->name,
                "vehicel_no"        => $request->vehicel_no,
                "seat_capicity"     => $request->seat_capicity, 
                "active_status"     => $request->active_status,
                "updated_by"        => Auth::user()->id,
                "updated_at"        => date('Y-m-d H:i:s'),
            );

            DB::beginTransaction();
            try {
                DB::table('npoly_vehicel')
                    ->where('id', $id)
                    ->update($driverData);

                DB::commit();
            } catch (\Throwable $e) {
                DB::rollback();
                throw $e;
            }

        }

    }

}
