<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
use Auth;

class TicketModel extends Model
{
    use HasFactory;
    protected $table = 'npoly_tickets';
    protected $primaryKey = 'id';

    /**
     * This method use for save class routine
     * @param Request $request
     *
     */
    public static function createTicket($request){
        $maxTicketNo = DB::table('npoly_tickets')->max('id')+1;

        $ticketData = array(
            "project_id"         => $request->project_id,
            "ticket_no"          => date('ymd').'#'.$maxTicketNo,
            "department_id"      => $request->department_id,
            "ticket_title"       => $request->ticket_title,
            "ticket_desc"        => $request->ticket_desc,
            "issue_type_id"      => $request->issue_type,
            'priority_id'        => $request->priority_id,
            'module_id'          => $request->module_id,
            'request_type_id'    => $request->request_type_id,
            'request_mode_id'    => $request->request_mode_id,
            'contact_person'     => $request->contact_person?$request->contact_person:0,
            'ticket_status'      => '225',
            "support_user_id"    => Auth::user()->id,
            "created_by"         => Auth::user()->id,
            "created_at"         => date('Y-m-d H:i:s'),
            "ticket_create_date"        => date('Y-m-d'),
        );

        DB::beginTransaction();
        try {
            $ticketId = DB::table('npoly_tickets')->insertGetId($ticketData);
            DB::commit();

            // ticket attachment store
            if($request->file('ticket_attachment')){
                $files = $request->file('ticket_attachment');
                foreach ($files as $file) {

                    //$name = $Userid.'-'.date('Ymd').mt_rand(1000,9999).'.'.$file->getClientOriginalExtension();
                    $name = $ticketId.'-'.$file->getClientOriginalName();
                    $exten = $file->getClientOriginalExtension();
                    if($exten == "docx" || $exten == "xlsx" || $exten == "doc" || $exten == "pdf" || $exten == "bmp" || $exten == "zip" ){
                        $file->move(public_path() . '/uploads/ticket_image/', $name);
                    }else{
                        $file->move(public_path() . '/uploads/ticket_image/', $name);
                    }

                    // Save the filename to the database

                    $ticketAttachData = array(
                        "ticket_id"    => $ticketId,
                        "ticket_attachment"      => '/uploads/ticket_image/'.$name,
                        "created_by"        => Auth::user()->id,
                        "created_at"        => date('Y-m-d H:i:s'),
                    );
                    $data = DB::table('npoly_ticket_attachment')->insert($ticketAttachData);

                }
            }


            return $ticketId;
        } catch (\Throwable $e) {
            DB::rollback();
            throw $e;
            exit;
        }

    }

    /**
     * This method use for update class routine
     * @param Request $request
     *
     */
    public static function updateTaskAssign($request){


        $id = $request->ticket_id;




        if($id && DB::table('npoly_tickets')->where('id', $id)->first()){
            $ticketData = array(
                "department_id"          => $request->department_id,
                "employee_id"        => $request->employee_id,
                "updated_by"        => Auth::user()->id,
                "updated_at"        => date('Y-m-d H:i:s'),
            );

            // insert task info
            $ticktInfo = DB::table('npoly_tickets')->where('id', $id)->first();

            $taskData = array(
                "task_title"          => $ticktInfo->ticket_title,
                "task_desc"           => $ticktInfo->ticket_desc,
                "department_id"       => $request->department_id,
                "employee_id"         => $request->employee_id,
                "work_station"         => $request->work_station,
                "assign_date"         => date('Y-m-d',strtotime($request->assign_date)),
                'forecast_date'       => date('Y-m-d',strtotime($request->forecast_date)),
                'client_id'           => $ticktInfo->client_id,
                'project_id'          => $ticktInfo->project_id,
                'task_priority_id'    => $ticktInfo->priority_id,
                'ticket_id'           => $id,
                'active_status'       => 1,
                "created_by"          => Auth::user()->id,
                "created_at"          => date('Y-m-d H:i:s'),
            );

            DB::beginTransaction();
            try {
                DB::table('npoly_tickets')
                    ->where('id', $id)
                    ->update($ticketData);

                $data = DB::table('npoly_task_report')->insert($taskData);

                DB::commit();
            } catch (\Throwable $e) {
                DB::rollback();
                throw $e;
            }

        }

    }
    public static function updateBasicInfo($request){
        $id = $request->ticket_id;

        if($id && DB::table('npoly_tickets')->where('id', $id)->first()){
            $ticketData = array(
                "client_id"          => $request->client_id,
                "project_id"          => $request->project_id,
                "ticket_title"        => $request->ticket_title,
                "ticket_desc"        => $request->ticket_desc,
                "updated_by"        => Auth::user()->id,
                "updated_at"        => date('Y-m-d H:i:s'),
            );



            DB::beginTransaction();
            try {
                DB::table('npoly_tickets')
                    ->where('id', $id)
                    ->update($ticketData);

                DB::commit();
            } catch (\Throwable $e) {
                DB::rollback();
                throw $e;
            }

        }

    }
    public static function updateTicketForwardDeptInfo($request){
        $id = $request->ticket_id;

        if($id && DB::table('npoly_tickets')->where('id', $id)->first()){
            $ticketData = array(
                "department_id"          => $request->department_id,
                "dept_forward_reason"          => $request->dept_forward_reason,
                "updated_by"        => Auth::user()->id,
                "updated_at"        => date('Y-m-d H:i:s'),
            );
            DB::beginTransaction();
            try {
                DB::table('npoly_tickets')
                    ->where('id', $id)
                    ->update($ticketData);

                DB::commit();
            } catch (\Throwable $e) {
                DB::rollback();
                throw $e;
            }

        }

    }
    public static function updateStatusInfo($request){
        $id = $request->ticket_id;

        if($id && DB::table('npoly_tickets')->where('id', $id)->first()){
            $ticketData = array(
                "ticket_status"          => $request->ticket_status,
                "request_type_id"          => $request->request_type_id,
                "priority_id"        => $request->priority_id,
                "request_mode_id"        => $request->request_mode_id,
                "resolution"        => $request->resolution,
                "remarks"        => $request->remarks,
                "feedback"        => $request->feedback,
                "not_resolve_reason"        => $request->not_resolve_reason,
                "updated_by"        => Auth::user()->id,
                "updated_at"        => date('Y-m-d H:i:s'),
            );



            DB::beginTransaction();
            try {
                DB::table('npoly_tickets')
                    ->where('id', $id)
                    ->update($ticketData);

                DB::commit();
            } catch (\Throwable $e) {
                DB::rollback();
                throw $e;
            }

        }

    }
    public static function updateAssignInfo($request){
        $id = $request->ticket_id;

        if($id && DB::table('npoly_tickets')->where('id', $id)->first()){
            $ticketData = array(
               // "department_id"          => $request->department_id,
                "department_id"          => Auth::user()->department_id,
                "employee_id"          => $request->employee_id,
                "ticket_status"          => '234',
                "updated_by"        => Auth::user()->id,
                "updated_at"        => date('Y-m-d H:i:s'),
            );

            DB::beginTransaction();
            try {
                DB::table('npoly_tickets')
                    ->where('id', $id)
                    ->update($ticketData);

                $checkAssingInfo = DB::table('npoly_task_report')->select('*')->where('ticket_id',$id)->first();
                if(empty($checkAssingInfo)){
                    $hourSecond = $request->duration_hour ? $request->duration_hour * 3600 : 0; 
                    $minSecond = $request->duration_min ? $request->duration_min * 60 : 0; 
                    $setTotalSecond = $hourSecond + $minSecond;
                    $ticktInfo = DB::table('npoly_tickets')->where('id', $id)->first();
                    $departmentId = DB::table('npoly_employees')->select('department_id')->where('employee_id', $request->employee_id)->first();
                    $taskData = array(
                        "task_title"          => $ticktInfo->ticket_title,
                        "task_desc"           => $ticktInfo->ticket_desc,
                        "department_id"       => $departmentId->department_id,
                        "employee_id"         => $request->employee_id,
                        "work_station"        => $request->work_station,
                        "assign_by"           => Auth::user()->employee_id,
                        "assign_date"         => date('Y-m-d'),
                        "task_create_date"    => date('Y-m-d'),
                        'forecast_date'       => date('Y-m-d',strtotime($request->forecast_date)),
                        'client_id'           => $ticktInfo->client_id,
                        'project_id'          => $ticktInfo->project_id,
                        'task_priority_id'    => $ticktInfo->priority_id,
                        'ticket_id'           => $id,
                        'active_status'       => 1,
                        'set_task_duration'       => $setTotalSecond,
                        "created_by"          => Auth::user()->id,
                        "created_at"          => date('Y-m-d H:i:s'),
                    );
                    $data = DB::table('npoly_task_report')->insert($taskData);
                }

                DB::commit();
            } catch (\Throwable $e) {
                DB::rollback();
                throw $e;
            }

        }

    }
    public static function updateReAssignInfo($request){
        $id = $request->ticket_id;

        if($id && DB::table('npoly_tickets')->where('id', $id)->first()){
            $ticketData = array(
                "department_id"          => $request->department_id,
                "employee_id"            => $request->employee_id,
                "ticket_status"          => '234',
                "previous_emp_id"        => $request->previoue_emp_id,
                "previous_task_id"       => $request->previoue_task_id,
                "reassign_reason"        => $request->reassign_reason,
                "reassign_fg"            => 1,
                "updated_by"             => Auth::user()->id,
                "updated_at"             => date('Y-m-d H:i:s'),
            );

            DB::beginTransaction();
            try {
                DB::table('npoly_tickets')
                    ->where('id', $id)
                    ->update($ticketData);

                $checkAssingInfo = DB::table('npoly_task_report')->select('*')->where('ticket_id',$id)->first();
                if(!empty($checkAssingInfo)){
                    $ticktInfo = DB::table('npoly_tickets')->where('id', $id)->first();
                    $taskData = array(
                        "task_title"          => $ticktInfo->ticket_title,
                        "task_desc"           => $ticktInfo->ticket_desc,
                        "department_id"       => $request->department_id,
                        "employee_id"         => $request->employee_id,
                        "previous_ticket_id"  => $id,
                        "reassing_task_fg"    => 1,
                        "work_station"        => !empty($request->work_station)?$request->work_station:'',
                        "assign_date"         => date('Y-m-d',strtotime($request->assign_date)),
                        'forecast_date'       => date('Y-m-d',strtotime($request->forecast_date)),
                        'client_id'           => $ticktInfo->client_id,
                        'project_id'          => $ticktInfo->project_id,
                        'task_priority_id'    => $ticktInfo->priority_id,
                        'ticket_id'           => $id,
                        'active_status'       => 1,
                        "created_by"          => Auth::user()->id,
                        "created_at"          => date('Y-m-d H:i:s'),
                    );
                    $data = DB::table('npoly_task_report')->insert($taskData);
                }

                DB::commit();
            } catch (\Throwable $e) {
                DB::rollback();
                throw $e;
            }

        }

    }

}
