<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
use Auth;
use Mail;

class TaskReportModel extends Model
{
    use HasFactory;
    protected $table = 'npoly_task_report';
    protected $primaryKey = 'task_id';

    /**
     * This method use for save class routine
     * @param Request $request
     *
     */
    public static function createTaskAssign($request){
        if(!empty($request->department_id)){
            $departmentIds = $request->department_id;
            $countDept = count($departmentIds);
            if($countDept ==1){
                $departmentID = $request->department_id[0];
            }else if($countDept > 1){
                $departmentIdIn = implode(',',$request->department_id);
            }
        }
       
        
        $taskAssignData = array(
            "project_id"          => $request->project_id,
            "client_id"          => DB::selectOne("select client_id from npoly_projects where project_id = $request->project_id")->client_id,
            "task_title"          => $request->task_title,
            "task_category"          => !empty($request->task_category)?$request->task_category:"",
            "task_desc"        => $request->task_desc,
            "assign_by"    => !empty($request->assign_by)?$request->assign_by:"",
            "assign_person_name"    => !empty($request->assign_person_name)?$request->assign_person_name:"",
            "employee_id"    => $request->assign_to,
            "assign_date"    => date('Y-m-d',strtotime($request->assign_date)),
            "forecast_date"    => date('Y-m-d',strtotime($request->forecast_date)),
            "task_priority_id"    => $request->task_priority,
            "task_duration"    => $request->task_duration,
           //"department_id"    => !empty($request->department_id)? $request->department_id: Auth::user()->department_id,
            "department_id"    => !empty($departmentID)? $departmentID: Auth::user()->department_id,
            "multi_dept_id"    => !empty($departmentIdIn)? $departmentIdIn: '0',
            'active_status'          => 1,
            "created_by"        => Auth::user()->id,
            "created_at"        => date('Y-m-d H:i:s'),
            "task_create_date"        => date('Y-m-d'),
        );

        DB::beginTransaction();
        try {
            $data = DB::table('npoly_task_report')->insert($taskAssignData);
            DB::commit();
        } catch (\Throwable $e) {
            DB::rollback();
            throw $e;
            exit;
        }

    }
    public static function createTask($request){
        $time = date('h:i:s A');
        $startTime = strtotime($time) - strtotime('today');
        $taskData = array(
            "project_id"          => $request->project_id,
            "client_id"          => DB::selectOne("select client_id from npoly_projects where project_id = $request->project_id")->client_id,
            "task_title"          => $request->task_title,
            "task_desc"        => $request->task_desc,
            "task_category"        => $request->task_category,
            "assign_by"    => !empty($request->assign_by)?$request->assign_by:"",
            "assign_person_name"    => !empty($request->assign_person_name)?$request->assign_person_name:'',
            "work_station"    => $request->work_station,
            "employee_id"    => Auth::user()->employee_id,
            "assign_date"    => date('Y-m-d',strtotime($request->assign_date)),
            "forecast_date"    => date('Y-m-d',strtotime($request->forecast_date)),
            //"task_duration"    => $request->task_duration,
            "department_id"    => Auth::user()->department_id,
            'active_status'          => 1,
            'task_priority_id'          => 218,
            'task_running'          => $request->start_status =='1' ? 1:0,
            'start_time'          => $request->start_status =='1' ? $startTime:0,
            "created_by"        => Auth::user()->id,
            "task_create_date"        => date('Y-m-d'),
            "prof_task_perfome_dt"        => date('Y-m-d'),
            "created_at"        => date('Y-m-d H:i:s'),
        );

        DB::beginTransaction();
        try {
            $data = DB::table('npoly_task_report')->insert($taskData);
            DB::commit();
            if($request->start_status==1){
                // if task already exist then this section
                if($request->start_status==1 && $request->started_task > 0){
                    $time = date('h:i:s A');
                    $ebdTime = strtotime($time) - strtotime('today');
                    $taskId = DB::table('npoly_task_report')->select('task_id')->where('employee_id',Auth::user()->employee_id)->where('task_running',1)->get();
                    $stopData = array(
                       "task_running"=>0,
                       "end_time"=>$ebdTime,
                       "updated_by"=>Auth::user()->employee_id,
                       "updated_at"=>date('Y-m-d H:i:s'),
                    );
                    //
                    $stopLogData = array(
                        "end_time"=>$ebdTime,
                        "updated_by"=>Auth::user()->employee_id,
                        "updated_at"=>date('Y-m-d H:i:s'),
                    );
                    foreach ($taskId as $tksId){
                        DB::table('npoly_task_report')
                            ->where('task_id', $tksId->task_id)
                            ->update($stopData);
                    }
                    // log data update
                    foreach ($taskId as $tksId){
                        DB::table('npoly_task_report_log')
                            ->where('task_id', $tksId->task_id)
                            ->update($stopLogData);
                    }


                }
                // if task already exist then this section
                $maxStartedLogId = DB::table('npoly_task_report')->max('task_id');
                $taskInfo = DB::table('npoly_task_report')->select('*')->where('task_id',$maxStartedLogId)->first();

                $taskMailData = array(
                    "task_id"       => $taskInfo->task_id,
                    "task_title"         => $taskInfo->task_title,
                    "task_desc"             => $taskInfo->task_desc,
                    "task_category"        => $request->task_category,
                    //"departmtent_id"            => $taskInfo->departmtent_id,
                    "project_id"            => $taskInfo->project_id,
                    "employee_id"            => $taskInfo->employee_id,
                    "assign_by"    => !empty($request->assign_by)?$request->assign_by:"",
                    "assign_person_name"    => !empty($request->assign_person_name)?$request->assign_person_name:'',
                    "assign_date"       => date('Y-m-d',strtotime($taskInfo->assign_date)),
                    "forecast_date"       => date('Y-m-d',strtotime($taskInfo->forecast_date)),
                    "task_priority_id"            => $taskInfo->task_priority_id,
                    "ticket_id"            => $taskInfo->ticket_id,
                    "start_time"            => $taskInfo->start_time,
                    //"end_time"            => $taskInfo->end_time,
                    "task_complete"            => $taskInfo->task_complete,
                    "task_duration"            => $taskInfo->task_duration,
                    //'active_status'     => 1,
                    "created_by"        => Auth::user()->id,
                    "created_at"        => date('Y-m-d H:i:s'),
                    "task_create_date"        => date('Y-m-d'),
                    "prof_task_perfome_dt"        => date('Y-m-d'),
                );
                $data = DB::table('npoly_task_report_log')->insert($taskMailData);
            }


        } catch (\Throwable $e) {
            DB::rollback();
            throw $e;
            exit;
        }

    }
    public static function createTaskMail($request){
        $ccTo = implode(',',$request->cc_person);
        $bccTo = implode(',',$request->bcc_person);

        $cc_toMail = DB::select("select email from npoly_employees where employee_id in($ccTo)");
        //$ccMailId = '';
        if(!empty($cc_toMail)){
            $ccMail =[];
            foreach ($cc_toMail as $cc){
                $ccMail [] = "'".$cc->email."'";
            }
            $ccMailId = implode(',',$ccMail);
            $ccToName = str_replace('"','',$ccMailId);
        }
        $taskMailData = array(
            "employee_id"       => $request->employee_id,
            "report_to"         => $request->report_to,
            "cc_to"             => $ccTo,
            //"cc_to_name"             => $ccToName,
            "bcc_to"            => $bccTo,
            "assign_date"       => date('Y-m-d',strtotime($request->assign_date)),
            'active_status'     => 1,
            "created_by"        => Auth::user()->id,
            "created_at"        => date('Y-m-d H:i:s'),
        );

        DB::beginTransaction();
        try {
            $data = DB::table('npoly_task_mail')->insert($taskMailData);
            DB::commit();
        } catch (\Throwable $e) {
            DB::rollback();
            throw $e;
            exit;
        }

    }

    public static function updateTaskMailInof($request){


        $id = $request->task_mail_id;


        if($id && DB::table('npoly_task_mail')->where('task_mail_id', $id)->first()){
            $ccTo = implode(',',$request->cc_person);
            $bccTo = implode(',',$request->bcc_person);
            $taskData = array(
                "employee_id"       => $request->employee_id,
                "report_to"         => $request->report_to,
                "cc_to"             => $ccTo,
                "bcc_to"            => $bccTo,
                "assign_date"       => date('Y-m-d',strtotime($request->assign_date)),
                "active_status"          => $request->active_status,
                "updated_by"        => Auth::user()->id,
                "updated_at"        => date('Y-m-d H:i:s'),
            );

            DB::beginTransaction();
            try {
                DB::table('npoly_task_mail')
                    ->where('task_mail_id', $id)
                    ->update($taskData);


                DB::commit();
            } catch (\Throwable $e) {
                DB::rollback();
                throw $e;
            }

        }

    }

    /**
     * This method use for update class routine
     * @param Request $request
     *
     */
    public static function updateTaskAssign($request){


        $id = $request->task_id;


        if($id && DB::table('npoly_task_report')->where('task_id', $id)->first()){
            if(!empty($request->department_id)){
                $departmentIds = $request->department_id;
                $countDept = count($departmentIds);
                if($countDept ==1){
                    $departmentID = $request->department_id[0];
                }else if($countDept > 1){
                    $departmentIdIn = implode(',',$request->department_id);
                }
            }
            $taskData = array(
                "project_id"          => $request->project_id,
                "client_id"          => DB::selectOne("select client_id from npoly_projects where project_id = $request->project_id")->client_id,
                "task_title"          => $request->task_title,
                "task_desc"        => $request->task_desc,
                "assign_by"    => $request->assign_by,
                "employee_id"    => $request->assign_to,
                "assign_date"    => date('Y-m-d',strtotime($request->assign_date)),
                "forecast_date"    => date('Y-m-d',strtotime($request->forecast_date)),
                "task_priority_id"    => $request->task_priority,
                "task_duration"    => $request->task_duration,
                //"department_id"    => Auth::user()->department_id,
                "department_id"    => !empty($departmentID)? $departmentID: Auth::user()->department_id,
                "multi_dept_id"    => !empty($departmentIdIn)? $departmentIdIn: '0',
                "active_status"          => $request->active_status,
                "updated_by"        => Auth::user()->id,
                "updated_at"        => date('Y-m-d H:i:s'),
            );

            DB::beginTransaction();
            try {
                DB::table('npoly_task_report')
                    ->where('task_id', $id)
                    ->update($taskData);

                $ticketId = DB::table('npoly_task_report')->select('ticket_id')->where('task_id',$id)->first();
                if(!empty($ticketId)){
                    $updateTicketStatus = array(
                        'ticket_status'=>'234'
                    );
                    DB::table('npoly_tickets')
                        ->where('id', $ticketId->ticket_id)
                        ->update($updateTicketStatus);
                }

                DB::commit();
            } catch (\Throwable $e) {
                DB::rollback();
                throw $e;
            }

        }

    }
    public static function updateTask($request){


        $id = $request->task_id;


        if($id && DB::table('npoly_task_report')->where('task_id', $id)->first()){
            $taskData = array(
                "task_title"           => $request->task_title,
                "task_desc"            => $request->task_desc,
                "work_station"         => $request->work_station,
                "task_complete"        => $request->task_complete,
                "fdate_change_reason"  => !empty($request->fdate_change_reason)?$request->fdate_change_reason:"",
                "assign_date"          => date('Y-m-d',strtotime($request->assign_date)),
                "forecast_date"        => date('Y-m-d',strtotime($request->forecast_date)),
                "active_status"        => $request->active_status,
                "updated_by"           => Auth::user()->id,
                "updated_at"           => date('Y-m-d H:i:s'),
            );

            if(!empty($request->fdate_change_reason)){
                $taskPrevInfo = DB::table('npoly_task_report')->select("*")->where('task_id',$id)->first();

                $updateInfo = array(
                    "task_id"                    => $taskPrevInfo->task_id,
                    "task_title"                 => $taskPrevInfo->task_title,
                    "task_desc"                  => $taskPrevInfo->task_desc,
                    "employee_id"                => $taskPrevInfo->employee_id,
                    "prev_forecast_date"         => date('Y-m-d',strtotime($taskPrevInfo->forecast_date)),
                    "fdate_change_by"            => Auth::user()->employee_id,
                    "fdate_change_at"            => date('Y-m-d H:i:s'),
                );
                $data = DB::table('npoly_task_report_log')->insert($updateInfo);
            }

            DB::beginTransaction();
            try {
                DB::table('npoly_task_report')
                    ->where('task_id', $id)
                    ->update($taskData);

                // get max task log id
                $maxStartedLogId = DB::table('npoly_task_report_log')->where('task_id',$id)->max('task_log_id');
                $updateLogData = array(
                    "task_complete"     => $request->task_complete,
                    "updated_by"        => Auth::user()->id,
                    "updated_at"        => date('Y-m-d H:i:s'),
                );
                DB::table('npoly_task_report_log')
                    ->where('task_log_id', $maxStartedLogId)
                    ->update($updateLogData);


                if($request->task_complete =='100'){
                    $ticketId = DB::table('npoly_task_report')->select('ticket_id')->where('task_id',$id)->first();
                    if(!empty($ticketId->ticket_id)){
                        $updateTicketStatus = array(
                            'ticket_status'=>'228',
                            'resolution'=>$request->task_resolution
                        );
                        DB::table('npoly_tickets')
                            ->where('id', $ticketId->ticket_id)
                            ->update($updateTicketStatus);

                        // ticket resolved mail form here
                        $results = DB::table('npoly_tickets as tkt')
                            //->leftJoin('npoly_clients as clnt','tkt.client_id','clnt.client_id')
                            ->leftJoin('npoly_projects as pro','tkt.project_id','pro.project_id')
                            ->leftJoin('npoly_support_modules as mod','tkt.module_id','mod.module_id')
                            ->leftJoin('sa_lookup_data as lkp','tkt.priority_id','lkp.LOOKUP_DATA_ID')
                            ->leftJoin('sa_lookup_data as lkp1','tkt.ticket_status','lkp1.LOOKUP_DATA_ID')
                            ->leftJoin('sa_lookup_data as lkp2','tkt.issue_type_id','lkp2.LOOKUP_DATA_ID')
                            ->leftJoin('sa_lookup_data as lkp3','tkt.request_type_id','lkp3.LOOKUP_DATA_ID')
                            ->leftJoin('sa_lookup_data as lkp4','tkt.request_mode_id','lkp4.LOOKUP_DATA_ID')
                            ->select('tkt.*','pro.project_name','mod.module_name','lkp.LOOKUP_DATA_NAME as priority_name','lkp1.LOOKUP_DATA_NAME as ticket_status','lkp2.LOOKUP_DATA_NAME as issue_type','lkp3.LOOKUP_DATA_NAME as request_type','lkp4.LOOKUP_DATA_NAME as request_mode')
                            ->where('id',$ticketId->ticket_id)
                            ->first();
                        $deptHeadMail = DB::table('users')->select('email_address')->where('department_id',$results->department_id)->where('is_dept_head',1)->first();

                        $data['results']= $results ;
                        $data['ticket_id']= $ticketId->ticket_id ;
                        $data['title'] = 'Resolved Ticket';
                        $data['form_email'] = 'ticket@nationalpolymer.net';
                        $data['to_email'] = $deptHeadMail->email_address;
                        $data['form_name'] = 'Support User'.'('.$results->ticket_no.')';
                        $data['to_name'] = 'Npoly Group';

                         // Requester Info
                        // $requesterInfo = DB::table("users as urs")
                        // ->leftJoin('sa_lookup_data as lkp','urs.designation','lkp.LOOKUP_DATA_ID')
                        // ->select('urs.name','urs.email_address','urs.contact_no','urs.pbx_no','lkp.LOOKUP_DATA_NAME as designation_name')
                        // ->where('id','=',$results->created_by)
                        // ->first();
                        $requesterInfo = DB::table('users')->select('*')->where('id',$results->created_by)->first();
                        $data['created_by'] = $requesterInfo->name;
                        $data['created_at'] = $results->created_at;
                        $data['req_email'] = $requesterInfo->email_address;
                        $data['cc_to'] = $requesterInfo->email_address;
                        $data['pbx_no'] = $requesterInfo->pbx_no;
                        $data['contact_no'] = $requesterInfo->contact_no;
                        $data['request_type'] = $results->request_type;
                        $data['request_mode'] = $results->request_mode;
                    
                        $data['department_name'] = $requesterInfo->department_name;
                        $data['designation_name'] = $requesterInfo->designation_name;


                        $sent = Mail::send('emails.ticket_mail', $data, function ($email) use ($data) {
                            $email->subject($data['title']);
                            $email->from('ticket@nationalpolymer.net','Npoly Ticket');
                            $email->to([$data['to_email']]);
                            //$email->to(['azam.ali@nationalpolymer.net']);
                            $email->cc([$data['req_email']]);
                            //$email->bcc('azam.ali@nationalpolymer.net');
                        });
                    }
                }


                DB::commit();
            } catch (\Throwable $e) {
                DB::rollback();
                throw $e;
            }

        }

    }

}
// azam ali
