<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
use Auth;

class KpiSetupModel extends Model
{
    use HasFactory;
    protected $table = 'npoly_kpi';
    protected $primaryKey = 'kpi_id';

    /**
     * This method use for save class routine
     * @param Request $request
     *
     */
    public static function createKpi($request){
        $kpiData = array(
            "kpi_title"          => $request->kpi_title,
            //"kpi_desc"             => $request->kpi_desc,
            "department_id"        => $request->department_id,
            "kip_year"              => $request->kip_year,
            "dependency"        => $request->dependency,
            "kpi_percentage"        => $request->kpi_percentage,
            "kpi_expire_date"        => date('Y-m-d',strtotime($request->kpi_expire_date)),
            'active_status'          => 1,
            "created_by"        => Auth::user()->id,
            "created_at"        => date('Y-m-d H:i:s'),
        );

        DB::beginTransaction();
        try {
            $data = DB::table('npoly_kpi')->insert($kpiData);
            DB::commit();
        } catch (\Throwable $e) {
            DB::rollback();
            throw $e;
            exit;
        }

    }
    public static function createApproveKpi($request){

        $approvalNameData = array(
            "approval_name"          => $request->approval_name,
            "department_id"          => $request->department_id,
            'active_status'          => 1,
            "created_by"        => Auth::user()->id,
            "created_at"        => date('Y-m-d H:i:s'),
        );


        DB::beginTransaction();
        try {
            $lasApprovetId = DB::table('approval_name')->insertGetId($approvalNameData);

            // final approval data
            $approvalFinalData = array(
                "approval_final_id"          => $request->approval_id,
                "approval_id"          => $lasApprovetId,

                "user_id"          => Auth::user()->id,
                "user_name"          => Auth::user()->name,
                "employee_id"          => Auth::user()->employee_id,
                //"user_designation"          => $request->user_id,
                "final_status"          => !empty($request->final_status)?$request->final_status:0 ,
                'active_status'          => 1,
                "created_by"        => Auth::user()->id,
                "created_at"        => date('Y-m-d H:i:s'),
            );
            $lastFinalId = DB::table('approval_final')->insertGetId($approvalFinalData);
            // sub subordinate insert info

            if(!empty($request->subordinate_id)){
                $employeeInfo = DB::table('npoly_employees as emp')
                    ->leftJoin('sa_lookup_data as lkp','emp.designation_id','=','lkp.LOOKUP_DATA_ID')
                    ->select('emp.employee_id','emp.employee_name','lkp.LOOKUP_DATA_NAME as designation_name')
                    ->where('emp.employee_id',$request->subordinate_id)
                    ->first();
            }

            $subordinateData = array(
                "subordinate_id"          => $request->subordinate_id,
                "approval_final_id"          => $lastFinalId,
                "user_id"          => Auth::user()->id,
                "employee_id"          => !empty($employeeInfo)?$employeeInfo->employee_id:'',
                "user_name"          => !empty($employeeInfo)?$employeeInfo->employee_name:'',
                "user_designation"          => !empty($employeeInfo)?$employeeInfo->designation_name:'',
                //"final_status"          => !empty($request->final_status)?$request->final_status:0 ,
                'active_status'          => 1,
                "created_by"        => Auth::user()->id,
                "created_at"        => date('Y-m-d H:i:s'),
            );
            $lastSubId = DB::table('approval_subordinate')->insertGetId($subordinateData);
            //Initiator insert info

            if(!empty($request->initiator_id)){
                foreach ($request->initiator_id as $value){
                    $employeeInfo = DB::table('npoly_employees as emp')
                                    ->leftJoin('sa_lookup_data as lkp','emp.designation_id','=','lkp.LOOKUP_DATA_ID')
                                    ->select('emp.employee_id','emp.employee_name','lkp.LOOKUP_DATA_NAME as designation_name')
                                    ->where('emp.employee_id',$value)
                                    ->first();
                    $iniData = array(
                        "initiator_id"          => $value,
                        "subordinate_id"          => $lastSubId,
                        "user_id"                  => $employeeInfo->employee_id,
                        "user_name"                 => $employeeInfo->employee_name,
                        "user_designation"          => $employeeInfo->designation_name,
                        'active_status'          => 1,
                        "created_by"        => Auth::user()->id,
                        "created_at"        => date('Y-m-d H:i:s'),
                    );
                    $lastInerior = DB::table('approval_initiator')->insertGetId($iniData);
                }
            }

            DB::commit();
        } catch (\Throwable $e) {
            DB::rollback();
            throw $e;
            exit;
        }

    }

    public static function updateKpiApprove($request){

        $approvalFinalId = $request->approval_name_id;

        if(!empty($approvalFinalId)){
            DB::beginTransaction();
        try {
            $approvalNameData = array(
                "approval_name"          => $request->approval_name,
                "department_id"          => $request->department_id,
                'active_status'          => 1,
                "updated_by"        => Auth::user()->id,
                "updated_at"        => date('Y-m-d H:i:s'),
            );
            
            DB::table('approval_name')
            ->where('id', $approvalFinalId)
            ->update($approvalNameData);

            // update approve final table

            $approvalFinalData = array(
                "employee_id"          => $request->approval_id,
                "updated_by"        => Auth::user()->id,
                "updated_at"        => date('Y-m-d H:i:s'),
            );

            DB::table('approval_final')
            ->where('approval_id', $approvalFinalId)
            ->update($approvalFinalData);

            // update sub oridinate info
            $subordinateData = array(
                "user_id"          => Auth::user()->id,
                "employee_id"          => $request->subordinate_id,
                //"user_name"          => !empty($employeeInfo)?$employeeInfo->employee_name:'',
                'active_status'          => 1,
                "updated_by"        => Auth::user()->id,
                "updated_at"        => date('Y-m-d H:i:s'),
            );
            DB::table('approval_subordinate')
            ->where('approval_final_id', $approvalFinalId)
            ->update($subordinateData);

            DB::commit();
        } catch (\Throwable $e) {
            DB::rollback();
            throw $e;
            exit;
        }
        }



        

    }
    public static function kpiAssignStore($request){

        $taskAssignData = array(
            //"project_id"          => $request->project_id,
            //"client_id"          => DB::selectOne("select client_id from npoly_projects where project_id = $request->project_id")->client_id,
            "task_title"          => $request->kpi_title,
            //"task_category"          => !empty($request->task_category)?$request->task_category:"",
            //"task_desc"        => $request->task_desc,
            //"assign_by"    => !empty($request->assign_by)?$request->assign_by:"",
            //"assign_person_name"    => !empty($request->assign_person_name)?$request->assign_person_name:"",
            "employee_id"    => $request->assign_to,
            "kpi_percentage"    => $request->kpi_percentage,
            "kpi_id"    => $request->kpi_id,
            "assign_date"    => date('Y-m-d',strtotime($request->assign_date)),
            "forecast_date"    => date('Y-m-d',strtotime($request->forecast_date)),
            //"task_priority_id"    => $request->task_priority,
            //"task_duration"    => $request->task_duration,
            "department_id"    => $request->department_id,
            'active_status'          => 1,
            "created_by"        => Auth::user()->id,
            "created_at"        => date('Y-m-d H:i:s'),
            "task_create_date"        => date('Y-m-d'),
        );

        DB::beginTransaction();
        try {
            $data = DB::table('npoly_task_report')->insert($taskAssignData);
            DB::commit();
        } catch (\Throwable $e) {
            DB::rollback();
            throw $e;
            exit;
        }


    }

    /**
     * This method use for update class routine
     * @param Request $request
     *
     */
    public static function updateKpi($request){

        $id = $request->kpi_id;

        if($id && DB::table('npoly_kpi')->where('kpi_id', $id)->first()){
            $kpiData = array(
                "kpi_title"          => $request->kpi_title,
                //"kpi_desc"             => $request->kpi_desc,
                "department_id"        => $request->department_id,
                "dependency"        => $request->dependency,
                "kpi_percentage"        => $request->kpi_percentage,
                "kip_year"              => $request->kip_year,
                "kpi_expire_date"        => date('Y-m-d',strtotime($request->kpi_expire_date)),
                'active_status'          => 1,
                "updated_by"        => Auth::user()->id,
                "updated_at"        => date('Y-m-d H:i:s'),
            );

            DB::beginTransaction();
            try {
                DB::table('npoly_kpi')
                    ->where('kpi_id', $id)
                    ->update($kpiData);

                DB::commit();
            } catch (\Throwable $e) {
                DB::rollback();
                throw $e;
            }

        }

    }

}
