<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
use Auth;

class DriverSetupModel extends Model
{
    use HasFactory;
    protected $table = 'npoly_driver';
    protected $primaryKey = 'id';

    /**
     * This method use for save class routine
     * @param Request $request
     *
     */
    public static function createDriver($request){
        $driverData = array(
            "name"          => $request->name,
            "mobile"             => $request->mobile,
            "active_status"      => 1,
            "created_by"         => Auth::user()->id,
            "created_at"         => date('Y-m-d H:i:s'),
        );

        DB::beginTransaction();
        try {
            $data = DB::table('npoly_driver')->insert($driverData);
            DB::commit();
        } catch (\Throwable $e) {
            DB::rollback();
            throw $e;
            exit;
        }

    }

    /**
     * This method use for update class routine
     * @param Request $request
     *
     */
    public static function updateDriver($request){


        $id = $request->id;


        if($id && DB::table('npoly_driver')->where('id', $id)->first()){
            $driverData = array(
                "name"         => $request->name,
                "mobile"            => $request->mobile,
                "active_status"     => $request->active_status,
                "updated_by"        => Auth::user()->id,
                "updated_at"        => date('Y-m-d H:i:s'),
            );

            DB::beginTransaction();
            try {
                DB::table('npoly_driver')
                    ->where('id', $id)
                    ->update($driverData);

                DB::commit();
            } catch (\Throwable $e) {
                DB::rollback();
                throw $e;
            }

        }

    }

}
