<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
use Auth;

class DepoSetupModel extends Model
{
    use HasFactory;
    protected $table = 'npoly_depo';
    protected $primaryKey = 'depo_id';

    /**
     * This method use for save class routine
     * @param Request $request
     *
     */
    public static function createDepo($request){
        $depoData = array(
            "depo_name"          => $request->depo_name,
            "org_id"             => $request->org_id,
            "active_status"      => 1,
            "created_by"         => Auth::user()->id,
            "created_at"         => date('Y-m-d H:i:s'),
        );

        DB::beginTransaction();
        try {
            $data = DB::table('npoly_depo')->insert($depoData);
            DB::commit();
        } catch (\Throwable $e) {
            DB::rollback();
            throw $e;
            exit;
        }

    }

    /**
     * This method use for update class routine
     * @param Request $request
     *
     */
    public static function updateDepo($request){


        $id = $request->depo_id;


        if($id && DB::table('npoly_depo')->where('depo_id', $id)->first()){
            $depoData = array(
                "depo_name"         => $request->depo_name,
                "org_id"            => $request->org_id,
                "active_status"     => $request->active_status,
                "updated_by"        => Auth::user()->id,
                "updated_at"        => date('Y-m-d H:i:s'),
            );

            DB::beginTransaction();
            try {
                DB::table('npoly_depo')
                    ->where('depo_id', $id)
                    ->update($depoData);

                DB::commit();
            } catch (\Throwable $e) {
                DB::rollback();
                throw $e;
            }

        }

    }

}
