<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use DB;

class SendNotification implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public $request;
    public $employeeNumber;
    public $title;
    public $body;

    public function __construct($request, $employeeNumber, $title, $body)
    {
        $this->request = $request;
        $this->employeeNumber = $employeeNumber;
        $this->title = $title;
        $this->body = $body;
    }
    static function notificationSend($empNumber,$title,$body){
        //$input = $request->all();
        
        $fcmId = $data = DB::connection('oracle')->selectOne("select FCM_REG_ID from XX_TKT_OFF_APP_USERS where employee_number = $empNumber");
        /*$url = ' http://192.168.251.39:3000/api/v1/mobile/auth/notify';
        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
  
        $response = curl_exec($curl);
        curl_close($curl);*/
        $url = 'http://182.163.98.54:3001/api/v1/mobile/auth/notify';
  
        // The data to send in the POST request
        $data = array(
          'fcmRegId' => $fcmId ? $fcmId->fcm_reg_id:"",
          'title' => $title,
          'desc' => $body,
        );
  
        // Convert the data array to JSON
        $jsonData = json_encode($data);
  
        // Initialize cURL session
        $curl = curl_init($url);
  
    // Set the cURL options
            curl_setopt($curl, CURLOPT_URL, $url);
            curl_setopt($curl, CURLOPT_POST, true); // Set the request method to POST
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_HEADER, false);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $jsonData); // Attach the JSON data
            curl_setopt($curl, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json',
                'Content-Length: ' . strlen($jsonData)
            ));
  
            // Execute the POST request
            $response = curl_exec($curl);
  
            // Check for errors
            // if (curl_errno($curl)) {
            //     echo 'Error:' . curl_error($curl);
            // } else {
            //     // Print the response from the server
            //     echo 'Response from server: ' . $response;
            // }
  
            // Close cURL session
            //curl_close($curl);
        }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        //dd($this->request);
        $empNumber =  $this->employeeNumber;
        $title =  $this->title;
        $body =  $this->body;
        $this::notificationSend($empNumber,$title,$body);
    }
}
