<?php

namespace App\Http\Controllers\vehicle;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Session;
use App\Models\VehicleModel;
use DB;
use Auth;
use DatePeriod;
use DateTime;
use DateInterval;
use Illuminate\Support\Facades\Mail;
use App\Events\RealTimeEvent;
use App\Jobs\SendNotification;

class VehicleController extends Controller
{
    public function index(Request $request)
    {
       $path = $request->path();
       $empId = Auth::user()->employee_id;
       //$empId = 58;
       $moduleId = DB::table('sa_org_mlinks')->select('sa_module_id')->where('url_uri',$path)->first();
       $deptPermission = DB::table('request_approved_permission')
                        ->select('department_id')
                        ->where('module_id', $moduleId->sa_module_id)
                        ->where('employee_id', $empId)
                        ->first();
        $header = array(
            'pageTitle' => 'Vehicle',
            'tableTitle' => ''
        );

        $userLvlId = Auth::user()->USERLVL_ID;
        $condition = '';
        //$today = date('Y-m-d');
       if(Auth::user()->is_dept_head =='1'){
       //if(!empty($deptPermission->department_id)){
            $departmentId = Auth::user()->department_id;
            //$condition  .="and vrm.created_dept = $departmentId";
            $results = DB::select("SELECT
                                vrm.id,
                                lkp.lookup_data_name as visit_type,
                                vrm.visit_type_id,
                                vrm.visit_place,
                                vrm.trip_type_id,
                                vrm.from_date,
                                vrm.to_date,
                                lkp1.lookup_data_name as status,
                                vrm.status AS status_id,
                                vrm.start_time,
                                vrm.end_time,
                                vrm.group_request,
                                vrm.vehicle_id,
                                vrm.driver_id,
                                vrm.created_by,
                                vrm.multi_req_appr_status,
                                vrm.created_dept
                            FROM
                                vehicel_request_mst vrm,sa_lookup_data lkp,sa_lookup_data lkp1
                                WHERE vrm.visit_type_id = lkp.lookup_data_id
                                AND vrm.status = lkp1.lookup_data_id
                                AND vrm.created_dept = $departmentId
                                AND vrm.from_date >= CURRENT_DATE
                                AND vrm.active_status =1
                                ORDER BY vrm.id DESC
                                ");
        }else if($userLvlId =='22' || $userLvlId =='6'){
            $createdBy = Auth::user()->id;
            $condition  .="and (vrm.status <> 300 OR vrm.created_by = $createdBy)";
            $results = DB::select("SELECT
                                vrm.id,
                                lkp.lookup_data_name as visit_type,
                                vrm.visit_type_id,
                                vrm.visit_place,
                                vrm.trip_type_id,
                                vrm.from_date,
                                vrm.to_date,
                                lkp1.lookup_data_name as status,
                                vrm.status AS status_id,
                                vrm.start_time,
                                vrm.end_time,
                                vrm.group_request,
                                vrm.vehicle_id,
                                vrm.driver_id,
                                vrm.created_by,
                                vrm.multi_req_appr_status,
                                vrm.created_dept
                            FROM
                                vehicel_request_mst vrm,sa_lookup_data lkp,sa_lookup_data lkp1
                                WHERE vrm.visit_type_id = lkp.lookup_data_id
                                AND vrm.status = lkp1.lookup_data_id
                               $condition 
                               AND vrm.from_date >= CURRENT_DATE
                               AND vrm.active_status =1
                               AND vrm.status <> 303
                               ORDER BY vrm.id DESC
                                ");

        }else{
            $employeeNumber = Auth::user()->employee_number;
            $condition  .= "and vrc.employee_number = $employeeNumber";
           $results =  DB::select("SELECT
                                    vrm.id,
                                    lkp.lookup_data_name AS visit_type,
                                    vrm.visit_place,
                                    vrm.trip_type_id,
                                    vrm.from_date,
                                    vrm.to_date,
                                    vrc.pick_up_point,
                                    vrm.status AS status_id,
                                    lkp1.lookup_data_name AS status,
                                    vrm.start_time,
                                    vrm.end_time,
                                    vrc.end_time,
                                    vrc.pick_up_point,
                                    vrc.pickup_time,
                                    vrm.group_request,
                                    vrm.vehicle_id,
                                    vrm.driver_id,
                                    vrm.created_by,
                                    vrm.multi_req_appr_status,
                                    vrm.created_dept
                                FROM
                                    vehicel_request_mst vrm,
                                    vehicel_request_chd vrc,
                                    sa_lookup_data lkp,
                                    sa_lookup_data lkp1
                                WHERE
                                    vrm.id = vrc.request_id 
                                    AND lkp.LOOKUP_DATA_ID = vrm.visit_type_id 
                                    AND lkp1.LOOKUP_DATA_ID = vrm.status 
                                    AND vrm.active_status =1
                                    $condition ORDER BY vrm.id DESC");
        }

        return view('vehicle.index',compact('header','results','userLvlId'));
    }
    public function approvalIndex(Request $request)
    {
      
        $header = array(
            'pageTitle' => 'Vehicle',
            'tableTitle' => ''
        );
        $userLvlId = Auth::user()->USERLVL_ID;
        $today = date('Y-m-d');
        $results = DB::select("SELECT
        vrm.id,
        lkp.lookup_data_name as visit_type,
        vrm.visit_type_id,
        vrm.visit_place,
        vrm.trip_type_id,
        vrm.from_date,
        vrm.to_date,
        lkp1.lookup_data_name as status,
        vrm.status AS status_id,
        vrm.start_time,
        vrm.end_time,
        vrm.group_request,
        vrm.vehicle_id,
        vrm.driver_id,
        vrm.created_by,
        vrm.multi_req_appr_status,
        vrm.created_dept
    FROM
        vehicel_request_mst vrm,sa_lookup_data lkp,sa_lookup_data lkp1
        WHERE vrm.visit_type_id = lkp.lookup_data_id
        AND vrm.status = lkp1.lookup_data_id
        AND vrm.status = 300
       AND vrm.from_date >= CURRENT_DATE
       AND vrm.active_status =1
       ORDER BY vrm.id DESC
        ");
        

        return view('vehicle.waitingForApproval',compact('header','results','userLvlId'));
    }
    public function create()
    {
        $header = array(
            'pageTitle' => 'Vehicle',
            'tableTitle' => 'Vehicle'
        );
        $visitList = DB::table('sa_lookup_data')
                ->select('LOOKUP_DATA_ID', 'LOOKUP_DATA_NAME')
                ->where('LOOKUP_GRP_ID', '47')
                ->where('active_flag',1)
                ->get();

        $employeeList = DB::table('npoly_employees')
        ->select('employee_id', 'employee_name')
        ->where('active_status',1)
        ->get();

               

        return view('vehicle.create', compact('header','visitList','employeeList'));
    }

   
    public function store(Request $request)
    {
        VehicleModel::createVechile($request);
        
        Session::flash('success', 'Data Saved successfully!');
        return redirect()->route('vehicelIndex');
    }
    public function updateRequest($id)
    {
        $header = array(
            'pageTitle' => 'Vehicle',
            'tableTitle' => ''
        );
        $visitList = DB::table('sa_lookup_data')
        ->select('LOOKUP_DATA_ID', 'LOOKUP_DATA_NAME')
        ->where('LOOKUP_GRP_ID', '47')
        ->where('active_flag',1)
        ->get();

        $userLvlId = Auth::user()->USERLVL_ID;

        if(Auth::user()->is_dept_head =='1'){
         $requestStatus = DB::table('sa_lookup_data')
        ->select('LOOKUP_DATA_ID', 'LOOKUP_DATA_NAME')
        ->where('LOOKUP_GRP_ID', '48')
        ->where('LOOKUP_DATA_ID','!=', '302')
        ->where('active_flag',1)
        ->get(); 
        }else{
        $requestStatus = DB::table('sa_lookup_data')
        ->select('LOOKUP_DATA_ID', 'LOOKUP_DATA_NAME')
        ->where('LOOKUP_GRP_ID', '48')
        ->where('LOOKUP_DATA_ID','!=', '300')
        //->where('LOOKUP_DATA_ID','!=', '301')
        ->where('active_flag',1)
        ->get();
        }
        $employeeList = DB::table('npoly_employees')
        ->select('employee_id', 'employee_name','employee_number')
        ->where('active_status',1)
        ->get();
      
        $result = VehicleModel::find($id);
        $pickUpPoint = '';
        if($result->group_request =='0'){
            $pickUpPoint .= DB::table('vehicel_request_chd')->select('pick_up_point')->where('request_id',$id)->first()->pick_up_point;
        }
        
        
        $requesterInfo = DB::table('vehicel_request_chd as vrc')
        ->leftJoin('npoly_employees as emp','emp.employee_number','=','vrc.employee_number')
        ->select('vrc.*','emp.employee_id')
        ->where('vrc.request_id',$id)
        ->get();
        return view('vehicle.update', compact('header','pickUpPoint','result','visitList','requestStatus','userLvlId','employeeList','requesterInfo'));

    }
    static  function getAllDates($startDate, $endDate) {
        $dates = array();
    
        $currentDate = new DateTime($startDate);
        $endDate = new DateTime($endDate);
    
        while ($currentDate <= $endDate) {
            // Check if the current day is not a Friday (5 is the index for Friday in PHP)
            if ($currentDate) {
                $dates[] = $currentDate->format('Y-m-d');
            }
    
            // Move to the next day
            $currentDate->modify('+1 day');
        }
    
        return $dates;
    }

    public function approveRequest(Request $request, $id){
        $checkMultiReq = DB::table('vehicel_request_mst')->select('multi_req_ids')->where('id',$id)->first();

        if($checkMultiReq->multi_req_ids){
            $ids = $checkMultiReq->multi_req_ids;
            //$this::updateMultiReqApprove($checkMultiReq->multi_req_ids);
            $header = array(
                'pageTitle' => 'Vehicle',
                'tableTitle' => ''
            );
           
            $visitList = DB::table('sa_lookup_data')
            ->select('LOOKUP_DATA_ID', 'LOOKUP_DATA_NAME')
            ->where('LOOKUP_GRP_ID', '47')
            ->where('active_flag',1)
            ->get();
    
            $userLvlId = Auth::user()->USERLVL_ID;
    
            
            $requestStatus = DB::table('sa_lookup_data')
            ->select('LOOKUP_DATA_ID', 'LOOKUP_DATA_NAME')
            ->where('LOOKUP_GRP_ID', '48')
            ->where('LOOKUP_DATA_ID','!=', '300')
            ->where('LOOKUP_DATA_ID','!=', '301')
            ->where('active_flag',1)
            ->get();
           
    
            
            $driverList = DB::table('npoly_driver')->select('id','name','mobile')
            ->where('active_status',1)
            ->get();
    
            $result = DB::select("SELECT
                                        vrm.*,
                                        lkp.lookup_data_name AS visit_type,
                                        lkp1.lookup_data_name AS request_status
                                    FROM
                                        vehicel_request_mst vrm,sa_lookup_data lkp,sa_lookup_data lkp1
                                        WHERE vrm.visit_type_id = lkp.LOOKUP_DATA_ID
                                        AND vrm.status = lkp1.LOOKUP_DATA_ID
                                    AND vrm.id IN($ids)");
                                    
            
    
            $reqFromDate = $result[0]->from_date;
            $reqToDate = $result[0]->to_date;

            $prevDriver = $result[0]->driver_id ? $result[0]->driver_id : 0;
            $preVechicle = $result[0]->vehicle_id ? $result[0]->vehicle_id : 0;
    
            $maxReqDate = DB::selectOne("select max(to_date) to_date from vehicel_request_mst where status = 302");
            $fromDate = $maxReqDate->to_date > $reqFromDate ?  date('Y-m-d'):$reqFromDate;
            $toDate =  $maxReqDate->to_date > $reqFromDate ? $maxReqDate->to_date:$reqToDate;
    
            $allDate = $this::getAllDates($fromDate,$toDate);
    
            $allVehicle = [];
            foreach($allDate as $value){
               $allVehicle []= DB::select("SELECT vehicle_id, driver_id
                                            FROM vehicel_request_mst
                                            WHERE STATUS = 302
                                            AND '$value' BETWEEN from_date AND to_date");
            }
            $allVehicle = $allVehicle[0];
            //$vehicleList = array_unique($allVehicle);
            $vechileNewList = [];
            $driverNewList = [];
            foreach($allVehicle  as $key=> $vl){
                $vechileNewList []= $vl->vehicle_id;
                $driverNewList []= $vl->driver_id;
            }
            // vehicle
            $newList = array_unique($vechileNewList);
            $vehicleIn = implode(',',$newList);
            // driver
            $newDriverList = array_unique($driverNewList);
            $driverIn = implode(',',$newDriverList);
            // vehicle condition
            $vehiceleCondition = "";
    
            if(!empty($vehicleIn)){
                $vehiceleCondition .="and id not in($vehicleIn)";
            }
            // driver condition
            $driverCondition = "";
    
            if(!empty($driverIn)){
                $driverCondition .="and id not in($driverIn)";
            }
    
            $veichleList = DB::select("select id,name,vehicel_no 
            from npoly_vehicel 
            where active_status = 1
            $vehiceleCondition
            ");

            $vehicle = DB::select("select id,name,vehicel_no 
            from npoly_vehicel 
            where active_status = 1
            and id = $preVechicle
            ");
           

            $updateVehicleList = array_merge($veichleList,$vehicle);

    
            // $driverList = DB::table('npoly_driver')->select('id','name','mobile')
            // ->where('active_status',1)
            // ->get();
    
            $driverList = DB::select("select id,name,mobile 
            from npoly_driver
            where active_status = 1
            $driverCondition
            ");

            $driver = DB::select("select id,name,mobile 
            from npoly_driver
            where active_status = 1
            and id = $prevDriver
            ");

            $driverList = array_merge($driverList,$driver);
    
            //$createrInfo = DB::table('users')->select('name','department_name','designation_name')->where('id',$result->created_by)->first();
            $participentInfo = DB::select("SELECT
                                                vrc.*,
                                                usr.name,
                                                usr.contact_no,
                                                usr.department_name
                                            FROM
                                                vehicel_request_chd vrc,users usr
                                                
                                            WHERE usr.employee_number = vrc.employee_number 
                                            and vrc.request_id in ($ids)");
                                            $id = 70;
    
            
            return view('vehicle.multi_approve_request', compact('header','id','result','visitList','requestStatus','userLvlId','updateVehicleList','driverList','participentInfo','ids'));
        }else{
            $header = array(
                'pageTitle' => 'Vehicle',
                'tableTitle' => ''
            );
            $visitList = DB::table('sa_lookup_data')
            ->select('LOOKUP_DATA_ID', 'LOOKUP_DATA_NAME')
            ->where('LOOKUP_GRP_ID', '47')
            ->where('active_flag',1)
            ->get();
    
            $userLvlId = Auth::user()->USERLVL_ID;
    
            
            $requestStatus = DB::table('sa_lookup_data')
            ->select('LOOKUP_DATA_ID', 'LOOKUP_DATA_NAME')
            ->where('LOOKUP_GRP_ID', '48')
            ->where('LOOKUP_DATA_ID','!=', '300')
            ->where('LOOKUP_DATA_ID','!=', '301')
            ->where('active_flag',1)
            ->get();
           
    
            
            $driverList = DB::table('npoly_driver')->select('id','name','mobile')
            ->where('active_status',1)
            ->get();
    
            $result = DB::table('vehicel_request_mst as vrm')
                        ->leftJoin('sa_lookup_data as lkp','vrm.visit_type_id','=','lkp.lookup_data_id')
                        ->leftJoin('sa_lookup_data as lkp1','vrm.status','=','lkp1.lookup_data_id')
                        ->select('vrm.*','lkp.lookup_data_name as visit_type','lkp1.lookup_data_name as request_status')
                        ->where('vrm.id',$id)
                        ->first();
                        
            
            $reqFromDate = $result->from_date;
            $reqToDate = $result->to_date;
    
            $maxReqDate = DB::selectOne("select max(to_date) to_date from vehicel_request_mst where status = 302");
           // $fromDate = $maxReqDate->to_date > $reqFromDate ?  date('Y-m-d'):$reqFromDate;
            $fromDate = $reqFromDate;
            $toDate =  $maxReqDate->to_date > $reqFromDate ? $maxReqDate->to_date:$reqToDate;
    
            $allDate = $this::getAllDates($fromDate,$toDate);
            $allVehicle = [];
            foreach($allDate as $value){
               $allVehicle []= DB::select("SELECT vehicle_id, driver_id
                                            FROM vehicel_request_mst
                                            WHERE STATUS = 302
                                            AND '$value' BETWEEN from_date AND to_date");
            }
            //dd($allVehicle[0]);
            $allVehicle = $allVehicle[0];
            //$vehicleList = array_unique($allVehicle);
            $vechileNewList = [];
            $driverNewList = [];
            foreach($allVehicle  as $key=> $vl){
                $vechileNewList []= $vl->vehicle_id;
                $driverNewList []= $vl->driver_id;
            }
            // vehicle
            $newList = array_unique($vechileNewList);
            $vehicleIn = implode(',',$newList);
            // driver
            $newDriverList = array_unique($driverNewList);
            $driverIn = implode(',',$newDriverList);
            // vehicle condition
            $vehiceleCondition = "";
    
            if(!empty($vehicleIn)){
                $vehiceleCondition .="and id not in($vehicleIn)";
            }
            // driver condition
            $driverCondition = "";
    
            if(!empty($driverIn)){
                $driverCondition .="and id not in($driverIn)";
            }
    
            $veichleList = DB::select("select id,name,vehicel_no 
            from npoly_vehicel 
            where active_status = 1
            $vehiceleCondition
            ");
    
            $vehicleId = $result->vehicle_id ? $result->vehicle_id:0;
    
             $veichle = DB::select("select id,name,vehicel_no 
                from npoly_vehicel 
                where active_status = 1
                and id = $vehicleId
                ");
            $veichleList = array_merge($veichleList,$veichle);
    
            $driverList = DB::select("select id,name,mobile 
            from npoly_driver
            where active_status = 1
            $driverCondition
            ");
    
            $driverId = $result->driver_id ? $result->driver_id:0;
            $driver = DB::select("select id,name,mobile 
            from npoly_driver
            where active_status = 1
            and id = $driverId
            ");
    
            $driverList = array_merge($driverList,$driver);
    
            $createrInfo = DB::table('users')->select('name','department_name','designation_name')->where('id',$result->created_by)->first();
            $participentInfo = DB::table('vehicel_request_chd  as vrc')
            ->leftJoin('users as usr','usr.employee_number','=','vrc.employee_number')
            ->select('vrc.*','usr.name','usr.contact_no','usr.department_name')
            ->where('vrc.request_id',$id)
            ->get();
    
            
            return view('vehicle.approve_request', compact('header','createrInfo','id','result','visitList','requestStatus','userLvlId','veichleList','driverList','participentInfo'));
        }

    }

    public function approveRequest1(Request $request, $id){
        $header = array(
            'pageTitle' => 'Vehicle',
            'tableTitle' => ''
        );
        $visitList = DB::table('sa_lookup_data')
        ->select('LOOKUP_DATA_ID', 'LOOKUP_DATA_NAME')
        ->where('LOOKUP_GRP_ID', '47')
        ->where('active_flag',1)
        ->get();

        $userLvlId = Auth::user()->USERLVL_ID;

        
        $requestStatus = DB::table('sa_lookup_data')
        ->select('LOOKUP_DATA_ID', 'LOOKUP_DATA_NAME')
        ->where('LOOKUP_GRP_ID', '48')
        ->where('LOOKUP_DATA_ID','!=', '300')
        ->where('LOOKUP_DATA_ID','!=', '301')
        ->where('active_flag',1)
        ->get();
       

        
        $driverList = DB::table('npoly_driver')->select('id','name','mobile')
        ->where('active_status',1)
        ->get();

        $result = DB::table('vehicel_request_mst as vrm')
                    ->leftJoin('sa_lookup_data as lkp','vrm.visit_type_id','=','lkp.lookup_data_id')
                    ->leftJoin('sa_lookup_data as lkp1','vrm.status','=','lkp1.lookup_data_id')
                    ->select('vrm.*','lkp.lookup_data_name as visit_type','lkp1.lookup_data_name as request_status')
                    ->where('vrm.id',$id)
                    ->first();
                    
        
        $reqFromDate = $result->from_date;
        $reqToDate = $result->to_date;

        $maxReqDate = DB::selectOne("select max(to_date) to_date from vehicel_request_mst where status = 302");
        $fromDate = $maxReqDate->to_date > $reqFromDate ?  date('Y-m-d'):$reqFromDate;
        $toDate =  $maxReqDate->to_date > $reqFromDate ? $maxReqDate->to_date:$reqToDate;

        $allDate = $this::getAllDates($fromDate,$toDate);
        $allVehicle = [];
        foreach($allDate as $value){
           $allVehicle []= DB::select("SELECT vehicle_id, driver_id
                                        FROM vehicel_request_mst
                                        WHERE STATUS = 302
                                        AND '$value' BETWEEN from_date AND to_date");
        }
        $allVehicle = $allVehicle[0];
        //$vehicleList = array_unique($allVehicle);
        $vechileNewList = [];
        $driverNewList = [];
        foreach($allVehicle  as $key=> $vl){
            $vechileNewList []= $vl->vehicle_id;
            $driverNewList []= $vl->driver_id;
        }
        // vehicle
        $newList = array_unique($vechileNewList);
        $vehicleIn = implode(',',$newList);
        // driver
        $newDriverList = array_unique($driverNewList);
        $driverIn = implode(',',$newDriverList);
        // vehicle condition
        $vehiceleCondition = "";

        if(!empty($vehicleIn)){
            $vehiceleCondition .="and id not in($vehicleIn)";
        }
        // driver condition
        $driverCondition = "";

        if(!empty($driverIn)){
            $driverCondition .="and id not in($driverIn)";
        }

        $veichleList = DB::select("select id,name,vehicel_no 
        from npoly_vehicel 
        where active_status = 1
        $vehiceleCondition
        ");

        // $driverList = DB::table('npoly_driver')->select('id','name','mobile')
        // ->where('active_status',1)
        // ->get();

        $driverList = DB::select("select id,name,mobile 
        from npoly_driver
        where active_status = 1
        $driverCondition
        ");
        $createrInfo = DB::table('users')->select('name','department_name','designation_name')->where('id',$result->created_by)->first();
        $participentInfo = DB::table('vehicel_request_chd  as vrc')
        ->leftJoin('users as usr','usr.employee_number','=','vrc.employee_number')
        ->select('vrc.*','usr.name','usr.contact_no','usr.department_name')
        ->where('vrc.request_id',$id)
        ->get();

        
        return view('vehicle.approve_request', compact('header','createrInfo','id','result','visitList','requestStatus','userLvlId','veichleList','driverList','participentInfo'));

    }
    /* class routine update action
     * @param $request
     *
     */
    
    public function update(Request $request)
    {
        VehicleModel::updateVechileRequest($request);

        Session::flash('success', 'Data Updated successfully!');
        return redirect()->route('vehicelIndex');
    }
    public function vehiceBookedlInfo(){
        $header = array(
            'pageTitle' => 'Vehicle',
            'tableTitle' => ''
        );
   
        $driverList = DB::table('npoly_driver')
                    ->select("*")
                    ->where('active_status',1)
                    ->get();

        $vehicleList = DB::table('npoly_vehicel')
        ->select("*")
        ->where('active_status',1)
        ->get();
        //dd($vehicleList);
        $today = date('Y-m-d');
        $requestCount = DB::table('vehicel_request_mst')
        ->select('id')
        ->where('status',301)
        ->where('from_date', '>=', $today)
        ->where('active_status',1)
        ->count();
       

        return view('vehicle_status.index',compact('header','vehicleList','requestCount'));
    }

    public function getTotalVehicleRequest(Request $request){
        $today = date('Y-m-d');
        $requestCount = DB::table('vehicel_request_mst')
        ->select('id')
        ->where('status',301)
        ->where('from_date',$today)
        ->where('active_status',1)
        ->count();
        return $requestCount;
    }


    public function approveByAdmin(Request $request)
    {
        VehicleModel::approveReqByAdmin($request);

        Session::flash('success', 'Request Approve successfully!');
        return redirect()->route('vehicelInfo');
    }
    public function apprMultiReqByAdmin(Request $request)
    {
        //dd($_POST);
        VehicleModel::multiReqByAdmin($request);
        Session::flash('success', 'Request Approve successfully!');
        return redirect()->route('vehicelIndex');
    }
    public function multiReqApprove(Request $request,$ids){
       
        $header = array(
            'pageTitle' => 'Vehicle',
            'tableTitle' => ''
        );
        $id = 70;
        $visitList = DB::table('sa_lookup_data')
        ->select('LOOKUP_DATA_ID', 'LOOKUP_DATA_NAME')
        ->where('LOOKUP_GRP_ID', '47')
        ->where('active_flag',1)
        ->get();

        $userLvlId = Auth::user()->USERLVL_ID;

        
        $requestStatus = DB::table('sa_lookup_data')
        ->select('LOOKUP_DATA_ID', 'LOOKUP_DATA_NAME')
        ->where('LOOKUP_GRP_ID', '48')
        ->where('LOOKUP_DATA_ID','!=', '300')
        ->where('LOOKUP_DATA_ID','!=', '301')
        ->where('active_flag',1)
        ->get();
       

        
        $driverList = DB::table('npoly_driver')->select('id','name','mobile')
        ->where('active_status',1)
        ->get();

        $result = DB::select("SELECT
                                    vrm.*,
                                    lkp.lookup_data_name AS visit_type,
                                    lkp1.lookup_data_name AS request_status
                                FROM
                                    vehicel_request_mst vrm,sa_lookup_data lkp,sa_lookup_data lkp1
                                    WHERE vrm.visit_type_id = lkp.LOOKUP_DATA_ID
                                    AND vrm.status = lkp1.LOOKUP_DATA_ID
                                AND vrm.id IN($ids)");
                                
        

        $reqFromDate = $result[0]->from_date;
        $reqToDate = $result[0]->to_date;

        $maxReqDate = DB::selectOne("select max(to_date) to_date from vehicel_request_mst where status = 302 and status <> 303");
        //$fromDate = $maxReqDate->to_date > $reqFromDate ?  date('Y-m-d'):$reqFromDate;
        $fromDate = $reqFromDate;
        $toDate =  $maxReqDate->to_date > $reqFromDate ? $maxReqDate->to_date:$reqToDate;

        $allDate = $this::getAllDates($fromDate,$toDate);
        $allVehicle = [];
        foreach($allDate as $value){
           $allVehicle []= DB::select("SELECT vehicle_id, driver_id
                                        FROM vehicel_request_mst
                                        WHERE STATUS = 302
                                        AND '$value' BETWEEN from_date AND to_date");
        }
        $allVehicle = $allVehicle[0];
        //$vehicleList = array_unique($allVehicle);
        $vechileNewList = [];
        $driverNewList = [];
        foreach($allVehicle  as $key=> $vl){
            $vechileNewList []= $vl->vehicle_id;
            $driverNewList []= $vl->driver_id;
        }
        // vehicle
        $newList = array_unique($vechileNewList);
        $vehicleIn = implode(',',$newList);
        // driver
        $newDriverList = array_unique($driverNewList);
        $driverIn = implode(',',$newDriverList);
        // vehicle condition
        $vehiceleCondition = "";

        if(!empty($vehicleIn)){
            $vehiceleCondition .="and id not in($vehicleIn)";
        }
        // driver condition
        $driverCondition = "";

        if(!empty($driverIn)){
            $driverCondition .="and id not in($driverIn)";
        }

        $updateVehicleList = DB::select("select id,name,vehicel_no 
        from npoly_vehicel 
        where active_status = 1
        $vehiceleCondition
        ");

        // $driverList = DB::table('npoly_driver')->select('id','name','mobile')
        // ->where('active_status',1)
        // ->get();

        $driverList = DB::select("select id,name,mobile 
        from npoly_driver
        where active_status = 1
        $driverCondition
        ");

        //$createrInfo = DB::table('users')->select('name','department_name','designation_name')->where('id',$result->created_by)->first();
        $participentInfo = DB::select("SELECT
                                            vrc.*,
                                            usr.name,
                                            usr.contact_no,
                                            usr.department_name
                                        FROM
                                            vehicel_request_chd vrc,users usr
                                            
                                        WHERE usr.employee_number = vrc.employee_number 
                                        and vrc.request_id in ($ids)");

        
        return view('vehicle.multi_approve_request', compact('header','id','result','visitList','requestStatus','userLvlId','updateVehicleList','driverList','participentInfo','ids'));

    }

    public function participantList($ids){

        $header = array(
            'pageTitle' => 'Vehicle',
            'tableTitle' => ''
        );
        $results = DB::select("SELECT chd.pick_up_point,TIME_FORMAT(SEC_TO_TIME( chd.pickup_time), '%h:%i %p') as pickup_time,emp.employee_name,emp.mobile_no,dept.department_name FROM vehicel_request_chd chd,npoly_employees emp,set_department dept
                                WHERE chd.employee_number = emp.employee_number
                                AND chd.department_id = dept.id
                                AND  request_id  in($ids)");
        return view('vehicle_status.participants', compact('header','ids','results'));
        

    }
    public function vehicleReport(){
        $header = array(
            'pageTitle' => 'Vehicle Report',
            'tableTitle' => ''
        );

        $visitType = DB::table('sa_lookup_data')
        ->select('LOOKUP_DATA_ID', 'LOOKUP_DATA_NAME')
        ->where('LOOKUP_GRP_ID', '47')
        ->where('active_flag',1)
        ->get();

        $driverList = DB::table('npoly_driver')->select('id','name','mobile') ->get();
        $vehicleList = DB::table('npoly_vehicel')->select('id','name','vehicel_no') ->get();

        $userLvlId = Auth::user()->USERLVL_ID;
        $mfirstDate = date('Y-m-01');
        $today = date('Y-m-d');
        $results = DB::select("SELECT
                                vrm.id,
                                lkp.lookup_data_name as visit_type,
                                vrm.visit_type_id,
                                vrm.visit_place,
                                vrm.trip_type_id,
                                vrm.from_date,
                                vrm.to_date,
                                lkp1.lookup_data_name as status,
                                vrm.status AS status_id,
                                vrm.start_time,
                                vrm.end_time,
                                vrm.group_request,
                                vrm.vehicle_id,
                                vrm.driver_id,
                                vrm.created_by,
                                vrm.multi_req_appr_status,
                                vrm.created_dept
                            FROM
                                vehicel_request_mst vrm,sa_lookup_data lkp,sa_lookup_data lkp1
                                WHERE vrm.visit_type_id = lkp.lookup_data_id
                                AND vrm.status = lkp1.lookup_data_id
                               AND vrm.from_date BETWEEN '$mfirstDate' AND '$today'
                               AND vrm.active_status =1
                               AND vrm.status not in ('300','301')
                               ORDER BY vrm.id DESC
                                ");
        return view('vehicle_report.vehicleReport',compact('results','header','userLvlId','visitType','driverList','vehicleList'));
    }

    public function searchVehicleReport(Request $request){

        $header = array(
            'pageTitle' => 'Vehicle Report',
            'tableTitle' => ''
        );

        $fromDate = date('Y-m-d',strtotime($request->fromDate));
        $toDate = date('Y-m-d',strtotime($request->toDate));
        $visitId = $request->visitId;
        $vehicleId = $request->vehicleId;
        $driverId = $request->driverId;

        $condition = "";

        if(!empty($toDate)){
            $condition .=" AND vrm.from_date BETWEEN '$fromDate' AND '$toDate'";
        }

        if(!empty($visitId)){
            $condition .= " AND vrm.visit_type_id = '$visitId' ";
        }

        if(!empty($vehicleId)){
            $condition .= " AND vrm.vehicle_id = '$vehicleId' ";
        }

        if(!empty($driverId)){
            $condition .= " AND vrm.driver_id = '$driverId' ";
        }

        $results = DB::select("SELECT
            vrm.id,
            lkp.lookup_data_name as visit_type,
            vrm.visit_type_id,
            vrm.visit_place,
            vrm.trip_type_id,
            vrm.from_date,
            vrm.to_date,
            lkp1.lookup_data_name as status,
            vrm.status AS status_id,
            vrm.start_time,
            vrm.end_time,
            vrm.group_request,
            vrm.vehicle_id,
            vrm.driver_id,
            vrm.created_by,
            vrm.multi_req_appr_status,
            vrm.created_dept
            FROM
            vehicel_request_mst vrm,sa_lookup_data lkp,sa_lookup_data lkp1
            WHERE vrm.visit_type_id = lkp.lookup_data_id
            AND vrm.status = lkp1.lookup_data_id
            AND vrm.status not in ('300','301')
            $condition
            AND vrm.active_status =1
            ORDER BY vrm.id DESC
        ");

        return view('vehicle_report.searchReport',compact('results','header'));

    }
}
