<?php

namespace App\Http\Controllers\support;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Session;
use App\Models\VehicelSetupModel;
use DB;
use Auth;

class VehicelSetupController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $header = array(
            'pageTitle' => 'Vehicle',
            'tableTitle' => 'Vehicle List'
        );


        $results = DB::table('npoly_vehicel')
            ->select('*')
            //->where('active_status',1)
            ->orderBy('id','desc')
            ->get();

        return view('setup/vehicel.index',compact('header','results'));
    }

    /**
     * Create class routine form
     * @param None
     *
     */
    public function create()
    {
        $header = array(
            'pageTitle' => 'Vehicle',
            'tableTitle' => 'Vehicle List'
        );

        return view('setup/vehicel.create', compact('header'));
    }

    /* save class routine
     * @param Request $request
     *
     */
    public function store(Request $request)
    {
        VehicelSetupModel::createVechile($request);
        Session::flash('success', 'Data Saved successfully!');
        return redirect()->route('vehicelSetupIndex');
    }

    /* class routine update page
     * @param $id
     *
     */
    public function edit($id)
    {
        $header = array(
            'pageTitle' => 'Vehicle',
            'tableTitle' => 'Vehicle List'
        );

        $result = VehicelSetupModel::find($id);
        return view('setup/vehicel.update', compact('header', 'result'));

    }

    /* class routine update action
     * @param $request
     *
     */
    public function update(Request $request)
    {
        VehicelSetupModel::updateVechile($request);
        Session::flash('success', 'Data Updated successfully!');
        return redirect()->route('vehicelSetupIndex');
    }
}
