<?php

namespace App\Http\Controllers\support;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Session;
use App\Models\TicketModel;
use  App\Models\lookup\LookupGroupDataModel;
use DB;
use Auth;
use Illuminate\Support\Facades\Mail;

class TicketController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $header = array(
            'pageTitle' => 'Ticket',
            'tableTitle' => ''

        );
        $supportUserId = Auth::user()->support_user_id;
        $userLevel = Auth::user()->USERLVL_ID;

        if($supportUserId !=0){
            $fordwardInfo = [];
            $userId = Auth::user()->id;
            $results = DB::table('npoly_tickets as tkt')
            ->leftJoin('sa_lookup_data as lkp', 'tkt.priority_id', '=', 'lkp.LOOKUP_DATA_ID')
            ->leftJoin('sa_lookup_data as lkp1', 'tkt.ticket_status', '=', 'lkp1.LOOKUP_DATA_ID')
            ->leftJoin('npoly_clients as clnt', 'clnt.client_id', '=', 'tkt.client_id')
            ->leftJoin('npoly_projects as pro', 'pro.project_id', '=', 'tkt.project_id')
            ->leftJoin('npoly_task_report as tskr', 'tskr.ticket_id', '=', 'tkt.id')
            ->leftJoin('npoly_support_modules as tm', 'tm.module_id', '=', 'tkt.module_id')
            ->select('tkt.*','lkp.LOOKUP_DATA_NAME as priorityName','clnt.client_name','pro.project_name','tskr.created_at','tskr.forecast_date','tskr.employee_id','tskr.fordward_employee','tskr.task_complete','lkp1.LOOKUP_DATA_NAME as ticketStatus','tm.module_name')
            ->where('tkt.ticket_status','!=',230)
            ->where('tkt.created_by',$userId)
            ->where('tkt.active_status',1)
            ->orderBy('tkt.id','desc')
            ->get();
        }else if($userLevel =='7'){
            $empId = Auth::user()->employee_id;
            $userId = Auth::user()->id;
            $today = date('Y-m-d');
            $fordwardInfo = DB::selectOne("select start_date, end_date from npoly_ticket_fordward where employee_id = $empId and active_status= 1 and end_date > '$today'");
            
           if(!empty($fordwardInfo)){
            $sratrDate = $fordwardInfo->start_date;
            $endDate = $fordwardInfo->end_date;
           }
            $condition = "";
            if(!empty($sratrDate) && !empty($endDate)){
                $condition .=" or `ticket_create_date` between '$sratrDate' and '$endDate' ";
            }
            $results= DB::select("select `tkt`.*, `lkp`.`LOOKUP_DATA_NAME` as `priorityName`, `clnt`.`client_name`, `pro`.`project_name`, `tskr`.`employee_id`,`tskr`.`fordward_employee`,`tskr`.`task_complete`,`tskr`.`created_at`, `tskr`.`forecast_date`, `lkp1`.`LOOKUP_DATA_NAME` as `ticketStatus`, `tm`.`module_name` 
            from `npoly_tickets` as `tkt` 
            left join `sa_lookup_data` as `lkp` on `tkt`.`priority_id` = `lkp`.`LOOKUP_DATA_ID` 
            left join `sa_lookup_data` as `lkp1` on `tkt`.`ticket_status` = `lkp1`.`LOOKUP_DATA_ID` 
            left join `npoly_clients` as `clnt` on `clnt`.`client_id` = `tkt`.`client_id` 
            left join `npoly_projects` as `pro` on `pro`.`project_id` = `tkt`.`project_id` 
            left join `npoly_task_report` as `tskr` on `tskr`.`ticket_id` = `tkt`.`id` 
            left join `npoly_support_modules` as `tm` on `tm`.`module_id` = `tkt`.`module_id` 
            where `tkt`.`employee_id` = $empId
            or tkt.created_by = $userId
            and tkt.active_status = 1
            $condition
             order by `tkt`.`id` desc");
        }else if(Auth::user()->is_admin == '1'){
            $today = date('Y-m-d');
            $fordwardInfo = DB::selectOne("select start_date, end_date from npoly_ticket_fordward where  active_status= 1 and end_date > '$today'");
            
            $results = DB::table('npoly_tickets as tkt')
            ->leftJoin('sa_lookup_data as lkp', 'tkt.priority_id', '=', 'lkp.LOOKUP_DATA_ID')
            ->leftJoin('sa_lookup_data as lkp1', 'tkt.ticket_status', '=', 'lkp1.LOOKUP_DATA_ID')
            ->leftJoin('npoly_clients as clnt', 'clnt.client_id', '=', 'tkt.client_id')
            ->leftJoin('npoly_projects as pro', 'pro.project_id', '=', 'tkt.project_id')
            ->leftJoin('npoly_task_report as tskr', 'tskr.ticket_id', '=', 'tkt.id')
            ->leftJoin('npoly_support_modules as tm', 'tm.module_id', '=', 'tkt.module_id')
            ->select('tkt.*','lkp.LOOKUP_DATA_NAME as priorityName','clnt.client_name','pro.project_name','tskr.employee_id','tskr.fordward_employee','tskr.created_at','tskr.forecast_date','tskr.task_complete','lkp1.LOOKUP_DATA_NAME as ticketStatus','tm.module_name')
            ->where('tkt.ticket_status','!=',230)
            ->where('tkt.active_status',1)
            ->orderBy('tkt.id','desc')
            ->get();
        }else{
            $today = date('Y-m-d');
            $fordwardInfo = DB::selectOne("select start_date, end_date from npoly_ticket_fordward where  active_status= 1 and end_date > '$today'");
            
            $results = DB::table('npoly_tickets as tkt')
            ->leftJoin('sa_lookup_data as lkp', 'tkt.priority_id', '=', 'lkp.LOOKUP_DATA_ID')
            ->leftJoin('sa_lookup_data as lkp1', 'tkt.ticket_status', '=', 'lkp1.LOOKUP_DATA_ID')
            ->leftJoin('npoly_clients as clnt', 'clnt.client_id', '=', 'tkt.client_id')
            ->leftJoin('npoly_projects as pro', 'pro.project_id', '=', 'tkt.project_id')
            ->leftJoin('npoly_task_report as tskr', 'tskr.ticket_id', '=', 'tkt.id')
            ->leftJoin('npoly_support_modules as tm', 'tm.module_id', '=', 'tkt.module_id')
            ->select('tkt.*','lkp.LOOKUP_DATA_NAME as priorityName','clnt.client_name','pro.project_name','tskr.employee_id','tskr.fordward_employee','tskr.created_at','tskr.forecast_date','tskr.task_complete','lkp1.LOOKUP_DATA_NAME as ticketStatus','tm.module_name')
            ->where('tkt.department_id',Auth::user()->department_id)
            ->where('tkt.ticket_status','!=',230)
            ->where('tkt.active_status',1)
            ->orderBy('tkt.id','desc')
            ->get();
        }

        $ticketStatus = DB::table('sa_lookup_data as s')
        ->where('s.LOOKUP_GRP_ID', 38)
        ->select('s.LOOKUP_DATA_ID','s.LOOKUP_DATA_NAME')
        ->where('s.ACTIVE_FLAG', 1)
        //->where('s.LOOKUP_DATA_ID', '!=','234')
        ->get();

        return view('support.index',compact('header','results','fordwardInfo','ticketStatus'));
    }
    public function deptTicket()
    {
        $header = array(
            'pageTitle' => 'Ticket',
            'tableTitle' => ''

        );
            
        $results = DB::table('npoly_tickets as tkt')
        ->leftJoin('sa_lookup_data as lkp', 'tkt.priority_id', '=', 'lkp.LOOKUP_DATA_ID')
        ->leftJoin('sa_lookup_data as lkp1', 'tkt.ticket_status', '=', 'lkp1.LOOKUP_DATA_ID')
        ->leftJoin('npoly_clients as clnt', 'clnt.client_id', '=', 'tkt.client_id')
        ->leftJoin('npoly_projects as pro', 'pro.project_id', '=', 'tkt.project_id')
        ->leftJoin('npoly_task_report as tskr', 'tskr.ticket_id', '=', 'tkt.id')
        ->leftJoin('npoly_support_modules as tm', 'tm.module_id', '=', 'tkt.module_id')
        ->select('tkt.*','lkp.LOOKUP_DATA_NAME as priorityName','clnt.client_name','pro.project_name','tskr.employee_id','tskr.fordward_employee','tskr.created_at','tskr.forecast_date','tskr.task_complete','lkp1.LOOKUP_DATA_NAME as ticketStatus','tm.module_name')
        ->where('tkt.department_id',Auth::user()->department_id)
        ->where('tkt.ticket_status','!=',230)
        ->orderBy('tkt.id','desc')
        ->get();
        

        $ticketStatus = DB::table('sa_lookup_data as s')
        ->where('s.LOOKUP_GRP_ID', 38)
        ->select('s.LOOKUP_DATA_ID','s.LOOKUP_DATA_NAME')
        ->where('s.ACTIVE_FLAG', 1)
        //->where('s.LOOKUP_DATA_ID', '!=','234')
        ->get();

        return view('support.deptIndex',compact('header','results','ticketStatus'));
    }
    /**
     * Create class routine form
     * @param None
     *
     */
    public function serachDateWiseTicket(Request $request){
        $supportUser = Auth::user()->support_user_id;

        $fromDate = $request->fromDate? date('Y-m-d',strtotime($request->fromDate)):"";
        $toDate =   $request->toDate? date('Y-m-d',strtotime($request->toDate)):"";
       
        $statusId =   $request->statusId;

        $condition = '';
        if(!empty($statusId)){
            $condition .= " and tkt.ticket_status ='$statusId' ";
        }

        if($supportUser !='0'){
            $fordwardInfo = [];
            $userId = Auth::user()->id;
            $results= DB::select("select `tkt`.*, `lkp`.`LOOKUP_DATA_NAME` as `priorityName`, `clnt`.`client_name`, `pro`.`project_name`, `tskr`.`employee_id`,`tskr`.`fordward_employee`,`tskr`.`task_complete`,`tskr`.`created_at`, `tskr`.`forecast_date`, `lkp1`.`LOOKUP_DATA_NAME` as `ticketStatus`, `tm`.`module_name` 
            from `npoly_tickets` as `tkt` 
            left join `sa_lookup_data` as `lkp` on `tkt`.`priority_id` = `lkp`.`LOOKUP_DATA_ID` 
            left join `sa_lookup_data` as `lkp1` on `tkt`.`ticket_status` = `lkp1`.`LOOKUP_DATA_ID` 
            left join `npoly_clients` as `clnt` on `clnt`.`client_id` = `tkt`.`client_id` 
            left join `npoly_projects` as `pro` on `pro`.`project_id` = `tkt`.`project_id` 
            left join `npoly_task_report` as `tskr` on `tskr`.`ticket_id` = `tkt`.`id` 
            left join `npoly_support_modules` as `tm` on `tm`.`module_id` = `tkt`.`module_id` 
            where `tkt`.`created_by` = $userId
            and `ticket_create_date` between '$fromDate' and '$toDate'
            $condition
             order by `tkt`.`id` desc");
        }else if(Auth::user()->USERLVL_ID =='7') {
            $fordwardInfo = [];
            $empId = Auth::user()->employee_id;
            $userId = Auth::user()->id;
            $results= DB::select("select `tkt`.*, `lkp`.`LOOKUP_DATA_NAME` as `priorityName`, `clnt`.`client_name`, `pro`.`project_name`, `tskr`.`employee_id`,`tskr`.`fordward_employee`,`tskr`.`task_complete`,`tskr`.`created_at`, `tskr`.`forecast_date`, `lkp1`.`LOOKUP_DATA_NAME` as `ticketStatus`, `tm`.`module_name` 
            from `npoly_tickets` as `tkt` 
            left join `sa_lookup_data` as `lkp` on `tkt`.`priority_id` = `lkp`.`LOOKUP_DATA_ID` 
            left join `sa_lookup_data` as `lkp1` on `tkt`.`ticket_status` = `lkp1`.`LOOKUP_DATA_ID` 
            left join `npoly_clients` as `clnt` on `clnt`.`client_id` = `tkt`.`client_id` 
            left join `npoly_projects` as `pro` on `pro`.`project_id` = `tkt`.`project_id` 
            left join `npoly_task_report` as `tskr` on `tskr`.`ticket_id` = `tkt`.`id` 
            left join `npoly_support_modules` as `tm` on `tm`.`module_id` = `tkt`.`module_id` 
            where `ticket_create_date` between '$fromDate' and '$toDate'
            and `tkt`.`employee_id` = $empId
            or tkt.created_by = $userId
            $condition
             order by `tkt`.`id` desc");
        }else if(Auth::user()->is_admin=='1'){
            $fromDate = $request->fromDate? date('Y-m-d',strtotime($request->fromDate)):"";
            $toDate =   $request->toDate? date('Y-m-d',strtotime($request->toDate)):"";
           
            $today = date('Y-m-d');
            $fordwardInfo = DB::selectOne("select start_date, end_date from npoly_ticket_fordward where  active_status= 1 and end_date > '$today'");
            $results= DB::select("select `tkt`.*, `lkp`.`LOOKUP_DATA_NAME` as `priorityName`, `clnt`.`client_name`, `pro`.`project_name`, `tskr`.`employee_id`,`tskr`.`fordward_employee`,`tskr`.`task_complete`,`tskr`.`created_at`, `tskr`.`forecast_date`, `lkp1`.`LOOKUP_DATA_NAME` as `ticketStatus`, `tm`.`module_name` 
            from `npoly_tickets` as `tkt` 
            left join `sa_lookup_data` as `lkp` on `tkt`.`priority_id` = `lkp`.`LOOKUP_DATA_ID` 
            left join `sa_lookup_data` as `lkp1` on `tkt`.`ticket_status` = `lkp1`.`LOOKUP_DATA_ID` 
            left join `npoly_clients` as `clnt` on `clnt`.`client_id` = `tkt`.`client_id` 
            left join `npoly_projects` as `pro` on `pro`.`project_id` = `tkt`.`project_id` 
            left join `npoly_task_report` as `tskr` on `tskr`.`ticket_id` = `tkt`.`id` 
            left join `npoly_support_modules` as `tm` on `tm`.`module_id` = `tkt`.`module_id` 
            where `ticket_create_date` between '$fromDate' and '$toDate'
            $condition
             order by `tkt`.`id` desc"); 
        }
        else{
            
             $fromDate = $request->fromDate? date('Y-m-d',strtotime($request->fromDate)):"";
            $toDate =   $request->toDate? date('Y-m-d',strtotime($request->toDate)):"";

            $deptId = Auth::user()->department_id;
           
            $today = date('Y-m-d');
            $fordwardInfo = DB::selectOne("select start_date, end_date from npoly_ticket_fordward where  active_status= 1 and end_date > '$today'");
            $results= DB::select("select `tkt`.*, `lkp`.`LOOKUP_DATA_NAME` as `priorityName`, `clnt`.`client_name`, `pro`.`project_name`, `tskr`.`employee_id`,`tskr`.`fordward_employee`,`tskr`.`task_complete`,`tskr`.`created_at`, `tskr`.`forecast_date`, `lkp1`.`LOOKUP_DATA_NAME` as `ticketStatus`, `tm`.`module_name` 
            from `npoly_tickets` as `tkt` 
            left join `sa_lookup_data` as `lkp` on `tkt`.`priority_id` = `lkp`.`LOOKUP_DATA_ID` 
            left join `sa_lookup_data` as `lkp1` on `tkt`.`ticket_status` = `lkp1`.`LOOKUP_DATA_ID` 
            left join `npoly_clients` as `clnt` on `clnt`.`client_id` = `tkt`.`client_id` 
            left join `npoly_projects` as `pro` on `pro`.`project_id` = `tkt`.`project_id` 
            left join `npoly_task_report` as `tskr` on `tskr`.`ticket_id` = `tkt`.`id` 
            left join `npoly_support_modules` as `tm` on `tm`.`module_id` = `tkt`.`module_id` 
            where `ticket_create_date` between '$fromDate' and '$toDate'
            and tkt.department_id = $deptId
            $condition
             order by `tkt`.`id` desc"); 
        }

        return view('support.serachTicketInfo',compact('results','fordwardInfo'));

    }
    public function create()
    {
        $header = array(
            'pageTitle' => 'Ticket',
            'tableTitle' => 'Ticket List'

        );

        $clients = DB::table('npoly_clients')
            ->select('*')
            ->where('active_status',1)
            ->orderBy('client_id','desc')
            ->get();

        $projects = DB::table('npoly_projects')
            ->select('project_id','project_name')
            ->where('active_status',1)
            ->orderBy('project_id','desc')
            ->get();



        $requestType = DB::table('sa_lookup_data as s')
        ->where('s.LOOKUP_GRP_ID', 35)
        ->select('s.LOOKUP_DATA_ID','s.LOOKUP_DATA_NAME')
        ->where('s.ACTIVE_FLAG', 1)
        ->get();

        $priority = DB::table('sa_lookup_data as s')
            ->where('s.LOOKUP_GRP_ID', 36)
            ->select('s.LOOKUP_DATA_ID','s.LOOKUP_DATA_NAME')
            ->where('s.ACTIVE_FLAG', 1)
            ->get();

        $requestMode = DB::table('sa_lookup_data as s')
            ->where('s.LOOKUP_GRP_ID', 37)
            ->select('s.LOOKUP_DATA_ID','s.LOOKUP_DATA_NAME')
            ->where('s.ACTIVE_FLAG', 1)
            ->get();

        $problemList = DB::table('sa_lookup_data as s')
            ->where('s.LOOKUP_GRP_ID', 39)
            ->select('s.LOOKUP_DATA_ID','s.LOOKUP_DATA_NAME')
            ->where('s.ACTIVE_FLAG', 1)
            ->get();

        $employees = DB::table('npoly_employees')
            ->select('employee_id','employee_name')
            ->where('active_status', 1)
            ->where('employee_id','!=',15)
            ->orderBy('user_serial_no')
            ->get();
    
        // $department = DB::table('sa_lookup_data as s')
        //     ->where('s.LOOKUP_GRP_ID', 5)
        //     ->select('s.LOOKUP_DATA_ID','s.LOOKUP_DATA_NAME')
        //     ->where('s.ACTIVE_FLAG', 1)
        //     ->get();

        $department = DB::table('set_department')
        ->select('id as department_id','department_name')
        ->where('active_status', 1)
        ->get();

        return view('support.create', compact('header',  'requestType', 'priority', 'requestMode','clients','problemList','projects','employees','department'));
    }

    /* save class routine
     * @param Request $request
     *
     */
    public function store(Request $request)
    {
        
        $returnId =  TicketModel::createTicket($request);

        // ticket mail send start here
        $results = DB::table('npoly_tickets as tkt')
            //->leftJoin('npoly_clients as clnt','tkt.client_id','clnt.client_id')
            ->leftJoin('npoly_projects as pro','tkt.project_id','pro.project_id')
            ->leftJoin('npoly_support_modules as mod','tkt.module_id','mod.module_id')
            ->leftJoin('sa_lookup_data as lkp','tkt.priority_id','lkp.LOOKUP_DATA_ID')
            ->leftJoin('sa_lookup_data as lkp1','tkt.ticket_status','lkp1.LOOKUP_DATA_ID')
            ->leftJoin('sa_lookup_data as lkp2','tkt.issue_type_id','lkp2.LOOKUP_DATA_ID')
            ->leftJoin('sa_lookup_data as lkp3','tkt.request_type_id','lkp3.LOOKUP_DATA_ID')
            ->leftJoin('sa_lookup_data as lkp4','tkt.request_mode_id','lkp4.LOOKUP_DATA_ID')
            ->select('tkt.*','pro.project_name','mod.module_name','lkp.LOOKUP_DATA_NAME as priority_name','lkp1.LOOKUP_DATA_NAME as ticket_status','lkp2.LOOKUP_DATA_NAME as issue_type','lkp3.LOOKUP_DATA_NAME as request_type','lkp4.LOOKUP_DATA_NAME as request_mode')
            ->where('id',$returnId)
            ->first();
        // mail config start here
        $contactPerson = $results->contact_person;
        if(!empty($contactPerson)){
            $contactPesonEmail = DB::table('npoly_employees')->select('employee_name','email')->where('employee_id',$contactPerson)->first();
        }
       
        $userId = Auth::user()->id;
        $supportUserMail = DB::table('users')->select('email_address','name','pbx_no')->where('id',$userId)->first();
        $aFileName = $_FILES['ticket_attachment']['name'];
        $aFile=$aFileName[0];
        $data['results']= $results ;
        $data['ticket_id']= $returnId ;
        $data['title'] = 'Support Ticket';
        $data['form_email'] = 'ticket@nationalpolymer.net';
        
        $data['form_name'] = 'Support User'.'('.$results->ticket_no.')';
        $data['to_name'] = 'Npoly Group';
        $data['to_email'] = 'mir.mh@nationalpolymer.net';
        $data['support_user_mail'] = $supportUserMail->email_address;
        $data['user_name'] = $supportUserMail->name;
        $data['pbx_no'] = $supportUserMail->pbx_no;
        // Requester Info
        $data['created_by'] = Auth::user()->name;
        $data['created_at'] = $results->created_at;
        $data['req_email'] = Auth::user()->email_address;
        $data['contact_no'] = Auth::user()->contact_no;
        $data['request_type'] = $results->request_type;
        $data['request_mode'] = $results->request_mode;
        $data['department_name'] = Auth::user()->department_name;
        $designationId = Auth::user()->designation ? Auth::user()->designation:'0';
        $desigName = DB::table('set_designation')->select('designation_name')->where('id',$designationId)->first();
       
        $data['designation_name'] = $desigName !="" ? $desigName->designation_name:"";

        if($aFile== ''){
            $sent = Mail::send('emails.ticket_mail', $data, function ($m) use ($data) {
                $m->from($data['form_email'], $data['form_name']);
                //$m->to($data['to_email'], $data['to_name']);
                 $m->to(['azam.ali@nationalpolymer.net']);
                $m->subject($data['title']);
            });
        }else{

            $sent = Mail::send('emails.ticket_mail', $data, function ($m) use ($data) {
                $m->from($data['form_email'], $data['form_name']);
                //$m->to($data['to_email'], $data['to_name']);
                $m->to(['azam.ali@nationalpolymer.net']);
                //$m->cc(['azamalibd808@gmail.com','ishtiaq.ahmed@nationalpolymer.net']);
                $m->subject($data['title']);
                $size = sizeOf($_FILES['ticket_attachment']['name']);
                for ($i=0; $i < $size; $i++) {
                    //$m->attach("UPLOADS/ATTACHMENT/".$_FILES['ticket_attachment']['name'][$i]);
                    $m->attach("public/uploads/ticket_image/".$data['ticket_id'].'-'.$_FILES['ticket_attachment']['name'][$i]);
                }
            });
        }
         // Generate Mail For Support User
         $sent = Mail::send('emails.support_user_mail', $data, function ($m) use ($data) {
            $m->from($data['form_email'], $data['form_name']);
            $m->to($data['support_user_mail']);
            //$m->to(['azam.ali@nationalpolymer.net']);
            $m->subject($data['title']);
        });
        // ticket mail send end here


        Session::flash('success', 'Data Saved successfully!');
        return redirect()->route('ticketIndex');
    }

    /* class routine update page
     * @param $id
     *
     */
    public function edit($id)
    {
        $header = array(
            'pageTitle' => 'Ticket',
            'tableTitle' => 'Ticket List'

        );

        $department = DB::table('sa_lookup_data as s')
            ->where('s.LOOKUP_GRP_ID', 5)
            ->select('s.LOOKUP_DATA_ID','s.LOOKUP_DATA_NAME')
            ->where('s.ACTIVE_FLAG', 1)
            ->get();

        $employee = DB::table('npoly_employees')
            ->select('employee_id','employee_name')
            ->where('active_status',1)
            ->get();


        //$result = TicketModel::find($id);
        $result = DB::table('npoly_tickets as tkt')
            ->leftJoin('npoly_clients as clnt','tkt.client_id','clnt.client_id')
            ->leftJoin('npoly_projects as pro','tkt.project_id','pro.project_id')
            ->select('tkt.*','clnt.client_name','pro.project_name')
            ->where('id',$id)
            ->first();


        return view('support.update', compact('header', 'result','department','employee'));

    }
    public function editDeptTicket($id)
    {
        $header = array(
            'pageTitle' => 'Ticket',
            'tableTitle' => 'Ticket List'

        );

        $department = DB::table('set_department')
            ->select('id as department_id','department_name')
            ->where('active_status', 1)
            ->get();

        $employee = DB::table('npoly_employees')
            ->select('employee_id','employee_name')
            ->where('active_status',1)
            ->get();


        //$result = TicketModel::find($id);
        $result = DB::table('npoly_tickets as tkt')
            ->leftJoin('npoly_clients as clnt','tkt.client_id','clnt.client_id')
            ->leftJoin('npoly_projects as pro','tkt.project_id','pro.project_id')
            ->select('tkt.*','clnt.client_name','pro.project_name')
            ->where('id',$id)
            ->first();


        return view('support.updateDeptTicket', compact('header', 'result','department','employee'));

    }
    

    public function ticketInfo(Request $request){
        $ticketId = $request->ticketId;

        if(!empty($ticketId)){
            $result = DB::table('npoly_tickets as tkt')
                ->leftJoin('npoly_clients as clnt','tkt.client_id','clnt.client_id')
                ->leftJoin('npoly_projects as pro','tkt.project_id','pro.project_id')
                ->select('tkt.*','clnt.client_name','pro.project_name')
                ->where('id',$ticketId)
                ->first();

            return view('support.ticket_basic_info', compact('result'));
        }
    }
    public function getTicketAssignInfo(Request $request){
        $ticketId = $request->ticketId;

        if(!empty($ticketId)){
            $result = DB::table('npoly_tickets as tkt')
                ->leftJoin('npoly_clients as clnt','tkt.client_id','clnt.client_id')
                ->leftJoin('npoly_task_report as tr','tkt.id','tr.ticket_id')
                ->leftJoin('npoly_projects as pro','tkt.project_id','pro.project_id')
                ->select('tkt.*','clnt.client_name','pro.project_name','tr.employee_id','tr.assign_date','tr.forecast_date','tr.work_station')
                ->where('id',$ticketId)
                ->first();

            return view('support.ticket_assign_info', compact('result'));
        }
    }
    public function getTicketStatus(Request $request){
        $ticketId = $request->ticketId;

        if(!empty($ticketId)){
            $result = DB::table('npoly_tickets as tkt')
                ->leftJoin('sa_lookup_data as lkp', 'tkt.priority_id', '=', 'lkp.LOOKUP_DATA_ID')
                ->leftJoin('sa_lookup_data as lkp1', 'tkt.request_type_id', '=', 'lkp1.LOOKUP_DATA_ID')
                ->leftJoin('sa_lookup_data as lkp2', 'tkt.request_mode_id', '=', 'lkp2.LOOKUP_DATA_ID')
                ->leftJoin('sa_lookup_data as lkp3', 'tkt.ticket_status', '=', 'lkp3.LOOKUP_DATA_ID')
                ->select('tkt.*','lkp.LOOKUP_DATA_NAME as priorityName','lkp1.LOOKUP_DATA_NAME as requestType','lkp2.LOOKUP_DATA_NAME as requestMode','lkp3.LOOKUP_DATA_NAME as ticketStatus')
                ->orderBy('tkt.id','desc')
                ->where('id',$ticketId)
                ->first();


            return view('support.ticket_status_info', compact('result'));
        }
    }

    /* class routine update action
     * @param $request
     *
     */
    public function update(Request $request)
    {
        TicketModel::updateTaskAssign($request);
        Session::flash('success', 'Data Updated successfully!');
        return redirect()->route('ticketIndex');
    }
    public function updateBasicInfo(Request $request)
    {
        TicketModel::updateBasicInfo($request);
        Session::flash('success', 'Data Updated successfully!');
        return redirect()->route('ticketIndex');
    }
    public function updateTicketForwardDeptInfo(Request $request)
    {
        TicketModel::updateTicketForwardDeptInfo($request);
        Session::flash('success', 'Data Updated successfully!');
        return redirect()->route('ticketIndex');
    }
    public function updateStatusInfo(Request $request)
    {
        TicketModel::updateStatusInfo($request);
        $results = DB::table('npoly_tickets as tkt')
            //->leftJoin('npoly_clients as clnt','tkt.client_id','clnt.client_id')
            ->leftJoin('npoly_projects as pro','tkt.project_id','pro.project_id')
            ->leftJoin('npoly_support_modules as mod','tkt.module_id','mod.module_id')
            ->leftJoin('sa_lookup_data as lkp','tkt.priority_id','lkp.LOOKUP_DATA_ID')
            ->leftJoin('sa_lookup_data as lkp1','tkt.ticket_status','lkp1.LOOKUP_DATA_ID')
            ->leftJoin('sa_lookup_data as lkp2','tkt.issue_type_id','lkp2.LOOKUP_DATA_ID')
            ->leftJoin('sa_lookup_data as lkp3','tkt.request_type_id','lkp3.LOOKUP_DATA_ID')
            ->leftJoin('sa_lookup_data as lkp4','tkt.request_mode_id','lkp4.LOOKUP_DATA_ID')
            ->select('tkt.*','pro.project_name','mod.module_name','lkp.LOOKUP_DATA_NAME as priority_name','lkp1.LOOKUP_DATA_NAME as ticket_status','lkp2.LOOKUP_DATA_NAME as issue_type','lkp3.LOOKUP_DATA_NAME as request_type','lkp4.LOOKUP_DATA_NAME as request_mode')
            ->where('id',$request->ticket_id)
            ->first();

        $deptHeadMail = DB::table('users')->select('email_address')->where('department_id',$results->department_id)->where('is_dept_head',1)->first();

        $data['results']= $results ;
        $data['ticket_id']= $request->ticket_id;
        $data['title'] = 'Ticket Status';
        $data['form_email'] = 'ticket@nationalpolymer.net';
        //$data['to_email'] = 'azam.ali@nationalpolymer.net';
        $data['to_email'] = 'mir.mh@nationalpolymer.net';
        $data['form_name'] = 'Support User'.'('.$results->ticket_no.')';
        $data['to_name'] = 'Npoly Group';

        // Requester Info
        $requesterInfo = DB::table("users as urs")
        ->leftJoin('set_designation as desig','urs.designation','desig.id')
        ->leftJoin('set_department as dept','urs.department_id','dept.id')
        ->select('urs.name','urs.email_address','urs.contact_no','urs.pbx_no','desig.designation_name','dept.department_name')
        ->where('urs.id','=',$results->created_by)
        ->first();
        $data['created_by'] = $requesterInfo->name;
        $data['created_at'] = $results->created_at;
        $data['req_email'] = $requesterInfo->email_address;
        $data['pbx_no'] = $requesterInfo->pbx_no;
        $data['contact_no'] = $requesterInfo->contact_no;
        $data['request_type'] = $results->request_type;
        $data['request_mode'] = $results->request_mode;

        $data['mail_to'] = Auth::user()->support_user_id > 0 ? $deptHeadMail->email_address:  $requesterInfo->email_address;
        $data['mail_cc'] = Auth::user()->support_user_id > 0 ?  [$requesterInfo->email_address]  : [$deptHeadMail->email_address];
       
        $data['designation_name'] = $requesterInfo->designation_name;
        $data['department_name'] = $requesterInfo->department_name;

        $sent = Mail::send('emails.ticket_mail', $data, function ($email) use ($data) {
            $email->subject($data['title']);
            $email->from('ticket@nationalpolymer.net','Npoly Ticket');
            $email->to( $data['mail_to']);
            //$email->to(['azam.ali@nationalpolymer.net']);
            $email->cc( $data['mail_cc']);
           // $m->cc(['mir.mh@nationalpolymer.net','azam.ali@nationalpolymer.net']);
            //$email->bcc('azam.ali@nationalpolymer.net');
        });
        Session::flash('success', 'Data Updated successfully!');
        return redirect()->route('ticketIndex');
    }
    public function updateAssignInfo(Request $request)
    {
        TicketModel::updateAssignInfo($request);
        // mail send after assign ticket
        $results = DB::table('npoly_tickets as tkt')
            //->leftJoin('npoly_clients as clnt','tkt.client_id','clnt.client_id')
            ->leftJoin('npoly_projects as pro','tkt.project_id','pro.project_id')
            ->leftJoin('npoly_support_modules as mod','tkt.module_id','mod.module_id')
            ->leftJoin('sa_lookup_data as lkp','tkt.priority_id','lkp.LOOKUP_DATA_ID')
            ->leftJoin('sa_lookup_data as lkp1','tkt.ticket_status','lkp1.LOOKUP_DATA_ID')
            ->leftJoin('sa_lookup_data as lkp2','tkt.issue_type_id','lkp2.LOOKUP_DATA_ID')
            ->leftJoin('sa_lookup_data as lkp3','tkt.request_type_id','lkp3.LOOKUP_DATA_ID')
            ->leftJoin('sa_lookup_data as lkp4','tkt.request_mode_id','lkp4.LOOKUP_DATA_ID')
            ->leftJoin('npoly_employees as emp','tkt.employee_id','emp.employee_id')
            ->select('tkt.*','pro.project_name','mod.module_name','lkp.LOOKUP_DATA_NAME as priority_name','lkp1.LOOKUP_DATA_NAME as ticket_status','lkp2.LOOKUP_DATA_NAME as issue_type','lkp3.LOOKUP_DATA_NAME as request_type','lkp4.LOOKUP_DATA_NAME as request_mode','emp.office_email')
            ->where('id',$request->ticket_id)
            ->first();

        $data['results']= $results ;
        $data['ticket_id']= $request->ticket_id;
        $data['title'] = 'Pending Ticket';
        $data['form_email'] = 'ticket@nationalpolymer.net';
        //$data['to_email'] = 'azam.ali@nationalpolymer.net';
        $data['to_email'] = $results->office_email;
        $data['form_name'] = 'Support User'.'('.$results->ticket_no.')';
        $data['to_name'] = 'Npoly Group';

        // $requesterInfo = DB::table("users as urs")
        // ->leftJoin('sa_lookup_data as lkp','urs.designation','lkp.LOOKUP_DATA_ID')
        // ->select('urs.name','urs.email_address','urs.contact_no','urs.pbx_no','lkp.LOOKUP_DATA_NAME as designation_name')
        // ->where('id','=',$results->created_by)
        // ->first();
        $requesterInfo = DB::table('users')->select('*')->where('id',$results->created_by)->first();
        $data['created_by'] = $requesterInfo->name;
        $data['created_at'] = $results->created_at;
        $data['req_email'] = $requesterInfo->email_address;
        $data['contact_no'] = $requesterInfo->contact_no;
        $data['request_type'] = $results->request_type;
        $data['request_mode'] = $results->request_mode;
        $data['pbx_no'] = $requesterInfo->pbx_no;
       
        $data['department_name'] = $requesterInfo->department_name ? $requesterInfo->department_name:"";
        $data['designation_name'] = $requesterInfo->designation_name ? $requesterInfo->designation_name :"";
        
        
        $sent = Mail::send('emails.ticket_mail', $data, function ($m) use ($data) {
            $m->from($data['form_email'], $data['form_name']);
            //$m->to(['azam.ali@nationalpolymer.net']);
            $m->to($data['to_email']);
            //$m->cc(['mir.mh@nationalpolymer.net',$data['req_email']]);
            $m->subject($data['title']);
        });
        Session::flash('success', 'Data Updated successfully!');
        return redirect()->route('ticketIndex');
    }
    public function updateTicketReAssignInfo(Request $request)
    {
        TicketModel::updateReAssignInfo($request);
        // mail send after assign ticket
        $results = DB::table('npoly_tickets as tkt')
            //->leftJoin('npoly_clients as clnt','tkt.client_id','clnt.client_id')
            ->leftJoin('npoly_projects as pro','tkt.project_id','pro.project_id')
            ->leftJoin('npoly_support_modules as mod','tkt.module_id','mod.module_id')
            ->leftJoin('sa_lookup_data as lkp','tkt.priority_id','lkp.LOOKUP_DATA_ID')
            ->leftJoin('sa_lookup_data as lkp1','tkt.ticket_status','lkp1.LOOKUP_DATA_ID')
            ->leftJoin('sa_lookup_data as lkp2','tkt.issue_type_id','lkp2.LOOKUP_DATA_ID')
            ->leftJoin('sa_lookup_data as lkp3','tkt.request_type_id','lkp3.LOOKUP_DATA_ID')
            ->leftJoin('sa_lookup_data as lkp4','tkt.request_mode_id','lkp4.LOOKUP_DATA_ID')
            ->leftJoin('npoly_employees as emp','tkt.employee_id','emp.employee_id')
            ->select('tkt.*','pro.project_name','mod.module_name','lkp.LOOKUP_DATA_NAME as priority_name','lkp1.LOOKUP_DATA_NAME as ticket_status','lkp2.LOOKUP_DATA_NAME as issue_type','lkp3.LOOKUP_DATA_NAME as request_type','lkp4.LOOKUP_DATA_NAME as request_mode','emp.office_email')
            ->where('id',$request->ticket_id)
            ->first();

        $data['results']= $results ;
        $data['ticket_id']= $request->ticket_id;
        $data['title'] = 'Pending Ticket';
        $data['form_email'] = 'ticket@nationalpolymer.net';
        $data['to_email'] =$results->office_email;
        $data['form_name'] = 'Support User'.'('.$results->ticket_no.')';
        $data['to_name'] = 'Npoly Group';

        // Requester Info
        $requesterInfo = DB::table("users as urs")
        ->leftJoin('set_designation as desig','urs.designation','desig.id')
        ->leftJoin('set_department as dept','urs.department_id','dept.id')
        ->select('urs.name','urs.email_address','urs.contact_no','urs.pbx_no','desig.designation_name','dept.department_name')
        ->where('urs.id','=',$results->created_by)
        ->first();

        $data['created_by'] = $requesterInfo->name;
        $data['created_at'] = $results->created_at;
        $data['req_email'] = $requesterInfo->email_address;
        $data['pbx_no'] = $requesterInfo->pbx_no;
        $data['contact_no'] = $requesterInfo->contact_no;
        $data['request_type'] = $results->request_type;
        $data['request_mode'] = $results->request_mode;
       
        $data['designation_name'] = $requesterInfo->designation_name;
        $ccToMail = array('hrnpil@nationalpolymer.net','mir.mh@nationalpolymer.net',$requesterInfo->email_address);

        $sent = Mail::send('emails.ticket_mail', $data, function ($email) use ($data) {
            $email->subject($data['title']);
            $email->from('ticket@nationalpolymer.net','Npoly Ticket');
            $email->to($data['to_email']);
            $email->cc([$data['req_email']]);
            //$email->cc(['azam.ali@nationalpolymer.net',$data['req_email']]);
           // $email->cc($ccToMail);
            //$email->bcc('azam.ali@nationalpolymer.net');
        });
        Session::flash('success', 'Data Updated successfully!');
        return redirect()->route('ticketIndex');
    }

    /* get day of date
     * @param $date
     *
     */


    public function getPorject($clientId){
      if(!empty($clientId)){
          $projectInfo = DB::table('npoly_projects')
              ->select('project_id','project_name')
              ->where('client_id',$clientId)
              ->where('active_status',1)
              ->get();

          if($projectInfo){
              $pro = '<option value="">--select--</option>';
              foreach($projectInfo as $p){
                  $pro.='<option value="'.$p->project_id.'">'.$p->project_name.'</option>';
              }
              return $pro;
          }

      }
    }
    public function getEmployee($depId){
        if(!empty($depId)){
            $empInfo = DB::table('npoly_employees')
                ->select('employee_id','employee_name')
                ->where('department_id',$depId)
                ->where('active_status',1)
                ->orderBy('user_serial_no')
                ->get();

            if($empInfo){
                $emps = '<option value="">--select--</option>';
                foreach($empInfo as $emp){
                    $emps.='<option value="'.$emp->employee_id.'">'.$emp->employee_name.'</option>';
                }
                return $emps;
            }

        }
    }

    public function getIssueGroup($depId){
        if(!empty($depId)){
            $proInfo = DB::table('npoly_projects')
                ->select('project_id','project_name')
                ->where('department_id',$depId)
                ->where('active_status',1)
                ->orWhere('department_id',0)
                ->orderBy('department_id','desc')
                ->get();
                
                // $additionalProject = (object) ['project_id' => 28, 'project_name' => 'orthers'];
                // $proInfo = $proInfo->toArray();
                // $proInfo[] = $additionalProject;

            if($proInfo){
                $pros = '<option value="">--select--</option>';
                foreach($proInfo as $pro){
                    $pros.='<option value="'.$pro->project_id.'">'.$pro->project_name.'</option>';
                }
                return $pros;
            }

        }
    }

    // Modify Ticket Info
    public  function editTicketInfo(Request $request){
        $ticketId = $request->ticketId;

        if(!empty($ticketId)){
            $ticketInfo = DB::table('npoly_tickets')
                ->select('*')
                ->where('id',$ticketId)
                ->first();
            $clinets = DB::table('npoly_clients')
                ->select('client_id','client_name')
                ->where('active_status',1)
                ->get();

            $projects = DB::table('npoly_projects')
                ->select('project_id','project_name')
                ->where('active_status',1)
                ->get();

            return view('support.edit_ticket_basic_info', compact('ticketInfo','clinets','projects'));


        }
    }
    public  function editTicketForwardInfo(Request $request){
        $ticketId = $request->ticketId;

        if(!empty($ticketId)){
            $ticketInfo = DB::table('npoly_tickets')
                ->select('*')
                ->where('id',$ticketId)
                ->first();

            $department = DB::table('sa_lookup_data as s')
            ->where('s.LOOKUP_GRP_ID', 5)
            ->select('s.LOOKUP_DATA_ID','s.LOOKUP_DATA_NAME')
            ->where('s.ACTIVE_FLAG', 1)
            ->get();


            return view('support.edit_ticket_forward_dept_info', compact('ticketInfo','department'));


        }
    }
    public  function editStatusInfo(Request $request){
        $ticketId = $request->ticketId;

        if(!empty($ticketId)){
            $ticketInfo = DB::table('npoly_tickets')
                ->select('*')
                ->where('id',$ticketId)
                ->first();
            if(Auth::user()->support_user_id ==0){
                $ticketStatus = DB::table('sa_lookup_data as s')
                ->where('s.LOOKUP_GRP_ID', 38)
                ->select('s.LOOKUP_DATA_ID','s.LOOKUP_DATA_NAME')
                ->where('s.ACTIVE_FLAG', 1)
                //->where('s.LOOKUP_DATA_ID', '!=','234')
                ->get();

            } else{
                $ticketStatus = DB::table('sa_lookup_data as s')
                ->where('s.LOOKUP_GRP_ID', 38)
                ->select('s.LOOKUP_DATA_ID','s.LOOKUP_DATA_NAME')
                ->where('s.ACTIVE_FLAG', 1)
                //->where('s.LOOKUP_DATA_ID', '!=','234')
                ->whereIn('s.LOOKUP_DATA_ID', [228,229,230,234])
                ->get();
            }   

            
            $requestType = DB::table('sa_lookup_data as s')
                ->where('s.LOOKUP_GRP_ID', 35)
                ->select('s.LOOKUP_DATA_ID','s.LOOKUP_DATA_NAME')
                ->where('s.ACTIVE_FLAG', 1)
                ->get();

            $priority = DB::table('sa_lookup_data as s')
                ->where('s.LOOKUP_GRP_ID', 36)
                ->select('s.LOOKUP_DATA_ID','s.LOOKUP_DATA_NAME')
                ->where('s.ACTIVE_FLAG', 1)
                ->get();

            $requestMode = DB::table('sa_lookup_data as s')
                ->where('s.LOOKUP_GRP_ID', 37)
                ->select('s.LOOKUP_DATA_ID','s.LOOKUP_DATA_NAME')
                ->where('s.ACTIVE_FLAG', 1)
                ->get();

            return view('support.edit_ticket_status_info', compact('ticketInfo','ticketStatus','requestType','priority','requestMode'));


        }
    }
    public  function editAssignInfo(Request $request){
        $ticketId = $request->ticketId;

        if(!empty($ticketId)){
            $department = DB::table('sa_lookup_data as s')
                ->where('s.LOOKUP_GRP_ID', 5)
                ->select('s.LOOKUP_DATA_ID','s.LOOKUP_DATA_NAME')
                ->where('s.ACTIVE_FLAG', 1)
                ->get();

            $employee = DB::table('npoly_employees')
                ->select('employee_id','employee_name','card_no')
                ->where('active_status',1)
                ->where('department_id',Auth::user()->department_id)
                ->orderBy('user_serial_no')
                ->get();
            
            $result = DB::table('npoly_tickets as tkt')
                ->leftJoin('npoly_clients as clnt','tkt.client_id','clnt.client_id')
                ->leftJoin('npoly_task_report as tr','tkt.id','tr.ticket_id')
                ->leftJoin('npoly_projects as pro','tkt.project_id','pro.project_id')
                ->select('tkt.*','clnt.client_name','pro.project_name','tr.employee_id','tr.assign_date','tr.forecast_date','tr.work_station')
                ->where('id',$ticketId)
                ->first();

            return view('support.edit_ticket_assign_info', compact('department','employee','result'));


        }
    }
    public  function editReAssignInfo(Request $request){
        $ticketId = $request->ticketId;

        if(!empty($ticketId)){
            $department = DB::table('sa_lookup_data as s')
                ->where('s.LOOKUP_GRP_ID', 5)
                ->select('s.LOOKUP_DATA_ID','s.LOOKUP_DATA_NAME')
                ->where('s.ACTIVE_FLAG', 1)
                ->get();

            $employee = DB::table('npoly_employees')
                ->select('employee_id','employee_name')
                ->where('active_status',1)
                ->get();


            //$result = TicketModel::find($id);
            $result = DB::table('npoly_tickets as tkt')
                ->leftJoin('npoly_clients as clnt','tkt.client_id','clnt.client_id')
                ->leftJoin('npoly_task_report as tr','tkt.id','tr.ticket_id')
                ->leftJoin('npoly_projects as pro','tkt.project_id','pro.project_id')
                ->select('tkt.*','clnt.client_name','pro.project_name','tr.employee_id','tr.assign_date','tr.forecast_date','tr.work_station','tr.task_id')
                ->where('id',$ticketId)
                ->first();

            return view('support.edit_ticket_re_assign_info', compact('department','employee','result'));


        }
    }

    public function fordwardTicket(Request $request, $ticketId){
        if($_POST){
            $ticketData = array(
                "assign_permission_emp"=> $request->employee_id,
                "updated_by"          => Auth::user()->employee_id,
                "updated_at"          => date('Y-m-d H:i:s'),
            );
            DB::beginTransaction();
            try {
                DB::table('npoly_tickets')
                    ->where('id', $ticketId)
                    ->update($ticketData);

                DB::commit();
            } catch (\Throwable $e) {
                DB::rollback();
                throw $e;
            }
            Session::flash('success', 'Data Saved successfully!');
            return redirect()->route('ticketIndex');

        }else{
        $employeeId = Auth::user()->employee_id;
        $employeeList = DB::table('npoly_employees')
                        ->select('employee_id','employee_name','card_no')
                        ->where('active_status',1)
                        ->where('department_id',Auth::user()->department_id)
                        ->where('employee_id','!=',$employeeId)
                        ->where('designation_id','!=','258')
                        ->orderBy('user_serial_no','asc')
                        ->get();
        $result = DB::table('npoly_tickets')->select('assign_permission_emp')->where('id',$ticketId)->first();
        

        return view('support.fordward_ticket', compact('employeeList','ticketId','result'));
        }
        

    }

    public function ticketForward(Request $request){
        if($_POST){
           if(!empty($request->fordward_id)){
            $fordwardData = array(
                "employee_id"=> $request->employee_id,
                "start_date"=> date('Y-m-d',strtotime($request->start_date)),
                "end_date"=> date('Y-m-d',strtotime($request->end_date)),
                "updated_by"          => Auth::user()->employee_id,
                "active_status"          => $request->active_status,
                "updated_at"          => date('Y-m-d H:i:s'),
            );
            DB::beginTransaction();
            try {
                DB::table('npoly_ticket_fordward')
                ->where('fordward_id', $request->fordward_id)
                ->update($fordwardData);

                DB::commit();
            } catch (\Throwable $e) {
                DB::rollback();
                throw $e;
            }
            Session::flash('success', 'Data Saved successfully!');
            return redirect()->route('ticketIndex');
           }else{
            $fordwardData = array(
                "employee_id"=> $request->employee_id,
                "start_date"=> date('Y-m-d',strtotime($request->start_date)),
                "end_date"=> date('Y-m-d',strtotime($request->end_date)),
                "active_status"          => $request->active_status,
                "created_by"          => Auth::user()->employee_id,
                "created_at"          => date('Y-m-d H:i:s'),
            );
            DB::beginTransaction();
            try {
                $data = DB::table('npoly_ticket_fordward')->insert($fordwardData);

                DB::commit();
            } catch (\Throwable $e) {
                DB::rollback();
                throw $e;
            }
            Session::flash('success', 'Data Saved successfully!');
            return redirect()->route('ticketIndex');
           }
           

        }else{
        $employeeId = Auth::user()->employee_id;
        $employeeList = DB::table('npoly_employees')
                        ->select('employee_id','employee_name','card_no')
                        ->where('active_status',1)
                        ->where('employee_id','!=',$employeeId)
                        ->where('department_id',Auth::user()->department_id)
                        ->where('designation_id','!=','258')
                        ->orderBy('user_serial_no','asc')
                        ->get();

        $today = date('Y-m-d');               
        $forwardInfo = DB::selectOne("select * from npoly_ticket_fordward where active_status = 1 and end_date > '$today' ");
        //dd($forwardInfo);
        
        

        return view('support.ticket_fordward', compact('employeeList','forwardInfo'));
        }
        

    }

}
