<?php

namespace App\Http\Controllers\support;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Session;
use App\Models\ProjectSetupModel;
use  App\Models\lookup\LookupGroupDataModel;
use DB;
use Auth;

class ProjectSetupController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function index()
    {
        $header = array(
            'pageTitle' => 'Project',
            'tableTitle' => 'Project List'
        );
         /*
        $employeeNumber = DB::table('npoly_employees')->select('employee_number')->where('employee_number','!=',1)->get();
        foreach( $employeeNumber as $empNum){
            $cardNo = DB::connection('oracle')->selectOne("SELECT NVL((SELECT OFFICE_ID 
            FROM SYS.XXNPTICKET_APP_HR_V 
            WHERE ORACLE_ID = '$empNum->employee_number'), 'N/A') AS OFFICE_ID
            FROM dual");
           //dd($cardNo);
           $update = DB::table('npoly_employees')->where('employee_number',$empNum->employee_number)->update([
            "card_no"=> $cardNo->office_id ? $cardNo->office_id: "N/A" 
           ]);
        }
           */
        $results = DB::table('npoly_projects as pro')
            ->leftJoin('set_department as dept', 'dept.id', '=', 'pro.department_id')
            ->select('pro.*','dept.department_name')
            ->orderBy('project_id','desc')
            ->get();

        return view('setup/projects.index',compact('header','results'));
    }
    public function documentIndex(){
        $header = array(
            'pageTitle' => 'Document',
            'tableTitle' => 'Document List'
        );
        return view('setup/document.index',compact('header'));
    }

    /**
     * Create class routine form
     * @param None
     *
     */
    public function create()
    {
        $header = array(
            'pageTitle' => 'Project',
            'tableTitle' => 'Project List'
        );
        //$clients = DB::table('npoly_clients')->select('client_id','client_name')->get();
       
        $departments = DB::table('set_department')
        ->select('id as department_id','department_name')
        ->where('active_status',1)
        ->get();


        return view('setup/projects.create', compact('header','departments'));
    }

    /* save class routine
     * @param Request $request
     *
     */
    public function store(Request $request)
    {
        ProjectSetupModel::createProject($request);
        Session::flash('success', 'Data Saved successfully!');
        return redirect()->route('projectSetupIndex');
    }

    /* class routine update page
     * @param $id
     *
     */
    public function edit($id)
    {
        $header = array(
            'pageTitle' => 'Project',
            'tableTitle' => 'Project List'
        );
   
        $departments = DB::table('set_department')
        ->select('id as department_id','department_name')
        ->where('active_status',1)
        ->get();
        $result = ProjectSetupModel::find($id);
        return view('setup/projects.update', compact('header', 'result','departments'));

    }

    /* class routine update action
     * @param $request
     *
     */
    public function update(Request $request)
    {
        ProjectSetupModel::updateProject($request);
        Session::flash('success', 'Data Updated successfully!');
        return redirect()->route('projectSetupIndex');
    }
  
}
