<?php

namespace App\Http\Controllers\support;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Session;
use App\Models\KpiSetupModel;
use  App\Models\lookup\LookupGroupDataModel;
use DB;
use Auth;

class KpiSetupController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $header = array(
            'pageTitle' => 'KPI',
            'tableTitle' => ''
        );

        $results = DB::table('npoly_kpi as kip')
            ->leftJoin('sa_lookup_data as lkp', 'lkp.LOOKUP_DATA_ID', '=', 'kip.department_id')
            ->select('kip.*','lkp.LOOKUP_DATA_NAME as deptName')
            ->orderBy('kpi_id','desc')
            ->get();

        return view('setup/kpi_setup.index',compact('header','results'));
    }
    public function kpiIApprovendex()
    {
        $header = array(
            'pageTitle' => 'KPI Approval Path',
            'tableTitle' => ''
        );

        $results = DB::table('approval_name as apn')
            ->leftJoin('approval_final as afl', 'apn.id', '=', 'afl.approval_id')
            ->leftJoin('approval_subordinate as sub', 'sub.approval_final_id', '=', 'afl.id')
            ->leftJoin('npoly_employees as emp', 'emp.employee_id', '=', 'afl.approval_final_id')
            ->leftJoin('npoly_employees as emp1', 'emp1.employee_id', '=', 'sub.subordinate_id')
            ->select('apn.*','apn.approval_name as name','afl.approval_final_id','sub.id as sub_ordinate_id','sub.subordinate_id','emp.employee_name as approval_name','emp1.employee_name as subordinate_name')
            ->get();




        return view('setup/kpi_approve.index',compact('header','results'));
    }

    /**
     * Create class routine form
     * @param None
     *
     */
    public function create()
    {
        $header = array(
            'pageTitle' => 'KPI',
            'tableTitle' => ''
        );

        $department = DB::table('sa_lookup_data')
            ->select('LOOKUP_DATA_ID','LOOKUP_DATA_NAME')
            ->where('LOOKUP_GRP_ID',5)
            ->where('ACTIVE_FLAG',1)
            ->get();

        return view('setup/kpi_setup.createKpiAllDept', compact('header','department'));
    }
    public function createApprove()
    {
        $header = array(
            'pageTitle' => 'Approve KPI',
            'tableTitle' => ''
        );

        $department = DB::table('sa_lookup_data')
            ->select('LOOKUP_DATA_ID','LOOKUP_DATA_NAME')
            ->where('LOOKUP_GRP_ID',5)
            ->where('ACTIVE_FLAG',1)
            ->get();

        $employee = DB::table('npoly_employees')
            ->select('employee_id','employee_name')
            ->where('active_status',1)
            ->orderBy('user_serial_no')
            ->get();

        return view('setup/kpi_approve.create', compact('header','department','employee'));
    }
    public function createKpi(Request $request,$deptId)
    {
        $header = array(
            'pageTitle' => 'KPI',
            'tableTitle' => ''
        );
       $countKpiPer = DB::selectOne("SELECT sum(kpi_percentage) as TotalPercentage FROM npoly_kpi WHERE department_id = $deptId");


        $department = DB::table('sa_lookup_data')
            ->select('LOOKUP_DATA_ID','LOOKUP_DATA_NAME')
            ->where('LOOKUP_GRP_ID',5)
            ->where('ACTIVE_FLAG',1)
            ->get();


        return view('setup/kpi_setup.create', compact('header','department','deptId','countKpiPer'));
    }

    /* save class routine
     * @param Request $request
     *
     */
    public function store(Request $request)
    {
        $deptId = $request->departmentId;
        KpiSetupModel::createKpi($request);
        Session::flash('success', 'Data Saved successfully!');
        //return redirect()->route('get_total_kpi_dept_wise/'.$deptId);
        return redirect('get_total_kpi_dept_wise/'.$deptId);
    }
    public function storeAllDept(Request $request)
    {
        $deptId = $request->departmentId;
        KpiSetupModel::createKpi($request);
        Session::flash('success', 'Data Saved successfully!');
        //return redirect()->route('get_total_kpi_dept_wise/'.$deptId);
        return redirect('get_total_kpi_info');
    }
    public function storeKpi(Request $request)
    {
       
        KpiSetupModel::createApproveKpi($request);
        Session::flash('success', 'Data Saved successfully!');
        return redirect()->route('kpiIApprovendex');

    }
    public function updateKpiApprove(Request $request)
    {
        //dd($_POST);exit;
       
        KpiSetupModel::updateKpiApprove($request);
        Session::flash('success', 'Data Update successfully!');
        return redirect()->route('kpiIApprovendex');

    }
     public function updateApproveKpiPath(Request $request, $id)
    {
        $header = array(
            'pageTitle' => 'Approve KPI',
            'tableTitle' => ''
        );

        $department = DB::table('sa_lookup_data')
            ->select('LOOKUP_DATA_ID','LOOKUP_DATA_NAME')
            ->where('LOOKUP_GRP_ID',5)
            ->where('ACTIVE_FLAG',1)
            ->get();

        $employee = DB::table('npoly_employees')
            ->select('employee_id','employee_name')
            ->where('active_status',1)
            ->orderBy('user_serial_no')
            ->get();

        $result = DB::table('approval_name as apn')
            ->leftJoin('approval_final as afl', 'apn.id', '=', 'afl.approval_id')
            ->leftJoin('approval_subordinate as sub', 'sub.approval_final_id', '=', 'afl.id')
            ->leftJoin('npoly_employees as emp', 'emp.employee_id', '=', 'afl.approval_final_id')
            ->leftJoin('npoly_employees as emp1', 'emp1.employee_id', '=', 'sub.subordinate_id')
            ->select('apn.*','apn.approval_name as name','afl.approval_final_id','afl.employee_id as final_approve_emp','sub.employee_id as sub_emp_id','sub.id as sub_ordinate_id','sub.subordinate_id','emp.employee_name as approval_name','emp1.employee_name as subordinate_name')
            ->where('apn.id',$id)
            ->first();

        return view('setup/kpi_approve.update', compact('header','department','employee','result'));
    }
    public function storeKpiAssign(Request $request)
    {
       
        KpiSetupModel::kpiAssignStore($request);
        Session::flash('success', 'Data Saved successfully!');
        //return redirect()->route('kpiIApprovendex');
        return redirect('get_mis_kpi_info/132');

    }

    /* class routine update page
     * @param $id
     *
     */
    public function edit($id)
    {
        $header = array(
            'pageTitle' => 'KPI',
            'tableTitle' => ''
        );
        $department = DB::table('sa_lookup_data')
            ->select('LOOKUP_DATA_ID','LOOKUP_DATA_NAME')
            ->where('LOOKUP_GRP_ID',5)
            ->where('ACTIVE_FLAG',1)
            ->get();
        $result = KpiSetupModel::find($id);
        //dd($result);
        return view('setup/kpi_setup.update', compact('header', 'result','department'));

    }

    /* class routine update action
     * @param $request
     *
     */
    public function update(Request $request)
    {
        $deptId = $request->department_id;
        KpiSetupModel::updateKpi($request);
        Session::flash('success', 'Data Updated successfully!');
        //return redirect()->route('get_mis_kpi_info/'.$deptId);
        return redirect('get_mis_kpi_info/'.$deptId);
    }

    public function kpiAssign($id){
        $header = array(
            'pageTitle' => 'KPI',
            'tableTitle' => ''
        );
        $result = DB::table('npoly_kpi')->select('*')->where('kpi_id',$id)->first();
        if(!empty($result)){
            $employees = DB::table('npoly_employees')
                ->select('employee_id','employee_name')
                ->where('department_id',$result->department_id)
                ->orderBy('user_serial_no')
                ->get();
        }

        return view('kpi.assignKpi', compact('header', 'result','employees','id'));

    }

    public function approveKpiInfo(Request $request, $deptId){
        $userId = $request->userId;
        $year = date('Y');
        if($deptId == '132'){
            $getKpiId = DB::table('npoly_kpi')
                ->select('kpi_id')
                ->whereIn('department_id',[132,262])
                ->where('kip_year',$year)
                ->where('kpi_status',1)
                ->get();

            $deptUserId = DB::table('approval_final')
                ->select('department_id','user_id')
                ->where('department_id',$deptId)
                ->where('user_id',$userId)
                ->first();
            if(!empty($deptUserId)){
                $kdpStatus = array(
                    "kpi_status"=>3
                );
                foreach ($getKpiId as $value){
                    DB::table('npoly_kpi')
                        ->where('kpi_id', $value->kpi_id)
                        ->update($kdpStatus);
                }
            }
        }
        return 1;


    }
    public function approveAllKpiInfo(Request $request){
        $empId = Auth::user()->employee_id;
        $year = date('Y');

            $getKpiId = DB::table('npoly_kpi')
                ->select('kpi_id')
                ->whereIn('department_id',[132,262])
                ->where('kip_year',$year)
                ->where('kpi_status',1)
                ->get();

            $deptUserId = DB::table('approval_final')
                ->select('department_id','user_id')
                ->where('department_id','!=',0)
                ->where('employee_id',$empId)
                ->first();
            if(!empty($deptUserId)){
                $kdpStatus = array(
                    "kpi_status"=>3
                );
                foreach ($getKpiId as $value){
                    DB::table('npoly_kpi')
                        ->where('kpi_id', $value->kpi_id)
                        ->update($kdpStatus);
                }

        }else{

            $approveSub = DB::table('approval_subordinate')->select('employee_id')->where('employee_id',Auth::user()->employee_id)->count();
            $approveInin = DB::table('approval_initiator')->select('user_id')->where('user_id',Auth::user()->employee_id)->count();
            
            if($approveSub > 0 || $approveInin > 0){
                $year = date('Y');
                $getKpiId = DB::table('npoly_kpi')
                ->select('kpi_id')
                ->whereIn('department_id',[132,262])
                ->where('kip_year',$year)
                ->where('kpi_status',1)
                ->get();

                $kdpStatus = array(
                    "kpi_status"=>2
                );
                foreach ($getKpiId as $value){
                    DB::table('npoly_kpi')
                        ->where('kpi_id', $value->kpi_id)
                        ->update($kdpStatus);
                }

            }

        }
        //return 1;
       // return redirect('get_total_kpi_info);


    }

    public function showKpiDetailsInfo($empId){
        $results = DB::select("select kpi.kpi_title,tr.task_complete,kpi.kip_year,kpi.kpi_percentage,kpi.complete_percentage
                                    from npoly_task_report as tr , npoly_kpi as kpi
                                    WHERE tr.kpi_id = kpi.kpi_id
                                    and tr.employee_id = $empId and tr.kpi_id > 0");

      return view('kpi.kpiDetailsInfo',compact('results'));
    }
    public function workingKpiDetailsInfo($empId){
        $results = DB::select("select kpi.kpi_title,tr.task_complete,kpi.kip_year,kpi.kpi_percentage,kpi.complete_percentage
                                    from npoly_task_report as tr , npoly_kpi as kpi
                                    WHERE tr.kpi_id = kpi.kpi_id
                                      AND tr.start_time > 0
                                      and tr.task_complete <100
                                    and tr.employee_id = $empId and tr.kpi_id > 0");

        return view('kpi.kpiDetailsInfo',compact('results'));
    }
    public function pendingKpiDetailsInfo($empId){
        $date = date('Y-m-d');
        $results = DB::select("select kpi.kpi_title,tr.task_complete,kpi.kip_year,kpi.kpi_percentage,kpi.complete_percentage
                                    from npoly_task_report as tr , npoly_kpi as kpi
                                    WHERE tr.kpi_id = kpi.kpi_id
                                      AND tr.start_time = 0
                                      and tr.task_complete =0
                                      and kpi.kpi_expire_date < '$date'
                                    and tr.employee_id = $empId and tr.kpi_id > 0");

        return view('kpi.kpiDetailsInfo',compact('results'));
    }
    public function expireKpiDetailsInfo($empId){
        $kpiIds = DB::selectOne("SELECT employee_id kpi_id, GROUP_CONCAT(kpi_id SEPARATOR ', ') AS kpi_id
                                                                                        FROM npoly_task_report
                                                                                        WHERE kpi_id > 0
                                                                                        AND employee_id = $empId
                                                                                        and task_complete < 100
                                                                                        GROUP BY employee_id;");
        if(!empty($kpiIds->kpi_id)){
            $date = date('Y-m-d');
            $results = DB::select("SELECT kpi.kpi_title,kpi.kip_year,kpi.kpi_percentage,tr.task_complete FROM npoly_kpi as kpi, npoly_task_report as tr
                                        WHERE kpi.kpi_id = tr.kpi_id
                                        AND kpi.active_status = 1
                                         AND kpi.kpi_id in($kpiIds->kpi_id)
                                         AND kpi.kpi_expire_date < '$date'");
        }

        return view('kpi.kpiDetailsInfo',compact('results'));
    }

    public function getActiveKpiInfo($id){

        $header = array(
            'pageTitle' => 'KPI',
            'tableTitle' => ''
        );

        $Closekpi = DB::select("SELECT DISTINCT kpi.kpi_id from npoly_kpi as kpi , npoly_task_report as tr
                                                                        WHERE kpi.kpi_id = tr.kpi_id
                                                                        and tr.kpi_id > 0");
        $kipsID = [];

        foreach ($Closekpi as $value){
            $kipsID []= $value->kpi_id;
        }
        if($id==1){
            $results = DB::table('npoly_kpi')
                ->select('*')
                ->whereNotIn('kpi_id',$kipsID)
                ->get();
        }else{
            $results = DB::table('npoly_kpi')
                ->select('*')
                ->whereIn('kpi_id',$kipsID)
                ->get();
        }

        return view('kpi.getActiveKpiInfo',compact('results','header'));
    }



}
