<?php

namespace App\Http\Controllers\support;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Session;
use App\Models\DriverSetupModel;
use DB;
use Auth;

class DriverSetupController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $header = array(
            'pageTitle' => 'Driver',
            'tableTitle' => 'Driver List'
        );


        $results = DB::table('npoly_driver')
            ->select('*')
            //->where('active_status',1)
            ->orderBy('id','desc')
            ->get();

        return view('setup/driver.index',compact('header','results'));
    }

    /**
     * Create class routine form
     * @param None
     *
     */
    public function create()
    {
        $header = array(
            'pageTitle' => 'Driver',
            'tableTitle' => 'Driver List'
        );

        return view('setup/driver.create', compact('header'));
    }

    /* save class routine
     * @param Request $request
     *
     */
    public function store(Request $request)
    {
        DriverSetupModel::createDriver($request);
        Session::flash('success', 'Data Saved successfully!');
        return redirect()->route('driverSetupIndex');
    }

    /* class routine update page
     * @param $id
     *
     */
    public function edit($id)
    {
        $header = array(
            'pageTitle' => 'Driver',
            'tableTitle' => 'Driver List'
        );

        $result = DriverSetupModel::find($id);
        return view('setup/driver.update', compact('header', 'result'));

    }

    /* class routine update action
     * @param $request
     *
     */
    public function update(Request $request)
    {
        DriverSetupModel::updateDriver($request);
        Session::flash('success', 'Data Updated successfully!');
        return redirect()->route('driverSetupIndex');
    }
}
