<?php

namespace App\Http\Controllers\support;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Session;
use App\Models\DepoSetupModel;
use  App\Models\lookup\LookupGroupDataModel;
use DB;
use Auth;

class DepoSetupController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $header = array(
            'pageTitle' => 'Depo',
            'tableTitle' => 'Depo List'
        );


        $results = DB::table('npoly_depo')
            ->select('*')
            //->where('active_status',1)
            ->orderBy('depo_id','desc')
            ->get();

        return view('setup/depo.index',compact('header','results'));
    }

    /**
     * Create class routine form
     * @param None
     *
     */
    public function create()
    {
        $header = array(
            'pageTitle' => 'Depo',
            'tableTitle' => 'Depo List'
        );

        return view('setup/depo.create', compact('header'));
    }

    /* save class routine
     * @param Request $request
     *
     */
    public function store(Request $request)
    {
        DepoSetupModel::createDepo($request);
        Session::flash('success', 'Data Saved successfully!');
        return redirect()->route('depoSetupIndex');
    }

    /* class routine update page
     * @param $id
     *
     */
    public function edit($id)
    {
        $header = array(
            'pageTitle' => 'Depo',
            'tableTitle' => 'Depo List'
        );

        $result = DepoSetupModel::find($id);
        return view('setup/depo.update', compact('header', 'result'));

    }

    /* class routine update action
     * @param $request
     *
     */
    public function update(Request $request)
    {
        DepoSetupModel::updateDepo($request);
        Session::flash('success', 'Data Updated successfully!');
        return redirect()->route('depoSetupIndex');
    }
}
