<?php

namespace App\Http\Controllers\security_access;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\security_access\MobileModulesScreenModel;
use Session;
use DB;

class MobileModulesScreenController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $header = array(
            'pageTitle' => 'Mobile Modules',
            'tableTitle' => ''
        );
        //$modules=MobileModulesScreenModel::get();
        $results = DB::table('mobile_module_screen as ms')
        ->leftJoin('mobile_module as mm','ms.module_id','=','mm.module_id')
        ->select('ms.*','mm.module_name')
        ->where('ms.active_status',1)
        ->get();
        return view('security_access.mobile_modules_screen.index', compact('header', 'results'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
         $header = array(
        'pageTitle'  => 'Mobile Modules Create',
        'tableTitle' => 'Mobile Modules List'
    );
    $mobileModules = DB::table('mobile_module')
    ->select('module_id','module_name')
    ->where('active_status',1)
    ->get();

     return view('security_access.mobile_modules_screen.create', compact('header','mobileModules'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       $modules=new MobileModulesScreenModel();
        $modules->screen_name=$request->screen_name;
        $modules->screen_name_bn=$request->screen_name_bn;
        $modules->category=1;
        $modules->short_name=$request->short_name;
        $modules->sl_no = $request->serial_no;
        $modules->screen_icon = $request->screen_icon;
        $modules->module_id = $request->module_id;
        $modules->active_status=$request->active_status;
        $modules->save();
        Session::flash('success', 'Data Saved successfully!');
        return redirect()->route('mobileModuleScreenSetup');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
          $header = array
         (
            'pageTitle'  => 'Mobile Modules Edit',

         );
         $modules = MobileModulesScreenModel::where('screen_id', $id)->first();
         $mobileModules = DB::table('mobile_module')
        ->select('module_id','module_name')
        ->where('active_status',1)
        ->get();
         return view('security_access.mobile_modules_screen.edit', compact('header','modules','mobileModules'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $modules = MobileModulesScreenModel::find($id);
        $modules->screen_name=$request->screen_name;
        $modules->screen_name_bn=$request->screen_name_bn;
        $modules->category=1;
        $modules->short_name=$request->short_name;
        $modules->sl_no = $request->serial_no;
        $modules->screen_icon = $request->screen_icon;
        $modules->module_id = $request->module_id;
        $modules->active_status=$request->active_status;
        $modules->save();
        Session::flash('success', 'Data Update successfully!');
        return redirect()->route('mobileModuleScreenSetup');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
