<?php

namespace App\Http\Controllers\security_access;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\security_access\MobileModulesModel;
use Session;
use DB;

class MobileModulesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $header = array(
            'pageTitle' => 'Mobile Modules',
            'tableTitle' => 'Mobile Modules'
        );
        $modules=MobileModulesModel::get();
        return view('security_access.mobile_modules.index', compact('header', 'modules'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
         $header = array(
        'pageTitle'  => 'Mobile Modules Create',
        'tableTitle' => 'Mobile Modules List'
    );
     return view('security_access.mobile_modules.create', compact('header'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       $modules=new MobileModulesModel();
        $modules->module_name=$request->module_name;
        $modules->module_name_bn=$request->module_name_bangla;
        $modules->category=1;
        $modules->short_name=$request->short_name;
        $modules->sl_no = $request->serial_no;
        $modules->module_icon = $request->module_icon;
        $modules->active_status=$request->active_status;
        $modules->save();
        Session::flash('success', 'Data Saved successfully!');
        return redirect()->route('mobileModuleSetup');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
          $header = array
         (
            'pageTitle'  => 'Mobile Modules Edit',

         );
         $modules = MobileModulesModel::where('module_id', $id)->first();
         return view('security_access.mobile_modules.edit', compact('header','modules'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $modules = MobileModulesModel::find($id);
        $modules->module_name=$request->module_name;
        $modules->module_name_bn=$request->module_name_bangla;
        $modules->category=1;
        $modules->short_name=$request->short_name;
        $modules->sl_no = $request->serial_no;
        $modules->module_icon = $request->module_icon;
        $modules->active_status=$request->active_status;
        $modules->save();
        Session::flash('success', 'Data Update successfully!');
        return redirect()->route('mobileModuleSetup');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
