<?php

namespace App\Http\Controllers\schedule;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Session;
use App\Models\TicketModel;
use  App\Models\lookup\LookupGroupDataModel;
use DB;
use Auth;
use DatePeriod;
use DateTime;
use DateInterval;
use Illuminate\Support\Facades\Mail;

class ScheduleController extends Controller
{
    public function index()
    {
        $header = array(
            'pageTitle' => 'Schedule',
            'tableTitle' => ''
        );
       

        $results = DB::table('employee_schedule as sc')
        ->leftJoin('npoly_employees as emp','emp.employee_id','sc.employee_id')
        ->leftJoin('sa_lookup_data as lkp','sc.schedule_place','lkp.LOOKUP_DATA_ID')
        ->leftJoin('sa_lookup_data as lkp1','sc.dept_id','lkp1.LOOKUP_DATA_ID')
        ->select('*','emp.employee_name','lkp.LOOKUP_DATA_NAME as schedule_place','lkp1.LOOKUP_DATA_NAME as dept_name')
        ->where('sc.active_status',1)
        ->get();


        return view('schedule.index',compact('header','results'));
    }

    public function create()  {
        $header = array(
            'pageTitle' => 'Schedule',
            'tableTitle' => ''
        );

        $employees = DB::table('npoly_employees')
        ->select('employee_id','employee_name')
        ->where('active_status',1)
        ->get();

        $departments = DB::table('sa_lookup_data as s')
        ->where('s.LOOKUP_GRP_ID', 5)
        ->select('s.LOOKUP_DATA_ID','s.LOOKUP_DATA_NAME')
        ->where('s.ACTIVE_FLAG', 1)
        ->get();

        $schedulePlace = DB::table('sa_lookup_data as s')
        ->where('s.LOOKUP_GRP_ID', 45)
        ->select('s.LOOKUP_DATA_ID','s.LOOKUP_DATA_NAME')
        ->where('s.ACTIVE_FLAG', 1)
        ->get();

        return view('schedule.create',compact('header','employees','departments','schedulePlace'));
    }

   static function getFridaysBetweenDates($startDate, $endDate) {
        $fridays = array();
    
        $currentDate = new DateTime($startDate);
        $endDate = new DateTime($endDate);
    
        while ($currentDate <= $endDate) {
            // Check if the current day is Friday (day of the week = 5)
            if ($currentDate->format('N') == 5) {
                $fridays[] = $currentDate->format('Y-m-d');
            }
    
            // Move to the next day
            $currentDate->modify('+1 day');
        }
    
        return $fridays;
    }

    public function store(Request $request) {

        $formDate = date('Y-m-d',strtotime($request->from_date));
        $toDate = date('Y-m-d',strtotime($request->to_date));

        $startTime = strtotime($request->start_time) - strtotime('today');
        $endTime = strtotime($request->end_time) - strtotime('today');

        $fridaysBetweenDates = $this::getFridaysBetweenDates($formDate, $toDate);

        $date = new DateTime($toDate);

        $date->modify('+1 day');
        $addToDate =  $date->format('Y-m-d');

        $startDate = new DateTime($formDate);
        $endDate = new DateTime($addToDate);

        $interval = new DateInterval('P1D'); // 1 day interval
        $dateRange = new DatePeriod($startDate, $interval, $endDate);
        $dayShortName = [];
        $rangeOfDate = [];
        foreach ($dateRange as $key=> $date) {
        array_push($dayShortName, $date->format('D'));
        array_push($rangeOfDate, $date->format('Y-m-d'));
        }
        $matchDay = array_intersect($dayShortName,$request->week_name?$request->week_name:[]);
        $getMatchDayKey = array_keys($matchDay);
        $keyValues = array_values($getMatchDayKey);

        $finalScheduleDate = [];

        foreach ($keyValues as $index) {
        if (isset($rangeOfDate[$index])) {
        $finalScheduleDate[] = $rangeOfDate[$index];
        }
        }

        if(!empty($finalScheduleDate)){
            foreach ($finalScheduleDate as $key => $value) {
                $insertInfo = DB::table('employee_schedule')->insert([
                 "employee_id"=> $request->employee_id,
                 "dept_id"=> $request->department_id,
                 "schedule_generate_date"=> date('Y-m-d'),
                 "schedule_date"=> $value,
                 "schedule_from_date"=> date('Y-m-d',strtotime($request->from_date)),
                 "schedule_to_date"=> date('Y-m-d',strtotime($request->to_date)),
                 "schedule_place"=> $request->schedule_place,
                 "schedule_start_time"=> $startTime,
                 "schedule_end_time"=> $endTime,
                 "active_status"=> 1,
                 "created_by"=> Auth::user()->id,
                ]);
             }
        }else{
            $finalScheduleDate = array_diff($rangeOfDate,$fridaysBetweenDates);

            foreach ($finalScheduleDate as $key => $value) {
                $insertInfo = DB::table('employee_schedule')->insert([
                 "employee_id"=> $request->employee_id,
                 "dept_id"=> $request->department_id,
                 "schedule_generate_date"=> date('Y-m-d'),
                 "schedule_date"=> $value,
                 "schedule_from_date"=> date('Y-m-d',strtotime($request->from_date)),
                 "schedule_to_date"=> date('Y-m-d',strtotime($request->to_date)),
                 "schedule_place"=> $request->schedule_place,
                 "schedule_start_time"=> $startTime,
                 "schedule_end_time"=> $endTime,
                 "active_status"=> 1,
                 "created_by"=> Auth::user()->id,
                ]);
             }
        }

    Session::flash('success', 'Data Saved successfully!');
    return redirect()->route('scheduleIndex');
    }
}
