<?php

namespace App\Http\Controllers\sales;


use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Session;
use App\Models\TicketModel;
use  App\Models\lookup\LookupGroupDataModel;
use DB;
use Auth;
use DatePeriod;
use DateTime;
use DateInterval;
use Illuminate\Support\Facades\Mail;

class SalesController extends Controller
{
    public function index(){
        $header = array(
            'pageTitle' => 'Sales',
            'tableTitle' => ''
        );
        $fromDate = date('01-M-Y');
        $toDate = date('d-M-Y');
        $results = DB::connection('oracle')->select("SELECT PRODUCT,MOTHER_CAT,ITEM_CODE,ITEM_NAME,UOM,
                                                        SUM(DO_QTY)DO_QTY,SUM(DO_AMOUNT)DO_AMOUNT,
                                                        SUM(SHIPPED_QUANTITY)SHIPPED_QUANTITY,SUM(SHIPPED_AMOUNT)SHIPPED_AMOUNT
                                                        FROM(SELECT OTA.ATTRIBUTE2 PRODUCT,MSIK.ATTRIBUTE10 MOTHER_CAT,               
                                                                L.ORDERED_ITEM ITEM_CODE, 
                                                                MSIK.DESCRIPTION ITEM_NAME,
                                                                ORDER_QUANTITY_UOM UOM,
                                                                SUM(NVL(L.ORDERED_QUANTITY, 0)-NVL(CANCELLED_QUANTITY,0))DO_QTY,
                                                                ROUND (SUM (CASE  WHEN H.TRANSACTIONAL_CURR_CODE = 'BDT' THEN ((NVL(L.ORDERED_QUANTITY,0)-NVL(CANCELLED_QUANTITY,0))*NVL(L.UNIT_SELLING_PRICE,0))
                                                                ELSE (((NVL(L.ORDERED_QUANTITY, 0)-NVL(CANCELLED_QUANTITY,0)) * NVL (L.UNIT_SELLING_PRICE, 0))) * NVL(APPS.XX_CONVERSION_RATE@XXNPTICKET_SALES (TRUNC (H.ORDERED_DATE)),0)
                                                                END)) DO_AMOUNT,        
                                                                0 SHIPPED_QUANTITY,
                                                                0 SHIPPED_AMOUNT
                                                        FROM ONT.OE_ORDER_HEADERS_ALL@XXNPTICKET_SALES H,
                                                            ONT.OE_ORDER_LINES_ALL@XXNPTICKET_SALES L,
                                                            ONT.OE_TRANSACTION_TYPES_TL@XXNPTICKET_SALES OT,
                                                            ONT.OE_TRANSACTION_TYPES_ALL@XXNPTICKET_SALES OTA,
                                                            APPS.MTL_SYSTEM_ITEMS_B_KFV@XXNPTICKET_SALES MSIK
                                                        WHERE    H.HEADER_ID = L.HEADER_ID
                                                            AND (ORDERED_ITEM NOT LIKE ('031.%') OR ORDERED_ITEM NOT LIKE ('033.%'))
                                                            AND H.ORG_ID = L.ORG_ID
                                                            AND ITEM_TYPE_CODE NOT IN ('CLASS','OPTION','CONFIG','INCLUDED')
                                                            AND ((L.TOP_MODEL_LINE_ID IS NOT NULL AND L.TOP_MODEL_LINE_ID = LINE_ID) OR (L.TOP_MODEL_LINE_ID IS NULL))
                                                            AND H.ORDER_TYPE_ID = OT.TRANSACTION_TYPE_ID
                                                            AND OT.TRANSACTION_TYPE_ID = OTA.TRANSACTION_TYPE_ID
                                                            AND H.BOOKED_FLAG = 'Y'
                                                            AND H.CANCELLED_FLAG = 'N'
                                                            AND H.BOOKED_DATE IS NOT NULL
                                                            AND (OT.NAME NOT LIKE '%Intercompany%' AND OT.NAME NOT LIKE '%Internal%' AND OT.NAME NOT LIKE '%Return%')
                                                            --AND TRUNC(ORDERED_DATE) BETWEEN :P_DATE_FR AND :P_DATE_TO
                                                            AND TRUNC(ORDERED_DATE) BETWEEN TO_DATE('$fromDate','DD-MM-YYYY') AND TO_DATE('$toDate','DD-MM-YYYY')
                                                            AND H.ORG_ID='101'
                                                            AND MSIK.ORGANIZATION_ID = H.ORG_ID
                                                            AND MSIK.INVENTORY_ITEM_ID = L.INVENTORY_ITEM_ID
                                                        GROUP BY OTA.ATTRIBUTE2,L.ORDERED_ITEM,MSIK.DESCRIPTION,MSIK.ATTRIBUTE10,L.ORDER_QUANTITY_UOM
                                                        UNION ALL
                                                        SELECT OTA.ATTRIBUTE2 PRODUCT,MSIK.ATTRIBUTE10 MOTHER_CAT,               
                                                                L.ORDERED_ITEM ITEM_CODE, 
                                                                MSIK.DESCRIPTION ITEM_NAME,
                                                                ORDER_QUANTITY_UOM UOM,
                                                                0 DO_QTY,
                                                                0 DO_AMOUNT,        
                                                                SUM(NVL(SHIPPED_QUANTITY,0))SHIPPED_QUANTITY,
                                                            ROUND (SUM (CASE  WHEN H.TRANSACTIONAL_CURR_CODE = 'BDT' THEN ((NVL(L.SHIPPED_QUANTITY,0))*NVL(L.UNIT_SELLING_PRICE,0))
                                                                ELSE (((NVL(L.SHIPPED_QUANTITY, 0)) * NVL (L.UNIT_SELLING_PRICE, 0))) * NVL(apps.XX_CONVERSION_RATE@XXNPTICKET_SALES (TRUNC (L.ACTUAL_FULFILLMENT_DATE)),0)
                                                                END))SHIPPED_AMOUNT
                                                                
                                                        FROM ONT.OE_ORDER_HEADERS_ALL@XXNPTICKET_SALES H,
                                                            ONT.OE_ORDER_LINES_ALL@XXNPTICKET_SALES L,
                                                            ONT.OE_TRANSACTION_TYPES_TL@XXNPTICKET_SALES OT,
                                                            ONT.OE_TRANSACTION_TYPES_ALL@XXNPTICKET_SALES OTA,
                                                            APPS.MTL_SYSTEM_ITEMS_B_KFV@XXNPTICKET_SALES MSIK
                                                        WHERE    H.HEADER_ID = L.HEADER_ID
                                                            AND (ORDERED_ITEM NOT LIKE ('031.%') OR ORDERED_ITEM NOT LIKE ('033.%'))
                                                            AND H.ORG_ID = L.ORG_ID
                                                            AND ITEM_TYPE_CODE NOT IN ('CLASS','OPTION','CONFIG','INCLUDED')
                                                            AND ((L.TOP_MODEL_LINE_ID IS NOT NULL AND L.TOP_MODEL_LINE_ID = LINE_ID) OR (L.TOP_MODEL_LINE_ID IS NULL))
                                                            AND H.ORDER_TYPE_ID = OT.TRANSACTION_TYPE_ID
                                                            AND OT.TRANSACTION_TYPE_ID = OTA.TRANSACTION_TYPE_ID
                                                            AND H.BOOKED_FLAG = 'Y'
                                                            AND H.CANCELLED_FLAG = 'N'
                                                            AND H.BOOKED_DATE IS NOT NULL
                                                            AND (OT.NAME NOT LIKE '%Intercompany%' AND OT.NAME NOT LIKE '%Internal%' AND OT.NAME NOT LIKE '%Return%')
                                                            --AND TRUNC(ACTUAL_FULFILLMENT_DATE) BETWEEN :P_DATE_FR AND :P_DATE_TO
                                                            AND TRUNC(ORDERED_DATE) BETWEEN TO_DATE('$fromDate','DD-MM-YYYY') AND TO_DATE('$toDate','DD-MM-YYYY')
                                                            AND H.ORG_ID='101'
                                                            AND MSIK.ORGANIZATION_ID = H.ORG_ID
                                                            AND MSIK.INVENTORY_ITEM_ID = L.INVENTORY_ITEM_ID
                                                        GROUP BY OTA.ATTRIBUTE2,L.ORDERED_ITEM,MSIK.DESCRIPTION,MSIK.ATTRIBUTE10,L.ORDER_QUANTITY_UOM)
                                                        GROUP BY PRODUCT,MOTHER_CAT,ITEM_CODE,ITEM_NAME,UOM");

        $products = DB::connection('oracle')->select("SELECT DISTINCT ATTRIBUTE2 PRODUCT FROM ONT.OE_TRANSACTION_TYPES_ALL@XXNPTICKET_SALES WHERE ATTRIBUTE2 <> 'NA'");
        $categorys = DB::connection('oracle')->select("SELECT distinct ATTRIBUTE10 category FROM APPS.MTL_SYSTEM_ITEMS_B_KFV@XXNPTICKET_SALES MSIK WHERE ATTRIBUTE10 is not null");
        $orgnizations = DB::connection('oracle')->select("SELECT ORGANIZATION_ID org_id,ORGANIZATION_NAME org_name from apps.ORG_ORGANIZATION_DEFINITIONS@XXNPTICKET_SALES
                                                        GROUP BY ORGANIZATION_ID,ORGANIZATION_NAME
                                                        ORDER BY ORGANIZATION_ID");
                                                       // dd($orgnizations);
        return view('sales.index',compact('header','results','products','categorys','orgnizations'));
    }

    public function searchReport(Request  $request){
        $fromDate = date('d-M-Y',strtotime($request->fromDate));
        $toDate = date('d-M-Y',strtotime($request->toDate));
        $productId = $request->productId;
        $categoryId = $request->categoryId;
        $orgId = $request->orgId;
        $condition = '';

        if(!empty($productId)){
            $condition .= " AND OTA.ATTRIBUTE2 = '$productId'";
        }
        if(!empty($categoryId)){
            $condition .= " AND MSIK.ATTRIBUTE10 = '$categoryId'";
        }
        if(!empty($orgId)){
            $condition .= " AND H.ORG_ID ='$orgId'";
        }
        

        $results = DB::connection('oracle')->select("SELECT PRODUCT,MOTHER_CAT,ITEM_CODE,ITEM_NAME,UOM,
            SUM(DO_QTY)DO_QTY,SUM(DO_AMOUNT)DO_AMOUNT,
            SUM(SHIPPED_QUANTITY)SHIPPED_QUANTITY,SUM(SHIPPED_AMOUNT)SHIPPED_AMOUNT
            FROM(SELECT OTA.ATTRIBUTE2 PRODUCT,MSIK.ATTRIBUTE10 MOTHER_CAT,               
                    L.ORDERED_ITEM ITEM_CODE, 
                    MSIK.DESCRIPTION ITEM_NAME,
                    ORDER_QUANTITY_UOM UOM,
                    SUM(NVL(L.ORDERED_QUANTITY, 0)-NVL(CANCELLED_QUANTITY,0))DO_QTY,
                    ROUND (SUM (CASE  WHEN H.TRANSACTIONAL_CURR_CODE = 'BDT' THEN ((NVL(L.ORDERED_QUANTITY,0)-NVL(CANCELLED_QUANTITY,0))*NVL(L.UNIT_SELLING_PRICE,0))
                    ELSE (((NVL(L.ORDERED_QUANTITY, 0)-NVL(CANCELLED_QUANTITY,0)) * NVL (L.UNIT_SELLING_PRICE, 0))) * NVL(APPS.XX_CONVERSION_RATE@XXNPTICKET_SALES (TRUNC (H.ORDERED_DATE)),0)
                    END)) DO_AMOUNT,        
                    0 SHIPPED_QUANTITY,
                    0 SHIPPED_AMOUNT
            FROM ONT.OE_ORDER_HEADERS_ALL@XXNPTICKET_SALES H,
                ONT.OE_ORDER_LINES_ALL@XXNPTICKET_SALES L,
                ONT.OE_TRANSACTION_TYPES_TL@XXNPTICKET_SALES OT,
                ONT.OE_TRANSACTION_TYPES_ALL@XXNPTICKET_SALES OTA,
                APPS.MTL_SYSTEM_ITEMS_B_KFV@XXNPTICKET_SALES MSIK
            WHERE    H.HEADER_ID = L.HEADER_ID
                AND (ORDERED_ITEM NOT LIKE ('031.%') OR ORDERED_ITEM NOT LIKE ('033.%'))
                AND H.ORG_ID = L.ORG_ID
                AND ITEM_TYPE_CODE NOT IN ('CLASS','OPTION','CONFIG','INCLUDED')
                AND ((L.TOP_MODEL_LINE_ID IS NOT NULL AND L.TOP_MODEL_LINE_ID = LINE_ID) OR (L.TOP_MODEL_LINE_ID IS NULL))
                AND H.ORDER_TYPE_ID = OT.TRANSACTION_TYPE_ID
                AND OT.TRANSACTION_TYPE_ID = OTA.TRANSACTION_TYPE_ID
                AND H.BOOKED_FLAG = 'Y'
                AND H.CANCELLED_FLAG = 'N'
                AND H.BOOKED_DATE IS NOT NULL
                AND (OT.NAME NOT LIKE '%Intercompany%' AND OT.NAME NOT LIKE '%Internal%' AND OT.NAME NOT LIKE '%Return%')
                --AND TRUNC(ORDERED_DATE) BETWEEN :P_DATE_FR AND :P_DATE_TO
                AND TRUNC(ORDERED_DATE) BETWEEN TO_DATE('$fromDate','DD-MM-YYYY') AND TO_DATE('$toDate','DD-MM-YYYY')
                $condition
                AND MSIK.ORGANIZATION_ID = H.ORG_ID
                AND MSIK.INVENTORY_ITEM_ID = L.INVENTORY_ITEM_ID
            GROUP BY OTA.ATTRIBUTE2,L.ORDERED_ITEM,MSIK.DESCRIPTION,MSIK.ATTRIBUTE10,L.ORDER_QUANTITY_UOM
            UNION ALL
            SELECT OTA.ATTRIBUTE2 PRODUCT,MSIK.ATTRIBUTE10 MOTHER_CAT,               
                    L.ORDERED_ITEM ITEM_CODE, 
                    MSIK.DESCRIPTION ITEM_NAME,
                    ORDER_QUANTITY_UOM UOM,
                    0 DO_QTY,
                    0 DO_AMOUNT,        
                    SUM(NVL(SHIPPED_QUANTITY,0))SHIPPED_QUANTITY,
                ROUND (SUM (CASE  WHEN H.TRANSACTIONAL_CURR_CODE = 'BDT' THEN ((NVL(L.SHIPPED_QUANTITY,0))*NVL(L.UNIT_SELLING_PRICE,0))
                    ELSE (((NVL(L.SHIPPED_QUANTITY, 0)) * NVL (L.UNIT_SELLING_PRICE, 0))) * NVL(apps.XX_CONVERSION_RATE@XXNPTICKET_SALES (TRUNC (L.ACTUAL_FULFILLMENT_DATE)),0)
                    END))SHIPPED_AMOUNT
                    
            FROM ONT.OE_ORDER_HEADERS_ALL@XXNPTICKET_SALES H,
                ONT.OE_ORDER_LINES_ALL@XXNPTICKET_SALES L,
                ONT.OE_TRANSACTION_TYPES_TL@XXNPTICKET_SALES OT,
                ONT.OE_TRANSACTION_TYPES_ALL@XXNPTICKET_SALES OTA,
                APPS.MTL_SYSTEM_ITEMS_B_KFV@XXNPTICKET_SALES MSIK
            WHERE    H.HEADER_ID = L.HEADER_ID
                AND (ORDERED_ITEM NOT LIKE ('031.%') OR ORDERED_ITEM NOT LIKE ('033.%'))
                AND H.ORG_ID = L.ORG_ID
                AND ITEM_TYPE_CODE NOT IN ('CLASS','OPTION','CONFIG','INCLUDED')
                AND ((L.TOP_MODEL_LINE_ID IS NOT NULL AND L.TOP_MODEL_LINE_ID = LINE_ID) OR (L.TOP_MODEL_LINE_ID IS NULL))
                AND H.ORDER_TYPE_ID = OT.TRANSACTION_TYPE_ID
                AND OT.TRANSACTION_TYPE_ID = OTA.TRANSACTION_TYPE_ID
                AND H.BOOKED_FLAG = 'Y'
                AND H.CANCELLED_FLAG = 'N'
                AND H.BOOKED_DATE IS NOT NULL
                AND (OT.NAME NOT LIKE '%Intercompany%' AND OT.NAME NOT LIKE '%Internal%' AND OT.NAME NOT LIKE '%Return%')
                --AND TRUNC(ACTUAL_FULFILLMENT_DATE) BETWEEN :P_DATE_FR AND :P_DATE_TO
                AND TRUNC(ORDERED_DATE) BETWEEN TO_DATE('$fromDate','DD-MM-YYYY') AND TO_DATE('$toDate','DD-MM-YYYY')
            $condition
                AND MSIK.ORGANIZATION_ID = H.ORG_ID
                AND MSIK.INVENTORY_ITEM_ID = L.INVENTORY_ITEM_ID
            GROUP BY OTA.ATTRIBUTE2,L.ORDERED_ITEM,MSIK.DESCRIPTION,MSIK.ATTRIBUTE10,L.ORDER_QUANTITY_UOM)
            GROUP BY PRODUCT,MOTHER_CAT,ITEM_CODE,ITEM_NAME,UOM");
        
        
        
        return view('sales.search_sales_report',compact('results'));
        
    }

    public function collectionIndex(){
        $header = array(
            'pageTitle' => 'Sales',
            'tableTitle' => ''
        );
        $fromDate = date('01-M-Y');
        $toDate = date('d-M-Y');
        $results = DB::connection('oracle')->select("SELECT PRODUCT,ORG_ID,
   SUM(DO_AMOUNT)DO_AMOUNT,
   SUM(INVOICE_AMOUNT)INVOICE_AMOUNT,
   SUM(COLLECTION_AMOUNT)COLLECTION_AMOUNT
FROM(
SELECT DECODE(OTA.ATTRIBUTE2,'Packing Mat','Packaging Materials',OTA.ATTRIBUTE2) PRODUCT,H.ORG_ID,
         ROUND (SUM (CASE  WHEN H.TRANSACTIONAL_CURR_CODE = 'BDT' THEN ((NVL(L.ORDERED_QUANTITY,0)-NVL(CANCELLED_QUANTITY,0))*NVL(L.UNIT_SELLING_PRICE,0))
        ELSE (((NVL(L.ORDERED_QUANTITY, 0)-NVL(CANCELLED_QUANTITY,0)) * NVL (L.UNIT_SELLING_PRICE, 0))) * NVL(APPS.XX_CONVERSION_RATE@XXNPTICKET_SALES (TRUNC (H.ORDERED_DATE)),0)
        END)) DO_AMOUNT,
        0 INVOICE_AMOUNT,
        0 COLLECTION_AMOUNT
FROM ONT.OE_ORDER_HEADERS_ALL@XXNPTICKET_SALES H,
     ONT.OE_ORDER_LINES_ALL@XXNPTICKET_SALES L,
     ONT.OE_TRANSACTION_TYPES_TL@XXNPTICKET_SALES OT,
     ONT.OE_TRANSACTION_TYPES_ALL@XXNPTICKET_SALES OTA
WHERE    H.HEADER_ID = L.HEADER_ID
    AND (ORDERED_ITEM NOT LIKE ('031.%') OR ORDERED_ITEM NOT LIKE ('033.%'))
    AND H.ORG_ID = L.ORG_ID
    AND ITEM_TYPE_CODE NOT IN ('CLASS','OPTION','CONFIG','INCLUDED')
    AND ((L.TOP_MODEL_LINE_ID IS NOT NULL AND L.TOP_MODEL_LINE_ID = LINE_ID) OR (L.TOP_MODEL_LINE_ID IS NULL))
    AND H.ORDER_TYPE_ID = OT.TRANSACTION_TYPE_ID
    AND OT.TRANSACTION_TYPE_ID = OTA.TRANSACTION_TYPE_ID
    AND H.BOOKED_FLAG = 'Y'
    AND H.CANCELLED_FLAG = 'N'
    AND H.BOOKED_DATE IS NOT NULL
    AND (OT.NAME NOT LIKE '%Intercompany%' AND OT.NAME NOT LIKE '%Internal%' AND OT.NAME NOT LIKE '%Return%')
    AND TRUNC(ORDERED_DATE) BETWEEN TO_DATE('$fromDate','DD-MM-YYYY') AND TO_DATE('$toDate','DD-MM-YYYY')
    AND H.ORG_ID=101
GROUP BY OTA.ATTRIBUTE2,H.ORG_ID
UNION ALL-----Invoice amount
SELECT DECODE(PROD_TYPE,'Packing','Packaging Materials',PROD_TYPE) PRODUCT, SAL.ORG_ID,
    0 DO_AMOUNT,
    SUM(NVL (DR_AMOUNT, 0)) INVOICE_AMOUNT,
    0 COLLECTION_AMOUNT                    
FROM APPS.XX_AR_CUST_DTL_LED_ACTUAL_V1@XXNPTICKET_SALES SAL,
     APPS.XX_AR_CUSTOMERS_ALL_V@XXNPTICKET_SALES CUST
WHERE  SAL.CUSTOMER_ID = CUST.CUSTOMER_ID(+)
   AND TRX_TYPE IN ('Sales')
   AND CUSTOMER_CLASS_CODE NOT IN ('INTERCOMPANY')
   AND SAL.GL_DATE BETWEEN TO_DATE('$fromDate','DD-MM-YYYY') AND TO_DATE('$toDate','DD-MM-YYYY')
   AND SAL.ORG_ID=101
GROUP BY PROD_TYPE, SAL.ORG_ID
UNION ALL-----Collection
SELECT PROD_NAME PRODUCT,ORG_ID,
0 DO_AMOUNT,
0 INVOICE_AMOUNT,
SUM(COLLAMT)COLLECTION_AMOUNT
FROM(SELECT 
(CASE WHEN A.PROD_TYPE='Pipe' THEN 'Pipe'
      WHEN A.PROD_TYPE='Pipe PVC1' THEN 'Pipe'
      WHEN A.PROD_TYPE='Pipe PVC2' THEN 'Pipe'
      WHEN A.PROD_TYPE='Packing Mat' THEN 'Packaging Materials'
      ELSE A.PROD_TYPE END)PROD_NAME,
      A.ORG_ID,
    (NVL (CR_AMOUNT, 0) - NVL (DR_AMOUNT, 0)) COLLAMT                      
 FROM APPS.XX_AR_CUST_DTL_LED_V_YUF@XXNPTICKET_SALES A, 
      APPS.XX_AR_CUSTOMERS_ALL_V@XXNPTICKET_SALES CUST
 WHERE A.CUSTOMER_ID = CUST.CUSTOMER_ID(+)
    AND CUSTOMER_CLASS_CODE NOT IN ('INTERCOMPANY')
    AND TRX_TYPE IN ('Receipts','Customer Refund','Reversed Receipts')
    AND A.GL_DATE BETWEEN TO_DATE('$fromDate','DD-MM-YYYY') AND TO_DATE('$toDate','DD-MM-YYYY')
    AND A.ORG_ID=101
    AND CUST.CUSTOMER_ID NOT IN (6042,4225,328992,228066,324440))
 GROUP BY PROD_NAME,ORG_ID)
 GROUP BY PRODUCT,ORG_ID");

        $products = DB::connection('oracle')->select("SELECT DISTINCT ATTRIBUTE2 PRODUCT FROM ONT.OE_TRANSACTION_TYPES_ALL@XXNPTICKET_SALES WHERE ATTRIBUTE2 <> 'NA'");
       // $categorys = DB::connection('oracle')->select("SELECT distinct ATTRIBUTE10 category FROM APPS.MTL_SYSTEM_ITEMS_B_KFV@XXNPTICKET_SALES MSIK WHERE ATTRIBUTE10 is not null");
        $orgnizations = DB::connection('oracle')->select("SELECT ORGANIZATION_ID org_id,ORGANIZATION_NAME org_name from apps.ORG_ORGANIZATION_DEFINITIONS@XXNPTICKET_SALES
                                                        GROUP BY ORGANIZATION_ID,ORGANIZATION_NAME
                                                        ORDER BY ORGANIZATION_ID");
        return view('sales.collectionIndex',compact('header','results','products','orgnizations'));
    }

    public function searchCollection(Request  $request){
        $fromDate = date('d-M-Y',strtotime($request->fromDate));
        $toDate = date('d-M-Y',strtotime($request->toDate));
        $productId = $request->productId;
        $categoryId = $request->categoryId;
        $orgId = $request->orgId ? $request->orgId:101;
        $condition1 = '';
        $condition2 = '';
        $condition3 = '';

        if(!empty($productId)){
            $condition1 .= " AND OTA.ATTRIBUTE2 = '$productId'";
        }
        if(!empty($productId)){
            $condition2 .= " AND PROD_TYPE = '$productId'";
        }
        if(!empty($productId)){
            $condition3 .= " AND A.PROD_TYPE = '$productId'";
        }
        
        

        $results = DB::connection('oracle')->select("SELECT PRODUCT,ORG_ID,
   SUM(DO_AMOUNT)DO_AMOUNT,
   SUM(INVOICE_AMOUNT)INVOICE_AMOUNT,
   SUM(COLLECTION_AMOUNT)COLLECTION_AMOUNT
FROM(
SELECT DECODE(OTA.ATTRIBUTE2,'Packing Mat','Packaging Materials',OTA.ATTRIBUTE2) PRODUCT,H.ORG_ID,
         ROUND (SUM (CASE  WHEN H.TRANSACTIONAL_CURR_CODE = 'BDT' THEN ((NVL(L.ORDERED_QUANTITY,0)-NVL(CANCELLED_QUANTITY,0))*NVL(L.UNIT_SELLING_PRICE,0))
        ELSE (((NVL(L.ORDERED_QUANTITY, 0)-NVL(CANCELLED_QUANTITY,0)) * NVL (L.UNIT_SELLING_PRICE, 0))) * NVL(APPS.XX_CONVERSION_RATE@XXNPTICKET_SALES (TRUNC (H.ORDERED_DATE)),0)
        END)) DO_AMOUNT,
        0 INVOICE_AMOUNT,
        0 COLLECTION_AMOUNT
FROM ONT.OE_ORDER_HEADERS_ALL@XXNPTICKET_SALES H,
     ONT.OE_ORDER_LINES_ALL@XXNPTICKET_SALES L,
     ONT.OE_TRANSACTION_TYPES_TL@XXNPTICKET_SALES OT,
     ONT.OE_TRANSACTION_TYPES_ALL@XXNPTICKET_SALES OTA
WHERE    H.HEADER_ID = L.HEADER_ID
    AND (ORDERED_ITEM NOT LIKE ('031.%') OR ORDERED_ITEM NOT LIKE ('033.%'))
    AND H.ORG_ID = L.ORG_ID
    AND ITEM_TYPE_CODE NOT IN ('CLASS','OPTION','CONFIG','INCLUDED')
    AND ((L.TOP_MODEL_LINE_ID IS NOT NULL AND L.TOP_MODEL_LINE_ID = LINE_ID) OR (L.TOP_MODEL_LINE_ID IS NULL))
    AND H.ORDER_TYPE_ID = OT.TRANSACTION_TYPE_ID
    AND OT.TRANSACTION_TYPE_ID = OTA.TRANSACTION_TYPE_ID
    AND H.BOOKED_FLAG = 'Y'
    AND H.CANCELLED_FLAG = 'N'
    AND H.BOOKED_DATE IS NOT NULL
    AND (OT.NAME NOT LIKE '%Intercompany%' AND OT.NAME NOT LIKE '%Internal%' AND OT.NAME NOT LIKE '%Return%')
    AND TRUNC(ORDERED_DATE) BETWEEN TO_DATE('$fromDate','DD-MM-YYYY') AND TO_DATE('$toDate','DD-MM-YYYY')
    AND H.ORG_ID='$orgId'
    $condition1
GROUP BY OTA.ATTRIBUTE2,H.ORG_ID
UNION ALL-----Invoice amount
SELECT DECODE(PROD_TYPE,'Packing','Packaging Materials',PROD_TYPE) PRODUCT, SAL.ORG_ID,
    0 DO_AMOUNT,
    SUM(NVL (DR_AMOUNT, 0)) INVOICE_AMOUNT,
    0 COLLECTION_AMOUNT                    
FROM APPS.XX_AR_CUST_DTL_LED_ACTUAL_V1@XXNPTICKET_SALES SAL,
     APPS.XX_AR_CUSTOMERS_ALL_V@XXNPTICKET_SALES CUST
WHERE  SAL.CUSTOMER_ID = CUST.CUSTOMER_ID(+)
   AND TRX_TYPE IN ('Sales')
   AND CUSTOMER_CLASS_CODE NOT IN ('INTERCOMPANY')
   AND SAL.GL_DATE BETWEEN TO_DATE('$fromDate','DD-MM-YYYY') AND TO_DATE('$toDate','DD-MM-YYYY')
   AND SAL.ORG_ID='$orgId'
   $condition2
GROUP BY PROD_TYPE, SAL.ORG_ID
UNION ALL-----Collection
SELECT PROD_NAME PRODUCT,ORG_ID,
0 DO_AMOUNT,
0 INVOICE_AMOUNT,
SUM(COLLAMT)COLLECTION_AMOUNT
FROM(SELECT 
(CASE WHEN A.PROD_TYPE='Pipe' THEN 'Pipe'
      WHEN A.PROD_TYPE='Pipe PVC1' THEN 'Pipe'
      WHEN A.PROD_TYPE='Pipe PVC2' THEN 'Pipe'
      WHEN A.PROD_TYPE='Packing Mat' THEN 'Packaging Materials'
      ELSE A.PROD_TYPE END)PROD_NAME,
      A.ORG_ID,
    (NVL (CR_AMOUNT, 0) - NVL (DR_AMOUNT, 0)) COLLAMT                      
 FROM APPS.XX_AR_CUST_DTL_LED_V_YUF@XXNPTICKET_SALES A, 
      APPS.XX_AR_CUSTOMERS_ALL_V@XXNPTICKET_SALES CUST
 WHERE A.CUSTOMER_ID = CUST.CUSTOMER_ID(+)
    AND CUSTOMER_CLASS_CODE NOT IN ('INTERCOMPANY')
    AND TRX_TYPE IN ('Receipts','Customer Refund','Reversed Receipts')
    AND A.GL_DATE BETWEEN TO_DATE('$fromDate','DD-MM-YYYY') AND TO_DATE('$toDate','DD-MM-YYYY')
    AND A.ORG_ID='$orgId'
    $condition3
    AND CUST.CUSTOMER_ID NOT IN (6042,4225,328992,228066,324440))
 GROUP BY PROD_NAME,ORG_ID)
 GROUP BY PRODUCT,ORG_ID");
        
        
        
        return view('sales.search_collection_report',compact('results'));
        
    }

    public function loaction(Request $request){

        $locations = [
            ['name' => 'Location 1', 'lat' => 23.90910868508846, 'lng' => 90.3980562086819],
            ['name' => 'Location 2', 'lat' => 23.911869479606402, 'lng' => 90.3959859622692],
            ['name' => 'Location 3', 'lat' => 23.95919533812984, 'lng' => 90.37885025448523],
            ['name' => 'Location 3', 'lat' => 23.880106996919192, 'lng' => 90.40109245286052],
        ];
    
        return view('map.index', compact('locations'));
    }

    public function notificationIndex(){
        $header = array(
            'pageTitle' => 'Dealer Offer Notificaiotn',
            'tableTitle' => ''
        );
        
        return view('dealer.index',compact('header'));
    }

    public function createNotificationSetup(){
        $header = array(
            'pageTitle' => 'Dealer Offer Notificaiotn',
            'tableTitle' => ''
        );
        
        return view('dealer.create',compact('header'));  
    }

    public function sendNotificaiton(Request $request){
        if($_POST){
            $title = $request->offer_title;
            $body = $request->offer_description;
            $productCode = $request->product_code;

            $url = 'http://138.2.64.100/api/v1/mobile/auth/notify';

            $data = array(
                'title' => $title,
                'desc' => $body,
                'product_code' => $productCode,
              );
        
              // Convert the data array to JSON
              $jsonData = json_encode($data);
        
              // Initialize cURL session
              $curl = curl_init($url);
        
          // Set the cURL options
                  curl_setopt($curl, CURLOPT_URL, $url);
                  curl_setopt($curl, CURLOPT_POST, true); // Set the request method to POST
                  curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                  curl_setopt($curl, CURLOPT_HEADER, false);
                  curl_setopt($curl, CURLOPT_POSTFIELDS, $jsonData); // Attach the JSON data
                  curl_setopt($curl, CURLOPT_HTTPHEADER, array(
                      'Content-Type: application/json',
                      'Content-Length: ' . strlen($jsonData)
                  ));
        
                  // Execute the POST request
                  $response = curl_exec($curl);

                  
            if (curl_errno($curl)) {
                echo 'Error:' . curl_error($curl);
            } else {
                // Print the response from the server
                Session::flash('success', 'Notification Send successfully!');
                return redirect()->route('dealer-offer-notification');
            }
          
           // curl_close($curl);


        
        }
    }
}
