<?php

namespace App\Http\Controllers\meeting_room;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Session;
use App\Models\TicketModel;
use  App\Models\lookup\LookupGroupDataModel;
use DB;
use Auth;
use DatePeriod;
use DateTime;
use DateInterval;
use Illuminate\Support\Facades\Mail;

class MeetingRoomController extends Controller
{
    public function index()
    {
        $header = array(
            'pageTitle' => 'Meeting',
            'tableTitle' => ''
        );
       
        $today = date('Y-m-d');
        $yesterday = date('Y-m-d', strtotime('-1 day'));
       
        $results = DB::select("SELECT
                                    mrb.*,
                                    lkp.LOOKUP_DATA_NAME AS room_name
                                FROM
                                    meeting_room_booking mrb, sa_lookup_data lkp

                                WHERE  mrb.room_id = lkp.LOOKUP_DATA_ID
                                and
                                    mrb.active_status = 1 AND mrb.meeting_status != 2
                                    AND mrb.meeting_date > '$yesterday'
                                ORDER BY
                                    `mrb`.`meeting_id`
                                DESC
                                    ");

        return view('meeting_room.index',compact('header','results'));
    }
    public function meetingReport(){
        $header = array(
            'pageTitle' => 'Meeting',
            'tableTitle' => ''
        );
       
        $fromDate = date('Y-m-01');
        $toDate = date('Y-m-d');

        $roomInfo = DB::table('sa_lookup_data')
                    ->select('LOOKUP_DATA_ID','LOOKUP_DATA_NAME')
                    ->where('LOOKUP_GRP_ID',46)
                    ->where('ACTIVE_FLAG',1)
                    ->get();
       
        $results = DB::select("SELECT
                                    mrb.*,
                                    lkp.LOOKUP_DATA_NAME AS room_name
                                FROM
                                    meeting_room_booking mrb, sa_lookup_data lkp

                                WHERE  mrb.room_id = lkp.LOOKUP_DATA_ID
                                and
                                    mrb.active_status = 1 AND mrb.meeting_status != 0
                                    AND mrb.meeting_date between '$fromDate' and '$toDate'
                                ORDER BY
                                    `mrb`.`meeting_id`
                                DESC
                                    ");
        

        return view('meeting_room.meeting_report',compact('header','results','roomInfo')); 
    }

    public function meetingRoomReport(Request $request){
        
        $header = array(
            'pageTitle' => 'Meeting',
            'tableTitle' => ''
        );

        $fromDate = date('Y-m-d',strtotime($request->fromDate));
        $toDate = date('Y-m-d',strtotime($request->toDate));
        $roomId = $request->roomId;
        $statusId = $request->statusId;

        $condition = "";

        if(!empty($roomId)){
            $condition .= " and mrb.room_id = '$roomId' ";
        }

        if(!empty($statusId)){
            $condition .= " and mrb.meeting_status = '$statusId' ";
        }

        $results = DB::select("SELECT
                                    mrb.*,
                                    lkp.LOOKUP_DATA_NAME AS room_name
                                FROM
                                    meeting_room_booking mrb, sa_lookup_data lkp

                                WHERE  mrb.room_id = lkp.LOOKUP_DATA_ID
                                and
                                    mrb.active_status = 1 AND mrb.meeting_status != 0
                                    AND mrb.meeting_date between '$fromDate' and '$toDate'

                                    $condition
                                ORDER BY
                                    `mrb`.`meeting_id`
                                DESC
                                    ");

        return view('meeting_room.searchMeetingRoomReport',compact('header','fromDate','toDate','results'));

    }
    public function selfMeetingIndex(){
        $header = array(
            'pageTitle' => 'Meeting',
            'tableTitle' => ''
        );

        /*$empId = Auth::user()->employee_id;
        $results = DB::select("SELECT mb.meeting_id,mp.meeting_date,TIME_FORMAT(SEC_TO_TIME(mp.start_time), '%h:%i %p') as start_time ,TIME_FORMAT(SEC_TO_TIME(mp.end_time), '%h:%i %p') as end_time ,mb.meeting_title,mb.meeting_desc,mb.particular_id,
        (SELECT COUNT(participant_id) FROM meeting_participent WHERE meeting_id = mb.meeting_id) as total_participent,mb.guest,mb.no_of_guest,lkp.lookup_data_name as room_no,mb.meeting_status,mb.created_by
        FROM meeting_participent as mp, meeting_room_booking mb,sa_lookup_data as lkp
        WHERE mp.meeting_id = mb.meeting_id
        AND mb.room_id = lkp.lookup_data_id
        and mp.participant_id =$empId
        and mb.active_status = 1
        ORDER by mp.meeting_id desc");*/

        $empId = Auth::user()->employee_id;
        $createdId = Auth::user()->id;
        $results = DB::select("SELECT distinct mb.meeting_id,mp.meeting_date,TIME_FORMAT(SEC_TO_TIME(mp.start_time), '%h:%i %p') as start_time ,TIME_FORMAT(SEC_TO_TIME(mp.end_time), '%h:%i %p') as end_time ,mb.meeting_title,mb.meeting_desc,mb.particular_id,
        (SELECT COUNT(participant_id) FROM meeting_participent WHERE meeting_id = mb.meeting_id) as total_participent,mb.guest,mb.no_of_guest,lkp.lookup_data_name as room_no,mb.meeting_status,mb.created_by
        FROM meeting_participent as mp, meeting_room_booking mb,sa_lookup_data as lkp
        WHERE mp.meeting_id = mb.meeting_id
        AND mb.room_id = lkp.lookup_data_id
        and ( mp.participant_id =$empId OR mb.created_by = $createdId)
        and mb.active_status = 1
        ORDER by mp.meeting_id desc");

         foreach( $results as $key => $meeting ) {
                    
            $results[ $key]->participent = DB::select("SELECT mp.participant_id,emp.employee_name FROM meeting_participent as mp, npoly_employees as emp
            WHERE mp.participant_id = emp.employee_id
            AND mp.meeting_id = $meeting->meeting_id
            ORDER BY emp.user_serial_no");
            $particularIdIn = $meeting->particular_id?$meeting->particular_id:0;
            $results[ $key]->services = DB::select("SELECT par.particular_id,par.name,par.icon  FROM meeting_particular par 
            WHERE par.particular_id in ($particularIdIn)");

        }

        return view('meeting_room.my_meeting',compact('header','results'));

    }
    public function meetingDetails(Request $request, $meetingId){

        $header = array(
            'pageTitle' => 'Meeting',
            'tableTitle' => ''
        );
        
        $results = DB::selectOne("SELECT mb.meeting_id,mp.meeting_date,TIME_FORMAT(SEC_TO_TIME(mp.start_time), '%h:%i %p') as start_time ,TIME_FORMAT(SEC_TO_TIME(mp.end_time), '%h:%i %p') as end_time ,mb.meeting_title,mb.meeting_desc,mb.particular_id,
        (SELECT COUNT(participant_id) FROM meeting_participent WHERE meeting_id = mb.meeting_id) as total_participent,mb.guest,mb.no_of_guest,lkp.lookup_data_name as room_no,mb.meeting_status,mb.created_by
        FROM meeting_participent as mp, meeting_room_booking mb,sa_lookup_data as lkp
        WHERE mp.meeting_id = mb.meeting_id
        AND mb.room_id = lkp.lookup_data_id
        and mp.meeting_id =$meetingId
        and mb.active_status = 1
        ORDER by mp.meeting_id desc");

        //  foreach( $results as $key => $meeting ) {
                    
        //     $results[ $key]->participent = DB::select("SELECT mp.participant_id,emp.employee_name FROM meeting_participent as mp, npoly_employees as emp
        //     WHERE mp.participant_id = emp.employee_id
        //     AND mp.meeting_id = $meeting->meeting_id
        //     ORDER BY emp.user_serial_no");
        //     $particularIdIn = $meeting->particular_id?$meeting->particular_id:0;
        //     $results[ $key]->services = DB::select("SELECT par.particular_id,par.name,par.icon  FROM meeting_particular par 
        //     WHERE par.particular_id in ($particularIdIn)");

        // }
        //dd($results);
        return view('meeting_room.meeting_details',compact('header','results'));

    }

    public function create()  {
        $header = array(
            'pageTitle' => 'Schedule',
            'tableTitle' => ''
        );

        // $employees = DB::table('npoly_employees')
        //                 ->select('employee_id','employee_name')
        //                 ->where('active_status',1)
        //                 ->orderBy('user_serial_no','asc')
        //                 ->get();
        $employees = DB::table('npoly_employees as emp')
        ->leftJoin('set_department as dept','emp.department_id','=','dept.id')
        ->select('emp.employee_id','emp.employee_name','dept.department_name')
        ->where('emp.active_status',1)
        ->orderBy('emp.user_serial_no','asc')
        ->get();

        $roomInfo = DB::table('sa_lookup_data')
                    ->select('LOOKUP_DATA_ID','LOOKUP_DATA_NAME')
                    ->where('LOOKUP_GRP_ID',46)
                    ->where('ACTIVE_FLAG',1)
                    ->get();
        $particular = DB::table('meeting_particular')
                        ->select('particular_id','name')
                        ->where('active_status',1)
                        ->get();

        return view('meeting_room.create',compact('header','employees','roomInfo','particular'));
    }
       static function isTimeRangeOverlap($start1, $end1, $ranges) {
        //$range1_start = $start1;
       // $range1_end = $end1;
    
        foreach ($ranges as $range) {
            $range_start = $range->start_time;
            $range_end = $range->end_time;
    
            // Check if the ranges overlap
            //if ($range1_start < $range_end && $range1_end > $range_start) {
            if ($start1 < $range_end && $end1 > $range_start) {
                return true;
            }
        }
    
        return false;
    }

    public function checkRoom(Request $request){
      $roomId = $request->roomId;
      $meetingDate = date('Y-m-d',strtotime($request->createDate));
      $startTime = $request->startSecond;
      $endTime = $request->endSecond;

      $ranges = DB::table('meeting_room_booking')
                        ->select('start_time','end_time')
                        ->where('room_id',$roomId)
                        ->where('meeting_date',$meetingDate)
                        ->where('active_status',1)
                        ->where('meeting_status',1)
                        ->get();

        if ($this::isTimeRangeOverlap($startTime, $endTime, $ranges)) {
           return 1;
        } else {
            return 2;
        }
    }
    public function checkEmpMeeting(Request $request){
        $employeeId = $request->employeeId;
        $meetingDate = date('Y-m-d',strtotime($request->createDate));
        $startTime = $request->startSecond;
        $endTime = $request->endSecond;
  
        /*$ranges = DB::table('meeting_participent')
                          ->select('start_time','end_time')
                          ->where('meeting_date',$meetingDate)
                          ->where('participant_id',$employeeId)
                          ->where('active_status',1)
                          ->get(); */
        $ranges = DB::table('meeting_participent as mp')
        ->leftJoin('meeting_room_booking as mb','mp.meeting_id','=','mb.meeting_id')
        ->select('mp.start_time','mp.end_time')
        ->where('mp.meeting_date',$meetingDate)
        ->where('mp.participant_id',$employeeId)
        ->where('mp.active_status',1)
        ->where('mb.meeting_status','!=',2)
        ->get();

          if ($this::isTimeRangeOverlap($startTime, $endTime, $ranges)) {
             return 1;
          } else {
              return 2;
          }
      }

    public function store(Request $request) {
  
    $roomBookedStatus = $request->room_booked;
    if($roomBookedStatus !='1'){

        $startTime = strtotime($request->start_time) - strtotime('today');
        $endTime = strtotime($request->end_time) - strtotime('today');

        $participentId = implode(',',$request->employee_id);
        $particular_id = implode(',',$request->particular_id ? $request->particular_id:[]);

        $insertInfo = DB::table('meeting_room_booking')->insert([
            "room_id"=> $request->room_id,
            "meeting_title"=> $request->meeting_title,
            "meeting_desc"=> $request->meeting_desc,
            "meeting_date"=> date('Y-m-d',strtotime($request->meeting_date)),
            "start_time"=> $startTime,
            "end_time"=> $endTime,
            "participant_id"=> $participentId ? $participentId :"",
            "guest"=>$request->guest,
            "no_of_guest"=>$request->guest_no ?$request->guest_no:0,
            "particular_id"=> $particular_id ? $particular_id:"",
           // "remarks"=> $request->remarks,
            "active_status"=> 1,
            "created_by"=> Auth::user()->id,
           ]);

           // insert participent info
           $participents = $request->employee_id;
           $lastMeetingId = DB::selectOne("SELECT max(meeting_id) meeting_id FROM meeting_room_booking");
           foreach($participents as $key => $value){
            $insertInfo = DB::table('meeting_participent')->insert([
                "room_id"=> $request->room_id,
                "meeting_id"=> $lastMeetingId->meeting_id,
                "meeting_date"=> date('Y-m-d',strtotime($request->meeting_date)),
                "start_time"=> $startTime,
                "end_time"=> $endTime,
                "participant_id"=> $value,
                "active_status"=> 1,
                "created_by"=> Auth::user()->id,
               ]);
           }
           //    // Mail to meeting participant 
          
           $userInfo = DB::table('users')->select('name','department_name','designation_name','email_address','contact_no')->where('id',Auth::user()->id)->first();
           
           $data['title'] = $request->meeting_title;
           $data['description'] =$request->meeting_desc;
           $data['meeting_date'] = date('d-M-Y',strtotime($request->meeting_date));
           $data['start_time'] = $request->start_time;
           $data['end_time'] = $request->end_time;
           $data['name'] = $userInfo->name;
           $data['department_name'] = $userInfo->department_name;
           $data['designation_name'] = $userInfo->designation_name;
           $data['email_address'] = $userInfo->email_address;
           $data['contact_no'] = $userInfo->contact_no;

           $data['room_no'] = DB::table('sa_lookup_data')->select('lookup_data_name')->where('lookup_data_id',$request->room_id)->first()->lookup_data_name;

           $to_mail = 'admnpil@nationalpolymer.net';
           //$to_mail = 'azam.ali@nationalpolymer.net';
           $sent = Mail::send('emails.admin_meeting_mail', $data, function ($email) use ($data, $to_mail) {
            $email->subject($data['title']);
            $email->from('ticket@nationalpolymer.net');
            $email->to($to_mail);
            //$email->cc($ccToMail);
            //$email->bcc($report_bcc_to_mail);
        });

        Session::flash('success', 'Data Saved successfully!');
        return redirect()->route('selfMeetingIndex');
    }else{
        Session::flash('error', 'This room is not available in this time !');
        return redirect()->route('selfMeetingIndex');
    }
   
    }

    public function update(Request $request, $id){
        if($_POST){
            $roomBookedStatus = $request->room_booked;
            if($roomBookedStatus !='1'){
                $startTime = strtotime($request->start_time) - strtotime('today');
                $endTime = strtotime($request->end_time) - strtotime('today');
        
                $participentId = implode(',',$request->employee_id ? $request->employee_id:[]);
                $particular_id = implode(',',$request->particular_id ? $request->particular_id:[]);
                
        
                $insertInfo = DB::table('meeting_room_booking')->where('meeting_id',$id)->update([
                    "room_id"=> $request->room_id,
                    "meeting_title"=> $request->meeting_title,
                    "meeting_desc"=> $request->meeting_desc,
                    "meeting_date"=> date('Y-m-d',strtotime($request->meeting_date)),
                    "start_time"=> $startTime,
                    "end_time"=> $endTime,
                    "participant_id"=> $participentId,
                    //"remarks"=> $request->remarks,
                    "guest"=>$request->guest,
                    "no_of_guest"=>$request->guest_no,
                    "particular_id"=> $particular_id,
                    "active_status"=>$request->active_status,
                    "updated_by"=> Auth::user()->id,
                    "updated_at"=> date('Y-m-d h:i:s A'),
                   ]);

                   // insert meeting participent 
                   $deleteParticipent = DB::table('meeting_participent')->where('meeting_id',$id)->delete();
                   $participents = $request->employee_id;
                   
                   foreach($participents as $key => $value){
                    $insertInfo = DB::table('meeting_participent')->insert([
                        "room_id"=> $request->room_id,
                        "meeting_id"=> $id,
                        "meeting_date"=> date('Y-m-d',strtotime($request->meeting_date)),
                        "start_time"=> $startTime,
                        "end_time"=> $endTime,
                        "participant_id"=> $value,
                        "active_status"=> 1,
                        "created_by"=> Auth::user()->id,
                       ]);
                   }//    // Mail to meeting participant 

           if($request->active_status =='1'){
            $userInfo = DB::table('users')->select('name','department_name','designation_name','email_address','contact_no')->where('id',Auth::user()->id)->first();
           
                $data['title'] = $request->meeting_title;
                $data['description'] =$request->meeting_desc;
                $data['meeting_date'] = date('d-M-Y',strtotime($request->meeting_date));
                $data['start_time'] = $request->start_time;
                $data['end_time'] = $request->end_time;
                $data['name'] = $userInfo->name;
                $data['department_name'] = $userInfo->department_name;
                $data['designation_name'] = $userInfo->designation_name;
                $data['email_address'] = $userInfo->email_address;
                $data['contact_no'] = $userInfo->contact_no;

                $data['room_no'] = DB::table('sa_lookup_data')->select('lookup_data_name')->where('lookup_data_id',$request->room_id)->first()->lookup_data_name;

                $to_mail = 'admnpil@nationalpolymer.net';
                //$to_mail = 'azam.ali@nationalpolymer.net';
                $sent = Mail::send('emails.admin_meeting_mail', $data, function ($email) use ($data, $to_mail) {
                    $email->subject($data['title']);
                    $email->from('ticket@nationalpolymer.net');
                    $email->to($to_mail);
                    //$email->cc($ccToMail);
                    //$email->bcc($report_bcc_to_mail);
                });
           }
          
           

                Session::flash('success', 'Data Updated successfully!');
                return redirect()->route('selfMeetingIndex');
            }else{
                Session::flash('error', 'This room is not available in this time !');
                return redirect()->route('selfMeetingIndex');
            } 
        }else{
            $result = DB::table('meeting_room_booking')->select('*')->where('meeting_id',$id)->first();

        // $employees = DB::table('npoly_employees')
        // ->select('employee_id','employee_name')
        // ->where('active_status',1)
        // ->orderBy('user_serial_no','asc')
        // ->get();
        $employees = DB::table('npoly_employees as emp')
        ->leftJoin('set_department as dept','emp.department_id','=','dept.id')
        ->select('emp.employee_id','emp.employee_name','dept.department_name')
        ->where('emp.active_status',1)
        ->orderBy('emp.user_serial_no','asc')
        ->get();

        $roomInfo = DB::table('sa_lookup_data')
                    ->select('LOOKUP_DATA_ID','LOOKUP_DATA_NAME')
                    ->where('LOOKUP_GRP_ID',46)
                    ->where('ACTIVE_FLAG',1)
                    ->get();
            
        $participent = DB::select("select employee_id from npoly_employees where employee_id in($result->participant_id)");
        $particularId = $result->particular_id;
        $particularIds = [];
        if(!empty($particularId)){
            $particularIds []= DB::select("select particular_id from meeting_particular where particular_id in($particularId)"); 
        }
        if(!empty($particularIds)){
            $particularIds = $particularIds[0];
        }else{
            $particularIds = [];
        }
        $particular = DB::table('meeting_particular')
                        ->select('particular_id','name')
                        ->where('active_status',1)
                        ->get();
       

        return view('meeting_room.update',compact('employees','roomInfo','result','participent','particular','particularIds')); 
        }

       
       
    }
    public function updateMeetingStatus1(Request $request, $id){
        if($_POST){
                $insertInfo = DB::table('meeting_room_booking')->where('meeting_id',$id)->update([
                    "meeting_status"=>$request->meeting_status,
                    "approve_by"=> $request->meeting_status == '1' ? Auth::user()->id:"",
                    "approve_date"=> $request->meeting_status == '1' ? date('Y-m-d h:i:s A'):"",
                    "cancle_by"=>  $request->meeting_status == '2' ? Auth::user()->id:"",
                    "cancle_date"=> $request->meeting_status == '2' ? date('Y-m-d h:i:s A'):"",
                   ]);

                  /* if($request->meeting_status == '1'){
                    $meetingInfo = DB::table('meeting_room_booking as m')
                    ->leftJoin('users as usr','usr.id','=','m.created_by')
                    ->select('m.*','usr.email_address')
                    ->where('meeting_id',$id)
                    ->first();
                    $participantMail = DB::select("select email from npoly_employees where employee_id in ($meetingInfo->participant_id) and active_status = 1");
                    $array_values= [];
                    foreach($participantMail as $array)
                    {
                        $array_values[]=$array->email;
                    }

                    $ccToMail =  array_values($array_values);
                    $data['title'] = $meetingInfo->meeting_title;
                    $data['description'] =$meetingInfo->meeting_desc;
                    $data['meeting_date'] = date('d-M-Y',strtotime($meetingInfo->meeting_date));
                    $data['start_time'] = $meetingInfo->start_time;
                    $data['end_time'] = $meetingInfo->end_time;
                    $data['update_meeting'] = 0;
                    $data['room_no'] = DB::table('sa_lookup_data')->select('lookup_data_name')->where('lookup_data_id',$meetingInfo->room_id)->first()->lookup_data_name;

                    //$to_mail = 'adminnpil@nationalpolymer.net';
                    $to_mail = $meetingInfo->email_address;
                    $sent = Mail::send('emails.meeting_mail', $data, function ($email) use ($data, $to_mail,$ccToMail) {
                        $email->subject($data['title']);
                        $email->from('ticket@nationalpolymer.net');
                        $email->to($to_mail);
                        $email->cc($ccToMail);
                        //$email->bcc($report_bcc_to_mail);
                    });
                   }else{
                    //    // Mail to meeting participant 
                    //    $participantMail = DB::select("select email from npoly_employees where employee_id in ($participentId) and active_status = 1");
                    //    $array_values= [];
                    //    foreach($participantMail as $array)
                    //    {
                    //        $array_values[]=$array->email;
                    //    }

                    //    $ccToMail =  array_values($array_values);
                    //    $data['title'] = $input['meeting_title'];
                    //    $data['description'] = $input['meeting_desc'];
                    //    $data['description'] = $input['meeting_desc'];
                    //    $data['meeting_date'] = date('d-M-Y',strtotime($input['meeting_date']));
                    //    $data['start_time'] = $input['start_time'];
                    //    $data['end_time'] = $input['end_time'];
                    //    $data['update_meeting'] = 0;
                    //    $data['room_no'] = DB::table('sa_lookup_data')->select('lookup_data_name')->where('lookup_data_id',$input['room_id'])->first()->lookup_data_name;

                    //    $to_mail = 'adminnpil@nationalpolymer.net';
                    //    $sent = Mail::send('emails.meeting_mail', $data, function ($email) use ($data, $to_mail,$ccToMail) {
                    //     $email->subject($data['title']);
                    //     $email->from('ticket@nationalpolymer.net');
                    //     $email->to($to_mail);
                    //     $email->cc($ccToMail);
                    //     //$email->bcc($report_bcc_to_mail);
                    // });
                   }*/

                   if($request->meeting_status == '1'){
                    $meetingInfo = DB::table('meeting_room_booking as m')
                    ->leftJoin('users as usr','usr.id','=','m.created_by')
                    ->select('m.*','usr.email_address')
                    ->where('meeting_id',$id)
                    ->first();
                    $participantMail = DB::select("select email from npoly_employees where employee_id in ($meetingInfo->participant_id) and active_status = 1");
                    $array_values= [];
                    foreach($participantMail as $array)
                    {
                        $array_values[]=$array->email;
                    }

                    $ccToMail =  array_values($array_values);
                    $data['title'] = $meetingInfo->meeting_title;
                    $data['description'] =$meetingInfo->meeting_desc;
                    $data['meeting_date'] = date('d-M-Y',strtotime($meetingInfo->meeting_date));
                    $data['start_time'] = $meetingInfo->start_time;
                    $data['end_time'] = $meetingInfo->end_time;
                    $data['update_meeting'] = 0;
                    $data['room_no'] = DB::table('sa_lookup_data')->select('lookup_data_name')->where('lookup_data_id',$meetingInfo->room_id)->first()->lookup_data_name;

                    //$to_mail = 'adminnpil@nationalpolymer.net';
                    $to_mail = $meetingInfo->email_address;
                    $sent = Mail::send('emails.meeting_mail', $data, function ($email) use ($data, $to_mail,$ccToMail) {
                        $email->subject($data['title']);
                        $email->from('ticket@nationalpolymer.net');
                        $email->to($to_mail);
                        $email->cc($ccToMail);
                        //$email->bcc($report_bcc_to_mail);
                    });
                   }else if($request->meeting_status == '2'){
                    if($statusCheck->meeting_status =='1'){
                        $meetingInfo = DB::table('meeting_room_booking as m')
                        ->leftJoin('users as usr','usr.id','=','m.created_by')
                        ->select('m.*','usr.email_address')
                        ->where('meeting_id',$id)
                        ->first();
                        $participantMail = DB::select("select email from npoly_employees where employee_id in ($meetingInfo->participant_id) and active_status = 1");
                        $array_values= [];
                        foreach($participantMail as $array)
                        {
                            $array_values[]=$array->email;
                        }
    
                        $ccToMail =  array_values($array_values);
                        $data['title'] = $meetingInfo->meeting_title;
                        $data['description'] =$meetingInfo->meeting_desc;
                        $data['meeting_date'] = date('d-M-Y',strtotime($meetingInfo->meeting_date));
                        $data['start_time'] = $meetingInfo->start_time;
                        $data['end_time'] = $meetingInfo->end_time;
                        $data['update_meeting'] = 2;
                        $data['room_no'] = DB::table('sa_lookup_data')->select('lookup_data_name')->where('lookup_data_id',$meetingInfo->room_id)->first()->lookup_data_name;
    
                        //$to_mail = 'adminnpil@nationalpolymer.net';
                        $to_mail = $meetingInfo->email_address;
                        $sent = Mail::send('emails.cancel_meeting_mail', $data, function ($email) use ($data, $to_mail,$ccToMail) {
                            $email->subject($data['title']);
                            $email->from('ticket@nationalpolymer.net');
                            $email->to($to_mail);
                            $email->cc($ccToMail);
                            //$email->bcc($report_bcc_to_mail);
                        });
                    }  
                   }else{
                   }
                  
                Session::flash('success', 'Data Updated successfully!');
                return redirect()->route('meetingIndex');
             
        }else{
            $result = DB::table('meeting_room_booking')->select('*')->where('meeting_id',$id)->first();

        $employees = DB::table('npoly_employees')
        ->select('employee_id','employee_name')
        ->where('active_status',1)
        ->orderBy('user_serial_no','asc')
        ->get();

        $roomInfo = DB::table('sa_lookup_data')
                    ->select('LOOKUP_DATA_ID','LOOKUP_DATA_NAME')
                    ->where('LOOKUP_GRP_ID',46)
                    ->where('ACTIVE_FLAG',1)
                    ->get();
            
        $participent = DB::select("select employee_id from npoly_employees where employee_id in($result->participant_id)");
        $particularId = $result->particular_id;
        $particularIds = [];
        if(!empty($particularId)){
            $particularIds []= DB::select("select particular_id from meeting_particular where particular_id in($particularId)"); 
        }
        if(!empty($particularIds)){
            $particularIds = $particularIds[0];
        }else{
            $particularIds = [];
        }
        $particular = DB::table('meeting_particular')
                        ->select('particular_id','name')
                        ->where('active_status',1)
                        ->get();
        
        $creatorInfo = DB::table('users')->select('*')->where('id',$result->created_by)->first();
       

        return view('meeting_room.change_meeting_status',compact('employees','roomInfo','result','participent','particular','particularIds','creatorInfo')); 
        }

       
       
    }
    
    public function updateMeetingStatus(Request $request, $id){
        if($_POST){

                $statusCheck = DB::table('meeting_room_booking')->select('meeting_status')->where('meeting_id',$id)->first()->meeting_status;
                
                $setMeetingStatus = $request->room_booked_status !=2 ? 2 :$request->meeting_status;
                $insertInfo = DB::table('meeting_room_booking')->where('meeting_id',$id)->update([
                    "meeting_status"=>$setMeetingStatus,
                    "approve_by"=> $setMeetingStatus == '1' ? Auth::user()->id:"",
                    "approve_date"=> $setMeetingStatus == '1' ? date('Y-m-d h:i:s A'):"",
                    "cancle_by"=>  $setMeetingStatus == '2' ? Auth::user()->id:"",
                    "cancle_date"=> $setMeetingStatus == '2' ? date('Y-m-d h:i:s A'):"",
                   ]);

                   if($setMeetingStatus == '1'){
                    $meetingInfo = DB::table('meeting_room_booking as m')
                    ->leftJoin('users as usr','usr.id','=','m.created_by')
                    ->select('m.*','usr.email_address')
                    ->where('meeting_id',$id)
                    ->first();
                    $participantMail = DB::select("select email from npoly_employees where employee_id in ($meetingInfo->participant_id) and active_status = 1");
                    $array_values= [];
                    foreach($participantMail as $array)
                    {
                        $array_values[]=$array->email;
                    }

                    $ccToMail =  array_values($array_values);
                    $data['title'] = $meetingInfo->meeting_title;
                    $data['description'] =$meetingInfo->meeting_desc;
                    $data['meeting_date'] = date('d-M-Y',strtotime($meetingInfo->meeting_date));
                    $data['start_time'] = $meetingInfo->start_time;
                    $data['end_time'] = $meetingInfo->end_time;
                    $data['update_meeting'] = 0;
                    $data['room_no'] = DB::table('sa_lookup_data')->select('lookup_data_name')->where('lookup_data_id',$meetingInfo->room_id)->first()->lookup_data_name;

                    //$to_mail = 'adminnpil@nationalpolymer.net';
                    $to_mail = $meetingInfo->email_address;
                    $sent = Mail::send('emails.meeting_mail', $data, function ($email) use ($data, $to_mail,$ccToMail) {
                        $email->subject($data['title']);
                        $email->from('ticket@nationalpolymer.net');
                        $email->to($to_mail);
                        $email->cc($ccToMail);
                        //$email->bcc($report_bcc_to_mail);
                    });
                   }else if($setMeetingStatus == '2'){
                    $meetingInfo = DB::table('meeting_room_booking as m')
                        ->leftJoin('users as usr','usr.id','=','m.created_by')
                        ->select('m.*','usr.email_address')
                        ->where('meeting_id',$id)
                        ->first();

                        $data['title'] = $meetingInfo->meeting_title;
                        $data['description'] =$meetingInfo->meeting_desc;
                        $data['meeting_date'] = date('d-M-Y',strtotime($meetingInfo->meeting_date));
                        $data['start_time'] = $meetingInfo->start_time;
                        $data['end_time'] = $meetingInfo->end_time;
                        $data['update_meeting'] = 2;
                        $data['room_no'] = DB::table('sa_lookup_data')->select('lookup_data_name')->where('lookup_data_id',$meetingInfo->room_id)->first()->lookup_data_name;
                       
                        $to_mail = $meetingInfo->email_address;
                        $participantMail = DB::select("select email from npoly_employees where employee_id in ($meetingInfo->participant_id) and active_status = 1");
                        $array_values= [];
                        foreach($participantMail as $array)
                        {
                            $array_values[]=$array->email;
                        }

                        $ccToMail =  $statusCheck =='1' ?  array_values($array_values) :[];
                        
                        $sent = Mail::send('emails.cancel_meeting_mail', $data, function ($email) use ($data, $to_mail,$ccToMail) {
                            $email->subject($data['title']);
                            $email->from('ticket@nationalpolymer.net');
                            $email->to($to_mail);
                            $email->cc($ccToMail);
                            //$email->bcc($report_bcc_to_mail);
                        }); 
                   }else{

                   }
                  
                Session::flash('success', 'Data Updated successfully!');
                return redirect()->route('meetingIndex');
             
        }else{

       $result = DB::table('meeting_room_booking')->select('*')->where('meeting_id',$id)->first();

        $employees = DB::table('npoly_employees')
        ->select('employee_id','employee_name')
        ->where('active_status',1)
        ->orderBy('user_serial_no','asc')
        ->get();

        $roomInfo = DB::table('sa_lookup_data')
                    ->select('LOOKUP_DATA_ID','LOOKUP_DATA_NAME')
                    ->where('LOOKUP_GRP_ID',46)
                    ->where('ACTIVE_FLAG',1)
                    ->get();
            
        $participent = DB::select("select employee_id from npoly_employees where employee_id in($result->participant_id)");
        $particularId = $result->particular_id;
        $particularIds = [];
        if(!empty($particularId)){
            $particularIds []= DB::select("select particular_id from meeting_particular where particular_id in($particularId)"); 
        }
        if(!empty($particularIds)){
            $particularIds = $particularIds[0];
        }else{
            $particularIds = [];
        }
        $particular = DB::table('meeting_particular')
                        ->select('particular_id','name')
                        ->where('active_status',1)
                        ->get();
        
        $creatorInfo = DB::table('users')->select('*')->where('id',$result->created_by)->first();
        
        $startTime = $result->start_time;
        $endTime = $result->end_time;
        $meetingDate =  date('Y-m-d',strtotime($result->meeting_date));

        $isBooked = DB::table('meeting_room_booking')
            ->where('room_id', $result->room_id)
            ->where('meeting_date', $meetingDate)
            ->where('meeting_id', '!=',$result->meeting_id)
            ->where('meeting_status', 1) // 1 means room is booked
            ->where(function ($query) use ($startTime, $endTime) {
                $query->where(function ($q) use ($startTime, $endTime) {
                    $q->where('start_time', '<', $endTime)
                    ->where('end_time', '>', $startTime);
                });
            })
            ->first();

            $bookedMeetinId = $isBooked ? $isBooked->meeting_id : 2;

        return view('meeting_room.change_meeting_status',compact('employees','roomInfo','result','participent','particular','particularIds','creatorInfo','bookedMeetinId')); 
        }

       
       
    }

    public function availableTimeSlot(Request $request){
      $roomId = $request->roomId;
      $meetingDate = date('Y-m-d',strtotime($request->createDate));
        
        $existingTimeSlots = DB::select("SELECT TIME_FORMAT(SEC_TO_TIME(start_time), '%h:%i %p') AS start_times,TIME_FORMAT(SEC_TO_TIME(end_time), '%h:%i %p') AS end_times FROM meeting_room_booking
        WHERE room_id = $roomId
        AND meeting_date = '$meetingDate'
        and active_status = 1
        and meeting_status = 1
        ORDER by start_time asc");
        
        $dayStartTime = '9:00 AM';
        $dayEndTime = '6:00 PM';
       
        $dayStartTimeObj = new DateTime($dayStartTime);
        $dayEndTimeObj = new DateTime($dayEndTime);
        
       
        $availableTimeSlots = [];

        if(count($existingTimeSlots)> 0){
            if (strtotime($existingTimeSlots[0]->start_times) > strtotime($dayStartTime)) {
                $availableTimeSlots[] = [
                    'start_times' => $dayStartTime,
                    'end_times' => $existingTimeSlots[0]->start_times,
                ];
            }
            
            for ($i = 0; $i < count($existingTimeSlots) - 1; $i++) {
                $currentEndTimeObj = new DateTime($existingTimeSlots[$i]->end_times);
                $nextStartTimeObj = new DateTime($existingTimeSlots[$i + 1]->start_times);
               
                $gapStartTime = $currentEndTimeObj->format('h:i A');
                $gapEndTime = $nextStartTimeObj->format('h:i A');
               
                if ($currentEndTimeObj >= $dayStartTimeObj && $nextStartTimeObj <= $dayEndTimeObj) {
                    $availableTimeSlots[] = ['start_times' => $gapStartTime, 'end_times' => $gapEndTime];
                }
            }
           
            if (strtotime($existingTimeSlots[count($existingTimeSlots) - 1]->end_times) < strtotime($dayEndTime)) {
                $availableTimeSlots[] = [
                    'start_times' => $existingTimeSlots[count($existingTimeSlots) - 1]->end_times,
                    'end_times' => $dayEndTime,
                ];
            }
            
            $availableSlot = "";
            foreach ($availableTimeSlots as $key=> $slot) {
                if($key =='0'){
                    $availableSlot .= $slot['start_times'] . ' - ' . $slot['end_times'];
                }else{
                    $availableSlot .= ", ".$slot['start_times'] . ' - ' . $slot['end_times'] ;
                }
            }
            return $availableSlot;
        }else{
            return "09:00 AM - 06:00 PM";
        }
        
    }

    public function meetingParticular(){
        $header = array(
            'pageTitle' => 'Meeting Particular',
            'tableTitle' => ''
        );
       

        $results = DB::table('meeting_particular')
        ->select('particular_id','name','icon','active_status')
        ->orderBy('particular_id','desc')
        ->get();

        return view('meeting_particular.index',compact('header','results'));
    }

    public function createParticular(Request $request){
        $header = array(
            'pageTitle' => 'Meeting Particular',
            'tableTitle' => ''
        );
        return view('meeting_particular.create',compact('header'));
    }

    public function storeParticular(Request $request){
        $validated = $request->validate([
            'meeting_particular' => 'required',
            'particular_icon' => 'required',
        ]);
        try {
            DB::table('meeting_particular')->insert([
                "name"=> strtolower($request->meeting_particular),
                "icon"=> strtolower($request->particular_icon),
                "active_status"=> 1,
                "created_by"=> Auth::user()->id,
                "created_at"=> date('Y-m-d h:i:s A'),
            ]);
            Session::flash('success', 'Data Saved successfully!');
            return redirect()->route('meetingParticularSetupIndex');
          
          } catch (\Exception $e) {
            Session::flash('error', 'Somethigs Went Wrong!');
            return redirect()->route('meetingParticularSetupIndex');
              
          }
    }
    public function editParticular(Request $request, $id){
        if($_POST){
            try {
                DB::table('meeting_particular')->where('particular_id',$id)->update([
                    "name"=> strtolower($request->meeting_particular),
                    "icon"=> strtolower($request->particular_icon),
                    "active_status"=>$request->active_status,
                    "updated_by"=> Auth::user()->id,
                    "updated_at"=> date('Y-m-d h:i:s A'),
                ]);
                Session::flash('success', 'Data Updated successfully!');
                return redirect()->route('meetingParticularSetupIndex');
              
              } catch (\Exception $e) {
                Session::flash('error', 'Somethigs Went Wrong!');
                return redirect()->route('meetingParticularSetupIndex');
              }
        }else{
            $header = array(
                'pageTitle' => 'Meeting Particular',
                'tableTitle' => ''
            );
    
            $result = DB::table('meeting_particular')->select('*')->where('particular_id',$id)->first();
    
           return view('meeting_particular.update',compact('header','result'));
        }
    }
}
