<?php

namespace App\Http\Controllers\meal;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Session;
use App\Models\TicketModel;
use  App\Models\lookup\LookupGroupDataModel;
use DB;
use Auth;
use DatePeriod;
use DateTime;
use DateInterval;
use Illuminate\Support\Facades\Mail;

class MealController extends Controller
{
    public function index()
    {
        $header = array(
            'pageTitle' => 'Meal',
            'tableTitle' => ''
        );
        $today = date('Y-m-d');
        // $results = DB::table('employee_meal as m')
        //             ->leftJoin('npoly_employees as emp','emp.employee_id','=','m.employee_id')
        //             ->leftJoin('sa_lookup_data as lkp','lkp.lookup_data_id','=','emp.department_id')
        //             ->leftJoin('sa_lookup_data as lkp1','lkp1.lookup_data_id','=','emp.designation_id')
        //             ->select('m.meal_id','m.meal_date','m.meal_status','emp.employee_name','lkp.lookup_data_name as department_name','lkp1.lookup_data_name as designation_name')
        //             ->where('m.meal_date',$today)    
        //             ->orderBy('emp.user_serial_no')    
        //             ->get();
        // $results = DB::table('employee_meal as m')
        // ->leftJoin('npoly_employees as emp','emp.employee_id','=','m.employee_id')
        // ->leftJoin('set_department as dept','dept.id','=','emp.department_id')
        // ->leftJoin('set_designation as desig','desig.id','=','emp.designation_id')
        // ->select('m.meal_id','m.meal_date','m.meal_status','emp.employee_name','dept.department_name','desig.designation_name')
        // ->where('m.meal_date',$today)    
        // ->orderBy('emp.user_serial_no')    
        // ->get(); 
        $today = date('Y-m-d');
        $tomorrow = strtotime("+1 day");
        $tomorrowDate = date("Y-m-d", $tomorrow);
        
        $results = DB::table('employee_meal as m')
            ->leftJoin('npoly_employees as emp', 'emp.employee_id', '=', 'm.employee_id')
            ->leftJoin('set_department as dept', 'dept.id', '=', 'emp.department_id')
            ->leftJoin('set_designation as desig', 'desig.id', '=', 'emp.designation_id')
            ->select('m.meal_id', 'm.meal_date', 'm.meal_status', 'emp.employee_name', 'emp.employee_number', 'dept.department_name', 'desig.designation_name')
            ->whereBetween('m.meal_date', [$today, $tomorrowDate])
            ->orderBy('emp.user_serial_no')
            ->get();
        $employees = DB::table('npoly_employees')
                        ->select('employee_id','employee_name')
                        ->where('active_status',1)
                        ->orderBy('user_serial_no','asc')
                        ->get();


        return view('meal.index',compact('header','results','employees'));
    }

    public function mealSettingIndex() {
        $header = array(
            'pageTitle' => 'Meal Setting',
            'tableTitle' => ''
        );

        $results = DB::table('employee_meal_setting as ms')
                        ->leftJoin('npoly_employees as emp','emp.employee_id','=','ms.employee_id')
                        ->leftJoin('sa_lookup_data as lkp','lkp.lookup_data_id','=','emp.department_id')
                        ->leftJoin('sa_lookup_data as lkp1','lkp1.lookup_data_id','=','emp.designation_id')
                        ->select('emp.employee_name','lkp.lookup_data_name as department_name','lkp1.lookup_data_name as designation_name','meal_status','action_from','id')
                        ->get();
        $results = DB::table('employee_meal_setting as ms')
        ->leftJoin('npoly_employees as emp','emp.employee_id','=','ms.employee_id')
        ->leftJoin('set_department as dept','dept.id','=','emp.department_id')
        ->leftJoin('set_designation as desig','desig.id','=','emp.designation_id')
        ->select('emp.employee_name','dept.department_name','desig.designation_name','ms.meal_status','ms.action_from','ms.id')
        ->where('emp.active_status',1)
        ->get();

        return view('meal_setting.index',compact('header','results'));
    }

    public function createMealSetting(Request $request) {
        if($_POST){
            $employees = $request->employee_id;
            foreach($employees as $emp){
                DB::table('employee_meal_setting')->insert([
                    "employee_id" => $emp,
                    "meal_status" => $request->meal_status,
                    "action_from" => 1,
                    "active_status" => 1,
                    "created_by" => Auth::user()->id,
                ]);
            }

                Session::flash('success', 'Setting Create successfully!');
                return redirect()->route('mealSettingIndex'); 
            
        }else{

            $header = array(
                'pageTitle' => 'Meal Setting',
                'tableTitle' => ''
            );
            // $employees = DB::table('npoly_employees')
            // ->select('employee_id','employee_name','employee_id')
            // ->where('active_status',1)
            // ->get();
            $employees =   DB::select("select employee_id,employee_name from npoly_employees where active_status = 1 AND employee_id not in (select employee_id from employee_meal_setting) order by user_serial_no");
            
            return view('meal_setting.create',compact('header','employees'));  
        }
    }

    public function updateMealSetting(Request $request,$id)  {
        
        if($_POST){
            DB::table('employee_meal_setting')->where('id',$id)->update([
                "employee_id" => $request->employee_id,
                "meal_status" => $request->meal_status,
                "updated_by"=>Auth::user()->id,
                "updated_at" => date('Y-m-d h:i:s A')
            ]);
            Session::flash('success', 'Setting Updated successfully!');
            return redirect()->route('mealSettingIndex'); 
        }else{

            $header = array(
                'pageTitle' => 'Meal Setting',
                'tableTitle' => ''
            );
             $employees = DB::table('npoly_employees')
            ->select('employee_id','employee_name','employee_id')
            ->where('active_status',1)
            ->get();
            $result = DB::table('employee_meal_setting')->select('*')->where('id',$id)->first();
           /// dd($result);

            return view('meal_setting.update',compact('header','employees','result','id'));  
        }
    }

    public function guestMealIndex(){
        $header = array(
            'pageTitle' => 'Meal',
            'tableTitle' => ''
        );
        //guest_meal
        $userLvlId = Auth::user()->USERLVL_ID;
        $employeeId = Auth::user()->employee_id;
        $departmentId = Auth::user()->department_id;
        if($userLvlId =='7'){// employee
            $results = DB::table('guest_meal as gmeal')
            ->leftJoin('npoly_employees as emp','emp.employee_id','=','gmeal.request_emp')
            ->leftJoin('set_department as dept','dept.id','=','gmeal.department_id')
            ->select('gmeal.id','gmeal.meal_date','gmeal.total_meal','gmeal.request_status','gmeal.request_reason','emp.employee_name','dept.department_name')
            ->where('request_emp',$employeeId)
            ->where('gmeal.department_id', $departmentId)
            ->orderBy('gmeal.id','desc')
            ->get();
        }else if($userLvlId =='6' || $userLvlId =='16'){// admin
            $results = DB::table('guest_meal as gmeal')
            ->leftJoin('npoly_employees as emp','emp.employee_id','=','gmeal.request_emp')
            ->leftJoin('set_department as dept','dept.id','=','gmeal.department_id')
            ->select('gmeal.id','gmeal.meal_date','gmeal.total_meal','gmeal.request_status','gmeal.request_reason','emp.employee_name','dept.department_name')
            ->where('gmeal.active_status',1)
            ->where('gmeal.request_status','!=',1)
            ->orderBy('gmeal.id','desc')
            ->get();
        }else{// department
            $results = DB::table('guest_meal as gmeal')
            ->leftJoin('npoly_employees as emp','emp.employee_id','=','gmeal.request_emp')
            ->leftJoin('set_department as dept','dept.id','=','gmeal.department_id')
            ->select('gmeal.id','gmeal.meal_date','gmeal.total_meal','gmeal.request_status','gmeal.request_reason','emp.employee_name','dept.department_name')
            ->where('gmeal.department_id', $departmentId)
            ->orderBy('gmeal.id','desc')
            ->get();
        }

        return view('guest_meal.index',compact('header','results'));
    }

    public function guestMealCreate(Request $request){

        $header = array(
            'pageTitle' => 'Meal',
            'tableTitle' => ''
        );
        $employees = DB::table('npoly_employees')
        ->select('employee_id','employee_name','employee_id')
        ->where('active_status',1)
        ->get();

        return view('guest_meal.create',compact('header','employees'));
    }

    public function storeGuestMeal(Request $request){
        if($_POST){
            DB::table('guest_meal')->insert([
                "request_emp" => Auth::user()->employee_id,
                "department_id" => Auth::user()->department_id,
                "meal_date" => date('Y-m-d',strtotime($request->meal_date)),
                "total_meal" =>$request->total_meal,
                "request_reason" =>$request->request_reason,
                "request_status" =>1,
                "active_status" =>1,
                "created_by"=>Auth::user()->id,
                "created_at" => date('Y-m-d h:i:s A')
            ]);

            Session::flash('success', 'Guest Meal Request Successfully!');
            return redirect()->route('guestMealIndex'); 
        }
    }
    public function requestApprove(Request $request,$reqId){
        if($_POST){
            $userLvlId = Auth::user()->USERLVL_ID;
            if($userLvlId =="7"){
                DB::table('guest_meal')->where('id',$reqId)->update([
                    "meal_date" => date('Y-m-d',strtotime($request->meal_date)),
                    "total_meal" =>$request->total_meal,
                    "request_reason" =>$request->request_reason,
                    "request_status" =>$request->request_status,
                    "active_status" =>$request->active_status,
                    "updated_by"=>Auth::user()->id,
                    "updated_at" => date('Y-m-d h:i:s A')
                ]); 
                Session::flash('success', 'Guest Meal Updated Successfully!');
                return redirect()->route('guestMealIndex'); 
            }else if($userLvlId =="6"){
                DB::table('guest_meal')->where('id',$reqId)->update([
                    "admin_approve_id" =>Auth::user()->employee_id,
                    "request_status" =>$request->request_status,
                    "admin_approve_date" => date('Y-m-d h:i:s A')
                ]); 
                Session::flash('success', 'Guest Meal Updated Successfully!');
                return redirect()->route('guestMealIndex'); 
            }else{
                DB::table('guest_meal')->where('id',$reqId)->update([
                    "respective_person_id" =>Auth::user()->employee_id,
                    "request_status" =>$request->request_status,
                    "request_approve_date" => date('Y-m-d h:i:s A')
                ]); 
                Session::flash('success', 'Guest Meal Updated Successfully!');
                return redirect()->route('guestMealIndex'); 
            }
        }else{
            $header = array(
                'pageTitle' => 'Meal',
                'tableTitle' => ''
            );
            $userLvlId = Auth::user()->USERLVL_ID;
            $employeeId = Auth::user()->employee_id;
            if($userLvlId =="7"){
                $requestStatus = array("1"=>"Pending Requst","0"=>"Cancle Request");
            }else if($userLvlId =="6" || $userLvlId =="16"){
                $requestStatus = array("3"=>"Approve Requst","0"=>"Cancle Request");
            }else{
                $requestStatus = array("2"=>"Peinding Requst","0"=>"Cancle Request");
            }
            $result = DB::table('guest_meal')->select('*')->where('id',$reqId)->first();
            return view('guest_meal.update',compact('header','result','reqId','requestStatus')); 
        }
    }

    public function staffMealIndex(){
        $header = array(
            'pageTitle' => 'Meal',
            'tableTitle' => ''
        );

      $results = DB::table('employee_meal as meal')
        ->leftJoin('npoly_employees as emp', 'emp.employee_id', '=', 'meal.employee_id')
        ->leftJoin('set_department as dept', 'dept.id', '=', 'emp.department_id')
        ->select('*', 'emp.employee_name', 'dept.department_name')
        ->where('emp.designation_id', '=', 2)
        ->whereBetween('meal.meal_date', [now()->startOfDay(), now()->addDay()->endOfDay()])
        ->get();

        return view('staff_meal.index',compact('header','results'));
    }

    public function staffMealCreate(Request $request){
        if($_POST){
            $regularMeal = $request->regular_meal;
            if(!empty($regularMeal)){
                $empId = $request->employee_id;
                    $checkEmpMealSetting = DB::table('employee_meal_setting')->select('id')->where('employee_id',$empId)->first();
                    if(!empty($checkEmpMealSetting)){
                        $update = DB::table('employee_meal_setting')->where('id',$checkEmpMealSetting->id)->update([
                            "meal_status"=>$request->meal_status,
                            "updated_by"=>Auth::user()->id,
                            "updated_at"=>date('Y-m-d H:i:s A'),
                        ]);
                    }else{
                        $update = DB::table('employee_meal_setting')->insert([
                            "employee_id"=>$empId,
                            "meal_status"=>$request->meal_status,
                            "action_from"=>1,
                            "active_status"=>1,
                            "created_by"=>Auth::user()->id,
                            "created_at"=>date('Y-m-d H:i:s A'),
                        ]);
                    }
            }
            
            if(empty($regularMeal)){
                $insertMeal = DB::table('employee_meal')->insert([
                    "employee_id"=>$request->employee_id, 
                    "meal_date"=>date('Y-m-d',strtotime($request->meal_date)), 
                    "meal_status"=>1, 
                    "active_status"=>1, 
                    "created_by"=>Auth::user()->id, 
                    "created_at"=>date('Y-m-d H:i:s A'), 
                ]);
                Session::flash('success', 'Staff Meal Created Successfully!');
                return redirect()->route('staffMealIndex'); 

            }else{
                // change meal setting info
                    $empId = $request->employee_id;
                    $checkEmpMealSetting = DB::table('employee_meal_setting')->select('id')->where('employee_id',$empId)->first();
                    if(!empty($checkEmpMealSetting)){
                        $update = DB::table('employee_meal_setting')->where('id',$checkEmpMealSetting->id)->update([
                            "meal_status"=>$request->meal_status,
                            "updated_by"=>Auth::user()->id,
                            "updated_at"=>date('Y-m-d H:i:s A'),
                        ]);
                    }else{
                        $update = DB::table('employee_meal_setting')->insert([
                            "employee_id"=>$empId,
                            "meal_status"=>$request->meal_status,
                            "action_from"=>1,
                            "active_status"=>1,
                            "created_by"=>Auth::user()->id,
                            "created_at"=>date('Y-m-d H:i:s A'),
                        ]);
                    }

                $fromDate = date('Y-m-d', strtotime('+1 day'));
                $toDate = date('Y-m-t'); 
                $mealDateExpectFir = $this::getDatesExcludingFriday($fromDate,$toDate);
                foreach($mealDateExpectFir as $value){
                    // 
                    $insertMeal = DB::table('employee_meal')->insert([
                        "employee_id"=>$request->employee_id,
                        "meal_date"=>$value, 
                        "meal_status"=>1, 
                        "active_status"=>1, 
                        "created_by"=>Auth::user()->id, 
                        "created_at"=>date('Y-m-d H:i:s A'), 
                    ]);
                }
                Session::flash('success', 'Staff Meal Created Successfully!');
                return redirect()->route('staffMealIndex'); 
            }
            
        }else{
            $header = array(
                'pageTitle' => 'Staff Meal',
                'tableTitle' => ''
            );
            $staffEmployee = DB::table('npoly_employees')
            ->select('employee_id','employee_name')
            ->where('designation_id','2')
            ->whereNull('employee_number')
            ->get();
            
            return view('staff_meal.create',compact('header','staffEmployee'));
        }
    }
    public function updateStaffMeal(Request $request,$id){
        if($_POST){
           $regularMeal = $request->regular_meal;
           $mealDate = date('Y-m-d',strtotime($request->meal_date));
           if(empty($regularMeal)){ // staff single date meal update

            DB::table('employee_meal')->where('meal_id',$id)->where('meal_date',$mealDate)->update([
                "employee_id" => $request->employee_id,
                "meal_status" => $request->meal_status,
                "updated_by"=>Auth::user()->id,
                "updated_at" => date('Y-m-d h:i:s A')
            ]);
            Session::flash('success', 'Meal Updated successfully!');
            return redirect()->route('staffMealIndex'); 
           }else{
                    $empId = $request->employee_id;
                    $checkEmpMealSetting = DB::table('employee_meal_setting')->select('id')->where('employee_id',$empId)->first();
                    if(!empty($checkEmpMealSetting)){
                        $update = DB::table('employee_meal_setting')->where('id',$checkEmpMealSetting->id)->update([
                            "meal_status"=>$request->meal_status,
                            "updated_by"=>Auth::user()->id,
                            "updated_at"=>date('Y-m-d H:i:s A'),
                        ]);
                    }else{
                        $update = DB::table('employee_meal_setting')->insert([
                            "employee_id"=>$empId,
                            "meal_status"=>$request->meal_status,
                            "action_from"=>1,
                            "active_status"=>1,
                            "created_by"=>Auth::user()->id,
                            "created_at"=>date('Y-m-d H:i:s A'),
                        ]);
                    }

            $today = date('Y-m-d');
            $empId = $request->employee_id;
            
            $mealDate = DB::select("select meal_id, meal_date,meal_status from employee_meal where employee_id = $empId
            and meal_date > '$today'");

            if(!empty($mealDate)){
                foreach ($mealDate as $key => $value) {
                    $updateMeal = DB::table('employee_meal')->where('employee_id',$empId)->where('meal_date',$value->meal_date)->update([
                        "meal_status"=>$request->meal_status,
                        "active_status"=>1, 
                        "updated_by"=>Auth::user()->id, 
                        "updated_at"=>date('Y-m-d H:i:s A'), 
                    ]); 
                }
                Session::flash('success', 'Meal Updated successfully!');
                return redirect()->route('staffMealIndex'); 
            }else{

                $fromDate = date('Y-m-d', strtotime('+1 day'));
                $toDate = date('Y-m-t'); 
                $mealDateExpectFir = $this::getDatesExcludingFriday($fromDate,$toDate);
                $empId = $request->employee_id;
                foreach($mealDateExpectFir as $value){
                    // 
                    $insertMeal = DB::table('employee_meal')->insert([
                        "employee_id"=>$empId, 
                        "meal_date"=>$value, 
                        "meal_status"=>$request->meal_status,
                        "active_status"=>1, 
                        "created_by"=>Auth::user()->id, 
                        "created_at"=>date('Y-m-d H:i:s A'), 
                    ]);
                }
                Session::flash('success', 'Meal Updated successfully!');
                return redirect()->route('staffMealIndex'); 
            }
           }
        }else{
            $header = array(
                'pageTitle' => 'Staff Meal',
                'tableTitle' => ''
            );
           $result = DB::table('employee_meal')->select('*')->where('meal_id',$id)->first();
           $staffEmployee = DB::table('npoly_employees')
           ->select('employee_id','employee_name')
           ->where('designation_id','2')
           ->get();
           $checkRegMeal = DB::table('employee_meal_setting')->select('meal_status')->where('employee_id',$result->employee_id)->first();
           $regMealStatus = $checkRegMeal?$checkRegMeal->meal_status:"0";
           return view('staff_meal.update',compact('header','result','staffEmployee','id','regMealStatus'));
        }
    }

    public function updateMealInfo(Request $request, $id){
        if($_POST){
            DB::table('employee_meal')->where('meal_id',$id)->update([
                "meal_status" => $request->meal_status,
                "updated_by"=>Auth::user()->id,
                "updated_at" => date('Y-m-d h:i:s A')
            ]);
            if(Auth::user()->employee_id > 0){
                Session::flash('success', 'Meal Updated successfully!');
                return redirect()->route('selfMealIndex');   
            }else{
                Session::flash('success', 'Meal Updated successfully!');
                return redirect()->route('mealIndex'); 
            }
        }else{
            //$result = DB::table('employee_meal')->select('*')->where('meal_id',$id)->first(); 
            $header = array(
                'pageTitle' => 'Meal',
                'tableTitle' => ''
            );
            $result = DB::table('employee_meal as m')
            ->leftJoin('npoly_employees as emp','emp.employee_id','=','m.employee_id')
            ->leftJoin('set_department as dept','dept.id','=','emp.department_id')
            ->leftJoin('set_designation as desig','desig.id','=','emp.designation_id')
            ->select('m.meal_id','m.meal_date','m.meal_status','emp.employee_name','dept.department_name','desig.designation_name')
            ->where('m.meal_id',$id) 
            ->first(); 

            return view('meal.update',compact('header','result','id'));  
        }
    }
    public function selfMealIndex(){
        $header = array(
            'pageTitle' => 'Self Meal',
            'tableTitle' => ''
        );
        $employeeId = Auth::user()->employee_id;
        $results = DB::table('employee_meal as m')
                    ->leftJoin('npoly_employees as emp','emp.employee_id','=','m.employee_id')
                    ->leftJoin('sa_lookup_data as lkp','lkp.lookup_data_id','=','emp.department_id')
                    ->leftJoin('sa_lookup_data as lkp1','lkp1.lookup_data_id','=','emp.designation_id')
                    ->select('m.meal_id','m.meal_date','m.meal_status','emp.employee_name','lkp.lookup_data_name as department_name','lkp1.lookup_data_name as designation_name')
                    ->where('m.employee_id',$employeeId) 
                    ->orderBy('m.meal_id','desc') 
                    ->get(); 

        return view('self_meal.index',compact('header','results'));
    }

    public function selfMealIndexModify(){
        $header = array(
            'pageTitle' => 'Self Meal',
            'tableTitle' => ''
        );
        $employeeId = Auth::user()->employee_id;
        $results = DB::table('employee_meal as m')
                    ->leftJoin('npoly_employees as emp','emp.employee_id','=','m.employee_id')
                    ->leftJoin('sa_lookup_data as lkp','lkp.lookup_data_id','=','emp.department_id')
                    ->leftJoin('sa_lookup_data as lkp1','lkp1.lookup_data_id','=','emp.designation_id')
                    ->select('m.meal_id','m.meal_date','m.meal_status','emp.employee_name','lkp.lookup_data_name as department_name','lkp1.lookup_data_name as designation_name')
                    ->where('m.employee_id',$employeeId) 
                    ->orderBy('m.meal_id','desc') 
                    ->get();
        $fromDate = date('Y-m-01');
        $toDate = date('Y-m-t');
        $activeMeal = DB::select("select meal_date from employee_meal where employee_id = $employeeId  and meal_status = 1");
        $InactiveMeal = DB::select("select meal_date from employee_meal where employee_id = $employeeId  and meal_status = 0");

        $mealSetting = DB::table('employee_meal_setting')->select('meal_status')->where('employee_id',$employeeId)->first();
        

        return view('self_meal_modify.index',compact('header','results','activeMeal','InactiveMeal','mealSetting'));
    }

    public function staffMealIndexModify(){
        $header = array(
            'pageTitle' => 'Self Meal',
            'tableTitle' => ''
        );
        $staffEmployee = DB::table('npoly_employees')
        ->select('employee_id','employee_name','employee_number')
        //->where('designation_id','2')
        ->where('active_status','1')
        //->whereNull('employee_number')
        ->get();

        $employeeId = Auth::user()->employee_id;
        $results = DB::table('employee_meal as m')
                    ->leftJoin('npoly_employees as emp','emp.employee_id','=','m.employee_id')
                    ->leftJoin('sa_lookup_data as lkp','lkp.lookup_data_id','=','emp.department_id')
                    ->leftJoin('sa_lookup_data as lkp1','lkp1.lookup_data_id','=','emp.designation_id')
                    ->select('m.meal_id','m.meal_date','m.meal_status','emp.employee_name','lkp.lookup_data_name as department_name','lkp1.lookup_data_name as designation_name')
                    ->where('m.employee_id',$employeeId) 
                    ->orderBy('m.meal_id','desc') 
                    ->get();
        $fromDate = date('Y-m-01');
        $toDate = date('Y-m-t');
        $activeMeal = DB::select("select meal_date from employee_meal where employee_id = $employeeId  and meal_status = 1");
        $InactiveMeal = DB::select("select meal_date from employee_meal where employee_id = $employeeId  and meal_status = 0");

        $mealSetting = DB::table('employee_meal_setting')->select('meal_status')->where('employee_id',$employeeId)->first();
        

        return view('staff_meal_modify.index',compact('header','results','activeMeal','InactiveMeal','mealSetting','staffEmployee'));
    }
    public function searchStaffMealStatus(Request $request){
       if(!empty($request->empId)){
        $header = array(
            'pageTitle' => 'Self Meal',
            'tableTitle' => ''
        );
        $staffEmployee = DB::table('npoly_employees')
        ->select('employee_id','employee_name','employee_number')
        ->where('active_status','1')
        ->get();

        $employeeId = $request->empId;

        Session::put('employeeId',$employeeId);
        $sessionEmpId = session('employeeId');
        $employeeId = $sessionEmpId;

        $results = DB::table('employee_meal as m')
                    ->leftJoin('npoly_employees as emp','emp.employee_id','=','m.employee_id')
                    ->leftJoin('sa_lookup_data as lkp','lkp.lookup_data_id','=','emp.department_id')
                    ->leftJoin('sa_lookup_data as lkp1','lkp1.lookup_data_id','=','emp.designation_id')
                    ->select('m.meal_id','m.meal_date','m.meal_status','emp.employee_name','lkp.lookup_data_name as department_name','lkp1.lookup_data_name as designation_name')
                    ->where('m.employee_id',$employeeId) 
                    ->orderBy('m.meal_id','desc') 
                    ->get();

        $fromDate = date('Y-m-01');
        $toDate = date('Y-m-t');
        $activeMeal = DB::select("select meal_date from employee_meal where employee_id = $employeeId  and meal_status = 1");
        $InactiveMeal = DB::select("select meal_date from employee_meal where employee_id = $employeeId  and meal_status = 0");

        $mealSetting = DB::table('employee_meal_setting')->select('meal_status')->where('employee_id',$employeeId)->first();
        
        return view('staff_meal_modify.searchStaffSelfMeal',compact('header','results','activeMeal','InactiveMeal','mealSetting','staffEmployee','employeeId'));
       }else{
        $header = array(
            'pageTitle' => 'Self Meal',
            'tableTitle' => ''
        );
        $staffEmployee = DB::table('npoly_employees')
        ->select('employee_id','employee_name','employee_number')
        ->where('active_status','1')
        ->get();

        $sessionEmpId = session('employeeId');
        $employeeId = $sessionEmpId;

        $results = DB::table('employee_meal as m')
                    ->leftJoin('npoly_employees as emp','emp.employee_id','=','m.employee_id')
                    ->leftJoin('sa_lookup_data as lkp','lkp.lookup_data_id','=','emp.department_id')
                    ->leftJoin('sa_lookup_data as lkp1','lkp1.lookup_data_id','=','emp.designation_id')
                    ->select('m.meal_id','m.meal_date','m.meal_status','emp.employee_name','lkp.lookup_data_name as department_name','lkp1.lookup_data_name as designation_name')
                    ->where('m.employee_id',$employeeId) 
                    ->orderBy('m.meal_id','desc') 
                    ->get();
                    //dd($results,$employeeId);

        $fromDate = date('Y-m-01');
        $toDate = date('Y-m-t');
        $activeMeal = DB::select("select meal_date from employee_meal where employee_id = $employeeId  and meal_status = 1");
        $InactiveMeal = DB::select("select meal_date from employee_meal where employee_id = $employeeId  and meal_status = 0");

        $mealSetting = DB::table('employee_meal_setting')->select('meal_status')->where('employee_id',$employeeId)->first();
        //dd($mealSetting);
        

        return view('staff_meal_modify.searchStaffSelfMeal',compact('header','results','activeMeal','InactiveMeal','mealSetting','staffEmployee','employeeId'));
       }
       
        
    }
    public function checkStaffPrePlan(Request $request){

        $tomorrow = strtotime("+1 day");
        $tomorrowDate = date("Y-m-d", $tomorrow);
        $lastDayOfMonth = date('Y-m-t');
        $empId =session('employeeId');

        $checkMealWithPrePlan =  DB::select("select meal_id from employee_meal where employee_id = $empId
               and meal_date between '$tomorrowDate' and '$lastDayOfMonth' and pre_plan_meal = 1");
               
        if(!empty($checkMealWithPrePlan)){
            return  1;
           
        }else{
            return  2;
        }
    }
    public function staffMealCreateAdmin(Request $request){

        $empId = session('employeeId');
         $mealType = $request->regular_meal;
         $changePrePlanMeal = $request->cheange_pre_plan;
 
         // change meal setting info
         $checkEmpMealSetting = DB::table('employee_meal_setting')->select('id')->where('employee_id',$empId)->first();
         
         if(!empty($checkEmpMealSetting)){
             $update = DB::table('employee_meal_setting')->where('id',$checkEmpMealSetting->id)->update([
                 "meal_status"=>$mealType,
                 "updated_by"=>Auth::user()->id,
                 "updated_at"=>date('Y-m-d H:i:s A'),
             ]);
         }else{
             $update = DB::table('employee_meal_setting')->insert([
                 "employee_id"=>$empId,
                 "meal_status"=>$mealType,
                 "action_from"=>1,
                 "active_status"=>1,
                 "created_by"=>Auth::user()->id,
                 "created_at"=>date('Y-m-d H:i:s A'),
             ]);
         }
        
 
         ///
         
         $tomorrow = strtotime("+1 day");
         $tomorrowDate = date("Y-m-d", $tomorrow);
         $lastDayOfMonth = date('Y-m-t');
 
         $mealDate = DB::select("select meal_id, meal_date,meal_status from employee_meal where employee_id = $empId
         and meal_date between '$tomorrowDate' and '$lastDayOfMonth'");
 
         if($mealType =="1"){
             if($changePrePlanMeal=='0'){ // o means no changes pre plan meal
                 // regular on no change pre plan meal
                $checkMealWithouPrePlan =  DB::select("select meal_id, meal_date,meal_status from employee_meal where employee_id = $empId
                and meal_date between '$tomorrowDate' and '$lastDayOfMonth' and pre_plan_meal = 0");
                if(!empty($checkMealWithouPrePlan)){
                 foreach ($checkMealWithouPrePlan as $key => $value) {
                     // without pre plan meal status update
                     $updateMeal = DB::table('employee_meal')->where('employee_id',$empId)->where('meal_date',$value->meal_date)->update([
                         //"meal_status"=>$value->meal_status == 1 ? 0: 1, 
                         "meal_status"=>1, 
                         "active_status"=>1, 
                         "updated_by"=>Auth::user()->id, 
                         "updated_at"=>date('Y-m-d H:i:s A'), 
                     ]);
                   
                 }
                 return true;
                }else{
                 $fromDate = date('Y-m-d', strtotime('+1 day'));
                 $toDate = date('Y-m-t'); 
                 $mealDateExpectFir = $this::getDatesExcludingFriday($fromDate,$toDate);
                 foreach($mealDateExpectFir as $value){
                     // 
                     $insertMeal = DB::table('employee_meal')->insert([
                         "employee_id"=>$empId, 
                         "meal_date"=>$value, 
                         "meal_status"=>1, 
                         "active_status"=>1, 
                         "created_by"=>Auth::user()->id, 
                         "created_at"=>date('Y-m-d H:i:s A'), 
                     ]);
                 }
                 return true; 
                }
 
             }else{
                 if(!empty($mealDate)){
                     foreach ($mealDate as $key => $value) {
                         $updateMeal = DB::table('employee_meal')->where('employee_id',$empId)->where('meal_date',$value->meal_date)->update([
                             "meal_status"=>1, 
                             "pre_plan_meal"=>0, 
                             "active_status"=>1, 
                             "updated_by"=>Auth::user()->id, 
                             "updated_at"=>date('Y-m-d H:i:s A'), 
                         ]); 
                     }
                     return true; 
                 }else{
                 $fromDate = date('Y-m-d', strtotime('+1 day'));
                 $toDate = date('Y-m-t'); 
                 $mealDateExpectFir = $this::getDatesExcludingFriday($fromDate,$toDate);
                 foreach($mealDateExpectFir as $value){
                     $insertMeal = DB::table('employee_meal')->insert([
                         "employee_id"=>$empId,
                         "meal_date"=>$value, 
                         "meal_status"=>1, 
                         "active_status"=>1, 
                         "created_by"=>Auth::user()->id,
                         "created_at"=>date('Y-m-d H:i:s A'), 
                     ]);
                 }
                 return true;    
                 }
             };
 
         }else if($mealType=="0"){
             if($changePrePlanMeal=='0'){
                 $checkMealWithouPrePlan =  DB::select("select meal_id, meal_date,meal_status from employee_meal where employee_id = $empId
                and meal_date between '$tomorrowDate' and '$lastDayOfMonth' and pre_plan_meal = 0");
               // dd($checkMealWithouPrePlan);exit;
                 if(!empty($mealDate)){
                     foreach ($checkMealWithouPrePlan as $key => $value) {
                         $updateMeal = DB::table('employee_meal')->where('employee_id',$empId)->where('meal_date',$value->meal_date)->update([
                            // "meal_status"=>$value->meal_status == 1 ? 0: 1,
                             "meal_status"=>$value->meal_status == 0,
                             "active_status"=>1, 
                             "updated_by"=>Auth::user()->id, 
                             "updated_at"=>date('Y-m-d H:i:s A'), 
                         ]); 
                     }
                 }
                 return true; 
             }else{
                if(!empty($mealDate)){
                 foreach ($mealDate as $key => $value) {
                     $updateMeal = DB::table('employee_meal')->where('employee_id',$empId)->where('meal_date',$value->meal_date)->update([
                         "meal_status"=>0, 
                         "pre_plan_meal"=>0, 
                         "active_status"=>1, 
                         "updated_by"=>Auth::user()->id, 
                         "updated_at"=>date('Y-m-d H:i:s A'), 
                     ]); 
                 }
                 return true;   
                }
             };
         }
    }
    public function getStaffEmpMealStatusByDate(Request $request){
        $mealDate = $request->MealDate;
        $employeeId = session('employeeId');

        $mealStatus = DB::table('employee_meal')->select('meal_status')
                        ->where('employee_id',$employeeId)
                        ->where('meal_date',$mealDate)
                        ->first();
        
        if(!empty($mealStatus)){
            return $mealStatus->meal_status;
        }else{
            return 3;
        }
    }
    public function updateStaffMealStatus(Request $request){
        $mealDate = $request->MealDate;
        $mealStatus = $request->mealStatus;
        $employeeId = session('employeeId');

        if($mealStatus =="3"){
            $updateMeal = DB::table('employee_meal')
                    ->insert([
                    "employee_id" => $employeeId,
                    "meal_status"=> 1,
                    "meal_date"=> $mealDate,
                    "pre_plan_meal"=> 1,
                    "active_status" =>1,
                    "created_by"=>Auth::user()->id,
                    "created_at"=>date('Y-m-d H:i:s A'),
                    ]);
        }else{

            $updateMeal = DB::table('employee_meal')
                    ->where('employee_id',$employeeId)
                    ->where('meal_date',$mealDate)->update([
                        "meal_status"=> $mealStatus,
                        "pre_plan_meal"=> 1,
                    ]);
        }
    }

    public function checkPrePlan(Request $request){

        $tomorrow = strtotime("+1 day");
        $tomorrowDate = date("Y-m-d", $tomorrow);
        $lastDayOfMonth = date('Y-m-t');
        $empId = Auth::user()->id;

        $checkMealWithPrePlan =  DB::select("select meal_id from employee_meal where employee_id = $empId
               and meal_date between '$tomorrowDate' and '$lastDayOfMonth' and pre_plan_meal = 1");
        if(!empty($checkMealWithPrePlan)){
            return  1;
           
        }else{
            return  2;
        }

    }

    public function selfMealCreate(Request $request){
       $empId = Auth::user()->employee_id;
        $mealType = $request->regular_meal;
        $changePrePlanMeal = $request->cheange_pre_plan;

        // change meal setting info
        $checkEmpMealSetting = DB::table('employee_meal_setting')->select('id')->where('employee_id',$empId)->first();
        if(!empty($checkEmpMealSetting)){
            $update = DB::table('employee_meal_setting')->where('id',$checkEmpMealSetting->id)->update([
                "meal_status"=>$mealType,
                "updated_by"=>Auth::user()->id,
                "updated_at"=>date('Y-m-d H:i:s A'),
            ]);
        }else{
            $update = DB::table('employee_meal_setting')->insert([
                "employee_id"=>$empId,
                "meal_status"=>$mealType,
                "action_from"=>1,
                "active_status"=>1,
                "created_by"=>Auth::user()->id,
                "created_at"=>date('Y-m-d H:i:s A'),
            ]);
        }
       

        ///
        
        $tomorrow = strtotime("+1 day");
        $tomorrowDate = date("Y-m-d", $tomorrow);
        $lastDayOfMonth = date('Y-m-t');

        $mealDate = DB::select("select meal_id, meal_date,meal_status from employee_meal where employee_id = $empId
        and meal_date between '$tomorrowDate' and '$lastDayOfMonth'");

        if($mealType =="1"){
            if($changePrePlanMeal=='0'){ // o means no changes pre plan meal
                // regular on no change pre plan meal
               $checkMealWithouPrePlan =  DB::select("select meal_id, meal_date,meal_status from employee_meal where employee_id = $empId
               and meal_date between '$tomorrowDate' and '$lastDayOfMonth' and pre_plan_meal = 0");
               if(!empty($checkMealWithouPrePlan)){
                foreach ($checkMealWithouPrePlan as $key => $value) {
                    // without pre plan meal status update
                    $updateMeal = DB::table('employee_meal')->where('employee_id',$empId)->where('meal_date',$value->meal_date)->update([
                        //"meal_status"=>$value->meal_status == 1 ? 0: 1, 
                        "meal_status"=>1, 
                        "active_status"=>1, 
                        "updated_by"=>Auth::user()->id, 
                        "updated_at"=>date('Y-m-d H:i:s A'), 
                    ]);
                  
                }
                return true;
               }else{
                $fromDate = date('Y-m-d', strtotime('+1 day'));
                $toDate = date('Y-m-t'); 
                $mealDateExpectFir = $this::getDatesExcludingFriday($fromDate,$toDate);
                foreach($mealDateExpectFir as $value){
                    // 
                    $insertMeal = DB::table('employee_meal')->insert([
                        "employee_id"=>$empId, 
                        "meal_date"=>$value, 
                        "meal_status"=>1, 
                        "active_status"=>1, 
                        "created_by"=>Auth::user()->id, 
                        "created_at"=>date('Y-m-d H:i:s A'), 
                    ]);
                }
                return true; 
               }

            }else{
                if(!empty($mealDate)){
                    foreach ($mealDate as $key => $value) {
                        $updateMeal = DB::table('employee_meal')->where('employee_id',$empId)->where('meal_date',$value->meal_date)->update([
                            "meal_status"=>1, 
                            "pre_plan_meal"=>0, 
                            "active_status"=>1, 
                            "updated_by"=>Auth::user()->id, 
                            "updated_at"=>date('Y-m-d H:i:s A'), 
                        ]); 
                    }
                    return true; 
                }else{
                $fromDate = date('Y-m-d', strtotime('+1 day'));
                $toDate = date('Y-m-t'); 
                $mealDateExpectFir = $this::getDatesExcludingFriday($fromDate,$toDate);
                foreach($mealDateExpectFir as $value){
                    $insertMeal = DB::table('employee_meal')->insert([
                        "employee_id"=>$empId,
                        "meal_date"=>$value, 
                        "meal_status"=>1, 
                        "active_status"=>1, 
                        "created_by"=>Auth::user()->id,
                        "created_at"=>date('Y-m-d H:i:s A'), 
                    ]);
                }
                return true;    
                }
            };

        }else if($mealType=="0"){
            if($changePrePlanMeal=='0'){
                $checkMealWithouPrePlan =  DB::select("select meal_id, meal_date,meal_status from employee_meal where employee_id = $empId
               and meal_date between '$tomorrowDate' and '$lastDayOfMonth' and pre_plan_meal = 0");
              // dd($checkMealWithouPrePlan);exit;
                if(!empty($mealDate)){
                    foreach ($checkMealWithouPrePlan as $key => $value) {
                        $updateMeal = DB::table('employee_meal')->where('employee_id',$empId)->where('meal_date',$value->meal_date)->update([
                           // "meal_status"=>$value->meal_status == 1 ? 0: 1,
                            "meal_status"=>$value->meal_status == 0,
                            "active_status"=>1, 
                            "updated_by"=>Auth::user()->id, 
                            "updated_at"=>date('Y-m-d H:i:s A'), 
                        ]); 
                    }
                }
                return true; 
            }else{
               if(!empty($mealDate)){
                foreach ($mealDate as $key => $value) {
                    $updateMeal = DB::table('employee_meal')->where('employee_id',$empId)->where('meal_date',$value->meal_date)->update([
                        "meal_status"=>0, 
                        "pre_plan_meal"=>0, 
                        "active_status"=>1, 
                        "updated_by"=>Auth::user()->id, 
                        "updated_at"=>date('Y-m-d H:i:s A'), 
                    ]); 
                }
                return true;   
               }
            };
        }
    }

    public function updatEmpSelfMealSetting(Request $request){
        if($_POST){
            $checkExist = DB::table('employee_meal_setting')
            ->select('id')
            ->where('employee_id',Auth::user()->employee_id)
            ->first();
            if($checkExist){
                DB::table('employee_meal_setting')->where('id',$checkExist->id)->update([
                    "meal_status" => $request->meal_status,
                    "updated_by"=>Auth::user()->id,
                    "updated_at" => date('Y-m-d h:i:s A')
                ]);
                Session::flash('success', 'Setting Updated successfully!');
                return redirect()->route('selfMealIndex'); 
            }else{
                DB::table('employee_meal_setting')->insert([
                    "employee_id" => Auth::user()->employee_id,
                    "meal_status" => $request->meal_status,
                    "action_from" =>1,
                    "active_status" =>1,
                    "meal_status" => $request->meal_status,
                    "created_by"=>Auth::user()->id,
                ]);
                Session::flash('success', 'Setting Created successfully!');
                return redirect()->route('selfMealIndex'); 
            }
            
           
        }else{
            $header = array(
                'pageTitle' => 'Self Meal',
                'tableTitle' => ''
            );
            $empId = Auth::user()->employee_id;
            $empInfo =  DB::table('npoly_employees as emp')
            ->leftJoin('set_department as dept','dept.id','=','emp.department_id')
            ->leftJoin('set_designation as desig','desig.id','=','emp.designation_id')
            ->select('emp.employee_name','dept.department_name','desig.designation_name')
            ->where('emp.employee_id',$empId)
            ->first(); 
            
            $mealStatus = DB::table('employee_meal_setting')
            ->select('meal_status')
            ->where('employee_id',$empId)
            ->first();

            return view('self_meal.update',compact('header','empInfo','mealStatus'));
        }
    }

    public function mealStatusIndex(){
        $header = array(
            'pageTitle' => 'Meal Status',
            'tableTitle' => ''
        );

        // $employees = DB::table('npoly_employees as emp')
        // ->leftJoin('set_department as dept','dept.id','=','emp.department_id')
        // ->leftJoin('set_designation as desig','desig.id','=','emp.designation_id')
        // ->select('emp.employee_id','emp.employee_name','dept.department_name','desig.designation_name','emp.card_no')
        // ->where('emp.active_status',1)
        // ->orderBy('emp.user_serial_no','asc')
        // ->get();

        // $totalDaysInMonth = date('t');
    $excludedEmployeeIds = [78, 108];
   $employees = DB::table('npoly_employees as emp')
    ->leftJoin('set_department as dept','dept.id','=','emp.department_id')
    ->leftJoin('set_designation as desig','desig.id','=','emp.designation_id')
    ->select('emp.employee_id', 'emp.employee_name', 'dept.department_name', 'desig.designation_name', 'emp.card_no')
    ->where('emp.active_status', 1)
    ->whereNotIn('emp.employee_id', $excludedEmployeeIds)
    ->orderBy('emp.user_serial_no', 'asc')
    ->get();

    $meals = DB::table('employee_meal')
        ->whereMonth('meal_date', '=', now()->month)
        ->whereYear('meal_date', '=', now()->year)
        ->get()
        ->groupBy('employee_id');

    $totalDaysInMonth = date('t');
        return view('meal_status.index',compact('header','employees','meals','totalDaysInMonth'));
    }

    public function mealReportIndex(){
        $header = array(
            'pageTitle' => 'Meal Status',
            'tableTitle' => ''
        );
        $excludedEmployeeIds = [78, 108];
        $employees = DB::table('npoly_employees as emp')
        ->leftJoin('set_department as dept','dept.id','=','emp.department_id')
        ->leftJoin('set_designation as desig','desig.id','=','emp.designation_id')
        ->select('emp.employee_id', 'emp.employee_name', 'dept.department_name', 'desig.designation_name', 'emp.card_no')
        ->where('emp.active_status', 1)
        ->whereNotIn('emp.employee_id', $excludedEmployeeIds)
        ->orderBy('emp.user_serial_no', 'asc')
        ->get();
    
        $meals = DB::table('employee_meal')
            ->whereMonth('meal_date', '=', now()->month)
            ->whereYear('meal_date', '=', now()->year)
            ->get()
            ->groupBy('employee_id');

        $totalDaysInMonth = date('t');

        return view('meal_status.meal_report',compact('header','employees','totalDaysInMonth','meals'));
    }

    public function changeMealStatus(Request $request){
        $mealId = $request->mealId;
        $mealStatus = $request->mealStatus;

        DB::table('employee_meal')->where('meal_id',$mealId)->update([
            "meal_status" => $request->mealStatus,
            "updated_by"=>Auth::user()->id,
            "updated_at" => date('Y-m-d h:i:s A')
        ]);
        if(Auth::user()->employee_id > 0){
            Session::flash('success', 'Meal Updated successfully!');
            return redirect()->route('selfMealIndex');   
        }else{
            Session::flash('success', 'Meal Updated successfully!');
            return redirect()->route('mealIndex'); 
        }
        
    }

    static  function getDatesExcludingFriday($startDate, $endDate) {
        $dates = array();
    
        $currentDate = new DateTime($startDate);
        $endDate = new DateTime($endDate);
    
        while ($currentDate <= $endDate) {
            // Check if the current day is not a Friday (5 is the index for Friday in PHP)
            if ($currentDate->format('N') != 5) {
                $dates[] = $currentDate->format('Y-m-d');
            }
    
            // Move to the next day
            $currentDate->modify('+1 day');
        }
    
        return $dates;
    }

    public function getEmpolyeeMealStatus(Request $request){
        $fromDate = date('Y-m-d',strtotime($request->fromDate));
        $toDate = date('Y-m-d',strtotime($request->toDate));
        $employeeId = $request->employeeId;

        $condition = '';

        if(!empty($employeeId)){
            $condition .=" and m.employee_id = $employeeId";
        }
        
        $results = DB::select("select m.meal_id,m.meal_date,m.meal_status,emp.employee_name, dept.department_name,desig.designation_name from employee_meal as m
        left join npoly_employees as emp on emp.employee_id = m.employee_id 
        left join set_department as dept on dept.id = emp.department_id 
        left join set_designation as desig on desig.id = emp.designation_id 
        where m.meal_date between '$fromDate' and '$toDate'
        $condition
        and m.active_status = 1
        order by m.meal_date
        ");

        return view('meal.searchEmployeeMeal',compact('results','fromDate','toDate'));
    }

    public function getEmpolyeeMealStatusByDate(Request $request){
        $mealDate = $request->MealDate;
        $employeeId = Auth::user()->employee_id;

        $mealStatus = DB::table('employee_meal')->select('meal_status')
                        ->where('employee_id',$employeeId)
                        ->where('meal_date',$mealDate)
                        ->first();
        
        if(!empty($mealStatus)){
            return $mealStatus->meal_status;
        }else{
            return 3;
        }
    }

    public function updateSelfMealStatus(Request $request){
        $mealDate = $request->MealDate;
        $mealStatus = $request->mealStatus;
        $employeeId = Auth::user()->employee_id;

        if($mealStatus =="3"){
            $updateMeal = DB::table('employee_meal')
                    ->insert([
                    "employee_id" => Auth::user()->employee_id,
                    "meal_status"=> 1,
                    "meal_date"=> $mealDate,
                    "pre_plan_meal"=> 1,
                    "active_status" =>1,
                    "created_by"=>Auth::user()->id,
                    "created_at"=>date('Y-m-d H:i:s A'),
                    ]);
        }else{

            $updateMeal = DB::table('employee_meal')
                    ->where('employee_id',$employeeId)
                    ->where('meal_date',$mealDate)->update([
                        "meal_status"=> $mealStatus,
                        "pre_plan_meal"=> 1,
                    ]);
        }
    }

    public function searchMealStatus(Request $request){

        $startDate = $request->startDate;
        $timestamp = strtotime($startDate);
        $month = date('m', $timestamp);
        $year = date('Y', $timestamp); 
        $totalDaysInMonth = date('t',$timestamp);
        
        $excludedEmployeeIds = [78, 108];
        $employees = DB::table('npoly_employees as emp')
            ->leftJoin('set_department as dept','dept.id','=','emp.department_id')
            ->leftJoin('set_designation as desig','desig.id','=','emp.designation_id')
            ->select('emp.employee_id', 'emp.employee_name', 'dept.department_name', 'desig.designation_name', 'emp.card_no')
            ->where('emp.active_status', 1)
            ->whereNotIn('emp.employee_id', $excludedEmployeeIds)
            ->orderBy('emp.user_serial_no', 'asc')
            ->get();

            $month = date('m', $timestamp);
            $year = date('Y', $timestamp);

            $meals = DB::table('employee_meal')
            ->whereMonth('meal_date', '=', $month) // Use the extracted month
            ->whereYear('meal_date', '=', $year)  // Use the extracted year
            ->get()
            ->groupBy('employee_id');

        return view('meal_status.searchMealStatus',compact('employees','meals','totalDaysInMonth','month','year'));
    }

    public function searchMealReport(Request $request){

        $startDate = $request->startDate;
        $timestamp = strtotime($startDate);
        $month = date('m', $timestamp);
        $year = date('Y', $timestamp); 
        $totalDaysInMonth = date('t',$timestamp);

        $excludedEmployeeIds = [78, 108];
        $employees = DB::table('npoly_employees as emp')
        ->leftJoin('set_department as dept','dept.id','=','emp.department_id')
        ->leftJoin('set_designation as desig','desig.id','=','emp.designation_id')
        ->select('emp.employee_id', 'emp.employee_name', 'dept.department_name', 'desig.designation_name', 'emp.card_no')
        ->where('emp.active_status', 1)
        ->whereNotIn('emp.employee_id', $excludedEmployeeIds)
        ->orderBy('emp.user_serial_no', 'asc')
        ->get();

        $month = date('m', $timestamp);
        $year = date('Y', $timestamp);
    
        $meals = DB::table('employee_meal')
            ->whereMonth('meal_date', '=', $month) // Use the extracted month
            ->whereYear('meal_date', '=', $year)  // Use the extracted year
            ->get()
            ->groupBy('employee_id');

        return view('meal_status.searchMealReport',compact('employees','totalDaysInMonth','meals','month','year'));
    }

    public function notificationIndex(){
        $header = array(
            'pageTitle' => 'Meal Notificaiotn',
            'tableTitle' => ''
        );
        
        return view('meal.notificationIndex',compact('header'));
    }

    public function sendMealNotification(Request $request){
        if($_POST){
                $title = $request->offer_title;
                $body = $request->offer_description;
                $employeeNumber = $request->employee_number;
    
                $url = 'http://192.168.100.34:3001/api/v1/mobile/auth/multiNotification';
    
                $data = array(
                    'title' => $title,
                    'desc' => $body,
                    'employee_number' => $employeeNumber,
                  );
            
                  // Convert the data array to JSON
                  $jsonData = json_encode($data);
            
                  // Initialize cURL session
                  $curl = curl_init($url);
            
              // Set the cURL options
                      curl_setopt($curl, CURLOPT_URL, $url);
                      curl_setopt($curl, CURLOPT_POST, true); // Set the request method to POST
                      curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                      curl_setopt($curl, CURLOPT_HEADER, false);
                      curl_setopt($curl, CURLOPT_POSTFIELDS, $jsonData); // Attach the JSON data
                      curl_setopt($curl, CURLOPT_HTTPHEADER, array(
                          'Content-Type: application/json',
                          'Content-Length: ' . strlen($jsonData)
                      ));
            
                      // Execute the POST request
                      $response = curl_exec($curl);
    
                      
                if (curl_errno($curl)) {
                    echo 'Error:' . curl_error($curl);
                } else {
                    // Print the response from the server
                    Session::flash('success', 'Notification Send successfully!');
                    return redirect()->route('meal-notification');
                }
              
               // curl_close($curl);
    
    
            
           
        }else{
            $header = array(
                'pageTitle' => 'Notificaiotn',
                'tableTitle' => ''
            );

            $employees = DB::table('npoly_employees')->select('employee_number','employee_name')->where('active_status',1)->get();
           
            
            return view('meal.notificationSend',compact('header','employees'));  
        }
    }
}
