<?php

namespace App\Http\Controllers\support;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Session;
use App\Models\ProjectSetupModel;
use  App\Models\lookup\LookupGroupDataModel;
use DB;
use Auth;

class EmployeeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $header = array(
            'pageTitle' => 'Employee List',
            'tableTitle' => ''
        );

        $results = DB::table('npoly_employees as emp')
            ->leftJoin('sa_lookup_data as lkp', 'lkp.LOOKUP_DATA_ID', '=', 'emp.department_id')
            ->leftJoin('sa_lookup_data as lkp1', 'lkp1.LOOKUP_DATA_ID', '=', 'emp.designation_id')
            ->select('emp.*','lkp.LOOKUP_DATA_NAME as department_name','lkp1.LOOKUP_DATA_NAME as designation_name')
            //->orderBy('emp.employee_id','desc')
            ->get();

        return view('setup/projects.index',compact('header','results'));
    }

    /**
     * Create class routine form
     * @param None
     *
     */
    public function create()
    {
        $header = array(
            'pageTitle' => 'Project',
            'tableTitle' => 'Project List'
        );
        $clients = DB::table('npoly_clients')->select('client_id','client_name')->get();

        return view('setup/projects.create', compact('header','clients'));
    }

    /* save class routine
     * @param Request $request
     *
     */
    public function store(Request $request)
    {
        ProjectSetupModel::createProject($request);
        Session::flash('success', 'Data Saved successfully!');
        return redirect()->route('projectSetupIndex');
    }

    /* class routine update page
     * @param $id
     *
     */
    public function edit($id)
    {
        $header = array(
            'pageTitle' => 'Project',
            'tableTitle' => 'Project List'
        );
        $clients = DB::table('npoly_clients')->select('client_id','client_name')->get();
        $result = ProjectSetupModel::find($id);
        return view('setup/projects.update', compact('header', 'result','clients'));

    }

    /* class routine update action
     * @param $request
     *
     */
    public function update(Request $request)
    {
        ProjectSetupModel::updateProject($request);
        Session::flash('success', 'Data Updated successfully!');
        return redirect()->route('projectSetupIndex');
    }

    /* get day of date
     * @param $date
     *
     */
   
}
