<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Auth;
use Session;

class RequestApprovedController extends Controller
{
    public function index(Request $request){
        $header = array(
            'pageTitle' => 'Permission',
            'tableTitle' => ''
        );
        $results = DB::table('request_approved_permission as p')
        ->leftJoin('sa_modules as m','p.module_id','=','m.module_id')
        ->leftJoin('set_department as d','p.department_id','=','d.id')
        ->leftJoin('npoly_employees as e','p.employee_id','=','e.employee_id')
        ->select('p.id','p.active_status','p.end_date','m.module_name','d.department_name','e.employee_name')
        ->get();

        return view('approved_permission.index',compact('header','results'));
    }
    public function create(Request $request){
        $header = array(
            'pageTitle' => 'Permission',
            'tableTitle' => ''
        );
        $module = DB::table('sa_modules')->select('module_id','module_name')->where('active_status',1)->get();
        $departments = DB::table('set_department')->select('id','department_name')->where('active_status',1)->get();
        
        return view('approved_permission.create',compact('header','module','departments'));
     
    }
    public function store(Request $request){
        if($_POST){
            $insertArray = array(
                "module_id" => $request->module_id,
                "department_id" => $request->department_id,
                "employee_id" => $request->employee_id,
                "active_status" => 1,
                "created_by" => Auth::user()->id,
            );
            $db = DB::table('request_approved_permission')->insert($insertArray);
        }
        Session::flash('success', 'Data Saved successfully!');
        return redirect()->route('permissionIndex');
    }

    public function edit(Request $request,$id){
        $header = array(
            'pageTitle' => 'Permission',
            'tableTitle' => ''
        );
        $results = DB::table('request_approved_permission')->select('*')->where('id',$id)->first();
        $module = DB::table('sa_modules')->select('module_id','module_name')->where('active_status',1)->get();
        $departments = DB::table('set_department')->select('id','department_name')->where('active_status',1)->get();
        $employees = DB::table('npoly_employees')->select('employee_id','employee_name')->where('department_id',$results->department_id)->where('active_status',1)->get();
        return view('approved_permission.update',compact('header','module','departments','results','employees'));
    }

    public function update(Request $request){
        if($_POST){
            $insertArray = array(
                "module_id" => $request->module_id,
                "department_id" => $request->department_id,
                "employee_id" => $request->employee_id,
                "active_status" => $request->active_status,
                "end_date" => $request->active_status == 0 ? date('Y-m-d h:i A'):null,
                "updated_by" => Auth::user()->id,
            );
            $db = DB::table('request_approved_permission')->where('id',$request->id)->update($insertArray);
        }
        Session::flash('success', 'Data Saved successfully!');
        return redirect()->route('permissionIndex');
    }
}
