<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Menu;
use App\Models\OrganizationInfo;
use DB;
use Session;
use Auth;

class DashboardController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('prevent-back-history');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function getTicketStatusInfo($status)
    {
        $header = array(
            'pageTitle' => 'Ticket',
            'tableTitle' => ''
        );

        if($status==1){
            $results = DB::table('npoly_tickets as tkt')
                ->leftJoin('sa_lookup_data as lkp', 'tkt.priority_id', '=', 'lkp.LOOKUP_DATA_ID')
                ->leftJoin('sa_lookup_data as lkp1', 'tkt.ticket_status', '=', 'lkp1.LOOKUP_DATA_ID')
                ->leftJoin('npoly_clients as clnt', 'clnt.client_id', '=', 'tkt.client_id')
                ->leftJoin('npoly_projects as pro', 'pro.project_id', '=', 'tkt.project_id')
                ->leftJoin('npoly_task_report as tskr', 'tskr.ticket_id', '=', 'tkt.id')
                ->leftJoin('npoly_support_modules as tm', 'tm.module_id', '=', 'tkt.module_id')
                ->select('tkt.*','lkp.LOOKUP_DATA_NAME as priorityName','clnt.client_name','pro.project_name','tskr.employee_id','tskr.task_complete','lkp1.LOOKUP_DATA_NAME as ticketStatus','tm.module_name')
                ->where('reassign_fg',1)
                ->orderBy('tkt.id','desc')
                ->get();
        }else{
            $supportUser = Auth::user()->support_user_id;
            if($supportUser !='0'){
                $supportUserId = Auth::user()->id;
                $results = DB::table('npoly_tickets as tkt')
                ->leftJoin('sa_lookup_data as lkp', 'tkt.priority_id', '=', 'lkp.LOOKUP_DATA_ID')
                ->leftJoin('sa_lookup_data as lkp1', 'tkt.ticket_status', '=', 'lkp1.LOOKUP_DATA_ID')
                ->leftJoin('npoly_clients as clnt', 'clnt.client_id', '=', 'tkt.client_id')
                ->leftJoin('npoly_projects as pro', 'pro.project_id', '=', 'tkt.project_id')
                ->leftJoin('npoly_task_report as tskr', 'tskr.ticket_id', '=', 'tkt.id')
                ->leftJoin('npoly_support_modules as tm', 'tm.module_id', '=', 'tkt.module_id')
                ->select('tkt.*','lkp.LOOKUP_DATA_NAME as priorityName','clnt.client_name','pro.project_name','tskr.employee_id','tskr.task_complete','lkp1.LOOKUP_DATA_NAME as ticketStatus','tm.module_name')
                ->where('tkt.ticket_status',$status)
                ->where('tkt.created_by',$supportUserId)
                ->orderBy('tkt.id','desc')
                ->get(); 
            }else{
                $empId = Auth::user()->employee_id;
                $results = DB::table('npoly_tickets as tkt')
                ->leftJoin('sa_lookup_data as lkp', 'tkt.priority_id', '=', 'lkp.LOOKUP_DATA_ID')
                ->leftJoin('sa_lookup_data as lkp1', 'tkt.ticket_status', '=', 'lkp1.LOOKUP_DATA_ID')
                ->leftJoin('npoly_clients as clnt', 'clnt.client_id', '=', 'tkt.client_id')
                ->leftJoin('npoly_projects as pro', 'pro.project_id', '=', 'tkt.project_id')
                ->leftJoin('npoly_task_report as tskr', 'tskr.ticket_id', '=', 'tkt.id')
                ->leftJoin('npoly_support_modules as tm', 'tm.module_id', '=', 'tkt.module_id')
                ->select('tkt.*','lkp.LOOKUP_DATA_NAME as priorityName','clnt.client_name','pro.project_name','tskr.employee_id','tskr.task_complete','lkp1.LOOKUP_DATA_NAME as ticketStatus','tm.module_name')
                ->where('tkt.ticket_status',$status)
                ->where('tkt.employee_id',$empId)
                ->orderBy('tkt.id','desc')
                ->get();
            }
           
        }

        return view('dashboard.ticket_dashboard',compact('header','results'));
    }

    public function totalPresentEmployee(Request $request){
        $header = array(
            'pageTitle' => 'Present',
            'tableTitle' => ''
        );
        $results = DB::table('hr_attendance as atn')
                            ->leftJoin('npoly_employees as emp','emp.employee_id','=','atn.employee_id')
                            ->leftJoin('sa_lookup_data as lkp','lkp.lookup_data_id','=','emp.department_id')
                            ->leftJoin('sa_lookup_data as lkp1','lkp1.lookup_data_id','=','emp.designation_id')
                            ->select('emp.employee_name','lkp.lookup_data_name as department_name','lkp1.lookup_data_name as designation_name','emp.email','emp.card_no','atn.attendance_date','atn.login_time','emp.mobile_no')
                            ->where('atn.present_status',1)
                            ->where('atn.attendance_date',date('Y-m-d'))
                            ->orderBy('emp.user_serial_no')
                            ->get();

        return view('dashboard.total_present',compact('header','results'));
    }

    public function totalAbsentEmployee(Request $request){
        $header = array(
            'pageTitle' => 'Absent',
            'tableTitle' => ''
        );
        $results = DB::table('hr_attendance as atn')
            ->leftJoin('npoly_employees as emp','emp.employee_id','=','atn.employee_id')
            ->leftJoin('sa_lookup_data as lkp','lkp.lookup_data_id','=','emp.department_id')
            ->leftJoin('sa_lookup_data as lkp1','lkp1.lookup_data_id','=','emp.designation_id')
            ->select('emp.employee_name','lkp.lookup_data_name as department_name','lkp1.lookup_data_name as designation_name','emp.email','emp.card_no','atn.attendance_date','atn.login_time','emp.mobile_no')
            ->where('atn.present_status',0)
            ->where('atn.attendance_date',date('Y-m-d'))
            ->orderBy('emp.user_serial_no')
            ->get();
        return view('dashboard.total_absent',compact('header','results'));
    }

    public function totalWorkingHour(Request $request){
        $header = array(
            'pageTitle' => 'Task',
            'tableTitle' => ''
        );
        $date = date('Y-m-d');
        $taskInfo = DB::select("select distinct employee_id from npoly_task_report where task_create_date = '$date'");
        $empIds = [];
        foreach ($taskInfo as $emp){
            $empIds [] =  $emp->employee_id;
        }
        $empIdIn = implode(',',$empIds);

        if(!empty($empIdIn)){
            $results = DB::select("select emp.employee_id,emp.employee_name,emp.card_no,emp.mobile_no,lkp.lookup_data_name as department_name,lkp1.LOOKUP_DATA_NAME as designation_name from npoly_employees as emp,sa_lookup_data as lkp, sa_lookup_data as lkp1
                                        WHERE emp.department_id = lkp.lookup_data_id
                                        and emp.designation_id = lkp1.lookup_data_id
                                        and emp.employee_id in($empIdIn)");

            return view('dashboard.total_working_horus',compact('results','header'));

        }else{
            $results = [];
            return view('dashboard.total_working_horus',compact('results','header'));
        }
    }

    public function taskDetailsSpecificEmp(Request $request,$empId){
        $header = array(
            'pageTitle' => 'Task',
            'tableTitle' => ''
        );

        $results = DB::table('npoly_task_report as tr')
            ->leftJoin('npoly_projects as pro','pro.project_id','=','tr.project_id')
            ->leftJoin('sa_lookup_data as lkp','lkp.LOOKUP_DATA_ID','=','tr.department_id')
            ->leftJoin('npoly_employees as emp','emp.employee_id','=','tr.employee_id')
            ->select('tr.*','pro.project_name','lkp.LOOKUP_DATA_NAME as DEPT_NAME','emp.employee_name')
            ->where('tr.active_status',1)
            ->where('tr.employee_id',$empId)
            ->where('tr.task_create_date',date('Y-m-d'))
            ->orderBy('tr.task_id','desc')
            ->get();

         return view('dashboard.specficEmpTaskDetails',compact('results','header'));

    }

    public function getLastSevenDaysTask(Request  $request){
        $header = array(
            'pageTitle' => 'Task',
            'tableTitle' => ''
        );

        $today = date('Y-m-d');
        $lastSevendDays = date('Y-m-d', strtotime('-7 days'));

        $results = DB::table('npoly_task_report as tr')
            ->leftJoin('npoly_projects as pro','pro.project_id','=','tr.project_id')
            ->leftJoin('sa_lookup_data as lkp','lkp.LOOKUP_DATA_ID','=','tr.department_id')
            ->leftJoin('npoly_employees as emp','emp.employee_id','=','tr.employee_id')
            ->select('tr.*','pro.project_name','lkp.LOOKUP_DATA_NAME as DEPT_NAME','emp.employee_name')
            ->where('tr.active_status',1)
            ->whereBetween('tr.task_create_date', [ $lastSevendDays,$today])
            ->orderBy('tr.task_id','desc')
            ->get();

        $results = DB::select("SELECT DISTINCT tr.employee_id,emp.employee_name,emp.card_no,emp.mobile_no,lkp.LOOKUP_DATA_NAME as department_name,lkp1.LOOKUP_DATA_NAME as designation_name FROM npoly_task_report as tr, npoly_employees as emp,sa_lookup_data as lkp,sa_lookup_data as lkp1
                                WHERE tr.employee_id = emp.employee_id
                                AND tr.department_id = lkp.LOOKUP_DATA_ID
                                AND emp.designation_id = lkp1.LOOKUP_DATA_ID
                                AND tr.task_create_date BETWEEN '$lastSevendDays' AND '$today'
                                and tr.active_status = 1
                                ORDER BY tr.task_id DESC");


        return view('dashboard.totalWrkLst7Days',compact('results','header','today','lastSevendDays'));

    }

    public function taskDetailsLast7Days(Request $request, $empId){
        $header = array(
            'pageTitle' => 'Task',
            'tableTitle' => ''
        );

        $today = date('Y-m-d');
        $lastSevendDays = date('Y-m-d', strtotime('-7 days'));

        $results = DB::table('npoly_task_report as tr')
            ->leftJoin('npoly_projects as pro','pro.project_id','=','tr.project_id')
            ->leftJoin('sa_lookup_data as lkp','lkp.LOOKUP_DATA_ID','=','tr.department_id')
            ->leftJoin('npoly_employees as emp','emp.employee_id','=','tr.employee_id')
            ->select('tr.*','pro.project_name','lkp.LOOKUP_DATA_NAME as DEPT_NAME','emp.employee_name')
            ->where('tr.active_status',1)
            ->where('tr.employee_id',$empId)
            ->whereBetween('task_create_date', [ $lastSevendDays,$today])
            ->orderBy('tr.task_id','desc')
            ->get();

        return view('dashboard.last7DaysTaskDetails',compact('results','header','today','lastSevendDays'));
    }

    public function deptWiseDashboard(Request $request){
        $deptId = $request->deptId;

        if($deptId =='132' || $deptId =='262'){
            $kpicount = DB::table('npoly_kpi')
                ->select('kpi_id')
                ->where('active_status',1)
                ->whereIn('department_id', [132,262])
                ->count();
        }else{
            $kpicount = DB::table('npoly_kpi')
                ->select('kpi_id')
                ->where('active_status',1)
                ->where('department_id',$deptId)
                ->count();
        }

        return view('department_wise_dashboard',compact('kpicount'));
    }

    public function getTotalTaskDashboardInfo()
    {

        $header = array(
            'pageTitle' => 'Task',
            'tableTitle' => ''
        );

            $results = DB::table('npoly_tickets as tkt')
                ->leftJoin('sa_lookup_data as lkp', 'tkt.priority_id', '=', 'lkp.LOOKUP_DATA_ID')
                ->leftJoin('sa_lookup_data as lkp1', 'tkt.ticket_status', '=', 'lkp1.LOOKUP_DATA_ID')
                ->leftJoin('npoly_clients as clnt', 'clnt.client_id', '=', 'tkt.client_id')
                ->leftJoin('npoly_projects as pro', 'pro.project_id', '=', 'tkt.project_id')
                ->leftJoin('npoly_task_report as tskr', 'tskr.ticket_id', '=', 'tkt.id')
                ->leftJoin('npoly_support_modules as tm', 'tm.module_id', '=', 'tkt.module_id')
                ->select('tkt.*','lkp.LOOKUP_DATA_NAME as priorityName','clnt.client_name','pro.project_name','tskr.employee_id','tskr.task_complete','lkp1.LOOKUP_DATA_NAME as ticketStatus','tm.module_name')
                ->where('reassign_fg',1)
                ->orderBy('tkt.id','desc')
                ->get();
        
        return view('dept_wise_task_report.getTotalTaskDashboardInfo',compact('header','results'));
    }

    public function deptTaskInfo($deptId){
        $header = array(
            'pageTitle' => 'Task',
            'tableTitle' => ''
        );

        $results = DB::table('npoly_tickets as tkt')
            ->leftJoin('sa_lookup_data as lkp', 'tkt.priority_id', '=', 'lkp.LOOKUP_DATA_ID')
            ->leftJoin('sa_lookup_data as lkp1', 'tkt.ticket_status', '=', 'lkp1.LOOKUP_DATA_ID')
            ->leftJoin('npoly_clients as clnt', 'clnt.client_id', '=', 'tkt.client_id')
            ->leftJoin('npoly_projects as pro', 'pro.project_id', '=', 'tkt.project_id')
            ->leftJoin('npoly_task_report as tskr', 'tskr.ticket_id', '=', 'tkt.id')
            ->leftJoin('npoly_support_modules as tm', 'tm.module_id', '=', 'tkt.module_id')
            ->select('tkt.*','lkp.LOOKUP_DATA_NAME as priorityName','clnt.client_name','pro.project_name','tskr.employee_id','tskr.task_complete','lkp1.LOOKUP_DATA_NAME as ticketStatus','tm.module_name')
            ->where('reassign_fg',1)
            ->orderBy('tkt.id','desc')
            ->get();



        //return view('dashboard.ticket_dashboard',compact('header','results'));
        return view('dept_wise_task_report.itDeptTaskInfo',compact('header','results'));
    }

    public function getDashboardKpiInfo(){
        $header = array(
            'pageTitle' => 'KPI',
            'tableTitle' => ''
        );

        $results = DB::table('npoly_tickets as tkt')
            ->leftJoin('sa_lookup_data as lkp', 'tkt.priority_id', '=', 'lkp.LOOKUP_DATA_ID')
            ->leftJoin('sa_lookup_data as lkp1', 'tkt.ticket_status', '=', 'lkp1.LOOKUP_DATA_ID')
            ->leftJoin('npoly_clients as clnt', 'clnt.client_id', '=', 'tkt.client_id')
            ->leftJoin('npoly_projects as pro', 'pro.project_id', '=', 'tkt.project_id')
            ->leftJoin('npoly_task_report as tskr', 'tskr.ticket_id', '=', 'tkt.id')
            ->leftJoin('npoly_support_modules as tm', 'tm.module_id', '=', 'tkt.module_id')
            ->select('tkt.*','lkp.LOOKUP_DATA_NAME as priorityName','clnt.client_name','pro.project_name','tskr.employee_id','tskr.task_complete','lkp1.LOOKUP_DATA_NAME as ticketStatus','tm.module_name')
            ->where('reassign_fg',1)
            ->orderBy('tkt.id','desc')
            ->get();

        $kpicount= DB::table('npoly_kpi')
                        ->select('kpi_id')
                        ->where('active_status',1)
                        ->whereIn('department_id',[132,262])
                        ->count();

        return view('kpi.getTotalKpiDashboardInfo',compact('header','results','kpicount'));
    }

    // get mis kip info
    public function getMisItKpiInfo($deptId)
    {
        $header = array(
            'pageTitle' => 'KPI',
            'tableTitle' => ''
        );

            $results = DB::table('npoly_kpi as kpi')
                ->leftJoin('sa_lookup_data as lkp', 'kpi.department_id', '=', 'lkp.LOOKUP_DATA_ID')
                ->select('kpi.*','lkp.LOOKUP_DATA_NAME as department_name')
                ->where('department_id',$deptId)
                ->orderBy('kpi.kpi_id','desc')
                ->get();

            $departmentName = DB::table('sa_lookup_data')
                                ->select('lookup_data_name')
                                ->where('lookup_data_id',$deptId)
                                ->first()->lookup_data_name;

            $employees = DB::table('npoly_employees')
                                            ->select('employee_name','employee_id','department_id')
                                            ->where('department_id',$deptId)
                                            ->where('active_status',1)
                                            ->orderBy('user_serial_no')
                                            ->get();



        return view('kpi.dept_wise_kpi',compact('header','results','deptId','departmentName','employees'));
    }
    public function getTotalKpiInfo()
    {
        $header = array(
            'pageTitle' => 'KPI',
            'tableTitle' => ''
        );

            $results = DB::table('npoly_kpi as kpi')
                ->leftJoin('sa_lookup_data as lkp', 'kpi.department_id', '=', 'lkp.LOOKUP_DATA_ID')
                ->select('kpi.*','lkp.LOOKUP_DATA_NAME as department_name')
                ->whereIn('department_id',[132,262])
                ->orderBy('kpi.kpi_id','desc')
                ->get();


            $departmentName = DB::table('sa_lookup_data')
                                ->select('lookup_data_name')
                                //->where('lookup_data_id',$deptId)
                                ->first()->lookup_data_name;

        return view('kpi.getAllKpiInfo',compact('header','results','departmentName'));
    }

    public function getTodayTotalTaskInfo(){
        $header = array(
            'pageTitle' => 'Task Report',
            'tableTitle' => ''
        );
        $today = date('Y-m-d');
        $condition = "";
        if(Auth::user()->USERLVL_ID ==13){
            $empId = Auth::user()->employee_id;
            $condition .= " and emp.department_id in(132,262)";
            $condition .= " and emp.employee_id !=$empId";
        }

        $condition = "";
        if(Auth::user()->is_admin=='1'){
            $condition = "";
        }else if(Auth::user()->department_id =='132' || Auth::user()->department_id =='132'){
            $empId = Auth::user()->employee_id;
            $condition .= " and emp.department_id in(132,262)";
            $condition .= " and emp.employee_id !=$empId";
        }else{
            $empId = Auth::user()->employee_id;
            $departmentId = Auth::user()->department_id;
            $condition .= " and emp.department_id =  $departmentId";
            $condition .= " and emp.employee_id !=$empId";
        }

        $employees = DB::select("select emp.employee_id,emp.employee_name,lkp.LOOKUP_DATA_NAME AS department_name,lkp1.lookup_data_name as designation_name
                                    from npoly_employees as emp, sa_lookup_data as lkp,sa_lookup_data as lkp1
                                    WHERE emp.department_id = lkp.LOOKUP_DATA_ID
                                    AND emp.designation_id = lkp1.LOOKUP_DATA_ID
                                    AND emp.active_status =1
                                    $condition
                                    ORDER BY emp.user_serial_no");

        return view('task_report.today_task_report',compact('header','employees'));
    }

    public function getTodayRunningTaskInfo(){
        $header = array(
            'pageTitle' => 'Working Progress Task',
            'tableTitle' => ''
        );
        $today = date('Y-m-d');
       
        $condition = "";
        if(Auth::user()->USERLVL_ID ==13){
            $empId = Auth::user()->employee_id;
            $condition .= " and emp.department_id in(132,262)";
            $condition .= " and emp.employee_id !=$empId";
        }
        $employees = DB::select("select emp.employee_id,emp.employee_name,lkp.LOOKUP_DATA_NAME AS department_name,lkp1.lookup_data_name as designation_name
                                    from npoly_employees as emp, sa_lookup_data as lkp,sa_lookup_data as lkp1
                                    WHERE emp.department_id = lkp.LOOKUP_DATA_ID
                                    AND emp.designation_id = lkp1.LOOKUP_DATA_ID
                                    AND emp.active_status =1
                                    $condition
                                    ORDER BY emp.user_serial_no");

        return view('task_report.today_running_task_report',compact('header','employees'));
    }
    public function getTodayDeptTaskInfo($deptId){
        $header = array(
            'pageTitle' => 'Task Report',
            'tableTitle' => ''
        );
        $today = date('Y-m-d');

        $condition = "";
        if(Auth::user()->USERLVL_ID ==13){
            $empId = Auth::user()->employee_id;
            $condition .= " and emp.department_id = $deptId";
            $condition .= " and emp.employee_id !=$empId";
        }

        $employees = DB::select("select emp.employee_id,emp.employee_name,lkp.LOOKUP_DATA_NAME AS department_name,lkp1.lookup_data_name as designation_name
                                    from npoly_employees as emp, sa_lookup_data as lkp,sa_lookup_data as lkp1
                                    WHERE emp.department_id = lkp.LOOKUP_DATA_ID
                                    AND emp.designation_id = lkp1.LOOKUP_DATA_ID
                                    AND emp.active_status =1
                                    AND emp.department_id = $deptId
                                    ORDER BY emp.user_serial_no");

        return view('task_report.today_task_report',compact('header','employees'));
    }

    public function getTodayDeptRunningTaskInfo($deptId){
        $header = array(
            'pageTitle' => 'Task Report',
            'tableTitle' => ''
        );
        $today = date('Y-m-d');

        $condition = "";
        if(Auth::user()->USERLVL_ID ==13){
            $empId = Auth::user()->employee_id;
            $condition .= " and emp.department_id = $deptId";
            $condition .= " and emp.employee_id !=$empId";
        }

        $employees = DB::select("select emp.employee_id,emp.employee_name,lkp.LOOKUP_DATA_NAME AS department_name,lkp1.lookup_data_name as designation_name
                                    from npoly_employees as emp, sa_lookup_data as lkp,sa_lookup_data as lkp1
                                    WHERE emp.department_id = lkp.LOOKUP_DATA_ID
                                    AND emp.designation_id = lkp1.LOOKUP_DATA_ID
                                    AND emp.active_status =1
                                    AND emp.department_id = $deptId
                                    ORDER BY emp.user_serial_no");

        return view('task_report.today_running_task_report',compact('header','employees'));
    }

    public function getAllPendingTaskDetails(){
        $header = array(
            'pageTitle' => 'Pending Task',
            'tableTitle' => ''
        );
        $today = date('Y-m-d');


        $results = DB::select("select DISTINCT(tr.employee_id) employee_id, emp.employee_name,lkp.LOOKUP_DATA_NAME as department_name,lkp1.LOOKUP_DATA_NAME as designation_name
                                            from npoly_task_report as tr, npoly_employees as emp, sa_lookup_data as lkp, sa_lookup_data as lkp1
                                            WHERE tr.employee_id = emp.employee_id
                                            AND emp.department_id = lkp.LOOKUP_DATA_ID
                                            AND emp.designation_id = lkp1.LOOKUP_DATA_ID
                                            AND tr.task_complete < 100
                                            AND tr.department_id !=0
                                            AND tr.forecast_date < '$today'");
        return view('task_report.totalPendingTask',compact('header','results'));
        


    }
    public function getDeptWisePendingTask($id){
        $header = array(
            'pageTitle' => 'Pending Task',
            'tableTitle' => ''
        );
        $today = date('Y-m-d');


        $results = DB::select("select DISTINCT(tr.employee_id) employee_id, emp.employee_name,lkp.LOOKUP_DATA_NAME as department_name,lkp1.LOOKUP_DATA_NAME as designation_name
                                            from npoly_task_report as tr, npoly_employees as emp, sa_lookup_data as lkp, sa_lookup_data as lkp1
                                            WHERE tr.employee_id = emp.employee_id
                                            AND emp.department_id = lkp.LOOKUP_DATA_ID
                                            and emp.designation_id = lkp1.LOOKUP_DATA_ID
                                            and tr.task_complete < 100
                                            and  tr.department_id = $id
                                            AND tr.forecast_date < '$today'");
        return view('task_report.totalPendingTask',compact('header','results'));


    }
    public function getPendingTaskDetails($id){
        $header = array(
            'pageTitle' => 'Pending Task',
            'tableTitle' => ''
        );
        $today = date('Y-m-d');
        $condition = '';

        if($id ==132){
            $condition .=" and tr.department_id = $id";
        }else if($id ==262){
            $condition .=" and tr.department_id = $id";
        }else{
            $condition .=" ";
        }

        $results = DB::select("select DISTINCT(tr.employee_id) employee_id, emp.employee_name,lkp.LOOKUP_DATA_NAME as department_name,lkp1.LOOKUP_DATA_NAME as designation_name
                                            from npoly_task_report as tr, npoly_employees as emp, sa_lookup_data as lkp, sa_lookup_data as lkp1
                                            WHERE tr.employee_id = emp.employee_id
                                            AND emp.department_id = lkp.LOOKUP_DATA_ID
                                            and emp.designation_id = lkp1.LOOKUP_DATA_ID
                                            and tr.task_complete < 100
                                              $condition
                                            AND tr.forecast_date < '$today'");
        return view('task_report.totalPendingTask',compact('header','results'));


    }

    public function showPendingTaskDetailsInfo($empId){
        $header = array(
            'pageTitle' => 'Pending Task',
            'tableTitle' => ''
        );
        $today = date('Y-m-d');
        $results = DB::select("SELECT tr.task_title,tr.task_desc,tr.assign_date,tr.forecast_date,tr.task_complete,tr.fdate_change_reason
                            from npoly_task_report as tr
                            WHERE tr.employee_id = $empId
                            AND tr.task_complete < 100
                            AND tr.department_id != 0
                            AND tr.forecast_date < '$today'");


        return view('task_report.pendingTaskInfo',compact('results','header'));

    }

    public function getScheduleInfo(){
        $header = array(
            'pageTitle' => 'Pending Schedule',
            'tableTitle' => ''
        );
        $fromDate = date('Y-m-01');
        $toDate = date('Y-m-t');
        $today = date('Y-m-d');

        /*$resultss = DB::select("select DISTINCT (tr.employee_id) employee_id,emp.employee_name ,
                                lkp.LOOKUP_DATA_NAME as department_name,lkp1.LOOKUP_DATA_NAME as designation_name
                                FROM npoly_task_report tr, npoly_employees as emp , sa_lookup_data as lkp ,sa_lookup_data as lkp1
                                WHERE tr.employee_id = emp.employee_id
                                AND emp.department_id = lkp.LOOKUP_DATA_ID
                                AND emp.designation_id = lkp1.LOOKUP_DATA_ID
                                AND tr.project_id in(4,10,11)
                                AND tr.department_id !=0
                                AND tr.task_create_date = $today
                                AND tr.task_create_date BETWEEN '$fromDate'AND'$toDate'");*/

        $results = DB::select("SELECT DISTINCT tr.employee_id,emp.employee_name,lkp.LOOKUP_DATA_NAME as department_name,lkp1.LOOKUP_DATA_NAME as designation_name

        FROM npoly_task_report as tr, npoly_employees as emp ,sa_lookup_data as lkp, sa_lookup_data as lkp1
        WHERE tr.employee_id = emp.employee_id
        AND tr.assign_date = '$today'
        AND tr.project_id in(4,10,11)
        AND tr.department_id != 0
        AND tr.employee_id !=0
        AND tr.assign_date BETWEEN '$fromDate'AND'$toDate'
        AND tr.department_id = lkp.LOOKUP_DATA_ID
        AND emp.designation_id = lkp1.LOOKUP_DATA_ID");                      

        return view('schedule.totalSchedule',compact('header','results'));

    }
    public function getAllScheduleInfoDeptWise($id){
        $header = array(
            'pageTitle' => 'Pending Schedule',
            'tableTitle' => ''
        );
        $fromDate = date('Y-m-01');
        $toDate = date('Y-m-t');
        $today = date('Y-m-d');

       /* $resultss = DB::select("select DISTINCT (tr.employee_id) employee_id,emp.employee_name ,
                                lkp.LOOKUP_DATA_NAME as department_name,lkp1.LOOKUP_DATA_NAME as designation_name
                                FROM npoly_task_report tr, npoly_employees as emp , sa_lookup_data as lkp ,sa_lookup_data as lkp1
                                WHERE tr.employee_id = emp.employee_id
                                AND emp.department_id = lkp.LOOKUP_DATA_ID
                                AND emp.designation_id = lkp1.LOOKUP_DATA_ID
                                AND tr.project_id in(4,10,11)
                                AND tr.department_id = $id
                                AND tr.task_create_date = $today
                                AND tr.task_create_date BETWEEN '$fromDate'AND'$toDate'");*/
        $results = DB::select("SELECT DISTINCT tr.employee_id,emp.employee_name,lkp.LOOKUP_DATA_NAME as department_name,lkp1.LOOKUP_DATA_NAME as designation_name

        FROM npoly_task_report as tr, npoly_employees as emp ,sa_lookup_data as lkp, sa_lookup_data as lkp1
        WHERE tr.employee_id = emp.employee_id
        AND tr.assign_date = '$today'
        AND tr.project_id in(4,10,11)
        AND tr.department_id = $id
        AND tr.employee_id !=0
        AND tr.assign_date BETWEEN '$fromDate'AND'$toDate'
        AND tr.department_id = lkp.LOOKUP_DATA_ID
        AND emp.designation_id = lkp1.LOOKUP_DATA_ID");  

        return view('schedule.totalSchedule',compact('header','results'));

    }
    public function getScheduleInfoDeptWise($id){
        $header = array(
            'pageTitle' => 'Pending Schedule',
            'tableTitle' => ''
        );

        $condition = '';

        if($id ==132){
            $condition .=" and tr.department_id = $id";
        }else if($id ==262){
            $condition .=" and tr.department_id = $id";
        }else{
            $condition .=" ";
        }

        $results = DB::select("select DISTINCT (tr.employee_id) employee_id,emp.employee_name ,
                                lkp.LOOKUP_DATA_NAME as department_name,lkp1.LOOKUP_DATA_NAME as designation_name
                                FROM npoly_task_report tr, npoly_employees as emp , sa_lookup_data as lkp ,sa_lookup_data as lkp1
                                WHERE tr.employee_id = emp.employee_id
                                and emp.department_id = lkp.LOOKUP_DATA_ID
                                and emp.designation_id = lkp1.LOOKUP_DATA_ID
                                and tr.project_id in(4,10,11)
                                  $condition
                                AND tr.task_create_date BETWEEN '2023-06-01'AND'2023-06-30'");

        return view('schedule.totalSchedule',compact('header','results'));

    }

    public function getScheduleDetailsInfo($empId){
        $header = array(
            'pageTitle' => 'Schedule Details',
            'tableTitle' => ''
        );
        $today = date('Y-m-d');
        $fromDate = date('Y-m-01');
        $toDate = date('Y-m-t');
        $results = DB::select("SELECT tr.task_title,tr.task_desc,tr.assign_date,tr.forecast_date,tr.task_complete,tr.fdate_change_reason
                            from npoly_task_report as tr
                            WHERE tr.employee_id = $empId
                              and tr.project_id in(4,10,11)
                              and tr.task_create_date = '$today'
                            and tr.task_create_date between '$fromDate' and '$toDate'");


        return view('schedule.scheduleDetails',compact('results','header'));

    }
    public function showTaskDetailsInfo($empId){
        $results = DB::table('npoly_task_report as tr')
            ->leftJoin('npoly_employees as emp','emp.employee_id','=','tr.assign_by')
            ->select('tr.task_title','tr.task_desc','tr.forecast_date','tr.task_complete','emp.employee_name as assign_person_name')
            ->where('tr.employee_id',$empId)
            ->where('tr.task_create_date',date('Y-m-d'))
            ->where('tr.active_status',1)
            ->orderBy('tr.task_id','desc')
            ->get();

        return view("task_report.show_task_details_info",compact('results'));
    }
    
    public function showPendingTaskInfo($empId){
        $results = DB::table('npoly_task_report as tr')
            ->leftJoin('npoly_employees as emp','emp.employee_id','=','tr.assign_by')
            ->select('tr.task_title','tr.task_desc','tr.forecast_date','tr.task_complete','emp.employee_name as assign_person_name')
            ->where('tr.employee_id',$empId)
            ->where('tr.task_create_date',date('Y-m-d'))
            ->where('tr.active_status',1)
            ->where('task_complete',0)
            ->where('task_running',0)
            ->orderBy('tr.task_id','desc')
            ->get();

        return view("task_report.show_task_details_info",compact('results'));
    }

    public function showCompleteTaskInfo($empId){
        $results = DB::table('npoly_task_report as tr')
            ->leftJoin('npoly_employees as emp','emp.employee_id','=','tr.assign_by')
            ->select('tr.task_title','tr.task_desc','tr.forecast_date','tr.task_complete','emp.employee_name as assign_person_name')
            ->where('tr.employee_id',$empId)
            ->where('tr.task_create_date',date('Y-m-d'))
            ->where('tr.active_status',1)
            ->where('task_complete',100)
            ->where('task_running',0)
            ->orderBy('tr.task_id','desc')
            ->get();

        return view("task_report.show_task_details_info",compact('results'));
    }

    public function showTaskRunningDetailsInfo($empId){
        $results = DB::table('npoly_task_report as tr')
            ->leftJoin('npoly_employees as emp','emp.employee_id','=','tr.assign_by')
            ->select('tr.task_title','tr.task_desc','tr.forecast_date','tr.task_complete','emp.employee_name as assign_person_name')
            ->where('tr.employee_id',$empId)
            ->where('tr.task_create_date',date('Y-m-d'))
            ->where('tr.active_status',1)
            ->where('tr.task_running',1)
            ->orderBy('tr.task_id','desc')
            ->get();

        return view("task_report.show_running_task_details_info",compact('results'));
    }

     public function getAllEmployee()
    {
        $header = array(
            'pageTitle' => 'All Employee',
            'tableTitle' => ''
        );
        $department = "";
        if(Auth::user()->is_admin=='1'){
            $department = "";
        }else if(Auth::user()->department_id=='132' || Auth::user()->department_id=='262'){
            $department = " and department_id in('132','262')";
        }else{
            $deptId = Auth::user()->department_id;
            $department = " and department_id = $deptId"; 
        }
        $results = DB::select("select `emp`.*, `lkp`.`LOOKUP_DATA_NAME` as `department_name`, `lkp1`.`LOOKUP_DATA_NAME` as `designation_name`
         from `npoly_employees` as `emp` 
         left join `sa_lookup_data` as `lkp` on `emp`.`department_id` = `lkp`.`LOOKUP_DATA_ID` 
         left join `sa_lookup_data` as `lkp1` on `emp`.`designation_id` = `lkp1`.`LOOKUP_DATA_ID` 
         where `emp`.`active_status` = 1  
         $department
         order by `emp`.`user_serial_no` asc");
           

            return view("employee.get_all_employee",compact('results','header'));
    }

  public function getPresentEmployee()
    {
        $header = array(
            'pageTitle' => 'Present Employee',
            'tableTitle' => ''
        );
        $today = date('Y-m-d');

        $department = "";
        if(Auth::user()->is_admin=='1'){
            $department .="";
        }else if(Auth::user()->department_id == '132' || Auth::user()->department_id =='262'){
            $department .=" and emp.department_id in ('132','262')";
        }else{
            $depId = Auth::user()->department_id;
            $department .= " and emp.department_id = $depId";
        }


        // $results = DB::table('npoly_employeess as emp')
        //     ->leftJoin('npoly_task_report as tr','emp.employee_id','=','tr.employee_id')
        //     ->leftJoin('sa_lookup_data as lkp','emp.department_id','=','lkp.LOOKUP_DATA_ID')
        //     ->leftJoin('sa_lookup_data as lkp1','emp.designation_id','=','lkp1.LOOKUP_DATA_ID')
        //     ->select('emp.*','lkp.LOOKUP_DATA_NAME as department_name','lkp1.LOOKUP_DATA_NAME as designation_name')
        //     ->where('emp.active_status',1)
        //     ->where('tr.task_create_date',$today)
        //     ->distinct('tr.employee_id')
        //     ->orderBy('emp.user_serial_no')
        //     ->get();

        $results = DB::select("select distinct `emp`.*, `lkp`.`LOOKUP_DATA_NAME` as `department_name`, `lkp1`.`LOOKUP_DATA_NAME` as `designation_name` from `npoly_employees` as `emp` 
        left join `npoly_task_report` as `tr` on `emp`.`employee_id` = `tr`.`employee_id` 
        left join `sa_lookup_data` as `lkp` on `emp`.`department_id` = `lkp`.`LOOKUP_DATA_ID` 
        left join `sa_lookup_data` as `lkp1` on `emp`.`designation_id` = `lkp1`.`LOOKUP_DATA_ID` 
        where `emp`.`active_status` = 1 
        and `tr`.`task_create_date` = '$today' 
        $department
        order by `emp`.`user_serial_no` asc");

            return view("employee.get_all_employee",compact('results','header'));
    }

    public function getAbsentEmployee()
    {
        $header = array(
            'pageTitle' => 'Absent Employee',
            'tableTitle' => ''
        ); 
        $results = [];
        $today = date('Y-m-d');

        $department = "";
        if(Auth::user()->is_admin=='1'){
            $department .="";
        }else if(Auth::user()->department_id == '132' || Auth::user()->department_id =='262'){
            $department .=" and department_id in ('132','262')";
        }else{
            $depId = Auth::user()->department_id;
            $department .= " and department_id = $depId";
        }

        $totalPresentEmployee = DB::select("select DISTINCT employee_id  FROM npoly_task_report WHERE task_create_date = '$today'");

        $countTotalEmp = count($totalPresentEmployee);

        if($countTotalEmp > 0){
            $empIdIn = [];
        foreach($totalPresentEmployee as $empId){
            $empIdIn [] =  $empId->employee_id;
        }
        $empIdNotIn = implode(',',$empIdIn);
        if(!empty($empIdNotIn)){

            $results = DB::select("select emp.*, lkp.lookup_data_name as department_name, lkp1.lookup_data_name as designation_name from npoly_employees as emp, sa_lookup_data as lkp, sa_lookup_data as lkp1
            where emp.department_id = lkp.lookup_data_id
            and emp.designation_id = lkp1.lookup_data_id
             and employee_id not in($empIdNotIn)
             $department
             order by emp.user_serial_no");

        return view("employee.get_all_employee",compact('results','header'));

           
        }
        }

        
        return view("employee.get_all_employee",compact('results','header'));
    }


}
