<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
use Mail;
use DatePeriod;
use DateTime;
use DateInterval;
use App\Jobs\SendNotification;
class VehicleController extends Controller
{
    public function vehicleCreateInfo(Request $request){
        try {

        $visitList = DB::table('sa_lookup_data')
        ->select('LOOKUP_DATA_ID as visit_type_id', 'LOOKUP_DATA_NAME as visit_type_name')
        ->where('LOOKUP_GRP_ID', '47')
        ->where('active_flag',1)
        ->get();
        $employeeList = DB::table('npoly_employees as emp')
        ->leftJoin('set_department as dept','emp.department_id','=','dept.id')
        ->leftJoin('set_designation as desig','emp.designation_id','=','desig.id')
        ->select('emp.employee_name','emp.employee_id','dept.department_name','desig.designation_name')
        ->where('emp.active_status',1)
        ->get();

        return response()->json([
            "success" => true,
            "message" => "Data get successfully.",
             "visit_list" =>$visitList,
             "employee_list" =>$employeeList,
        ],200);
          
          } catch (\Exception $e) {
          
            return response()->json([
            "success" => false,
            "message" => "Something Went Wrong.",
        ],500);
          }

    }
    public function vehicleCreate1(Request $request){

      $input = $request->all();
      $empNumber = $input['employee_number'];
      $userId = DB::table('users')->select('*')->where('employee_number',$empNumber)->first();
      $deptHeadMail = DB::table('users')->select('email_address','employee_number')->where('is_dept_head',1)->where('department_id',$userId->department_id)->first();
     // $fcmRegId = DB::connection('oracle')->selectOne("select FCM_REG_ID from XX_TKT_OFF_APP_USERS where employee_number = $empNumber");
     // $fcmRegId = DB::connection('oracle')->table('XX_TKT_OFF_APP_USERS')->select('FCM_REG_ID')->where('employee_number',$empNumber)->first();
      //dd($fcmRegId->fcm_reg_id);
      $employeesList =$input['employees_id'] ? $input['employees_id']:[];
    //   return response()->json([
    //     "success" => true,
    //     "status" => 200,
    //     "emplo_list" => $employeesList,
    //     "message" => "Data get successfully.",
    // ],200);
      
      $requestMstData = array(
          "visit_type_id"      => $input['visit_type'],
          "trip_type_id"       => $input['vahicle_trip'],
          "visit_place"        => $input['visit_place'] ?$input['visit_place']:"Npoly",
          "from_date"          => $input['start_date'] ? date('Y-m-d',strtotime($input['start_date'])):"",
          "to_date"            => $input['end_date'] ? date('Y-m-d',strtotime($input['end_date'])):"",
          "start_time"         => $input['start_time'] ? strtotime($input['start_time']) - strtotime('today'):"",
          "end_time"           => $input['end_time'] ? strtotime($input['end_time']) - strtotime('today'):"",
          "status"             => 300,
          "active_status"      => 1,
          "created_dept"       => $userId->department_id,
          "group_request"      => $input['group_request'] ? $input['group_request']:"0",
          "created_by"         => $userId->id,
          "request_from"         => 2,
          "created_at"         => date('Y-m-d H:i:s'),
      );

      DB::beginTransaction();
      try {
          $masterInsertedId = DB::table('vehicel_request_mst')->insertGetId($requestMstData);
          //DB::commit();
          
          if ($input['group_request'] =='2') {
              $employeesList = $input['employees_id'];
              foreach ($employeesList as $key => $value) {
                  $requestChaid = array(
                      "request_id"         => $masterInsertedId,
                      "employee_number"    => DB::table('npoly_employees')->select('employee_number')->where('employee_id', $value['_id'])->first()->employee_number,
                      "department_id"      => DB::table('npoly_employees')->select('department_id')->where('employee_id', $value['_id'])->first()->department_id,
                      "pickup_time"        => $value['start_time'] ? strtotime($value['start_time']) - strtotime('today') : strtotime($input['start_time']) - strtotime('today'),
                      "start_time"         => $input['start_time'] ? strtotime($input['start_time']) - strtotime('today'):"",
                      "end_time"           => $input['end_time'] ? strtotime( $input['end_time']) - strtotime('today'):"",
                      "pick_up_point"      => $value['pickUp_value']? $value['pickUp_value']:"",
                      "active_status"      => 1,
                      "created_by"         => $userId->id,
                      "created_at"         => date('Y-m-d H:i:s'),
                  );
                  DB::table('vehicel_request_chd')->insert($requestChaid);
              }

              // email starthere
                $data['visit_place'] = $input['visit_place'];
                $data['name'] = $userId->name;
                $data['department_name'] = $userId->department_name;
                $data['designation_name'] = $userId->designation_name;
                $data['from_date'] = date('d-M-Y',strtotime($input['start_date']));
                $data['to_date'] = date('d-M-Y',strtotime($input['end_date']));
                $data['title'] = 'Vehicle Request';
                $data['request_type'] = 2;
                $data['to_email'] = $deptHeadMail->email_address;

                $sent = Mail::send('emails.vehicle_req_dept', $data, function ($email) use ($data) {
                    $email->subject($data['title']);
                    $email->from('ticket@nationalpolymer.net','Vehicle Request');
                    $email->to([$data['to_email']]);
                    //$email->to(['azam.ali@nationalpolymer.net']);
                    //$email->to(['mahdi.hasan@nationalpolymer.net']);
                   // $email->cc([$data['req_email']]);
                    //$email->bcc('azam.ali@nationalpolymer.net');
                  });

                  $employeeNumber =$deptHeadMail->employee_number;
                  $empName =  $userId->name;
                  $title = 'Vehicle Request';
                  $body = 'A new vehicle request has been submitted by '.$empName. ' . Please review and approve the request.';
                  dispatch(new sendNotification((object)$request->all(),$employeeNumber,$title,$body));
          } else {
              $requestChaid = array(
                  "request_id"         => $masterInsertedId,
                  "employee_number"    => $userId->employee_number,
                  "department_id"      => $userId->department_id,
                  "start_time"         => $input['start_time'] ? strtotime($input['start_time']) - strtotime('today'):"",
                  "end_time"           => $input['end_time'] ? strtotime($input['end_time']) - strtotime('today'):"",
                  "pick_up_point"      => $input['pickup_point'],
                  "pickup_time"        => $input['start_time'] ? strtotime($input['start_time']) - strtotime('today'):"",
                  "active_status"      => 1,
                  "created_by"         => $userId->id,
                  "created_at"         => date('Y-m-d H:i:s'),
              );
              DB::table('vehicel_request_chd')->insertGetId($requestChaid);
              // emial start here
              $data['visit_place'] = $input['visit_place'];
                $data['name'] = $userId->name;
                $data['department_name'] = $userId->department_name;
                $data['designation_name'] = $userId->designation_name;
                $data['from_date'] = date('d-M-Y',strtotime($input['start_date']));
                $data['to_date'] = date('d-M-Y',strtotime($input['end_date']));
                $data['title'] = 'Vehicle Request';
                $data['request_type'] = 1;
                $data['to_email'] = $deptHeadMail->email_address;

                $sent = Mail::send('emails.vehicle_req_dept', $data, function ($email) use ($data) {
                $email->subject($data['title']);
                $email->from('ticket@nationalpolymer.net','Vehicle Request');
                $email->to([$data['to_email']]);
                //$email->to(['azam.ali@nationalpolymer.net']);
               // $email->cc([$data['req_email']]);
                //$email->bcc('azam.ali@nationalpolymer.net');
            });

                  $employeeNumber =$deptHeadMail->employee_number;
                  $empName =  $userId->name;
                  $title = 'Vehicle Request';
                  $body = 'A new vehicle request has been submitted by '.$empName. ' . Please review and approve the request.';
                  dispatch(new sendNotification((object)$request->all(),$employeeNumber,$title,$body));
          }
          DB::commit();

          //$deptHeadEmpNumber = DB::selectOne("select employee_number from users where department_id = $userId->department_id and is_dept_head = 1");


          //$this::sendNotification($deptHeadEmpNumber->employee_number);

          return response()->json([
            "success" => true,
            "status" => 200,
            "message" => "Data get successfully.",
        ],200);
          
      } catch (\Throwable $e) {
          DB::rollback();
          throw $e;
          exit;
      }
  }
  public function approveByAdmin1(Request $request){
    $input = $request->all();
    $child = $input['participants_info'];
    $userId = $input['userId'];
    $id = $input['id'];
    $driver_id = $input['driver_id'];
    $vehicle_id = $input['vehicle_id'];
    $status= $input['status'];
    //$ids = implode(',',$reqIds);
        // cancel mail start here
        if($status=='303'){
          $updateinfo = array(
              "status"=> $status,
              "canceled_by"=>$userId,
              "canceled_at"=> date('Y-m-d h:i A'),
          );
          $update = DB::table('vehicel_request_mst')->where('id', $id)->update($updateinfo);
          
          $userId = DB::table('vehicel_request_mst')->select('*')->where('id', $id)->first();
          $reqInfo = DB::table('users')->select('email_address','department_id','employee_number')->where('id',$userId->created_by)->first();
          $deptEmail = DB::table('users')->select('email_address')->where('is_dept_head',1)->where('department_id',$reqInfo->department_id)->first();
          $data['title'] = 'Vehicle Request has been Cancelled';
          $data['to_email'] =  $reqInfo->email_address;
          $data['cc_email'] =  $deptEmail->email_address;

          $data['from_date'] =  $userId->from_date;
          $data['to_date'] =  $userId->to_date;
          $data['start_time'] =  $userId->start_time;
          $data['visit_place'] =  $userId->visit_place ? $userId->visit_place:"";

          $sent = Mail::send('emails.vehicle_cancel_admin', $data, function ($email) use ($data) {
              $email->subject($data['title']);
              $email->from('ticket@nationalpolymer.net','Vehicle Request');
              $email->to([$data['to_email']]);
             // $email->to(['azam.ali@nationalpolymer.net']);
              $email->cc([$data['cc_email']]);
              $email->bcc('admnpil@nationalpolymer.net');
              //$email->bcc('azam.ali@nationalpolymer.net');
          });

            $employeeNumber =  $reqInfo->employee_number;
            $title = 'Vehicle Request';
            $body = 'Your vehicle request for '.date('d-M-Y',strtotime($userId->from_date)).' to '. date('d-M-Y',strtotime($userId->to_date)) .' visit place ' . $userId->visit_place . ' has been canceled.';
            dispatch(new sendNotification((object)$request->all(),$employeeNumber,$title,$body));

          return response()->json([
            "success" => true,
            "status" => 200,
            "message" => "Data get successfully.",
        ],200);
      }
      // cancel mail end here
    if($id && $datas = DB::table('vehicel_request_mst')->where('id', $id)->first()){
      $requestData = array(
      //"start_time"         => $request->start_time ? strtotime($request->start_time) - strtotime('today'):$data->start_time,
      //"end_time"           => $request->start_time ? strtotime($request->end_time) - strtotime('today'):$data->end_time,
      "status"             => $status,
      "vehicle_id"         =>  $vehicle_id,
      "driver_id"          => $driver_id,
      "approved_by"         => $userId,
      "approved_at"         => date('Y-m-d H:i:s'),
      );
  
      DB::beginTransaction();
      try {
          DB::table('vehicel_request_mst')
              ->where('id', $id)
              ->update($requestData);
  
              //$deletePre = DB::table('vehicel_request_chd')->where('request_id',$id)->delete();
              $child = $input['participants_info'];
              //dd($child[0]['id']);
              foreach ($child as $key => $chId) {
                  DB::table('vehicel_request_chd')->where('id',$chId['id'])->update([
                      "pick_up_point"      => $chId['pick_up_point'],
                      "pickup_time"        => $chId['pickup_time'] ? strtotime($chId['pickup_time']) - strtotime('today') : "",
                  ]);
              }
  
          DB::commit();
          // email start here
          $reqMstInfo = DB::table('vehicel_request_mst')->select('*')->where('id',$id)->first();
          $reqInfo = DB::table('users')->select('email_address','department_id','employee_number')->where('id',$reqMstInfo->created_by)->first();
          $deptEmail = DB::table('users')->select('email_address')->where('is_dept_head',1)->where('department_id',$reqInfo->department_id)->first();
  
          if($reqMstInfo->group_request !='2'){
          $driverInfo = DB::table('npoly_driver')->select('*')->where('id',$driver_id)->first();
          $vehicleInfo = DB::table('npoly_vehicel')->select('*')->where('id',$vehicle_id)->first();
          $data['vehicel_no'] = $vehicleInfo->vehicel_no;
          $data['vehicle_name'] = $vehicleInfo->name;
          $data['driver_name'] = $driverInfo->name;
          $data['driver_mobile'] = $driverInfo->mobile;
          $data['title'] = 'Vehicle Request';
          $data['to_email'] =  $reqInfo->email_address;
          $data['cc_email'] =  $deptEmail->email_address;
  
          $sent = Mail::send('emails.approve_vehicle', $data, function ($email) use ($data) {
              $email->subject($data['title']);
              $email->from('ticket@nationalpolymer.net','Vehicle Request');
              $email->to([$data['to_email']]);
             // $email->to(['azam.ali@nationalpolymer.net']);
              $email->cc([$data['cc_email']]);
              $email->bcc('admnpil@nationalpolymer.net');
              //$email->bcc('azam.ali@nationalpolymer.net');
          });

            $employeeNumber =  $reqInfo->employee_number;
            $title = 'Vehicle Request';
            $body = 'Your vehicle request for '.date('d-M-Y',strtotime($reqMstInfo->from_date)).' to '. date('d-M-Y',strtotime($reqMstInfo->to_date)) .' visit place ' . $reqMstInfo->visit_place . ' has been approved. For more details please login application.';
            dispatch(new sendNotification((object)$request->all(),$employeeNumber,$title,$body));

          }else{
          $participant = DB::select("SELECT chd.pick_up_point,emp.employee_name,emp.mobile_no,emp.email,chd.employee_number,
                                      TIME_FORMAT(SEC_TO_TIME( chd.pickup_time), '%h:%i %p') as pickup_time
                                      FROM vehicel_request_chd chd, npoly_employees emp
                                      WHERE chd.employee_number = emp.employee_number
                                      AND chd.request_id = $id");
          $array_values= [];
          foreach($participant as $array)
          {
              $array_values[]=$array->email;
              $employeeNumber =  $array->employee_number;
              $title = 'Vehicle Request';
              $body = 'Your vehicle request for '.date('d-M-Y',strtotime($reqMstInfo->from_date)).' to '. date('d-M-Y',strtotime($reqMstInfo->to_date)) .' visit place ' . $reqMstInfo->visit_place . ' has been approved. For more details please login application.';
              dispatch(new sendNotification((object)$request->all(),$employeeNumber,$title,$body));
          }

          $ccToMail =  array_values($array_values);

          $driverInfo = DB::table('npoly_driver')->select('*')->where('id',$driver_id)->first();
          $vehicleInfo = DB::table('npoly_vehicel')->select('*')->where('id',$vehicle_id)->first();
          $data['vehicel_no'] = $vehicleInfo->vehicel_no;
          $data['vehicle_name'] = $vehicleInfo->name;
          $data['driver_name'] = $driverInfo->name;
          $data['driver_mobile'] = $driverInfo->mobile;
          $data['title'] = 'Vehicle Request';
          $data['participants'] = $participant;
          $data['to_email'] = $deptEmail->email_address;
          $sent = Mail::send('emails.approve_vehicle_group', $data, function ($email) use ($data,$ccToMail) {
              $email->subject($data['title']);
              $email->from('ticket@nationalpolymer.net','Vehicle Request');
              $email->to([$data['to_email']]);
              //$email->to(['azam.ali@nationalpolymer.net']);
              $email->cc($ccToMail);
              $email->bcc('admnpil@nationalpolymer.net');
              //$email->bcc('azam.ali@nationalpolymer.net');
          });
          }

          return response()->json([
            "success" => true,
            "status" => 200,
            "message" => "Data get successfully.",
        ],200);
         
          
          // email end here
      } catch (\Throwable $e) {
          DB::rollback();
          return response()->json([
            "success" => true,
            "status" => 500,
            "message" => "Something Went Wrong !",
        ],500);
      }
  
    }
  }
  public function approveByAdmin(Request $request){
    $input = $request->all();
    $child = $input['participants_info'];
    $userId = $input['userId'];
    $id = $input['id'];
    $driver_id = $input['driver_id'];
    $vehicle_id = $input['vehicle_id'];
    $status= $input['status'];
    //$ids = implode(',',$reqIds);
        // cancel mail start here
        if($status=='303'){
          $updateinfo = array(
              "status"=> $status,
              "canceled_by"=>$userId,
              "canceled_at"=> date('Y-m-d h:i A'),
          );
          $update = DB::table('vehicel_request_mst')->where('id', $id)->update($updateinfo);
          
          $userId = DB::table('vehicel_request_mst')->select('*')->where('id', $id)->first();

          $prevDriver = "";
          $prevVehicle = "";

          if(!empty($userId->vehicle_id)){
              $prevDriver = DB::table('npoly_driver')->select('*')->where('id',$userId->driver_id)->first();
              $prevVehicle = DB::table('npoly_vehicel')->select('*')->where('id',$userId->vehicle_id)->first();
          }

          $reqInfo = DB::table('users')->select('email_address','department_id','employee_number')->where('id',$userId->created_by)->first();
          $deptEmail = DB::table('users')->select('email_address')->where('is_dept_head',1)->where('department_id',$reqInfo->department_id)->first();
          $data['title'] = 'Vehicle Request has been Cancelled';
          $data['to_email'] =  $reqInfo->email_address;
          $data['cc_email'] =  $deptEmail->email_address;

          $data['from_date'] =  $userId->from_date;
          $data['to_date'] =  $userId->to_date;
          $data['start_time'] =  $userId->start_time;
          $data['visit_place'] =  $userId->visit_place ? $userId->visit_place:"";

          $data['dirver_info'] = $prevDriver ? $prevDriver : "";
          $data['vehicle_info'] = $prevVehicle ? $prevVehicle : "";

          $sent = Mail::send('emails.vehicle_cancel_admin', $data, function ($email) use ($data) {
            $email->subject($data['title']);
            $email->from('ticket@nationalpolymer.net','Vehicle Request');
            $email->to([$data['to_email']]);
            $email->cc([$data['cc_email']]);
            $email->bcc('admnpil@nationalpolymer.net');
        });
            $employeeNumber =  $reqInfo->employee_number;
            $title = 'Vehicle Request';
            $body = 'Your vehicle request for '.date('d-M-Y',strtotime($userId->from_date)).' to '. date('d-M-Y',strtotime($userId->to_date)) .' visit place ' . $userId->visit_place . ' has been canceled.';
            dispatch(new sendNotification((object)$request->all(),$employeeNumber,$title,$body));

          return response()->json([
            "success" => true,
            "status" => 200,
            "message" => "Data get successfully.",
        ],200);
      }
      // cancel mail end here
    if($id && $datas = DB::table('vehicel_request_mst')->where('id', $id)->first()){

      $setVehicleId = $datas->vehicle_id;
      $setDirverId = $datas->driver_id;
      $setDriverInfo = "";
      $setVehicleInfo = "";
      if(!empty($setVehicleId)){
          $setDriverInfo = DB::table('npoly_driver')->select('*')->where('id',$setDirverId)->first();
          $setVehicleInfo = DB::table('npoly_vehicel')->select('*')->where('id',$setVehicleId)->first();
      }

      $requestData = array(
      //"start_time"         => $request->start_time ? strtotime($request->start_time) - strtotime('today'):$data->start_time,
      //"end_time"           => $request->start_time ? strtotime($request->end_time) - strtotime('today'):$data->end_time,
      "status"             => $status,
      "vehicle_id"         =>  $vehicle_id,
      "driver_id"          => $driver_id,
      "approved_by"         => $userId,
      "approved_at"         => date('Y-m-d H:i:s'),
      );
  
      DB::beginTransaction();
      try {
          DB::table('vehicel_request_mst')
              ->where('id', $id)
              ->update($requestData);
  
              //$deletePre = DB::table('vehicel_request_chd')->where('request_id',$id)->delete();
              $child = $input['participants_info'];
              //dd($child[0]['id']);
              foreach ($child as $key => $chId) {
                  DB::table('vehicel_request_chd')->where('id',$chId['id'])->update([
                      "pick_up_point"      => $chId['pick_up_point'],
                      "pickup_time"        => $chId['pickup_time'] ? strtotime($chId['pickup_time']) - strtotime('today') : "",
                  ]);
              }
  
          DB::commit();
          // email start here
          $reqMstInfo = DB::table('vehicel_request_mst')->select('*')->where('id',$id)->first();
          $reqInfo = DB::table('users')->select('email_address','department_id','employee_number')->where('id',$reqMstInfo->created_by)->first();
          $deptEmail = DB::table('users')->select('email_address')->where('is_dept_head',1)->where('department_id',$reqInfo->department_id)->first();
  
          if($reqMstInfo->group_request !='2'){
          $driverInfo = DB::table('npoly_driver')->select('*')->where('id',$driver_id)->first();
          $vehicleInfo = DB::table('npoly_vehicel')->select('*')->where('id',$vehicle_id)->first();
          $data['vehicel_no'] = $vehicleInfo->vehicel_no;
          $data['vehicle_name'] = $vehicleInfo->name;
          $data['driver_name'] = $driverInfo->name;
          $data['driver_mobile'] = $driverInfo->mobile;
          $data['title'] = 'Vehicle Request';
          $data['to_email'] =  $reqInfo->email_address;
          $data['cc_email'] =  $deptEmail->email_address;

          $data['set_dirver_info'] = $setDriverInfo ? $setDriverInfo : "";
          $data['set_vehicle_info'] = $setVehicleInfo ? $setVehicleInfo : "";
  
          $sent = Mail::send('emails.approve_vehicle', $data, function ($email) use ($data) {
            $email->subject($data['title']);
            $email->from('ticket@nationalpolymer.net','Vehicle Request');
            $email->to([$data['to_email']]);
            $email->cc([$data['cc_email']]);
            $email->bcc('admnpil@nationalpolymer.net');
        });
            $employeeNumber =  $reqInfo->employee_number;
            $title = 'Vehicle Request';
            $body = 'Your vehicle request for '.date('d-M-Y',strtotime($reqMstInfo->from_date)).' to '. date('d-M-Y',strtotime($reqMstInfo->to_date)) .' visit place ' . $reqMstInfo->visit_place . ' has been approved. For more details please login application.';
            dispatch(new sendNotification((object)$request->all(),$employeeNumber,$title,$body));

          }else{
          $participant = DB::select("SELECT chd.pick_up_point,emp.employee_name,emp.mobile_no,emp.email,chd.employee_number,
                                      TIME_FORMAT(SEC_TO_TIME( chd.pickup_time), '%h:%i %p') as pickup_time
                                      FROM vehicel_request_chd chd, npoly_employees emp
                                      WHERE chd.employee_number = emp.employee_number
                                      AND chd.request_id = $id");
          $array_values= [];
          foreach($participant as $array)
          {
              $array_values[]=$array->email;
              $employeeNumber =  $array->employee_number;
              $title = 'Vehicle Request';
              $body = 'Your vehicle request for '.date('d-M-Y',strtotime($reqMstInfo->from_date)).' to '. date('d-M-Y',strtotime($reqMstInfo->to_date)) .' visit place ' . $reqMstInfo->visit_place . ' has been approved. For more details please login application.';
              dispatch(new sendNotification((object)$request->all(),$employeeNumber,$title,$body));
          }

          $ccToMail =  array_values($array_values);

          $driverInfo = DB::table('npoly_driver')->select('*')->where('id',$driver_id)->first();
          $vehicleInfo = DB::table('npoly_vehicel')->select('*')->where('id',$vehicle_id)->first();
          $data['vehicel_no'] = $vehicleInfo->vehicel_no;
          $data['vehicle_name'] = $vehicleInfo->name;
          $data['driver_name'] = $driverInfo->name;
          $data['driver_mobile'] = $driverInfo->mobile;
          $data['title'] = 'Vehicle Request';
          $data['participants'] = $participant;
          $data['to_email'] = $deptEmail->email_address;

          $data['set_dirver_info'] = $setDriverInfo;
          $data['set_vehicle_info'] = $setVehicleInfo;

          $sent = Mail::send('emails.approve_vehicle_group', $data, function ($email) use ($data,$ccToMail) {
            $email->subject($data['title']);
            $email->from('ticket@nationalpolymer.net','Vehicle Request');
            $email->to([$data['to_email']]);
            $email->cc($ccToMail);
            $email->bcc('admnpil@nationalpolymer.net');
        });
          }

          return response()->json([
            "success" => true,
            "status" => 200,
            "message" => "Data get successfully.",
        ],200);
         
          
          // email end here
      } catch (\Throwable $e) {
          DB::rollback();
          return response()->json([
            "success" => true,
            "status" => 500,
            "message" => "Something Went Wrong !",
        ],500);
      }
  
    }
  }
  public  function multiReqByAdmin1(Request $request){
    $input = $request->all();
     $reqIds = $input['ids'];
     $userId = $input['userId'];
     $driver_id = $input['driver_id'];
     $vehicle_id = $input['vehicle_id'];
     $status= $input['status'];
     $ids = implode(',',$reqIds);
 
     if($status =='303'){
      $requestData = array(
      "status"             => $request->status,
      "canceled_by"         => $userId,
      "canceled_at"         => date('Y-m-d H:i:s'),
      );

  
      foreach($reqIds as $reqId){
          DB::table('vehicel_request_mst')
          ->where('id', $reqId)
          ->update($requestData);
      }

      $multiCreatedBy = DB::select("select u.email_address,u.employee_number,m.from_date,m.to_date,m.visit_place from 
      vehicel_request_mst m, users u
      where m.created_by = u.id
      and m.id in ($ids)
      ");
      
      $array_values= [];
      foreach($multiCreatedBy as $array)
      {
          $array_values[]=$array->email_address;

          $employeeNumber =  $array->employee_number;
          $title = 'Vehicle Request';
          $body = 'Vehicle request for '.date('d-M-Y',strtotime($array->from_date)).' to '. date('d-M-Y',strtotime($array->to_date)) .' visit place ' . $array->visit_place . ' has been canceled.';
          dispatch(new sendNotification((object)$request->all(),$employeeNumber,$title,$body));
      }

      $ccToMail =  array_values($array_values);
      //dd($ccToMail);

      $data['title'] = 'Vehicle Request has been Cancelled';

      $data['from_date'] =  '';
      $data['to_date'] = '';
      $data['start_time'] =  '';
      $data['visit_place'] = "";

      $sent = Mail::send('emails.vehicle_cancel_admin', $data, function ($email) use ($data,$ccToMail) {
          $email->subject($data['title']);
          $email->from('ticket@nationalpolymer.net','Vehicle Request');
          $email->to([$data['to_email']]);
          //$email->to(['azam.ali@nationalpolymer.net']);
          $email->cc($ccToMail);
          $email->bcc('admnpil@nationalpolymer.net');
          //$email->bcc('azam.ali@nationalpolymer.net');
      });
      return response()->json([
        "success" => true,
        "status" => 200,
        "message" => "Data get successfully.",
    ],200);


     }else{
      if($reqIds){
        //$idArray = explode(",",$reqIds);
        $requestData = array(
        //"start_time"         => $request->start_time ? strtotime($request->start_time) - strtotime('today'):$data->start_time,
        //"end_time"           => $request->start_time ? strtotime($request->end_time) - strtotime('today'):$data->end_time,
        "status"             => $status,
        "vehicle_id"         => $vehicle_id,
        "driver_id"          => $driver_id,
        "multi_req_ids"          => $ids,
        "multi_req_appr_status" => 1,
        "approved_by"         =>  $userId,
        "approved_at"         => date('Y-m-d H:i:s'),
        );
  
        DB::beginTransaction();
        try {
                foreach($reqIds as $reqId){
                    DB::table('vehicel_request_mst')
                    ->where('id', $reqId)
                    ->update($requestData);
                }
  
                
                $child = $input['participants_info'];
               
               foreach ($child as $key => $chId) {
                 DB::table('vehicel_request_chd')->where('id',$chId['id'])->update([
                     "pick_up_point"      => $chId['pick_up_point'],
                     "pickup_time"        => $chId['pickup_time'] ? strtotime($chId['pickup_time']) - strtotime('today') : "",
                 ]);
             }
  
            DB::commit();
            // email start here
            $participant = DB::select("SELECT chd.pick_up_point,emp.employee_name,emp.mobile_no,emp.email,chd.employee_number,
                                        TIME_FORMAT(SEC_TO_TIME( chd.pickup_time), '%h:%i %p') as pickup_time
                                        FROM vehicel_request_chd chd, npoly_employees emp
                                        WHERE chd.employee_number = emp.employee_number
                                        AND chd.request_id in ($ids)");
           $array_values= [];
           foreach($participant as $array)
           {
               $array_values[]=$array->email;

                    $employeeNumber =  $array->employee_number;
                    $title = 'Vehicle Request';
                    $body = 'Vehicle request for has been approved.';
                    dispatch(new sendNotification((object)$request->all(),$employeeNumber,$title,$body));
           }
 
           $ccToMail =  array_unique(array_values($array_values));
           $ccToMail1 =  array_values($ccToMail);
 
  
            $driverInfo = DB::table('npoly_driver')->select('*')->where('id',$driver_id)->first();
            $vehicleInfo = DB::table('npoly_vehicel')->select('*')->where('id',$vehicle_id)->first();
            $data['vehicel_no'] = $vehicleInfo->vehicel_no;
            $data['vehicle_name'] = $vehicleInfo->name;
            $data['driver_name'] = $driverInfo->name;
            $data['driver_mobile'] = $driverInfo->mobile;
            $data['title'] = 'Vehicle Request';
            $data['participants'] = $participant;
            $data['to_email'] = 'mahdi.hasan@nationalpolymer.net';
  
            $sent = Mail::send('emails.approve_vehicle_group', $data, function ($email) use ($data,$ccToMail1) {
                $email->subject($data['title']);
                $email->from('ticket@nationalpolymer.net','Vehicle Request');
                //$email->to([$data['to_email']]);
                $email->to('admnpil@nationalpolymer.net');
                //$email->to(['azam.ali@nationalpolymer.net']);
                $email->cc($ccToMail1);
                //$email->bcc('azam.ali@nationalpolymer.net');
            });
            // email end here
            return response()->json([
             "success" => true,
             "status" => 200,
             "message" => "Data get successfully.",
         ],200);
          
 
        } catch (\Throwable $e) {
            DB::rollback();
 
            return response()->json([
             "success" => true,
             "status" => 500,
             "message" => "Something Went Wrong !",
         ],500);
        }
  
    }
     }
   
 }
 public  function multiReqByAdmin(Request $request){
  $input = $request->all();
   $reqIds = $input['ids'];
   $userId = $input['userId'];
   $driver_id = $input['driver_id'];
   $vehicle_id = $input['vehicle_id'];
   $status= $input['status'];
   $ids = implode(',',$reqIds);


   $prevInfo = DB::selectOne("select driver_id,vehicle_id from vehicel_request_mst where id in ($ids) ");
  

   $prevDriver = "";
   $prevVehicle = "";

   if(!empty($prevInfo->vehicle_id)){
       $prevDriver = DB::table('npoly_driver')->select('*')->where('id',$prevInfo->driver_id)->first();
       $prevVehicle = DB::table('npoly_vehicel')->select('*')->where('id',$prevInfo->vehicle_id)->first();
   }

   if($status =='303'){
    $requestData = array(
    "status"             => $request->status,
    "canceled_by"         => $userId,
    "canceled_at"         => date('Y-m-d H:i:s'),
    );


    foreach($reqIds as $reqId){
        DB::table('vehicel_request_mst')
        ->where('id', $reqId)
        ->update($requestData);
    }

    $multiCreatedBy = DB::select("select u.email_address,u.employee_number,m.from_date,m.to_date,m.visit_place from 
    vehicel_request_mst m, users u
    where m.created_by = u.id
    and m.id in ($ids)
    ");
    
    $array_values= [];
    foreach($multiCreatedBy as $array)
    {
        $array_values[]=$array->email_address;

        $employeeNumber =  $array->employee_number;
        $title = 'Vehicle Request';
        $body = 'Vehicle request for '.date('d-M-Y',strtotime($array->from_date)).' to '. date('d-M-Y',strtotime($array->to_date)) .' visit place ' . $array->visit_place . ' has been canceled.';
        dispatch(new sendNotification((object)$request->all(),$employeeNumber,$title,$body));
    }

    $ccToMail =  array_values($array_values);
    //dd($ccToMail);

    $data['title'] = 'Vehicle Request has been Cancelled';

    $data['from_date'] =  '';
    $data['to_date'] = '';
    $data['start_time'] =  '';
    $data['visit_place'] = "";

    $data['dirver_info'] = $prevDriver ? $prevDriver : "";
    $data['vehicle_info'] = $prevVehicle ? $prevVehicle : "";

    $sent = Mail::send('emails.vehicle_cancel_admin', $data, function ($email) use ($data,$ccToMail) {
      $email->subject($data['title']);
      $email->from('ticket@nationalpolymer.net','Vehicle Request');
      $email->to([$data['to_email']]);
      $email->cc($ccToMail);
      $email->bcc('admnpil@nationalpolymer.net');
  });
    return response()->json([
      "success" => true,
      "status" => 200,
      "message" => "Data get successfully.",
  ],200);


   }else{
    if($reqIds){
      //$idArray = explode(",",$reqIds);
      $requestData = array(
      //"start_time"         => $request->start_time ? strtotime($request->start_time) - strtotime('today'):$data->start_time,
      //"end_time"           => $request->start_time ? strtotime($request->end_time) - strtotime('today'):$data->end_time,
      "status"             => $status,
      "vehicle_id"         => $vehicle_id,
      "driver_id"          => $driver_id,
      "multi_req_ids"          => $ids,
      "multi_req_appr_status" => 1,
      "approved_by"         =>  $userId,
      "approved_at"         => date('Y-m-d H:i:s'),
      );

      $requestInfo = DB::selectOne(" select vehicle_id,driver_id from vehicel_request_mst where id in ($ids) ");
          
      $setVehicleId = $requestInfo->vehicle_id;
      $setDirverId = $requestInfo->driver_id;
      $setDriverInfo = "";
      $setVehicleInfo= "";
      
      if(!empty($setVehicleId)){
          $setDriverInfo = DB::table('npoly_driver')->select('*')->where('id',$setDirverId)->first();
          $setVehicleInfo = DB::table('npoly_vehicel')->select('*')->where('id',$setVehicleId)->first();
      }

      DB::beginTransaction();
      try {
              foreach($reqIds as $reqId){
                  DB::table('vehicel_request_mst')
                  ->where('id', $reqId)
                  ->update($requestData);
              }

              
              $child = $input['participants_info'];
             
             foreach ($child as $key => $chId) {
               DB::table('vehicel_request_chd')->where('id',$chId['id'])->update([
                   "pick_up_point"      => $chId['pick_up_point'],
                   "pickup_time"        => $chId['pickup_time'] ? strtotime($chId['pickup_time']) - strtotime('today') : "",
               ]);
           }

          DB::commit();
          // email start here
          $participant = DB::select("SELECT chd.pick_up_point,emp.employee_name,emp.mobile_no,emp.email,chd.employee_number,
                                      TIME_FORMAT(SEC_TO_TIME( chd.pickup_time), '%h:%i %p') as pickup_time
                                      FROM vehicel_request_chd chd, npoly_employees emp
                                      WHERE chd.employee_number = emp.employee_number
                                      AND chd.request_id in ($ids)");
         $array_values= [];
         foreach($participant as $array)
         {
             $array_values[]=$array->email;

                  $employeeNumber =  $array->employee_number;
                  $title = 'Vehicle Request';
                  $body = 'Vehicle request for has been approved.';
                  dispatch(new sendNotification((object)$request->all(),$employeeNumber,$title,$body));
         }

         $ccToMail =  array_unique(array_values($array_values));
         $ccToMail1 =  array_values($ccToMail);


          $driverInfo = DB::table('npoly_driver')->select('*')->where('id',$driver_id)->first();
          $vehicleInfo = DB::table('npoly_vehicel')->select('*')->where('id',$vehicle_id)->first();
          $data['vehicel_no'] = $vehicleInfo->vehicel_no;
          $data['vehicle_name'] = $vehicleInfo->name;
          $data['driver_name'] = $driverInfo->name;
          $data['driver_mobile'] = $driverInfo->mobile;
          $data['title'] = 'Vehicle Request';
          $data['participants'] = $participant;
          $data['to_email'] = 'mahdi.hasan@nationalpolymer.net';

          $data['set_dirver_info'] = $setDriverInfo;
          $data['set_vehicle_info'] = $setVehicleInfo;

          $sent = Mail::send('emails.approve_vehicle_group', $data, function ($email) use ($data,$ccToMail1) {
            $email->subject($data['title']);
            $email->from('ticket@nationalpolymer.net','Vehicle Request');
            $email->to('admnpil@nationalpolymer.net');
            $email->cc($ccToMail1);
        });
          // email end here
          return response()->json([
           "success" => true,
           "status" => 200,
           "message" => "Data get successfully.",
       ],200);
        

      } catch (\Throwable $e) {
          DB::rollback();

          return response()->json([
           "success" => true,
           "status" => 500,
           "message" => "Something Went Wrong !",
       ],500);
      }

  }
   }
 
}
    public function vehicleCreate(Request $request){
      $input = $request->all();
      $userId = DB::table('users')->select('*')->where('employee_number',$input['employee_number'])->first();
      $vehicleData = array(
        "employee_number"    =>$input['employee_number'],
        "department_id"      => $userId->department_id,
        "visit_type_id"      => $input['visit_type'],
        "trip_type_id"       => $input['vahicle_trip'],
        "visit_place"        => $input['visit_place'],
        "form_date"          => $input['start_date'] ? date('Y-m-d',strtotime($input['start_date'])):"",
        "end_date"           => $input['end_date'] ? date('Y-m-d',strtotime($input['end_date'])):"",
        "start_time"         => $input['start_time'] ? strtotime($input['start_time']) - strtotime('today'):"",
        "end_time"           =>$input['end_time'] ? strtotime($input['end_time']) - strtotime('today'):"",
        "pick_up_point"      =>$input['pickup_point'],
        "status"             => 300,
        "active_status"      => 1,
        "created_by"         => $userId->id,
        "created_at"         => date('Y-m-d H:i:s'),
    );

    DB::beginTransaction();
    try {
        DB::table('vehicel_request')
            ->insert($vehicleData);

        DB::commit();
        return response()->json([
          "status" => 200,
          "success" => true,
          "message" => "Data get successfully.",
      ],200);
    } catch (\Throwable $e) {
        DB::rollback();
        throw $e;
    }

    }
    public function vechileRequestList(Request $request){
      $input = $request->all();
      $employeeNumber = $input['employee_number'];

      try {

      /*$results = DB::select("SELECT
      emp.employee_name,
      lkp.LOOKUP_DATA_NAME AS visit_type,
      vr.trip_type_id,
      vr.form_date,
      vr.end_date,
      vr.pick_up_point,
      lkp1.LOOKUP_DATA_NAME AS status ,
      vr.start_time,
      vr.end_date,
      vr.id
  FROM
      vehicel_request vr,
      npoly_employees emp,
      sa_lookup_data AS lkp,
      sa_lookup_data AS lkp1
  WHERE
      vr.employee_number = emp.employee_number
       AND vr.visit_type_id = lkp.LOOKUP_DATA_ID
        AND vr.status = lkp1.LOOKUP_DATA_ID
        and vr.employee_number = $employeeNumber
        order by vr.id desc");*/

        $results = DB::select("SELECT
                                emp.employee_name,
                                lkp.LOOKUP_DATA_NAME AS visit_type,
                                vrm.trip_type_id,
                                vrm.from_date,
                                vrm.to_date,
                                vrc.pick_up_point,
                                lkp1.LOOKUP_DATA_NAME AS status ,
                                TIME_FORMAT(SEC_TO_TIME( vrc.start_time), '%h:%i %p') as start_time,
                                TIME_FORMAT(SEC_TO_TIME( vrc.end_time), '%h:%i %p') as end_time,
                                vrm.id
                            FROM
                                vehicel_request_mst vrm,
                                vehicel_request_chd vrc,
                                npoly_employees emp,
                                sa_lookup_data AS lkp,
                                sa_lookup_data AS lkp1
                            WHERE
                              vrm.id = vrc.request_id
                              and vrc.employee_number = emp.employee_number
                                AND vrm.visit_type_id = lkp.LOOKUP_DATA_ID
                                  AND vrm.status = lkp1.LOOKUP_DATA_ID
                                  and vrc.employee_number = $employeeNumber
                                  order by vrm.id desc");
        

    return response()->json([
      "status" => 200,
      "success" => true,
      "data" => $results,
      "message" => "Data get successfully.",
    ],200);
      
      } catch (\Exception $e) {
      
        return response()->json([
          "status" => 500,
          "success" => false,
          "message" => "Something Went Wrong !.",
        ],500);
      }
    
    }
    public function deptVehicleReqList(Request $request){
        $input = $request->all();
        $employeeNumber = $input['employee_number'];

        $userInfo = DB::table('users')->select('department_id')->where('employee_number',$employeeNumber)->first();

        try {
          $results = DB::select("SELECT
                                  emp.employee_name,
                                  lkp.LOOKUP_DATA_NAME AS visit_type,
                                  vrm.trip_type_id,
                                  vrm.from_date,
                                  vrm.to_date,
                                  vrc.pick_up_point,
                                  lkp1.LOOKUP_DATA_NAME AS status ,
                                  TIME_FORMAT(SEC_TO_TIME( vrc.start_time), '%h:%i %p') as start_time,
                                  TIME_FORMAT(SEC_TO_TIME( vrc.end_time), '%h:%i %p') as end_time,
                                  vrm.id
                              FROM
                                  vehicel_request_mst vrm,
                                  vehicel_request_chd vrc,
                                  npoly_employees emp,
                                  sa_lookup_data AS lkp,
                                  sa_lookup_data AS lkp1
                              WHERE
                                vrm.id = vrc.request_id
                                and vrc.employee_number = emp.employee_number
                                  AND vrm.visit_type_id = lkp.LOOKUP_DATA_ID
                                    AND vrm.status = lkp1.LOOKUP_DATA_ID
                                    and vrc.department_id = $userInfo->department_id
                                    order by vrm.id desc");
          

      return response()->json([
        "status" => 200,
        "success" => true,
        "data" => $results,
        "message" => "Data get successfully.",
      ],200);
        
        } catch (\Exception $e) {
        
          return response()->json([
            "status" => 500,
            "success" => false,
            "message" => "Something Went Wrong !.",
          ],500);
        }
    }

    public function vechileRequestStatus(Request $request){
      $input = $request->all();
      $employeeNumber = $input['employee_number'];
      try {

        $userInfo = DB::table('users')->select('USERLVL_ID')->where('employee_number',$employeeNumber)->first();
        if($userInfo->USERLVL_ID =='13'){
          $result = DB::table('sa_lookup_data')
          ->select('LOOKUP_DATA_ID as status_id', 'LOOKUP_DATA_NAME as status_name')
         ->where('LOOKUP_GRP_ID', '48')
         ->where('LOOKUP_DATA_ID','!=', '298')
         ->where('active_flag',1)
         ->get(); 
         }else{
         $result = DB::table('sa_lookup_data')
         ->select('LOOKUP_DATA_ID as status_id', 'LOOKUP_DATA_NAME as status_name')
         ->where('LOOKUP_GRP_ID', '48')
         ->where('LOOKUP_DATA_ID','!=', '296')
         ->where('active_flag',1)
         ->get();
         }
         return response()->json([
          "status" => 200,
          "success" => true,
          "data" => $result,
          "message" => "Data get successfully.",
        ],200);
      
      } catch (\Exception $e) {
      
        return response()->json([
          "status" => 500,
          "success" => false,
          "message" => "Something Went Wrong !.",
        ],500);
      }
    }

    public function getRequestInfoByStatus(Request $request){
      $input = $request->all();
      $employeeNumber = $input['employee_number'];
      $status = $input['status'];
      
      
        try {
          
            $results = DB::select("SELECT
            emp.employee_name,
            lkp.LOOKUP_DATA_NAME AS visit_type,
            vrm.trip_type_id,
            vrm.from_date,
            vrm.to_date,
            vrc.pick_up_point,
            lkp1.LOOKUP_DATA_NAME AS status ,
            TIME_FORMAT(SEC_TO_TIME( vrc.start_time), '%h:%i %p') as start_time,
            TIME_FORMAT(SEC_TO_TIME( vrc.end_time), '%h:%i %p') as end_time,
            vrm.id
        FROM
            vehicel_request_mst vrm,
            vehicel_request_chd vrc,
            npoly_employees emp,
            sa_lookup_data AS lkp,
            sa_lookup_data AS lkp1
        WHERE
          vrm.id = vrc.request_id
          and vrc.employee_number = emp.employee_number
            AND vrm.visit_type_id = lkp.LOOKUP_DATA_ID
              AND vrm.status = lkp1.LOOKUP_DATA_ID
              and vrc.employee_number = $employeeNumber
              and vrm.status = $status
              order by vrm.id desc");
        return response()->json([
          "status" => 200,
          "success" => true,
          "data" => $results,
          "message" => "Data get successfully.",
        ],200);
        } catch (\Exception $e) {
        
          return response()->json([
            "status" => 500,
            "success" => false,
            "message" => "Something Went Wrong !.",
          ],500);
        }
    }

    public function vehicleReqInfoByIdUpdate(Request $request,$reqId,$userId){
      $userInfo = DB::table('users')->select('*')->where('id',$userId)->first();
      //dd($userInfo->USERLVL_ID);
      $mstInfo = DB::table('vehicel_request_mst')->select('*')->where('id',$reqId)->first();
      
     if($userInfo->USERLVL_ID ==22 || $userInfo->USERLVL_ID == 21){
      $results = DB::select("SELECT
      lkp.LOOKUP_DATA_NAME AS visit_type,
      vrm.trip_type_id,
      vrm.from_date,
      vrm.to_date,
      vrc.pick_up_point,
      vrm.visit_place,
      vrm.multi_req_ids,
      vrm.group_request,
      vrm.status as request_status,
      lkp1.LOOKUP_DATA_NAME AS status,
      TIME_FORMAT(SEC_TO_TIME(vrc.start_time), '%h:%i %p') AS start_time,
      TIME_FORMAT(SEC_TO_TIME(vrc.end_time), '%h:%i %p') AS end_time,
      vrm.id,
      v.name AS vehicle_name,
      v.vehicel_no,
      d.name AS driver_name,
      d.mobile,
      usr.name as created_by,
      usr.department_name as created_dept
  FROM
      vehicel_request_mst vrm
      INNER JOIN vehicel_request_chd vrc ON vrm.id = vrc.request_id
      INNER JOIN sa_lookup_data AS lkp ON vrm.visit_type_id = lkp.LOOKUP_DATA_ID
      INNER JOIN sa_lookup_data AS lkp1 ON vrm.status = lkp1.LOOKUP_DATA_ID
      INNER JOIN users AS usr ON vrm.created_by = usr.id
      LEFT JOIN npoly_vehicel v ON v.id = vrm.vehicle_id
      LEFT JOIN npoly_driver d ON d.id = vrm.driver_id
      WHERE
           vrm.id =  $reqId
      ORDER BY
          vrm.id DESC
      ");

      foreach($results as $key=> $value){
        $condition = "";
        if($value->multi_req_ids !=""){
          $condition .="AND chd.request_id in ($value->multi_req_ids)";
        }else{
          $condition .="AND chd.request_id in ($value->id)";
        }
        $results[ $key]->participent = DB::select("SELECT chd.id,chd.pick_up_point,emp.employee_name,emp.mobile_no,dept.department_name,
                        TIME_FORMAT(SEC_TO_TIME( chd.pickup_time), '%h:%i %p') as pickup_time
                        FROM vehicel_request_chd chd, npoly_employees emp,set_department dept
                        WHERE chd.employee_number = emp.employee_number
                        AND chd.department_id = dept.id
                        $condition");
      }
      return response()->json([
      "status" => 200,
      "success" => true,
      "data" => $results,
      "message" => "Data get successfully.",
      ],200);
     }else{
      $results = DB::select("SELECT
      lkp.LOOKUP_DATA_NAME AS visit_type,
      vrm.trip_type_id,
      vrm.from_date,
      vrm.to_date,
      vrc.pick_up_point,
      vrm.visit_place,
      vrm.multi_req_ids,
      vrm.group_request,
      vrm.status as request_status,
      lkp1.LOOKUP_DATA_NAME AS status,
      TIME_FORMAT(SEC_TO_TIME(vrc.start_time), '%h:%i %p') AS start_time,
      TIME_FORMAT(SEC_TO_TIME(vrc.end_time), '%h:%i %p') AS end_time,
      vrm.id,
      v.name AS vehicle_name,
      v.vehicel_no,
      d.name AS driver_name,
      d.mobile,
      usr.name as created_by,
      usr.department_name as created_dept
  FROM
      vehicel_request_mst vrm
      INNER JOIN vehicel_request_chd vrc ON vrm.id = vrc.request_id
      INNER JOIN sa_lookup_data AS lkp ON vrm.visit_type_id = lkp.LOOKUP_DATA_ID
      INNER JOIN sa_lookup_data AS lkp1 ON vrm.status = lkp1.LOOKUP_DATA_ID
      INNER JOIN users AS usr ON vrm.created_by = usr.id
      LEFT JOIN npoly_vehicel v ON v.id = vrm.vehicle_id
      LEFT JOIN npoly_driver d ON d.id = vrm.driver_id
      WHERE
          vrc.employee_number = $userInfo->employee_number
          AND vrm.id =  $reqId
      ORDER BY
          vrm.id DESC
      ");

      foreach($results as $key=> $value){
        $condition = "";
        if($value->multi_req_ids !=""){
          $condition .="AND chd.request_id in ($value->multi_req_ids)";
        }else{
          $condition .="AND chd.request_id in ($value->id)";
        }
        $results[ $key]->participent = DB::select("SELECT chd.id,chd.pick_up_point,emp.employee_name,emp.mobile_no,dept.department_name,
                        TIME_FORMAT(SEC_TO_TIME( chd.pickup_time), '%h:%i %p') as pickup_time
                        FROM vehicel_request_chd chd, npoly_employees emp,set_department dept
                        WHERE chd.employee_number = emp.employee_number
                        AND chd.department_id = dept.id
                        $condition");
      }
      return response()->json([
      "status" => 200,
      "success" => true,
      "data" => $results,
      "message" => "Data get successfully.",
      ],200);
     }
      

      
    }
    public function vehicleReqInfoById(Request $request,$reqId,$userId){
      $userInfo = DB::table('users')->select('*')->where('id',$userId)->first();
      $results = DB::select("SELECT
                                emp.employee_name,
                                lkp.LOOKUP_DATA_NAME AS visit_type,
                                vrm.trip_type_id,
                                vrm.from_date,
                                vrm.to_date,
                                vrc.pick_up_point,
                                vrm.visit_place,
                                lkp1.LOOKUP_DATA_NAME AS status ,
                                TIME_FORMAT(SEC_TO_TIME( vrc.start_time), '%h:%i %p') as start_time,
                                TIME_FORMAT(SEC_TO_TIME( vrc.end_time), '%h:%i %p') as end_time,
                                vrm.id
                            FROM
                                vehicel_request_mst vrm,
                                vehicel_request_chd vrc,
                                npoly_employees emp,
                                sa_lookup_data AS lkp,
                                sa_lookup_data AS lkp1
                            WHERE
                              vrm.id = vrc.request_id
                              and vrc.employee_number = emp.employee_number
                                AND vrm.visit_type_id = lkp.LOOKUP_DATA_ID
                                  AND vrm.status = lkp1.LOOKUP_DATA_ID
                                  and vrc.employee_number =$userInfo->employee_number
                                  AND vrm.id = $reqId
                                  order by vrm.id desc");
      return response()->json([
        "status" => 200,
        "success" => true,
        "data" => $results,
        "message" => "Data get successfully.",
      ],200);
    }

    public function deptVehicleReqInfoById(Request $request,$reqId,$userId){
      $userInfo = DB::table('users')->select('department_id')->where('id',$userId)->first();

                              $results = DB::select("SELECT
                              lkp.LOOKUP_DATA_NAME AS visit_type,
                              vrm.trip_type_id,
                              vrm.from_date,
                              vrm.to_date,
                              vrc.pick_up_point,
                              vrm.visit_place,
                              vrm.multi_req_ids,
                              vrm.group_request,
                              vrm.status as req_status,
                              lkp1.LOOKUP_DATA_NAME AS status,
                              TIME_FORMAT(SEC_TO_TIME(vrc.start_time), '%h:%i %p') AS start_time,
                              TIME_FORMAT(SEC_TO_TIME(vrc.end_time), '%h:%i %p') AS end_time,
                              vrm.id,
                              v.name AS vehicle_name,
                              v.vehicel_no,
                              d.name AS driver_name,
                              d.mobile,
                              usr.name as created_by,
                              usr.department_name as created_dept
                              FROM
                              vehicel_request_mst vrm
                              INNER JOIN vehicel_request_chd vrc ON vrm.id = vrc.request_id
                              INNER JOIN sa_lookup_data AS lkp ON vrm.visit_type_id = lkp.LOOKUP_DATA_ID
                              INNER JOIN sa_lookup_data AS lkp1 ON vrm.status = lkp1.LOOKUP_DATA_ID
                              INNER JOIN users AS usr ON vrm.created_by = usr.id
                              LEFT JOIN npoly_vehicel v ON v.id = vrm.vehicle_id
                              LEFT JOIN npoly_driver d ON d.id = vrm.driver_id
                              
                                  WHERE vrm.id =  $reqId
                                  AND vrc.department_id = $userInfo->department_id
                              ORDER BY
                                  vrm.id DESC
                              ");

foreach($results as $key=> $value){
  $condition = "";
  if($value->multi_req_ids !=""){
    $condition .="AND chd.request_id in ($value->multi_req_ids)";
  }else{
    $condition .="AND chd.request_id in ($value->id)";
  }
  $results[ $key]->participent = DB::select("SELECT chd.pick_up_point,emp.employee_name,emp.mobile_no,dept.department_name,
                  TIME_FORMAT(SEC_TO_TIME( chd.pickup_time), '%h:%i %p') as pickup_time
                  FROM vehicel_request_chd chd, npoly_employees emp,set_department dept
                  WHERE chd.employee_number = emp.employee_number
                  AND chd.department_id = dept.id
                  $condition");
}
      return response()->json([
        "status" => 200,
        "success" => true,
        "data" => $results,
        "message" => "Data get successfully.",
      ],200);
    }

    public function vehicleStatusChange(Request $request){

      $input = $request->all();
      $request_id = $input['request_id'];
      $vehicle_status = $input['vehicle_status'];
      $vehicle_status = $input['vehicle_status'];
      $change_by = $input['change_by'];

      $userInfo = DB::table('users')->select('*')->where('id',$change_by)->first();

      if($vehicle_status =='303'){
        $requestData = array(
          "status"             => $vehicle_status,
          "canceled_by"         => $change_by,
          "canceled_at"         => date('Y-m-d H:i:s'),
        );
        DB::table('vehicel_request_mst')
                  ->where('id', $request_id)
                  ->update($requestData);

        $userId = DB::table('vehicel_request_mst')->select('*')->where('id', $request_id)->first();
        $emailTo = DB::table('users')->select('email_address','employee_number')->where('id',$userId->created_by)->first();
        //dd($emailTo->email_address);
       // $data['visit_place'] = $requestData->visit_place;
        $datas['name'] = $userInfo->name;
        $datas['department_name'] = $userInfo->department_name;
        $datas['designation_name'] = $userInfo->designation_name;
       // $data['from_date'] = date('d-M-Y',strtotime($requestData->from_date));
       // $data['to_date'] = date('d-M-Y',strtotime($requestData->to_date));
        $datas['title'] = 'Vehicle Request has been Cancelled';
        $datas['to_email'] = $emailTo->email_address;

        $datas['from_date'] =  $userId->from_date;
        $datas['to_date'] =  $userId->to_date;
        $datas['start_time'] =  $userId->start_time;
        $datas['visit_place'] =  $userId->visit_place ? $userId->visit_place:"";

        $sent = Mail::send('emails.vehicle_cancel_hod', $datas, function ($email) use ($datas) {
            $email->subject($datas['title']);
            $email->from('ticket@nationalpolymer.net','Vehicle Request');
            $email->to([$datas['to_email']]);
            //$email->to(['azam.ali@nationalpolymer.net']);
        // $email->cc([$data['req_email']]);
            //$email->bcc('azam.ali@nationalpolymer.net');
        });

        $employeeNumber =  $emailTo->employee_number;
        $title = 'Vehicle Request';
        $body = 'Your vehicle request for '.date('d-M-Y',strtotime($userId->from_date)).' to '. date('d-M-Y',strtotime($userId->to_date)) .' visit place ' . $userId->visit_place . ' has been canceled.';
        dispatch(new sendNotification((object)$request->all(),$employeeNumber,$title,$body));
        
        return response()->json([
          "success" => true,
          "status" => 200,
          "message" => "Data get successfully.",
      ],200);
      }else{
        $requestData = array(
          "status"             => $vehicle_status,
          "updated_by"         => $change_by,
          "updated_at"         => date('Y-m-d H:i:s'),
        );

          DB::beginTransaction();
          try {
              DB::table('vehicel_request_mst')
                  ->where('id', $request_id)
                  ->update($requestData);

              DB::commit();
              $requestData = DB::table('vehicel_request_mst')->select('*')->where('id',$request_id)->first();
              $creatorInfo = DB::table('users')->select('name','department_name','designation_name')->where('id',$requestData->created_by)->first();
              $data['visit_place'] = $requestData->visit_place;
              $data['name'] = $userInfo->name;
              $data['department_name'] = $userInfo->department_name;
              $data['designation_name'] = $userInfo->designation_name;
              $data['from_date'] = date('d-M-Y',strtotime($requestData->from_date));
              $data['to_date'] = date('d-M-Y',strtotime($requestData->to_date));
              $data['title'] = 'Vehicle Request';
              $data['to_email'] = 'mahdi.hasan@nationalpolymer.net';

               // requester info
            $data['req_name'] = $creatorInfo->name;
            $data['req_dept'] = $creatorInfo->department_name;
            $data['req_desig'] = $creatorInfo->designation_name;

              $sent = Mail::send('emails.vehicle_req_admin', $data, function ($email) use ($data) {
                  $email->subject($data['title']);
                  $email->from('ticket@nationalpolymer.net','Vehicle Request');
                  //$email->to([$data['to_email']]);
                  $email->to('admnpil@nationalpolymer.net');
                  //$email->to(['azam.ali@nationalpolymer.net']);
                 // $email->cc([$data['req_email']]);
                  //$email->bcc('azam.ali@nationalpolymer.net');
              });

             // $empNumber = '10454';
              //$this::sendNotification($empNumber);

              $employeeNumber = '10454';
              $title = 'Vehicle Request';
              $body = 'A new vehicle request has been submitted From '.$userInfo->department_name. ' Department. Please review and approve the request.';
              dispatch(new sendNotification((object)$request->all(),$employeeNumber,$title,$body));

              return response()->json([
                "status" => 200,
                "success" => true,
                "message" => "Status successfully.",
              ],200);
          } catch (\Throwable $e) {
              DB::rollback();
              return response()->json([
                "status" => 500,
                "success" => false,
                "message" => "Something went Wrong",
              ],500);
          }
      }
    }

    static function sendNotification9999($empNumber){
      //$input = $request->all();
      
      $fcmId = $data = DB::connection('oracle')->selectOne("select FCM_REG_ID from XX_TKT_OFF_APP_USERS where employee_number = $empNumber");
      /*$url = ' http://192.168.251.39:3000/api/v1/mobile/auth/notify';
      $curl = curl_init($url);
      curl_setopt($curl, CURLOPT_URL, $url);
      curl_setopt($curl, CURLOPT_HEADER, false);
      curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

      $response = curl_exec($curl);
      curl_close($curl);*/
      $url = 'http://182.163.98.54:3001/api/v1/mobile/auth/notify';

      // The data to send in the POST request
      $data = array(
        'fcmRegId' => $fcmId ? $fcmId->fcm_reg_id:"",
        'title' => 'Vehicle Request',
        'desc' => '2 !',
      );

      // Convert the data array to JSON
      $jsonData = json_encode($data);

      // Initialize cURL session
      $curl = curl_init($url);

  // Set the cURL options
          curl_setopt($curl, CURLOPT_URL, $url);
          curl_setopt($curl, CURLOPT_POST, true); // Set the request method to POST
          curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
          curl_setopt($curl, CURLOPT_HEADER, false);
          curl_setopt($curl, CURLOPT_POSTFIELDS, $jsonData); // Attach the JSON data
          curl_setopt($curl, CURLOPT_HTTPHEADER, array(
              'Content-Type: application/json',
              'Content-Length: ' . strlen($jsonData)
          ));

          // Execute the POST request
          $response = curl_exec($curl);

          // Check for errors
          // if (curl_errno($curl)) {
          //     echo 'Error:' . curl_error($curl);
          // } else {
          //     // Print the response from the server
          //     echo 'Response from server: ' . $response;
          // }

          // Close cURL session
          curl_close($curl);
      }

      public function vechileRequestAdmin(Request $request){

        $input = $request->all();
        $employeeNumber = $input['employee_number'];
  
        $userInfo = DB::table('users')->select('department_id','id')->where('employee_number',$employeeNumber)->first();
  
        try {
          $condition = '';
          if(!empty($userInfo)){
           // $condition  .="and (vrm.status <> 300 OR vrm.created_by = $userInfo->id)";
            $condition  .="and vrm.status <> 300 ";
          }
         
          // $results = DB::select("SELECT
          //                         emp.employee_name,
          //                         lkp.LOOKUP_DATA_NAME AS visit_type,
          //                         vrm.trip_type_id,
          //                         vrm.from_date,
          //                         vrm.to_date,
          //                         vrc.pick_up_point,
          //                         lkp1.LOOKUP_DATA_NAME AS status ,
          //                         TIME_FORMAT(SEC_TO_TIME( vrc.start_time), '%h:%i %p') as start_time,
          //                         TIME_FORMAT(SEC_TO_TIME( vrc.end_time), '%h:%i %p') as end_time,
          //                         vrm.id
          //                     FROM
          //                         vehicel_request_mst vrm,
          //                         vehicel_request_chd vrc,
          //                         npoly_employees emp,
          //                         sa_lookup_data AS lkp,
          //                         sa_lookup_data AS lkp1
          //                     WHERE
          //                       vrm.id = vrc.request_id
          //                       and vrc.employee_number = emp.employee_number
          //                         AND vrm.visit_type_id = lkp.LOOKUP_DATA_ID
          //                           AND vrm.status = lkp1.LOOKUP_DATA_ID
          //                          $condition
          //                           order by vrm.id desc");
 $results = DB::select("SELECT
      lkp.LOOKUP_DATA_NAME AS visit_type,
      vrm.trip_type_id,
      vrm.from_date,
      vrm.to_date,
      vrm.visit_place,
      vrm.status as request_status,
      lkp1.LOOKUP_DATA_NAME AS status ,
      vrm.id
  FROM
      vehicel_request_mst vrm,
      sa_lookup_data AS lkp,
      sa_lookup_data AS lkp1
      WHERE vrm.visit_type_id = lkp.LOOKUP_DATA_ID
        AND vrm.status = lkp1.LOOKUP_DATA_ID
       $condition
        order by vrm.id desc");

foreach($results as $key=> $value){
  
  $results[ $key]->other_info = DB::selectOne("SELECT chd.pick_up_point,emp.employee_name,
                  TIME_FORMAT(SEC_TO_TIME( chd.pickup_time), '%h:%i %p') as pickup_time
                  FROM vehicel_request_chd chd, npoly_employees emp
                  WHERE chd.employee_number = emp.employee_number
                  AND chd.request_id = $value->id");
}
          
  
      return response()->json([
        "status" => 200,
        "success" => true,
        "data" => $results,
        "message" => "Data get successfully.",
      ],200);
        
        } catch (\Exception $e) {
        
          return response()->json([
            "status" => 500,
            "success" => false,
            "message" => "Something Went Wrong !.",
          ],500);
        }
      }

    static  function getAllDates($startDate, $endDate) {
      $dates = array();
  
      $currentDate = new DateTime($startDate);
      $endDate = new DateTime($endDate);
  
      while ($currentDate <= $endDate) {
          // Check if the current day is not a Friday (5 is the index for Friday in PHP)
          if ($currentDate) {
              $dates[] = $currentDate->format('Y-m-d');
          }
  
          // Move to the next day
          $currentDate->modify('+1 day');
      }
  
      return $dates;
  }

  public function vehicleReqApproveInfo(Request $request,$reqId,$userId){
      $userInfo = DB::table('users')->select('*')->where('id',$userId)->first();
      $mstInfo = DB::table('vehicel_request_mst')->select('*')->where('id',$reqId)->first();

      $result = DB::table('vehicel_request_mst as vrm')
                    ->leftJoin('sa_lookup_data as lkp','vrm.visit_type_id','=','lkp.lookup_data_id')
                    ->leftJoin('sa_lookup_data as lkp1','vrm.status','=','lkp1.lookup_data_id')
                    ->select('vrm.*','lkp.lookup_data_name as visit_type','lkp1.lookup_data_name as request_status')
                    ->where('vrm.id',$reqId)
                    ->first();

                    $reqFromDate = $result->from_date;
                    $reqToDate = $result->to_date;
            
                    $maxReqDate = DB::selectOne("select max(to_date) to_date from vehicel_request_mst where status = 302");
                    $fromDate = $maxReqDate->to_date > $reqFromDate ?  date('Y-m-d'):$reqFromDate;
                    $toDate =  $maxReqDate->to_date > $reqFromDate ? $maxReqDate->to_date:$reqToDate;
            
                    $allDate = $this::getAllDates($fromDate,$toDate);
                    $allVehicle = [];
                    foreach($allDate as $value){
                       $allVehicle []= DB::select("SELECT vehicle_id, driver_id
                                                    FROM vehicel_request_mst
                                                    WHERE STATUS = 302
                                                    AND '$value' BETWEEN from_date AND to_date");
                    }
                    $allVehicle = $allVehicle[0];
                    //$vehicleList = array_unique($allVehicle);
                    $vechileNewList = [];
                    $driverNewList = [];
                    foreach($allVehicle  as $key=> $vl){
                        $vechileNewList []= $vl->vehicle_id;
                        $driverNewList []= $vl->driver_id;
                    }
                    // vehicle
                    $newList = array_unique($vechileNewList);
                    $vehicleIn = implode(',',$newList);
                    // driver
                    $newDriverList = array_unique($driverNewList);
                    $driverIn = implode(',',$newDriverList);
                    // vehicle condition
                    $vehiceleCondition = "";
            
                    if(!empty($vehicleIn)){
                        $vehiceleCondition .="and id not in($vehicleIn)";
                    }
                    // driver condition
                    $driverCondition = "";
            
                    if(!empty($driverIn)){
                        $driverCondition .="and id not in($driverIn)";
                    }
            
                    $veichleList = DB::select("select id,name,vehicel_no 
                    from npoly_vehicel 
                    where active_status = 1
                    $vehiceleCondition
                    ");
            
                    // $driverList = DB::table('npoly_driver')->select('id','name','mobile')
                    // ->where('active_status',1)
                    // ->get();
            
                    $driverList = DB::select("select id,name,mobile 
                    from npoly_driver
                    where active_status = 1
                    $driverCondition
                    ");

                    $requestStatus = DB::table('sa_lookup_data')
                    ->select('LOOKUP_DATA_ID as id', 'LOOKUP_DATA_NAME as name')
                    ->where('LOOKUP_GRP_ID', '48')
                    ->where('LOOKUP_DATA_ID','!=', '300')
                    ->where('LOOKUP_DATA_ID','!=', '301')
                    ->where('active_flag',1)
                    ->get();

                    $requestInfo = [
                      "driver" =>$driverList ? $driverList : [],
                      "vehicle" =>$veichleList ? $veichleList : [],
                      "request_status" =>$requestStatus ? $requestStatus : [],
                  ];
      
                  return response()->json([
                      "success" => true,
                      "message" => "Data get successfully.",
                      "data" => $requestInfo
                  ],200);
  }

  public function multiReqApprove(Request $request){

    $input = $request->all();
    $reqIds = $input['ids'];

    $id = 70;
    $ids = implode(',',$reqIds);
    //dd($ids);
        //$userLvlId = Auth::user()->USERLVL_ID;

        
        $requestStatus = DB::table('sa_lookup_data')
        ->select('LOOKUP_DATA_ID as id', 'LOOKUP_DATA_NAME as name')
        ->where('LOOKUP_GRP_ID', '48')
        ->where('LOOKUP_DATA_ID','!=', '300')
        ->where('LOOKUP_DATA_ID','!=', '301')
        ->where('active_flag',1)
        ->get();
        //dd($requestStatus);

        $result = DB::select("SELECT
                                    vrm.*,
                                    lkp.lookup_data_name AS visit_type,
                                    lkp1.lookup_data_name AS request_status
                                FROM
                                    vehicel_request_mst vrm,sa_lookup_data lkp,sa_lookup_data lkp1
                                    WHERE vrm.visit_type_id = lkp.LOOKUP_DATA_ID
                                    AND vrm.status = lkp1.LOOKUP_DATA_ID
                                AND vrm.id IN($ids)");
       // dd($result);
                                
        

        $reqFromDate = $result[0]->from_date;
        $reqToDate = $result[0]->to_date;

        $maxReqDate = DB::selectOne("select max(to_date) to_date from vehicel_request_mst where status = 302");
        $fromDate = $maxReqDate->to_date > $reqFromDate ?  date('Y-m-d'):$reqFromDate;
        $toDate =  $maxReqDate->to_date > $reqFromDate ? $maxReqDate->to_date:$reqToDate;

        $allDate = $this::getAllDates($fromDate,$toDate);
        //dd($allDate);
        $allVehicle = [];
        foreach($allDate as $value){
           $allVehicle []= DB::select("SELECT vehicle_id, driver_id
                                        FROM vehicel_request_mst
                                        WHERE STATUS = 302
                                        AND '$value' BETWEEN from_date AND to_date");
        }
        $allVehicle = $allVehicle[0];
        //$vehicleList = array_unique($allVehicle);
        $vechileNewList = [];
        $driverNewList = [];
        foreach($allVehicle  as $key=> $vl){
            $vechileNewList []= $vl->vehicle_id;
            $driverNewList []= $vl->driver_id;
        }
        // vehicle
        $newList = array_unique($vechileNewList);
        $vehicleIn = implode(',',$newList);
        // driver
        $newDriverList = array_unique($driverNewList);
        $driverIn = implode(',',$newDriverList);
        // vehicle condition
        $vehiceleCondition = "";

        if(!empty($vehicleIn)){
            $vehiceleCondition .="and id not in($vehicleIn)";
        }
        // driver condition
        $driverCondition = "";

        if(!empty($driverIn)){
            $driverCondition .="and id not in($driverIn)";
        }

        $veichleList = DB::select("select id,name,vehicel_no 
        from npoly_vehicel 
        where active_status = 1
        $vehiceleCondition
        ");

        // $driverList = DB::table('npoly_driver')->select('id','name','mobile')
        // ->where('active_status',1)
        // ->get();

        $driverList = DB::select("select id,name,mobile 
        from npoly_driver
        where active_status = 1
        $driverCondition
        ");
        $participentInfo = DB::select("SELECT
                                            vrc.id,
                                            vrc.pick_up_point,
                                            TIME_FORMAT(SEC_TO_TIME( vrc.pickup_time), '%h:%i %p') as pickup_time,
                                            usr.name as employee_name,
                                            usr.contact_no as mobile_no,
                                            usr.department_name
                                        FROM
                                            vehicel_request_chd vrc,users usr
                                            
                                        WHERE usr.employee_number = vrc.employee_number 
                                        and vrc.request_id in ($ids)");
                                        

                  $requestInfo = [
                    "participant" =>$participentInfo ? $participentInfo : [],
                    "driver" =>$driverList ? $driverList : [],
                    "vehicle" =>$veichleList ? $veichleList : [],
                    "request_status" =>$requestStatus ? $requestStatus : [],
                ];
               
    
                return response()->json([
                    "success" => true,
                    "message" => "Data get successfully.",
                    "data" => $requestInfo
                ],200);
}

public function createCurrentLoaction(Request $request){
  $input = $request->all();
  $lat = $input['lat'];
  $long = $input['long'];
  $emp_number = $input['emp_number'];
  $device_name = $input['device_name'];
  $device_model = $input['device_model'];
  $os_version = $input['os_version'];

  $insertArray = array(
    "lat"=>$lat,
    "lng"=>$long,
    "employee_number"=>$emp_number,
    "device_name"=>$device_name,
    "device_model"=>$device_model,
    "os_version"=>$os_version,
    "active_status"=>1,
    "created_at"=>date('Y-m-d h:i A'),
  );
  $result = DB::table('emp_loaction')->insert($insertArray);
  if($result){
    return response()->json([
      "success" => true,
      "message" => "Data get successfully.",
      "status" =>200
  ],200);
  }
}

public function getLoaction(Request $request) {
  $input = $request->all();
  $emp_number = $input['employee_number'];
  $results = DB::table('emp_loaction')->select('*')->where('employee_number',$emp_number)->where('lat','>','0')->get();
  return response()->json([
    "success" => true,
    "message" => "Data get successfully.",
    "data"=>$results ,
    "status" =>200
],200);
}


  
}
