<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rules\File;

class TicketController extends Controller
{
   
    public function ticketInfo(Request $request)
    {
        $input = $request->all();
        $employeeNumber = $input['employee_number'];
        //$userId = $input['userId'];

        $userInfo = DB::table('users')->select('*')->where('employee_number',$employeeNumber)->first();
       

        $supportUserId = $userInfo->support_user_id;
        $userLevel = $userInfo->USERLVL_ID;

            // ticket information start here
            if($supportUserId !=0){
                $fordwardInfo = [];
                $userId = $userInfo->id;
                $results = DB::table('npoly_tickets as tkt')
                ->leftJoin('sa_lookup_data as lkp', 'tkt.priority_id', '=', 'lkp.LOOKUP_DATA_ID')
                ->leftJoin('set_department as dept', 'dept.id', '=', 'tkt.department_id')
                ->leftJoin('sa_lookup_data as lkp1', 'tkt.ticket_status', '=', 'lkp1.LOOKUP_DATA_ID')
                ->leftJoin('npoly_clients as clnt', 'clnt.client_id', '=', 'tkt.client_id')
                ->leftJoin('npoly_projects as pro', 'pro.project_id', '=', 'tkt.project_id')
                ->leftJoin('npoly_task_report as tskr', 'tskr.ticket_id', '=', 'tkt.id')
                ->leftJoin('npoly_support_modules as tm', 'tm.module_id', '=', 'tkt.module_id')
                ->leftJoin('npoly_employees as emp', 'emp.employee_id', '=', 'tkt.employee_id')
                ->leftJoin('npoly_employees as emp1', 'emp1.employee_id', '=', 'tskr.assign_by')
                ->leftJoin('users as usr', 'usr.id', '=', 'tkt.created_by')
                //->select('tkt.*','lkp.LOOKUP_DATA_NAME as priorityName','clnt.client_name','pro.project_name','tskr.created_at','tskr.forecast_date','tskr.employee_id','tskr.fordward_employee','tskr.task_complete','lkp1.LOOKUP_DATA_NAME as ticketStatus','tm.module_name')
                ->select(
                    'tkt.id',
                    'tkt.ticket_no',
                    'dept.department_name',
                    'usr.department_name as request_department',
                    'tkt.ticket_title',
                    'lkp.LOOKUP_DATA_NAME as priorityName',
                    'clnt.client_name',
                    'pro.project_name',
                    'tskr.employee_id',
                    'tskr.fordward_employee',
                    'tskr.created_at',
                    'tkt.created_by',
                    'tskr.forecast_date',
                    'tskr.task_complete',
                    'lkp1.LOOKUP_DATA_NAME as ticketStatus',
                    'tm.module_name',
                    'emp.employee_name as assign_employee',
                    'tskr.assign_date',
                    'emp1.employee_name as assign_by')
                ->where('tkt.ticket_status','!=',230)
                ->where('tkt.created_by',$userId)
                ->orderBy('tkt.id','desc')
                ->get();
                $workingProgress = DB::table('npoly_tickets')->select('id')->where('ticket_status',227)->where('created_by',$userId)->count();
                $notResolved = DB::table('npoly_tickets')->select('id')->where('ticket_status',229)->where('created_by',$userId)->count();
                $resolved = DB::table('npoly_tickets')->select('id')->where('ticket_status',228)->where('created_by',$userId)->count();
                $closed = DB::table('npoly_tickets')->select('id')->where('ticket_status',230)->where('created_by',$userId)->count();
            }else if($userLevel =='7' || $userLevel =='16' ||  $userLevel =='13'){
                $empId = $userInfo->employee_id;
                $results = DB::table('npoly_tickets as tkt')
                    ->leftJoin('sa_lookup_data as lkp', 'tkt.priority_id', '=', 'lkp.LOOKUP_DATA_ID')
                    ->leftJoin('set_department as dept', 'dept.id', '=', 'tkt.department_id')
                    ->leftJoin('sa_lookup_data as lkp1', 'tkt.ticket_status', '=', 'lkp1.LOOKUP_DATA_ID')
                    ->leftJoin('npoly_clients as clnt', 'clnt.client_id', '=', 'tkt.client_id')
                    ->leftJoin('npoly_projects as pro', 'pro.project_id', '=', 'tkt.project_id')
                    ->leftJoin('npoly_task_report as tskr', 'tskr.ticket_id', '=', 'tkt.id')
                    ->leftJoin('npoly_support_modules as tm', 'tm.module_id', '=', 'tkt.module_id')
                    ->leftJoin('npoly_employees as emp', 'emp.employee_id', '=', 'tkt.employee_id')
                    ->leftJoin('npoly_employees as emp1', 'emp1.employee_id', '=', 'tskr.assign_by')
                    ->leftJoin('users as usr', 'usr.id', '=', 'tkt.created_by')
                    ->select(
                        'tkt.id',
                        'tkt.ticket_no',
                        'dept.department_name',
                        'usr.department_name as request_department',
                        'tkt.ticket_title',
                        'lkp.LOOKUP_DATA_NAME as priorityName',
                        'clnt.client_name',
                        'pro.project_name',
                        'tskr.employee_id',
                        'tskr.fordward_employee',
                        'tskr.created_at',
                        'tkt.created_by',
                        'tskr.forecast_date',
                        'tskr.task_complete',
                        'lkp1.LOOKUP_DATA_NAME as ticketStatus',
                        'tm.module_name',
                        'emp.employee_name as assign_employee',
                        'tskr.assign_date',
                        'emp1.employee_name as assign_by')
                    ->where('tkt.employee_id',$empId)
                    ->orWhere('tkt.created_by',$userInfo->id)
                    ->where('tkt.ticket_status','!=',230)
                    ->orderBy('tkt.id','desc')
                    ->get();

                    $workingProgress = DB::table('npoly_tickets')->select('id')->where('ticket_status',227)->where('employee_id',$empId)->count();
                    $notResolved = DB::table('npoly_tickets')->select('id')->where('ticket_status',229)->where('employee_id',$empId)->count();
                    $resolved = DB::table('npoly_tickets')->select('id')->where('ticket_status',228)->where('employee_id',$empId)->count();
                    $closed = DB::table('npoly_tickets')->select('id')->where('ticket_status',230)->where('employee_id',$empId)->count();
            }else if($userInfo->is_admin == '1'){
                $today = date('Y-m-d');
                $fordwardInfo = DB::selectOne("select start_date, end_date from npoly_ticket_fordward where  active_status= 1 and end_date > '$today'");
                
                $results = DB::table('npoly_tickets as tkt')
                    ->leftJoin('sa_lookup_data as lkp', 'tkt.priority_id', '=', 'lkp.LOOKUP_DATA_ID')
                    ->leftJoin('set_department as dept', 'dept.id', '=', 'tkt.department_id')
                    ->leftJoin('sa_lookup_data as lkp1', 'tkt.ticket_status', '=', 'lkp1.LOOKUP_DATA_ID')
                    ->leftJoin('npoly_clients as clnt', 'clnt.client_id', '=', 'tkt.client_id')
                    ->leftJoin('npoly_projects as pro', 'pro.project_id', '=', 'tkt.project_id')
                    ->leftJoin('npoly_task_report as tskr', 'tskr.ticket_id', '=', 'tkt.id')
                    ->leftJoin('npoly_support_modules as tm', 'tm.module_id', '=', 'tkt.module_id')
                    ->leftJoin('users as usr', 'usr.id', '=', 'tkt.created_by')
                    ->select('tkt.*','lkp.LOOKUP_DATA_NAME as priorityName','dept.department_name','usr.department_name as request_department','clnt.client_name','pro.project_name','tskr.employee_id','tskr.fordward_employee','tskr.created_at','tskr.forecast_date','tskr.task_complete','lkp1.LOOKUP_DATA_NAME as ticketStatus','tm.module_name')
                    ->where('tkt.ticket_status','!=',230)
                    ->orderBy('tkt.id','desc')
                    ->get();

                    $workingProgress = DB::table('npoly_tickets')->select('id')->where('ticket_status',227)->count();
                    $notResolved = DB::table('npoly_tickets')->select('id')->where('ticket_status',229)->count();
                    $resolved = DB::table('npoly_tickets')->select('id')->where('ticket_status',228)->count();
                    $closed = DB::table('npoly_tickets')->select('id')->where('ticket_status',230)->count();
            }else{
                $today = date('Y-m-d');
                $fordwardInfo = DB::selectOne("select start_date, end_date from npoly_ticket_fordward where  active_status= 1 and end_date > '$today'");
                
                $results = DB::table('npoly_tickets as tkt')
                    ->leftJoin('sa_lookup_data as lkp', 'tkt.priority_id', '=', 'lkp.LOOKUP_DATA_ID')
                    ->leftJoin('set_department as dept', 'dept.id', '=', 'tkt.department_id')
                    ->leftJoin('sa_lookup_data as lkp1', 'tkt.ticket_status', '=', 'lkp1.LOOKUP_DATA_ID')
                    ->leftJoin('npoly_clients as clnt', 'clnt.client_id', '=', 'tkt.client_id')
                    ->leftJoin('npoly_projects as pro', 'pro.project_id', '=', 'tkt.project_id')
                    ->leftJoin('npoly_task_report as tskr', 'tskr.ticket_id', '=', 'tkt.id')
                    ->leftJoin('npoly_support_modules as tm', 'tm.module_id', '=', 'tkt.module_id')
                    ->leftJoin('users as usr', 'usr.id', '=', 'tkt.created_by')
                    ->select('tkt.*','lkp.LOOKUP_DATA_NAME as priorityName','dept.department_name','usr.department_name as request_department','clnt.client_name','pro.project_name','tskr.employee_id','tskr.fordward_employee','tskr.created_at','tskr.forecast_date','tskr.task_complete','lkp1.LOOKUP_DATA_NAME as ticketStatus','tm.module_name')
                    ->where('tkt.department_id',$userInfo->department_id)
                    ->where('tkt.ticket_status','!=',230)
                    ->orderBy('tkt.id','desc')
                    ->get();


                    $workingProgress = DB::table('npoly_tickets')->select('id')->where('ticket_status',227)->where('department_id',$userInfo->department_id)->count();
                    $notResolved = DB::table('npoly_tickets')->select('id')->where('ticket_status',229)->where('department_id',$userInfo->department_id)->count();
                    $resolved = DB::table('npoly_tickets')->select('id')->where('ticket_status',228)->where('department_id',$userInfo->department_id)->count();
                    $closed = DB::table('npoly_tickets')->select('id')->where('ticket_status',230)->where('department_id',$userInfo->department_id)->count();
            }
            // ticket information end here

            // $workingProgress = DB::table('npoly_tickets')->select('id')->where('ticket_status',227)->where('employee_id',1)->count();
            // $notResolved = DB::table('npoly_tickets')->select('id')->where('ticket_status',229)->where('employee_id',1)->count();
            // $resolved = DB::table('npoly_tickets')->select('id')->where('ticket_status',228)->where('employee_id',1)->count();
            // $closed = DB::table('npoly_tickets')->select('id')->where('ticket_status',230)->where('employee_id',1)->count();

            $ticketCountInfo = [
                "WorkingProgress" =>$workingProgress,
                "Resolve" =>$resolved,
                "notResolve" =>$notResolved,
                "closed" =>$closed
            ];

            return response()->json([
                "success" => true,
                "message" => "Data get successfully.",
                "count_info" => $ticketCountInfo,
                "data" => $results
            ],200);
        
    }
    public function deptTicketInfo(Request $request)
    {
        $input = $request->all();
        $employeeNumber = $input['employee_number'];
        //$userId = $input['userId'];

        $userInfo = DB::table('users')->select('*')->where('employee_number',$employeeNumber)->first();
       

            $supportUserId = $userInfo->support_user_id;
            $userLevel = $userInfo->USERLVL_ID;
            
          
                $today = date('Y-m-d');
                $fordwardInfo = DB::selectOne("select start_date, end_date from npoly_ticket_fordward where  active_status= 1 and end_date > '$today'");
                
                $results = DB::table('npoly_tickets as tkt')
                    ->leftJoin('sa_lookup_data as lkp', 'tkt.priority_id', '=', 'lkp.LOOKUP_DATA_ID')
                    ->leftJoin('set_department as dept', 'dept.id', '=', 'tkt.department_id')
                    ->leftJoin('sa_lookup_data as lkp1', 'tkt.ticket_status', '=', 'lkp1.LOOKUP_DATA_ID')
                    ->leftJoin('npoly_clients as clnt', 'clnt.client_id', '=', 'tkt.client_id')
                    ->leftJoin('npoly_projects as pro', 'pro.project_id', '=', 'tkt.project_id')
                    ->leftJoin('npoly_task_report as tskr', 'tskr.ticket_id', '=', 'tkt.id')
                    ->leftJoin('npoly_support_modules as tm', 'tm.module_id', '=', 'tkt.module_id')
                    ->leftJoin('npoly_employees as emp', 'emp.employee_id', '=', 'tkt.employee_id')
                    ->leftJoin('npoly_employees as emp1', 'emp1.employee_id', '=', 'tskr.assign_by')
                    ->leftJoin('users as usr', 'usr.id', '=', 'tkt.created_by')
                    ->select(
                        'tkt.id',
                        'tkt.ticket_no',
                        'dept.department_name',
                        'usr.department_name as request_department',
                        'tkt.ticket_title',
                        'lkp.LOOKUP_DATA_NAME as priorityName',
                        'clnt.client_name',
                        'pro.project_name',
                        'tskr.employee_id',
                        'tskr.fordward_employee',
                        'tskr.created_at',
                        'tkt.created_by',
                        'tskr.forecast_date',
                        'tskr.task_complete',
                        'lkp1.LOOKUP_DATA_NAME as ticketStatus',
                        'tm.module_name',
                        'emp.employee_name as assign_employee',
                        'tskr.assign_date',
                        'emp1.employee_name as assign_by')
                    ->where('tkt.department_id',$userInfo->department_id)
                    //->orWhere('tkt.created_by',$userInfo->id)
                    ->where('tkt.ticket_status','!=',230)
                    ->orderBy('tkt.id','desc')
                    ->get();


                    $workingProgress = DB::table('npoly_tickets')->select('id')->where('ticket_status',227)->where('department_id',$userInfo->department_id)->count();
                    $notResolved = DB::table('npoly_tickets')->select('id')->where('ticket_status',229)->where('department_id',$userInfo->department_id)->count();
                    $resolved = DB::table('npoly_tickets')->select('id')->where('ticket_status',228)->where('department_id',$userInfo->department_id)->count();
                    $closed = DB::table('npoly_tickets')->select('id')->where('ticket_status',230)->where('department_id',$userInfo->department_id)->count();
            
           

            $ticketCountInfo = [
                "WorkingProgress" =>$workingProgress,
                "Resolve" =>$resolved,
                "notResolve" =>$notResolved,
                "closed" =>$closed
            ];

            return response()->json([
                "success" => true,
                "message" => "Data get successfully.",
                "count_info" => $ticketCountInfo,
                "data" => $results
            ],200);
        
    }

    public function getTicketInfoByStatus(Request $request){
        $input = $request->all();
        $ticketStatus = $input['ticket_status'];
        //$userId = $input['userId'];
        $employeeNumber = $input['employee_number'];

        $userInfo = DB::table('users')->select('*')->where('employee_number',$employeeNumber)->first();

        $supportUserId = $userInfo->support_user_id;
        $userLevel = $userInfo->USERLVL_ID;

        if($supportUserId !=0){
            $userId = $userInfo->id;
            $results = DB::table('npoly_tickets as tkt')
            ->leftJoin('sa_lookup_data as lkp', 'tkt.priority_id', '=', 'lkp.LOOKUP_DATA_ID')
            ->leftJoin('set_department as dept', 'dept.id', '=', 'tkt.department_id')
            ->leftJoin('sa_lookup_data as lkp1', 'tkt.ticket_status', '=', 'lkp1.LOOKUP_DATA_ID')
            ->leftJoin('npoly_clients as clnt', 'clnt.client_id', '=', 'tkt.client_id')
            ->leftJoin('npoly_projects as pro', 'pro.project_id', '=', 'tkt.project_id')
            ->leftJoin('npoly_task_report as tskr', 'tskr.ticket_id', '=', 'tkt.id')
            ->leftJoin('npoly_support_modules as tm', 'tm.module_id', '=', 'tkt.module_id')
            ->leftJoin('npoly_employees as emp', 'emp.employee_id', '=', 'tkt.employee_id')
            ->leftJoin('npoly_employees as emp1', 'emp1.employee_id', '=', 'tskr.assign_by')
            ->leftJoin('users as usr', 'usr.id', '=', 'tkt.created_by')
            ->select(
                'tkt.id',
                'tkt.ticket_no',
                'dept.department_name',
                'usr.department_name as request_department',
                'tkt.ticket_title',
                'lkp.LOOKUP_DATA_NAME as priorityName',
                'clnt.client_name',
                'pro.project_name',
                'tskr.employee_id',
                'tskr.fordward_employee',
                'tskr.created_at',
                'tkt.created_by',
                'tskr.forecast_date',
                'tskr.task_complete',
                'lkp1.LOOKUP_DATA_NAME as ticketStatus',
                'tm.module_name',
                'emp.employee_name as assign_employee',
                'tskr.assign_date',
                'emp1.employee_name as assign_by')
            ->where('tkt.created_by',$userId)
            ->where('tkt.ticket_status','=',$ticketStatus)
            ->orderBy('tkt.id','desc')
            ->get();
        }else if($userLevel =='7'){
            $empId = $userInfo->employee_id;
            // $results = DB::table('npoly_tickets as tkt')
            // ->leftJoin('sa_lookup_data as lkp', 'tkt.priority_id', '=', 'lkp.LOOKUP_DATA_ID')
            // ->leftJoin('set_department as dept', 'dept.id', '=', 'tkt.department_id')
            // ->leftJoin('sa_lookup_data as lkp1', 'tkt.ticket_status', '=', 'lkp1.LOOKUP_DATA_ID')
            // ->leftJoin('npoly_clients as clnt', 'clnt.client_id', '=', 'tkt.client_id')
            // ->leftJoin('npoly_projects as pro', 'pro.project_id', '=', 'tkt.project_id')
            // ->leftJoin('npoly_task_report as tskr', 'tskr.ticket_id', '=', 'tkt.id')
            // ->leftJoin('npoly_support_modules as tm', 'tm.module_id', '=', 'tkt.module_id')
            // ->leftJoin('npoly_employees as emp', 'emp.employee_id', '=', 'tkt.employee_id')
            // ->leftJoin('npoly_employees as emp1', 'emp1.employee_id', '=', 'tskr.assign_by')
            // ->select(
            //     'tkt.id',
            //     'tkt.ticket_no',
            //     'dept.department_name',
            //     'tkt.ticket_title',
            //     'lkp.LOOKUP_DATA_NAME as priorityName',
            //     'clnt.client_name',
            //     'pro.project_name',
            //     'tskr.employee_id',
            //     'tskr.fordward_employee',
            //     'tskr.created_at',
            //     'tkt.created_by',
            //     'tskr.forecast_date',
            //     'tskr.task_complete',
            //     'lkp1.LOOKUP_DATA_NAME as ticketStatus',
            //     'tm.module_name',
            //     'emp.employee_name as assign_employee',
            //     'tskr.assign_date',
            //     'emp1.employee_name as assign_by')
            // ->where('tkt.employee_id',$empId)
            // ->orWhere('tkt.created_by',$userInfo->id)
            // ->where('tkt.ticket_status','=',$ticketStatus)
            // ->orderBy('tkt.id','desc')
            // ->get();
            $results = DB::select("select `tkt`.`id`, `tkt`.`ticket_no`, `dept`.`department_name`,`usr`.`department_name as request_department`, `tkt`.`ticket_title`, `lkp`.`LOOKUP_DATA_NAME` as `priorityName`, `clnt`.`client_name`, `pro`.`project_name`, `tskr`.`employee_id`, `tskr`.`fordward_employee`, `tskr`.`created_at`, `tkt`.`created_by`, `tkt`.`ticket_status`, `tskr`.`forecast_date`, `tskr`.`task_complete`, `lkp1`.`LOOKUP_DATA_NAME` as `ticketStatus`, `tm`.`module_name`, `emp`.`employee_name` as `assign_employee`, `tskr`.`assign_date`, `emp1`.`employee_name` as `assign_by` 
                                from `npoly_tickets` as `tkt` 
                                left join `sa_lookup_data` as `lkp` on `tkt`.`priority_id` = `lkp`.`LOOKUP_DATA_ID` 
                                left join `set_department` as `dept` on `dept`.`id` = `tkt`.`department_id` 
                                left join `sa_lookup_data` as `lkp1` on `tkt`.`ticket_status` = `lkp1`.`LOOKUP_DATA_ID` 
                                left join `npoly_clients` as `clnt` on `clnt`.`client_id` = `tkt`.`client_id` 
                                left join `npoly_projects` as `pro` on `pro`.`project_id` = `tkt`.`project_id` 
                                left join `npoly_task_report` as `tskr` on `tskr`.`ticket_id` = `tkt`.`id` 
                                left join `npoly_support_modules` as `tm` on `tm`.`module_id` = `tkt`.`module_id` 
                                left join `npoly_employees` as `emp` on `emp`.`employee_id` = `tkt`.`employee_id` 
                                left join `npoly_employees` as `emp1` on `emp1`.`employee_id` = `tskr`.`assign_by`
                                left join `users` as `usr` on `usr`.`id` = `tkt`.`created_by`
                                WHERE (tkt.employee_id = '$empId' OR tkt.created_by = '$userInfo->id')  
                                and `tkt`.`ticket_status` = '$ticketStatus' order by `tkt`.`id` desc");
        }else if($userInfo->is_admin == '1'){
            $results = DB::table('npoly_tickets as tkt')
            ->leftJoin('sa_lookup_data as lkp', 'tkt.priority_id', '=', 'lkp.LOOKUP_DATA_ID')
            ->leftJoin('set_department as dept', 'dept.id', '=', 'tkt.department_id')
            ->leftJoin('sa_lookup_data as lkp1', 'tkt.ticket_status', '=', 'lkp1.LOOKUP_DATA_ID')
            ->leftJoin('npoly_clients as clnt', 'clnt.client_id', '=', 'tkt.client_id')
            ->leftJoin('npoly_projects as pro', 'pro.project_id', '=', 'tkt.project_id')
            ->leftJoin('npoly_task_report as tskr', 'tskr.ticket_id', '=', 'tkt.id')
            ->leftJoin('npoly_support_modules as tm', 'tm.module_id', '=', 'tkt.module_id')
            ->leftJoin('npoly_employees as emp', 'emp.employee_id', '=', 'tkt.employee_id')
            ->leftJoin('npoly_employees as emp1', 'emp1.employee_id', '=', 'tskr.assign_by')
            ->leftJoin('users as usr', 'usr.id', '=', 'tkt.created_by')
            ->select(
                'tkt.id',
                'tkt.ticket_no',
                'dept.department_name',
                'usr.department_name as request_department',
                'tkt.ticket_title',
                'lkp.LOOKUP_DATA_NAME as priorityName',
                'clnt.client_name',
                'pro.project_name',
                'tskr.employee_id',
                'tskr.fordward_employee',
                'tskr.created_at',
                'tkt.created_by',
                'tskr.forecast_date',
                'tskr.task_complete',
                'lkp1.LOOKUP_DATA_NAME as ticketStatus',
                'tm.module_name',
                'emp.employee_name as assign_employee',
                'tskr.assign_date',
                'emp1.employee_name as assign_by')
            ->where('tkt.ticket_status','=',$ticketStatus)
            ->orderBy('tkt.id','desc')
            ->get();
                
        }else{
            $results = DB::table('npoly_tickets as tkt')
            ->leftJoin('sa_lookup_data as lkp', 'tkt.priority_id', '=', 'lkp.LOOKUP_DATA_ID')
            ->leftJoin('set_department as dept', 'dept.id', '=', 'tkt.department_id')
            ->leftJoin('sa_lookup_data as lkp1', 'tkt.ticket_status', '=', 'lkp1.LOOKUP_DATA_ID')
            ->leftJoin('npoly_clients as clnt', 'clnt.client_id', '=', 'tkt.client_id')
            ->leftJoin('npoly_projects as pro', 'pro.project_id', '=', 'tkt.project_id')
            ->leftJoin('npoly_task_report as tskr', 'tskr.ticket_id', '=', 'tkt.id')
            ->leftJoin('npoly_support_modules as tm', 'tm.module_id', '=', 'tkt.module_id')
            ->leftJoin('npoly_employees as emp', 'emp.employee_id', '=', 'tkt.employee_id')
            ->leftJoin('npoly_employees as emp1', 'emp1.employee_id', '=', 'tskr.assign_by')
            ->leftJoin('users as usr', 'usr.id', '=', 'tkt.created_by')
            ->select(
                'tkt.id',
                'tkt.ticket_no',
                'dept.department_name',
                'usr.department_name as request_department',
                'tkt.ticket_title',
                'lkp.LOOKUP_DATA_NAME as priorityName',
                'clnt.client_name',
                'pro.project_name',
                'tskr.employee_id',
                'tskr.fordward_employee',
                'tskr.created_at',
                'tkt.created_by',
                'tskr.forecast_date',
                'tskr.task_complete',
                'lkp1.LOOKUP_DATA_NAME as ticketStatus',
                'tm.module_name',
                'emp.employee_name as assign_employee',
                'tskr.assign_date',
                'emp1.employee_name as assign_by')
            ->where('tkt.ticket_status','=',$ticketStatus)
            ->orderBy('tkt.id','desc')
            ->get();
        }

            return response()->json([
                "success" => true,
                "message" => "Data get successfully.",
                "data" => $results
            ],200);
    }
    public function getDeptTicketInfoByStatus(Request $request){
        $input = $request->all();
        $ticketStatus = $input['ticket_status'];
        //$userId = $input['userId'];
        $employeeNumber = $input['employee_number'];

        $userInfo = DB::table('users')->select('*')->where('employee_number',$employeeNumber)->first();

        $supportUserId = $userInfo->support_user_id;
        $userLevel = $userInfo->USERLVL_ID;

            $results = DB::table('npoly_tickets as tkt')
            ->leftJoin('sa_lookup_data as lkp', 'tkt.priority_id', '=', 'lkp.LOOKUP_DATA_ID')
            ->leftJoin('set_department as dept', 'dept.id', '=', 'tkt.department_id')
            ->leftJoin('sa_lookup_data as lkp1', 'tkt.ticket_status', '=', 'lkp1.LOOKUP_DATA_ID')
            ->leftJoin('npoly_clients as clnt', 'clnt.client_id', '=', 'tkt.client_id')
            ->leftJoin('npoly_projects as pro', 'pro.project_id', '=', 'tkt.project_id')
            ->leftJoin('npoly_task_report as tskr', 'tskr.ticket_id', '=', 'tkt.id')
            ->leftJoin('npoly_support_modules as tm', 'tm.module_id', '=', 'tkt.module_id')
            ->leftJoin('npoly_employees as emp', 'emp.employee_id', '=', 'tkt.employee_id')
            ->leftJoin('npoly_employees as emp1', 'emp1.employee_id', '=', 'tskr.assign_by')
            ->leftJoin('users as usr', 'usr.id', '=', 'tkt.created_by')
            ->select(
                'tkt.id',
                'tkt.ticket_no',
                'dept.department_name',
                'usr.department_name as request_department',
                'tkt.ticket_title',
                'lkp.LOOKUP_DATA_NAME as priorityName',
                'clnt.client_name',
                'pro.project_name',
                'tskr.employee_id',
                'tskr.fordward_employee',
                'tskr.created_at',
                'tkt.created_by',
                'tskr.forecast_date',
                'tskr.task_complete',
                'lkp1.LOOKUP_DATA_NAME as ticketStatus',
                'tm.module_name',
                'emp.employee_name as assign_employee',
                'tskr.assign_date',
                'emp1.employee_name as assign_by')
            ->where('tkt.ticket_status','=',$ticketStatus)
            ->where('tkt.department_id','=',$userInfo->department_id)
            ->orderBy('tkt.id','desc')
            ->get();
        

            return response()->json([
                "success" => true,
                "message" => "Data get successfully.",
                "data" => $results
            ],200);
    }
    public function ticketStatusChange(Request $request){
        $input = $request->all();
        $ticketId = $input['ticket_id'];
        $status = $input['ticket_status'];

        if($status =='230'){
            $feedback = $input['feedback'];
            $update = DB::table('npoly_tickets')->where('id',$ticketId)->update([
                "feedback" => $feedback,
                "ticket_status" => $status,
            ]);
            return response()->json([
                "success" => true,
                "message" =>  "Status change successfully."
            ],200);
        }else{
            $reason = $input['not_resolve_reason'];
            $update = DB::table('npoly_tickets')->where('id',$ticketId)->update([
                "not_resolve_reason" => $reason,
                "ticket_status" => $status
            ]);
            return response()->json([
                "success" => true,
                "message" => "Status change successfully.",
            ],200);
        }
    }

    public function closedTicketList(Request $request){
        $input = $request->all();
        $employeeNumber = $input['employee_number'];

        $userInfo = DB::table('users')->select('*')->where('employee_number',$employeeNumber)->first();
        $empId = $userInfo->employee_id;

        $results = DB::select("select `tkt`.`id`, `tkt`.`ticket_no`, `dept`.`department_name`, `usr`.`department_name as request_department`,`tkt`.`ticket_title`, `lkp`.`LOOKUP_DATA_NAME` as `priorityName`, `clnt`.`client_name`, `pro`.`project_name`, `tskr`.`employee_id`, `tskr`.`fordward_employee`, `tskr`.`created_at`, `tkt`.`created_by`, `tkt`.`ticket_status`, `tskr`.`forecast_date`, `tskr`.`task_complete`, `lkp1`.`LOOKUP_DATA_NAME` as `ticketStatus`, `tm`.`module_name`, `emp`.`employee_name` as `assign_employee`, `tskr`.`assign_date`, `emp1`.`employee_name` as `assign_by` 
                                from `npoly_tickets` as `tkt` 
                                left join `sa_lookup_data` as `lkp` on `tkt`.`priority_id` = `lkp`.`LOOKUP_DATA_ID` 
                                left join `set_department` as `dept` on `dept`.`id` = `tkt`.`department_id` 
                                left join `sa_lookup_data` as `lkp1` on `tkt`.`ticket_status` = `lkp1`.`LOOKUP_DATA_ID` 
                                left join `npoly_clients` as `clnt` on `clnt`.`client_id` = `tkt`.`client_id` 
                                left join `npoly_projects` as `pro` on `pro`.`project_id` = `tkt`.`project_id` 
                                left join `npoly_task_report` as `tskr` on `tskr`.`ticket_id` = `tkt`.`id` 
                                left join `npoly_support_modules` as `tm` on `tm`.`module_id` = `tkt`.`module_id` 
                                left join `npoly_employees` as `emp` on `emp`.`employee_id` = `tkt`.`employee_id` 
                                left join `npoly_employees` as `emp1` on `emp1`.`employee_id` = `tskr`.`assign_by`
                                left join `users` as `usr` on `usr`.`id` = `tkt`.`created_by`
                                WHERE (tkt.employee_id = '$empId' OR tkt.created_by = '$userInfo->id')  
                                and `tkt`.`ticket_status` = 230 order by `tkt`.`id` desc");

            return response()->json([
                "success" => true,
                "message" => "Data get successfully.",
                "data" => $results
            ],200);

    }
    public function deptClosedTicketList(Request $request){
        $input = $request->all();
        $employeeNumber = $input['employee_number'];

        $userInfo = DB::table('users')->select('*')->where('employee_number',$employeeNumber)->first();
        $empId = $userInfo->employee_id;
        

        $results = DB::select("select `tkt`.`id`, `tkt`.`ticket_no`, `dept`.`department_name`,`usr.department_name as request_department`, `tkt`.`ticket_title`, `lkp`.`LOOKUP_DATA_NAME` as `priorityName`, `clnt`.`client_name`, `pro`.`project_name`, `tskr`.`employee_id`, `tskr`.`fordward_employee`, `tskr`.`created_at`, `tkt`.`created_by`, `tkt`.`ticket_status`, `tskr`.`forecast_date`, `tskr`.`task_complete`, `lkp1`.`LOOKUP_DATA_NAME` as `ticketStatus`, `tm`.`module_name`, `emp`.`employee_name` as `assign_employee`, `tskr`.`assign_date`, `emp1`.`employee_name` as `assign_by` 
                                from `npoly_tickets` as `tkt` 
                                left join `sa_lookup_data` as `lkp` on `tkt`.`priority_id` = `lkp`.`LOOKUP_DATA_ID` 
                                left join `set_department` as `dept` on `dept`.`id` = `tkt`.`department_id` 
                                left join `sa_lookup_data` as `lkp1` on `tkt`.`ticket_status` = `lkp1`.`LOOKUP_DATA_ID` 
                                left join `npoly_clients` as `clnt` on `clnt`.`client_id` = `tkt`.`client_id` 
                                left join `npoly_projects` as `pro` on `pro`.`project_id` = `tkt`.`project_id` 
                                left join `npoly_task_report` as `tskr` on `tskr`.`ticket_id` = `tkt`.`id` 
                                left join `npoly_support_modules` as `tm` on `tm`.`module_id` = `tkt`.`module_id` 
                                left join `npoly_employees` as `emp` on `emp`.`employee_id` = `tkt`.`employee_id` 
                                left join `npoly_employees` as `emp1` on `emp1`.`employee_id` = `tskr`.`assign_by`
                                left join `users` as `usr` on `usr`.`id` = `tkt`.`created_by`
                                WHERE tkt.departmet_id = $userInfo->department_id 
                                and `tkt`.`ticket_status` = 230 order by `tkt`.`id` desc");

            return response()->json([
                "success" => true,
                "message" => "Data get successfully.",
                "data" => $results
            ],200);

    }

    public function ticketInfoById($ticketId){

        $results = DB::table('npoly_tickets as tkt')
        ->leftJoin('sa_lookup_data as lkp', 'tkt.priority_id', '=', 'lkp.LOOKUP_DATA_ID')
        ->leftJoin('set_department as dept', 'dept.id', '=', 'tkt.department_id')
        ->leftJoin('sa_lookup_data as lkp1', 'tkt.ticket_status', '=', 'lkp1.LOOKUP_DATA_ID')
        ->leftJoin('npoly_clients as clnt', 'clnt.client_id', '=', 'tkt.client_id')
        ->leftJoin('npoly_projects as pro', 'pro.project_id', '=', 'tkt.project_id')
        ->leftJoin('npoly_task_report as tskr', 'tskr.ticket_id', '=', 'tkt.id')
        ->leftJoin('npoly_support_modules as tm', 'tm.module_id', '=', 'tkt.module_id')
        ->leftJoin('npoly_employees as emp', 'emp.employee_id', '=', 'tkt.employee_id')
        ->leftJoin('npoly_employees as emp1', 'emp1.employee_id', '=', 'tskr.assign_by')
        ->leftJoin('users as usr', 'usr.id', '=', 'tkt.created_by')
        ->select(
            'tkt.id',
            'tkt.ticket_no',
            'dept.department_name',
            'usr.department_name as request_department',
            'tkt.ticket_title',
            'tkt.ticket_desc',
            'lkp.LOOKUP_DATA_NAME as priorityName',
            'clnt.client_name',
            'pro.project_name',
            'tskr.employee_id',
            'tskr.fordward_employee',
            'tkt.created_at',
            'tkt.created_by',
            'tskr.forecast_date',
            'tskr.task_complete',
            'lkp1.LOOKUP_DATA_NAME as ticketStatus',
            'tm.module_name',
            'emp.employee_name as assign_employee',
            'tskr.assign_date',
            'emp1.employee_name as assign_by')
        ->where('tkt.id','=',$ticketId)
        ->orderBy('tkt.id','desc')
        ->get();

        $ticketAttachment = DB::table('npoly_ticket_attachment')->select('ticket_attachment')->where('ticket_id',$ticketId)->get();

        return response()->json([
            "success" => true,
            "message" => "Data get successfully.",
            "data" => $results,
            "ticket_attachment" => $ticketAttachment,
        ],200);
    }

    public function ticketCreateInfo(Request $request) {

        $department = DB::table('set_department')
        ->select('id as department_id','department_name')
        ->where('active_status', 1)
        ->get();

            return response()->json([
                "success" => true,
                "message" => "Data get successfully.",
                // "issue_group" => $projects,
                // "issue_list" => $problemList,
                // "request_type" => $requestType,
                // "priority" => $priority,
                // "request_mode" => $requestMode,
                // "request_mode" => $requestMode,
                // "contact_person" => $employees,
                "department" => $department,
            ],200);
    }
    public function ticketAssignInfo(Request $request) {
        $input = $request->all();
        $employeeNumber = $input['employee_number'];

        $userInfo = DB::table('users')->select('*')->where('employee_number',$employeeNumber)->first();
        $depId = $userInfo->department_id;
       

        $employees = DB::table('npoly_employees')
            ->select('employee_id','employee_name')
            ->where('active_status', 1)
            ->where('department_id','=',$depId)
            ->orderBy('user_serial_no')
            ->get();

            return response()->json([
                "success" => true,
                "message" => "Data get successfully.",
                 "employees" => $employees,
            ],200);
    }
    public function empTicketAssign(Request $request) {
        $input = $request->all();
        $employeeNumber = $input['employee_number'];
        $ticket_id = $input['ticket_id'];
        $forecast_date = $input['forecast_date'];
        $employee_id = $input['employee_id'];
        $total_hour = $input['total_hour'];
        $total_min = $input['total_min'];

        $userInfo = DB::table('users')->select('*')->where('employee_number',$employeeNumber)->first();
        $depId = $userInfo->department_id;

        if($ticket_id && DB::table('npoly_tickets')->where('id', $ticket_id)->first()){
            $ticketData = array(
               // "department_id"          => $request->department_id,
                "department_id"          => $depId,
                "employee_id"          => $employee_id,
                "ticket_status"          => '234',
                "updated_by"        => $userInfo->id,
                "updated_at"        => date('Y-m-d H:i:s'),
            );

            DB::beginTransaction();
            try {
                DB::table('npoly_tickets')
                    ->where('id', $ticket_id)
                    ->update($ticketData);

                $checkAssingInfo = DB::table('npoly_task_report')->select('*')->where('ticket_id',$ticket_id)->first();
                if(empty($checkAssingInfo)){
                    $hourSecond = $total_hour ? $total_hour * 3600 : 0; 
                    $minSecond = $total_min ? $total_min * 60 : 0; 
                    $setTotalSecond = $hourSecond + $minSecond;
                    $ticktInfo = DB::table('npoly_tickets')->where('id', $ticket_id)->first();
                    //$departmentId = DB::table('npoly_employees')->select('department_id')->where('employee_id', $request->employee_id)->first();
                    $taskData = array(
                        "task_title"          => $ticktInfo->ticket_title,
                        "task_desc"           => $ticktInfo->ticket_desc,
                        "department_id"       => $depId,
                        "employee_id"         => $employee_id,
                        "work_station"        => 1,
                        "assign_by"           => $userInfo->employee_id,
                        "assign_date"         => date('Y-m-d'),
                        "task_create_date"    => date('Y-m-d'),
                        'forecast_date'       => date('Y-m-d',strtotime($forecast_date)),
                        'client_id'           => $ticktInfo->client_id,
                        'project_id'          => $ticktInfo->project_id,
                        'task_priority_id'    => $ticktInfo->priority_id,
                        'ticket_id'           => $ticket_id,
                        'active_status'       => 1,
                        'set_task_duration'       => $setTotalSecond,
                        "created_by"          => $userInfo->id,
                        "created_at"          => date('Y-m-d H:i:s'),
                    );
                    $data = DB::table('npoly_task_report')->insert($taskData);
                }

                DB::commit();
                return response()->json([
                    "success" => true,
                    "message" => "Data get successfully.",
                ],200);

            } catch (\Throwable $e) {
                DB::rollback();
                throw $e;
            }

        }
    }

    public function getIssueGroup(Request $request){
        $input = $request->all();
        $deptId = $input['department_id'];

        $projects = DB::table('npoly_projects')
                ->select('project_id','project_name')
                ->where('department_id',$deptId)
                ->where('active_status',1)
                ->orWhere('department_id',0)
                ->orderBy('department_id','desc')
                ->get();

        // $additionalProject = (object) ['project_id' => 28, 'project_name' => 'others'];
        // $projects = $projects->toArray();
        // $projects[] = $additionalProject;

        $problemList = DB::table('sa_lookup_data as s')
        ->where('s.LOOKUP_GRP_ID', 39)
        ->select('s.LOOKUP_DATA_ID','s.LOOKUP_DATA_NAME')
        ->where('s.ACTIVE_FLAG', 1)
        ->get();

         $employees = DB::table('npoly_employees')
            ->select('employee_id','employee_name')
            ->where('active_status', 1)
            ->where('department_id', $deptId)
            ->where('employee_id','!=',15)
            ->orderBy('user_serial_no')
            ->get();

        return response()->json([
            "success" => true,
            "message" => "Data get successfully.",
                "issue_group" => $projects,
                "issue_list" => $problemList,
                "contact_person" => $employees,
        ],200);
    }

    public function ticketCreateOtherInfo(Request $request){
       $requestType = DB::table('sa_lookup_data as s')
        ->where('s.LOOKUP_GRP_ID', 35)
        ->select('s.LOOKUP_DATA_ID','s.LOOKUP_DATA_NAME')
        ->where('s.ACTIVE_FLAG', 1)
        ->get();

        $priority = DB::table('sa_lookup_data as s')
            ->where('s.LOOKUP_GRP_ID', 36)
            ->select('s.LOOKUP_DATA_ID','s.LOOKUP_DATA_NAME')
            ->where('s.ACTIVE_FLAG', 1)
            ->get();

        $requestMode = DB::table('sa_lookup_data as s')
            ->where('s.LOOKUP_GRP_ID', 37)
            ->select('s.LOOKUP_DATA_ID','s.LOOKUP_DATA_NAME')
            ->where('s.ACTIVE_FLAG', 1)
            ->get();

            return response()->json([
                "success" => true,
                "message" => "Data get successfully.",
                 "request_type" => $requestType,
                 "priority" => $priority,
                 "request_mode" => $requestMode
            ],200);
            
    }

    // public function getIssueGroup(Requst $request){
    //     $input = $request->all();
    //     $deptId = $input['department_id'];

    //     $projects = DB::table('npoly_projects')
    //             ->select('project_id','project_name')
    //             ->where('department_id',$deptId)
    //             ->where('active_status',1)
    //             ->orWhere('department_id',0)
    //             ->orderBy('department_id','desc')
    //             ->get();

    //     $problemList = DB::table('sa_lookup_data as s')
    //     ->where('s.LOOKUP_GRP_ID', 39)
    //     ->select('s.LOOKUP_DATA_ID','s.LOOKUP_DATA_NAME')
    //     ->where('s.ACTIVE_FLAG', 1)
    //     ->get();

    //             return response()->json([
    //                 "success" => true,
    //                 "message" => "Data get successfully.",
    //                  "issue_group" => $projects,
    //                  "issue_list" => $problemList,
    //                 "department" => $department,
    //             ],200);
    // }

    public function ticketCreate(Request $request) {
        $input = $request->all();
        $maxTicketNo = DB::table('npoly_tickets')->max('id')+1;

        $userId = DB::table('users')->select('*')->where('employee_number',$input['created_by'])->first();
        //dd($userId->name);exit;

        $ticketData = array(
            "project_id"         => $input['project_id'],
            "ticket_no"          => date('ymd').'#'.$maxTicketNo,
            "department_id"      => $input['department_id'],
            "ticket_title"       => $input['ticket_title'],
            "ticket_desc"        => $input['ticket_desc'],
            "issue_type_id"      => $input['issue_type_id'],
            'priority_id'        => $input['priority_id'],
            //'module_id'          => $input['module_id'],
            'request_type_id'    => $input['request_type_id'],
            'request_mode_id'    => $input['request_mode_id'],
            'contact_person'     => $input['contact_person'],
            'ticket_status'      => '225',
            "support_user_id"    => $input['support_user_id'],
            "created_by"         => $userId->id,
            "created_at"         => date('Y-m-d H:i:s'),
            "ticket_create_date"        => date('Y-m-d'),
        );

        DB::beginTransaction();
        try {
            $ticketId = DB::table('npoly_tickets')->insertGetId($ticketData);
            DB::commit();
            $aFile='';

            

            // if($request->file('image')){
            //     $file = $request->file('image');
            //     $filename = $ticketId.'-'.uniqid() . "_" . $file->getClientOriginalName();
            //     $aFile .=$filename;
            //     $file->move(public_path() . '/uploads/ticket_image/', $filename);

            //     $ticketAttachData = array(
            //         "ticket_id"    => $ticketId,
            //         "ticket_attachment"      => '/uploads/ticket_image/'.$filename,
            //         "created_by"        => $userId->id,
            //         "created_at"        => date('Y-m-d H:i:s'),
            //     );
            //     $data = DB::table('npoly_ticket_attachment')->insert($ticketAttachData);
                

            // }

            // ticket attachment store
            $aFile=[];
            if($request->file('image')){
                $files = $request->file('image');
                $aFile []=$files;
                foreach ($files as $file) {
    
                    //$name = $Userid.'-'.date('Ymd').mt_rand(1000,9999).'.'.$file->getClientOriginalExtension();
                    $name = $ticketId.'-'.$file->getClientOriginalName();
                    $exten = $file->getClientOriginalExtension();
                    if($exten == "docx" || $exten == "xlsx" || $exten == "doc" || $exten == "pdf" || $exten == "bmp" || $exten == "zip" ){
                        $file->move(public_path() . '/uploads/ticket_image/', $name);
                    }else{
                        $file->move(public_path() . '/uploads/ticket_image/', $name);
                    }
    
                    // Save the filename to the database
    
                    $ticketAttachData = array(
                        "ticket_id"    => $ticketId,
                        "ticket_attachment"      => '/uploads/ticket_image/'.$name,
                        //"created_by"        => Auth::user()->id,
                        "created_at"        => date('Y-m-d H:i:s'),
                    );
                    $data = DB::table('npoly_ticket_attachment')->insert($ticketAttachData);
    
                }
            }
           
                // ticket mail send start here
        
          $results = DB::table('npoly_tickets as tkt')
        //->leftJoin('npoly_clients as clnt','tkt.client_id','clnt.client_id')
        ->leftJoin('npoly_projects as pro','tkt.project_id','pro.project_id')
        ->leftJoin('npoly_support_modules as mod','tkt.module_id','mod.module_id')
        ->leftJoin('sa_lookup_data as lkp','tkt.priority_id','lkp.LOOKUP_DATA_ID')
        ->leftJoin('sa_lookup_data as lkp1','tkt.ticket_status','lkp1.LOOKUP_DATA_ID')
        ->leftJoin('sa_lookup_data as lkp2','tkt.issue_type_id','lkp2.LOOKUP_DATA_ID')
        ->leftJoin('sa_lookup_data as lkp3','tkt.request_type_id','lkp3.LOOKUP_DATA_ID')
        ->leftJoin('sa_lookup_data as lkp4','tkt.request_mode_id','lkp4.LOOKUP_DATA_ID')
        ->select('tkt.*','pro.project_name','mod.module_name','lkp.LOOKUP_DATA_NAME as priority_name','lkp1.LOOKUP_DATA_NAME as ticket_status','lkp2.LOOKUP_DATA_NAME as issue_type','lkp3.LOOKUP_DATA_NAME as request_type','lkp4.LOOKUP_DATA_NAME as request_mode')
        ->where('id',$ticketId)
        ->first();
        
        $dpetHeadEmail = DB::table('users')
                        ->select('email_address')
                        ->where('department_id',$results->department_id)
                        ->where('is_dept_head',1)
                        ->first();
        
    // mail config start here
    $contactPerson = $results->contact_person;
    if(!empty($contactPerson)){
        $contactPesonEmail = DB::table('npoly_employees')->select('employee_name','email')->where('employee_id',$contactPerson)->first();
    }
  
    /*
    $supportUserMail = DB::table('users')->select('email_address','name','pbx_no')->where('id',$userId->id)->first();
    //$aFileName = $_FILES['image']['name'];
   // $aFile=$aFileName[0];
    //$aFile='';
    $data['results']= $results ;
    $data['ticket_id']= $ticketId ;
    $data['title'] = 'Support Ticket';
    $data['form_email'] = 'ticket@nationalpolymer.net';
    
    $data['form_name'] = 'Support User'.'('.$results->ticket_no.')';
    $data['to_name'] = 'Npoly Group';
    $data['to_email'] = 'mir.mh@nationalpolymer.net';
    $data['support_user_mail'] = $supportUserMail->email_address;
    $data['user_name'] = $supportUserMail->name;
    $data['pbx_no'] = $supportUserMail->pbx_no;
    // Requester Info
    $data['created_by'] = $userId->name;
    $data['created_at'] = $results->created_at;
    $data['req_email'] = $userId->email_address;
    $data['contact_no'] = $userId->contact_no;
    $data['request_type'] = $results->request_type;
    $data['request_mode'] = $results->request_mode;
    $designationId = $userId->designation;
    $desigName = DB::table('sa_lookup_data')->select('lookup_data_name as designation')->where('lookup_data_id',$designationId)->first();
   
    $data['designation_name'] = $desigName !="" ? $desigName->designation:"";
*/
$data = array();
    if(empty($aFile)){
        $supportUserMail = DB::table('users')->select('email_address','name','pbx_no')->where('id',$userId->id)->first();  
        $data['results']= $results ;
        $data['ticket_id']= $ticketId ;
        $data['title'] = 'Support Ticket';
        $data['form_email'] = 'ticket@nationalpolymer.net';
        
        $data['form_name'] = 'Support User'.'('.$results->ticket_no.')';
        $data['to_name'] = 'Npoly Group';
        $data['attachment'] = $aFile;
        $data['to_email'] = $dpetHeadEmail->email_address;
        $data['support_user_mail'] = $supportUserMail->email_address;
        $data['user_name'] = $supportUserMail->name;
        $data['pbx_no'] = $supportUserMail->pbx_no;
        // Requester Info
        $data['created_by'] = $userId->name;
        $data['created_at'] = $results->created_at;
        $data['req_email'] = $userId->email_address;
        $data['contact_no'] = $userId->contact_no;
        $data['request_type'] = $results->request_type;
        $data['request_mode'] = $results->request_mode;
        $designationId = $userId->designation;
        $deptName = DB::table('set_department')->select('department_name')->where('id',$userId->department_id)->first();
        $desigName = DB::table('sa_lookup_data')->select('lookup_data_name as designation')->where('lookup_data_id',$designationId)->first();
        $data['designation_name'] = $desigName !="" ? $desigName->designation:"";
        $data['department_name'] = $deptName !="" ? $deptName->department_name:"";
        $sent = Mail::send('emails.ticket_mail', $data, function ($m) use ($data) {
            $m->from($data['form_email'], $data['form_name']);
            $m->to($data['to_email'], $data['to_name']);
             //$m->to(['azam.ali@nationalpolymer.net']);
            $m->subject($data['title']);
        });
    }else
    {
        $supportUserMail = DB::table('users')->select('email_address','name','pbx_no')->where('id',$userId->id)->first();
        
        $data['results']= $results ;
        $data['ticket_id']= $ticketId ;
        $data['title'] = 'Support Ticket';
        $data['form_email'] = 'ticket@nationalpolymer.net';
        
        $data['form_name'] = 'Support User'.'('.$results->ticket_no.')';
        $data['to_name'] = 'Npoly Group';
        $data['attachment'] = $aFile;
        $data['to_email'] = $dpetHeadEmail->email_address;
        $data['support_user_mail'] = $supportUserMail->email_address;
        $data['user_name'] = $supportUserMail->name;
        $data['pbx_no'] = $supportUserMail->pbx_no;
        // Requester Info
        $data['created_by'] = $userId->name;
        $data['created_at'] = $results->created_at;
        $data['req_email'] = $userId->email_address;
        $data['contact_no'] = $userId->contact_no;
        $data['request_type'] = $results->request_type;
        $data['request_mode'] = $results->request_mode;
        $designationId = $userId->designation;
        $desigName = DB::table('set_designation')->select('designation_name as designation')->where('id',$designationId)->first();
        $deptName = DB::table('set_department')->select('department_name')->where('id',$userId->department_id)->first();
        $data['designation_name'] = $desigName !="" ? $desigName->designation:"";
        $data['department_name'] = $deptName !="" ? $deptName->department_name:"";
        $sent = Mail::send('emails.ticket_mail', $data, function ($m) use ($data) {
            $m->from($data['form_email'], $data['form_name']);
            $m->to($data['to_email'], $data['to_name']);
            //$m->to(['azam.ali@nationalpolymer.net']);
            //$m->cc(['azamalibd808@gmail.com','ishtiaq.ahmed@nationalpolymer.net']);
            $m->subject($data['title']);
            //$m->attach("public/uploads/ticket_image/".$data['attachment']);
            
            $size = sizeOf($_FILES['image']['name']);
            for ($i=0; $i < $size; $i++) {
                //$m->attach("UPLOADS/ATTACHMENT/".$_FILES['ticket_attachment']['name'][$i]);
                $m->attach("public/uploads/ticket_image/".$data['ticket_id'].'-'.$_FILES['image']['name'][$i]);
            }
            
        });
    }
     // Generate Mail For Support User
     $sent = Mail::send('emails.support_user_mail', $data, function ($m) use ($data) {
        $m->from($data['form_email'], $data['form_name']);
        $m->to($data['support_user_mail']);
        //$m->to(['azam.ali@nationalpolymer.net']);
        $m->subject($data['title']);
    });

    

    return response()->json([
        "success" => true,
        "message" => "Data get successfully.",
        "data" => $results
    ],200);

    // ticket mail send end here

        } catch (\Throwable $e) {
            DB::rollback();
            throw $e;
            exit;
        }
        
        
    }
}
