<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;

class SalesController extends Controller
{
    public function getSearchInfo(Request $request){
        $products = DB::connection('oracle')->select("SELECT DISTINCT ATTRIBUTE2 PRODUCT FROM ONT.OE_TRANSACTION_TYPES_ALL@XXNPTICKET_SALES WHERE ATTRIBUTE2 <> 'NA'");
        
         $orgnizations = DB::connection('oracle')->select("SELECT ORGANIZATION_ID org_id,ORGANIZATION_NAME org_name from apps.ORG_ORGANIZATION_DEFINITIONS@XXNPTICKET_SALES
                                                         GROUP BY ORGANIZATION_ID,ORGANIZATION_NAME
                                                         ORDER BY ORGANIZATION_ID");
        $data = [
            "product_list" =>$products ? $products : [],
            "orgnization" =>$orgnizations ? $orgnizations : [],
        ];
        return response()->json([
            "success" => true,
            "message" => "Data get successfully.",
            "data"=>$data ,
            "status" =>200
        ],200);
    }

    public function searchCollection(Request $request){
        $input = $request->all();

        $fromDate = date('d-M-Y',strtotime($input['fromDate']));
        $toDate = date('d-M-Y',strtotime($input['toDate']));
        $productId = $input['productId'];
        $orgId = $input['orgId'] ? $input['orgId']:101;

        $condition1 = '';
        $condition2 = '';
        $condition3 = '';

        if(!empty($productId)){
            $condition1 .= " AND OTA.ATTRIBUTE2 = '$productId'";
        }
        if(!empty($productId)){
            $condition2 .= " AND PROD_TYPE = '$productId'";
        }
        if(!empty($productId)){
            $condition3 .= " AND A.PROD_TYPE = '$productId'";
        }

        $results = DB::connection('oracle')->select("SELECT PRODUCT,ORG_ID,
                                                        SUM(DO_AMOUNT)DO_AMOUNT,
                                                        SUM(INVOICE_AMOUNT)INVOICE_AMOUNT,
                                                        SUM(COLLECTION_AMOUNT)COLLECTION_AMOUNT
                                                        FROM(
                                                        SELECT DECODE(OTA.ATTRIBUTE2,'Packing Mat','Packaging Materials',OTA.ATTRIBUTE2) PRODUCT,H.ORG_ID,
                                                                ROUND (SUM (CASE  WHEN H.TRANSACTIONAL_CURR_CODE = 'BDT' THEN ((NVL(L.ORDERED_QUANTITY,0)-NVL(CANCELLED_QUANTITY,0))*NVL(L.UNIT_SELLING_PRICE,0))
                                                                ELSE (((NVL(L.ORDERED_QUANTITY, 0)-NVL(CANCELLED_QUANTITY,0)) * NVL (L.UNIT_SELLING_PRICE, 0))) * NVL(APPS.XX_CONVERSION_RATE@XXNPTICKET_SALES (TRUNC (H.ORDERED_DATE)),0)
                                                                END)) DO_AMOUNT,
                                                                0 INVOICE_AMOUNT,
                                                                0 COLLECTION_AMOUNT
                                                        FROM ONT.OE_ORDER_HEADERS_ALL@XXNPTICKET_SALES H,
                                                            ONT.OE_ORDER_LINES_ALL@XXNPTICKET_SALES L,
                                                            ONT.OE_TRANSACTION_TYPES_TL@XXNPTICKET_SALES OT,
                                                            ONT.OE_TRANSACTION_TYPES_ALL@XXNPTICKET_SALES OTA
                                                        WHERE    H.HEADER_ID = L.HEADER_ID
                                                            AND (ORDERED_ITEM NOT LIKE ('031.%') OR ORDERED_ITEM NOT LIKE ('033.%'))
                                                            AND H.ORG_ID = L.ORG_ID
                                                            AND ITEM_TYPE_CODE NOT IN ('CLASS','OPTION','CONFIG','INCLUDED')
                                                            AND ((L.TOP_MODEL_LINE_ID IS NOT NULL AND L.TOP_MODEL_LINE_ID = LINE_ID) OR (L.TOP_MODEL_LINE_ID IS NULL))
                                                            AND H.ORDER_TYPE_ID = OT.TRANSACTION_TYPE_ID
                                                            AND OT.TRANSACTION_TYPE_ID = OTA.TRANSACTION_TYPE_ID
                                                            AND H.BOOKED_FLAG = 'Y'
                                                            AND H.CANCELLED_FLAG = 'N'
                                                            AND H.BOOKED_DATE IS NOT NULL
                                                            AND (OT.NAME NOT LIKE '%Intercompany%' AND OT.NAME NOT LIKE '%Internal%' AND OT.NAME NOT LIKE '%Return%')
                                                            AND TRUNC(ORDERED_DATE) BETWEEN TO_DATE('$fromDate','DD-MM-YYYY') AND TO_DATE('$toDate','DD-MM-YYYY')
                                                            AND H.ORG_ID='$orgId'
                                                            $condition1
                                                        GROUP BY OTA.ATTRIBUTE2,H.ORG_ID
                                                        UNION ALL-----Invoice amount
                                                        SELECT DECODE(PROD_TYPE,'Packing','Packaging Materials',PROD_TYPE) PRODUCT, SAL.ORG_ID,
                                                            0 DO_AMOUNT,
                                                            SUM(NVL (DR_AMOUNT, 0)) INVOICE_AMOUNT,
                                                            0 COLLECTION_AMOUNT                    
                                                        FROM APPS.XX_AR_CUST_DTL_LED_ACTUAL_V1@XXNPTICKET_SALES SAL,
                                                            APPS.XX_AR_CUSTOMERS_ALL_V@XXNPTICKET_SALES CUST
                                                        WHERE  SAL.CUSTOMER_ID = CUST.CUSTOMER_ID(+)
                                                        AND TRX_TYPE IN ('Sales')
                                                        AND CUSTOMER_CLASS_CODE NOT IN ('INTERCOMPANY')
                                                        AND SAL.GL_DATE BETWEEN TO_DATE('$fromDate','DD-MM-YYYY') AND TO_DATE('$toDate','DD-MM-YYYY')
                                                        AND SAL.ORG_ID='$orgId'
                                                        $condition2
                                                        GROUP BY PROD_TYPE, SAL.ORG_ID
                                                        UNION ALL-----Collection
                                                        SELECT PROD_NAME PRODUCT,ORG_ID,
                                                        0 DO_AMOUNT,
                                                        0 INVOICE_AMOUNT,
                                                        SUM(COLLAMT)COLLECTION_AMOUNT
                                                        FROM(SELECT 
                                                        (CASE WHEN A.PROD_TYPE='Pipe' THEN 'Pipe'
                                                            WHEN A.PROD_TYPE='Pipe PVC1' THEN 'Pipe'
                                                            WHEN A.PROD_TYPE='Pipe PVC2' THEN 'Pipe'
                                                            WHEN A.PROD_TYPE='Packing Mat' THEN 'Packaging Materials'
                                                            ELSE A.PROD_TYPE END)PROD_NAME,
                                                            A.ORG_ID,
                                                            (NVL (CR_AMOUNT, 0) - NVL (DR_AMOUNT, 0)) COLLAMT                      
                                                        FROM APPS.XX_AR_CUST_DTL_LED_V_YUF@XXNPTICKET_SALES A, 
                                                            APPS.XX_AR_CUSTOMERS_ALL_V@XXNPTICKET_SALES CUST
                                                        WHERE A.CUSTOMER_ID = CUST.CUSTOMER_ID(+)
                                                            AND CUSTOMER_CLASS_CODE NOT IN ('INTERCOMPANY')
                                                            AND TRX_TYPE IN ('Receipts','Customer Refund','Reversed Receipts')
                                                            AND A.GL_DATE BETWEEN TO_DATE('$fromDate','DD-MM-YYYY') AND TO_DATE('$toDate','DD-MM-YYYY')
                                                            AND A.ORG_ID='$orgId'
                                                            $condition3
                                                            AND CUST.CUSTOMER_ID NOT IN (6042,4225,328992,228066,324440))
                                                        GROUP BY PROD_NAME,ORG_ID)
                                                        GROUP BY PRODUCT,ORG_ID");

                return response()->json([
                    "success" => true,
                    "message" => "Data get successfully.",
                    "data"=>$results ,
                    "status" =>200
                ],200);
    }

    public function salesInfo(Request $request){
        $products = DB::connection('oracle')->select("SELECT DISTINCT ATTRIBUTE2 PRODUCT FROM ONT.OE_TRANSACTION_TYPES_ALL@XXNPTICKET_SALES WHERE ATTRIBUTE2 <> 'NA'");
         $categorys = DB::connection('oracle')->select("SELECT distinct ATTRIBUTE10 category FROM APPS.MTL_SYSTEM_ITEMS_B_KFV@XXNPTICKET_SALES MSIK WHERE ATTRIBUTE10 is not null");
         $orgnizations = DB::connection('oracle')->select("SELECT ORGANIZATION_ID org_id,ORGANIZATION_NAME org_name from apps.ORG_ORGANIZATION_DEFINITIONS@XXNPTICKET_SALES
                                                         GROUP BY ORGANIZATION_ID,ORGANIZATION_NAME
                                                         ORDER BY ORGANIZATION_ID");
        $data = [
            "product" =>$products ? $products : [],
            "categorys" =>$categorys ? $categorys : [],
            "orgnization" =>$orgnizations ? $orgnizations : [],
        ];

        return response()->json([
            "success" => true,
            "message" => "Data get successfully.",
            "data"=>$data ,
            "status" =>200
        ],200);
    }

    public function searchSalesInfo(Request $request){
        $input = $request->all();

        $fromDate = date('d-M-Y',strtotime($input['fromDate']));
        $toDate = date('d-M-Y',strtotime($input['toDate']));
        $productId = $input['productId'] ?  $input['productId'] :"";
        $categoryId = $input['categoryId'] ? $input['categoryId']:"";
        $orgId = $input['orgId'] ? $input['orgId']:101;

        $condition = '';

        if(!empty($productId)){
            $condition .= " AND OTA.ATTRIBUTE2 = '$productId'";
        }
        if(!empty($categoryId)){
            $condition .= " AND MSIK.ATTRIBUTE10 = '$categoryId'";
        }
        if(!empty($orgId)){
            $condition .= " AND H.ORG_ID ='$orgId'";
        }
        

        $results = DB::connection('oracle')->select("SELECT PRODUCT,MOTHER_CAT,ITEM_CODE,ITEM_NAME,UOM,
            SUM(DO_QTY)DO_QTY,SUM(DO_AMOUNT)DO_AMOUNT,
            SUM(SHIPPED_QUANTITY)SHIPPED_QUANTITY,SUM(SHIPPED_AMOUNT)SHIPPED_AMOUNT
            FROM(SELECT OTA.ATTRIBUTE2 PRODUCT,MSIK.ATTRIBUTE10 MOTHER_CAT,               
                    L.ORDERED_ITEM ITEM_CODE, 
                    MSIK.DESCRIPTION ITEM_NAME,
                    ORDER_QUANTITY_UOM UOM,
                    SUM(NVL(L.ORDERED_QUANTITY, 0)-NVL(CANCELLED_QUANTITY,0))DO_QTY,
                    ROUND (SUM (CASE  WHEN H.TRANSACTIONAL_CURR_CODE = 'BDT' THEN ((NVL(L.ORDERED_QUANTITY,0)-NVL(CANCELLED_QUANTITY,0))*NVL(L.UNIT_SELLING_PRICE,0))
                    ELSE (((NVL(L.ORDERED_QUANTITY, 0)-NVL(CANCELLED_QUANTITY,0)) * NVL (L.UNIT_SELLING_PRICE, 0))) * NVL(APPS.XX_CONVERSION_RATE@XXNPTICKET_SALES (TRUNC (H.ORDERED_DATE)),0)
                    END)) DO_AMOUNT,        
                    0 SHIPPED_QUANTITY,
                    0 SHIPPED_AMOUNT
            FROM ONT.OE_ORDER_HEADERS_ALL@XXNPTICKET_SALES H,
                ONT.OE_ORDER_LINES_ALL@XXNPTICKET_SALES L,
                ONT.OE_TRANSACTION_TYPES_TL@XXNPTICKET_SALES OT,
                ONT.OE_TRANSACTION_TYPES_ALL@XXNPTICKET_SALES OTA,
                APPS.MTL_SYSTEM_ITEMS_B_KFV@XXNPTICKET_SALES MSIK
            WHERE    H.HEADER_ID = L.HEADER_ID
                AND (ORDERED_ITEM NOT LIKE ('031.%') OR ORDERED_ITEM NOT LIKE ('033.%'))
                AND H.ORG_ID = L.ORG_ID
                AND ITEM_TYPE_CODE NOT IN ('CLASS','OPTION','CONFIG','INCLUDED')
                AND ((L.TOP_MODEL_LINE_ID IS NOT NULL AND L.TOP_MODEL_LINE_ID = LINE_ID) OR (L.TOP_MODEL_LINE_ID IS NULL))
                AND H.ORDER_TYPE_ID = OT.TRANSACTION_TYPE_ID
                AND OT.TRANSACTION_TYPE_ID = OTA.TRANSACTION_TYPE_ID
                AND H.BOOKED_FLAG = 'Y'
                AND H.CANCELLED_FLAG = 'N'
                AND H.BOOKED_DATE IS NOT NULL
                AND (OT.NAME NOT LIKE '%Intercompany%' AND OT.NAME NOT LIKE '%Internal%' AND OT.NAME NOT LIKE '%Return%')
                --AND TRUNC(ORDERED_DATE) BETWEEN :P_DATE_FR AND :P_DATE_TO
                AND TRUNC(ORDERED_DATE) BETWEEN TO_DATE('$fromDate','DD-MM-YYYY') AND TO_DATE('$toDate','DD-MM-YYYY')
                $condition
                AND MSIK.ORGANIZATION_ID = H.ORG_ID
                AND MSIK.INVENTORY_ITEM_ID = L.INVENTORY_ITEM_ID
            GROUP BY OTA.ATTRIBUTE2,L.ORDERED_ITEM,MSIK.DESCRIPTION,MSIK.ATTRIBUTE10,L.ORDER_QUANTITY_UOM
            UNION ALL
            SELECT OTA.ATTRIBUTE2 PRODUCT,MSIK.ATTRIBUTE10 MOTHER_CAT,               
                    L.ORDERED_ITEM ITEM_CODE, 
                    MSIK.DESCRIPTION ITEM_NAME,
                    ORDER_QUANTITY_UOM UOM,
                    0 DO_QTY,
                    0 DO_AMOUNT,        
                    SUM(NVL(SHIPPED_QUANTITY,0))SHIPPED_QUANTITY,
                ROUND (SUM (CASE  WHEN H.TRANSACTIONAL_CURR_CODE = 'BDT' THEN ((NVL(L.SHIPPED_QUANTITY,0))*NVL(L.UNIT_SELLING_PRICE,0))
                    ELSE (((NVL(L.SHIPPED_QUANTITY, 0)) * NVL (L.UNIT_SELLING_PRICE, 0))) * NVL(apps.XX_CONVERSION_RATE@XXNPTICKET_SALES (TRUNC (L.ACTUAL_FULFILLMENT_DATE)),0)
                    END))SHIPPED_AMOUNT
                    
            FROM ONT.OE_ORDER_HEADERS_ALL@XXNPTICKET_SALES H,
                ONT.OE_ORDER_LINES_ALL@XXNPTICKET_SALES L,
                ONT.OE_TRANSACTION_TYPES_TL@XXNPTICKET_SALES OT,
                ONT.OE_TRANSACTION_TYPES_ALL@XXNPTICKET_SALES OTA,
                APPS.MTL_SYSTEM_ITEMS_B_KFV@XXNPTICKET_SALES MSIK
            WHERE    H.HEADER_ID = L.HEADER_ID
                AND (ORDERED_ITEM NOT LIKE ('031.%') OR ORDERED_ITEM NOT LIKE ('033.%'))
                AND H.ORG_ID = L.ORG_ID
                AND ITEM_TYPE_CODE NOT IN ('CLASS','OPTION','CONFIG','INCLUDED')
                AND ((L.TOP_MODEL_LINE_ID IS NOT NULL AND L.TOP_MODEL_LINE_ID = LINE_ID) OR (L.TOP_MODEL_LINE_ID IS NULL))
                AND H.ORDER_TYPE_ID = OT.TRANSACTION_TYPE_ID
                AND OT.TRANSACTION_TYPE_ID = OTA.TRANSACTION_TYPE_ID
                AND H.BOOKED_FLAG = 'Y'
                AND H.CANCELLED_FLAG = 'N'
                AND H.BOOKED_DATE IS NOT NULL
                AND (OT.NAME NOT LIKE '%Intercompany%' AND OT.NAME NOT LIKE '%Internal%' AND OT.NAME NOT LIKE '%Return%')
                --AND TRUNC(ACTUAL_FULFILLMENT_DATE) BETWEEN :P_DATE_FR AND :P_DATE_TO
                AND TRUNC(ORDERED_DATE) BETWEEN TO_DATE('$fromDate','DD-MM-YYYY') AND TO_DATE('$toDate','DD-MM-YYYY')
            $condition
                AND MSIK.ORGANIZATION_ID = H.ORG_ID
                AND MSIK.INVENTORY_ITEM_ID = L.INVENTORY_ITEM_ID
            GROUP BY OTA.ATTRIBUTE2,L.ORDERED_ITEM,MSIK.DESCRIPTION,MSIK.ATTRIBUTE10,L.ORDER_QUANTITY_UOM)
            GROUP BY PRODUCT,MOTHER_CAT,ITEM_CODE,ITEM_NAME,UOM");

            return response()->json([
                "success" => true,
                "message" => "Data get successfully.",
                "data"=>$results ,
                "status" =>200
            ],200);
    }
}
