<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rules\File;
use DateTime;

class MeetingController extends Controller
{
    public function meetingInfoByDate(Request $request){
        $input = $request->all();
        $meetingDate = date('Y-m-d',strtotime($input['meeting_date']));
        //$meetingDate = $input['department_id'],
        $today = date('Y-m-d');

            try {

                $roomImage = array(
                    '0' => array('room_id' =>'286', 'image' =>'https://images.unsplash.com/photo-1582653291997-079a1c04e5a1?q=80&w=1000&auto=format&fit=crop&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxzZWFyY2h8Mnx8Y29uZmVyZW5jZSUyMHJvb218ZW58MHx8MHx8fDA%3D%27'),
                    '1' => array('room_id' =>'287', 'image' =>'https://t3.ftcdn.net/jpg/04/69/06/04/360_F_469060472_lJxHKmA0Z3fWaK5lHpNtXCDjWLY8XWgW.jpg'),
                    '2' => array('room_id' =>'288', 'image' =>'https://static.vecteezy.com/system/resources/previews/019/775/102/original/meeting-room-cartoon-vector.jpg'),
                    '3' => array('room_id' =>'300', 'image' =>'https://static.vecteezy.com/system/resources/previews/019/775/102/original/meeting-room-cartoon-vector.jpg'),
                    '4' => array('room_id' =>'301', 'image' =>'https://static.vecteezy.com/system/resources/previews/019/775/102/original/meeting-room-cartoon-vector.jpg')
                );
                

                $roomInfo = DB::table('sa_lookup_data')
                            ->select('lookup_data_id as room_id','lookup_data_name as room_no')
                            ->where('lookup_grp_id',46)
                            ->where('ACTIVE_FLAG',1)
                            ->orderBy('lookup_data_id','asc')
                            ->get();

                foreach( $roomInfo as $key => $room ) {

                    
                    $roomInfo[ $key]->image = $roomImage[$key]['image'];
        
                }

               $meetingInfo = DB::select("SELECT m.room_id,lkp.LOOKUP_DATA_NAME as room_no,m.meeting_title, m.participant_id, CONCAT(meeting_date,' ',TIME_FORMAT(SEC_TO_TIME(start_time), '%h:%i:%s %p')) AS start_times,CONCAT(meeting_date,' ',TIME_FORMAT(SEC_TO_TIME(end_time), '%h:%i:%s %p')) AS end_times,m.meeting_status FROM meeting_room_booking as m, sa_lookup_data as lkp
               WHERE m.room_id = lkp.LOOKUP_DATA_ID
                       AND m.meeting_date = '$meetingDate'
                       and m.active_status = 1
                       ORDER by m.start_time asc");

        foreach( $meetingInfo as $key => $meet ) {

            //$module[ $key]->stack = DB::table('mobile_module_screen')->select('screen_name')->where('module_id',$adress->module_id)->get();
            $meetingInfo[ $key]->guest = DB::selectOne("SELECT COUNT(employee_id) employee_id FROM npoly_employees WHERE employee_id in($meet->participant_id)")->employee_id;

        }
                return response()->json([
                    "success" => true,
                    "message" => "Data get successfully.",
                    "room_info" => $roomInfo,
                    "data" => $meetingInfo
                ],200);
                
                } catch (\Exception $e) {
                
                    return response()->json([
                        "success" => false,
                        "message" => "Somethings went wrong",
                    ],500);
                }
    }

    public function meetingInfoByRoomWise(Request $request){
        $input = $request->all();
        $roomId = $input['room_id'];
        $meetingDate = $input['meeting_date'];

        try {

            $meetingInfo = DB::select("SELECT m.meeting_id,m.room_id,lkp.LOOKUP_DATA_NAME as room_no,m.meeting_title,m.meeting_desc,m.remarks, m.participant_id,m.meeting_date, CONCAT(meeting_date,' ',TIME_FORMAT(SEC_TO_TIME(start_time), '%h:%i:%s %p')) AS meeting_start_time,CONCAT(meeting_date,' ',TIME_FORMAT(SEC_TO_TIME(end_time), '%h:%i:%s %p')) AS meeting_end_time,m.meeting_status,m.guest,m.no_of_guest,m.particular_id FROM meeting_room_booking as m, sa_lookup_data as lkp
               WHERE m.room_id = lkp.LOOKUP_DATA_ID
                        and m.room_id = '$roomId'
                       AND m.meeting_date = '$meetingDate'
                       and m.active_status = 1
                       ORDER by m.start_time asc");

        foreach( $meetingInfo as $key => $meet ) {

            //$module[ $key]->stack = DB::table('mobile_module_screen')->select('screen_name')->where('module_id',$adress->module_id)->get();
            $meetingInfo[ $key]->current_meeting = $meet->meeting_id =='19'? true:false;
            //$meetingInfo[ $key]->current_time = $meet->start_time;
            $meetingInfo[ $key]->participent = DB::selectOne("SELECT COUNT(employee_id) employee_id FROM npoly_employees WHERE employee_id in($meet->participant_id)")->employee_id;
            $meetingInfo[ $key]->participent_name = DB::select("SELECT emp.employee_name,desig.designation_name,dept.department_name,emp.office_email,'' as 'image'
            FROM npoly_employees as emp, set_department as dept, set_designation as desig
            WHERE emp.department_id = dept.id
            AND emp.designation_id = desig.id
            AND emp.employee_id IN ($meet->participant_id) order by emp.user_serial_no asc");

            $particularIdIn = $meet->particular_id?$meet->particular_id:0;
            $meetingInfo[ $key]->services = DB::select("SELECT par.particular_id,par.name,par.icon  FROM meeting_particular par 
            WHERE par.particular_id in ( $particularIdIn)");

        }
            return response()->json([
                "success" => true,
                "message" => "Data get successfully.",
                "data" => $meetingInfo
            ],200);
            
            } catch (\Exception $e) {
            
                return response()->json([
                    "success" => false,
                    "message" => "Somethings went wrong",
                ],500);
            }

    }

    public function meetingStatusChange(Request $request){
        $input = $request->all();
        $meetingId = $input['meeting_id'];
        $meetingStatus = $input['meeting_status'];
        $statusChangeBy = $input['change_by'];
        $time = date('h:i:s A');
        $endTime = strtotime($time) - strtotime('today');

        if($meetingStatus =='3'){ // 3 meaning stop meeting
            DB::table('meeting_room_booking')->where('meeting_id',$meetingId)->update([
                "end_time"=>$endTime,
            ]);
    
            DB::table('meeting_participent')->where('meeting_id',$meetingId)->update([
                "end_time"=>$endTime,
            ]);  
        }

        DB::table('meeting_room_booking')->where('meeting_id',$meetingId)->update([
            "meeting_status"=>$meetingStatus,
            "approve_by"=>$meetingStatus =="1" ? $statusChangeBy:"",
            "approve_date"=>$meetingStatus =="1" ? date('Y-m-d H:i:s A'):"",
            "cancle_by"=>$meetingStatus =="3" ? $statusChangeBy:"",
            "cancle_date"=>$meetingStatus =="3" ? date('Y-m-d H:i:s A'):"",
        ]);

        DB::table('meeting_participent')->where('meeting_id',$meetingId)->update([
            "meeting_status"=>$meetingStatus,
        ]);

       /* if($meetingStatus =='1'){
             // Mail to meeting participant 
        $meetingInfo = DB::table('meeting_room_booking')->select('*')->where('meeting_id',$meetingId)->first();
        $participantMail = DB::select("select email from npoly_employees where employee_id in ($meetingInfo->participant_id) and active_status = 1");
        $array_values= [];
        foreach($participantMail as $array)
        {
            $array_values[]=$array->email;
        }

        $ccToMail =  array_values($array_values);
        $data['title'] = $meetingInfo->meeting_title;
        $data['description'] = $meetingInfo->meeting_desc;
        $data['meeting_date'] = date('d-M-Y',strtotime($meetingInfo->meeting_date));
        $data['start_time'] = $meetingInfo->start_time;
        $data['end_time'] = $meetingInfo->end_time;
        $data['update_meeting'] = 0;
        $data['room_no'] = DB::table('sa_lookup_data')->select('lookup_data_name')->where('lookup_data_id',$meetingInfo->room_id)->first()->lookup_data_name;

        $to_mail = 'azam.ali@nationalpolymer.net';
        $sent = Mail::send('emails.meeting_mail', $data, function ($email) use ($data, $to_mail,$ccToMail) {
         $email->subject($data['title']);
         $email->from('ticket@nationalpolymer.net');
         $email->to($to_mail);
         $email->cc($ccToMail);
         //$email->bcc($report_bcc_to_mail);
     });
        }*/

       

        return response()->json([
            "success" => true,
            "message" => "Meeting End successfully.",
        ],200);
    }

    public function meetingClosed(Request $request){
        $input = $request->all();
        $meetingId = $input['meeting_id'];
        $closedBy = $input['closed_by'];

        $time = date('h:i:s A');
        $endTime = strtotime($time) - strtotime('today');

        DB::table('meeting_room_booking')->where('meeting_id',$meetingId)->update([
            "end_time"=>$endTime
        ]);

        return response()->json([
            "success" => true,
            "message" => "Meeting End successfully.",
        ],200);
    }
    public function getMeetingParticular(){
        try {

            $results = DB::table('meeting_particular')
                    ->select('name as name:','icon as icon:')
                    ->where('active_status',1)
                    ->get();

            return response()->json([
                "success" => true,
                "status" => 200,
                "message" => "Particular get successfully.",
                "data" => $results
            ],200);
            
            } catch (\Exception $e) {
                return response()->json([
                    "success" => false,
                    "status" => 500,
                    "message" => "Somethings Went Wrong !.",
                ],500);
                
            }
    }
    public function getMeetingCreateInfo(Request $request){
        try {

            $roomInfo = DB::table('sa_lookup_data')
            ->select('lookup_data_id','lookup_data_name')
            ->where('lookup_grp_id',46)
            ->where('active_flag',1)
            ->get();

            $departmentInfo = DB::table('set_department')
                        ->select('id as department_id','department_name')
                        ->where('active_status',1)
                        ->get();

            $particular = DB::table('meeting_particular')
                            ->select('particular_id','name','icon')  
                            ->where('active_status',1)
                            ->get();

            return response()->json([
                "success" => true,
                "status" => 200,
                "message" => "Particular get successfully.",
                "room" => $roomInfo,
                "department" => $departmentInfo,
                "particular" => $particular
            ],200);
            
            } catch (\Exception $e) {
            
                return response()->json([
                    "success" => false,
                    "status" => 500,
                    "message" => "Somethings Went Wrong !.",
                ],500);
            } 
    }

    public function getAvailableTimeSlot(Request $request){
        $input = $request->all();
        $roomId = $input['roomId'];
        $meetingDate = date('Y-m-d',strtotime($input['createDate']));
          
          $existingTimeSlots = DB::select("SELECT TIME_FORMAT(SEC_TO_TIME(start_time), '%h:%i %p') AS start_times,TIME_FORMAT(SEC_TO_TIME(end_time), '%h:%i %p') AS end_times FROM meeting_room_booking
          WHERE room_id = $roomId
          AND meeting_date = '$meetingDate'
          and active_status = 1
          and meeting_status = 1
          ORDER by start_time asc");
          
          $dayStartTime = '9:00 AM';
          $dayEndTime = '6:00 PM';
         
          $dayStartTimeObj = new DateTime($dayStartTime);
          $dayEndTimeObj = new DateTime($dayEndTime);
          
         
          $availableTimeSlots = [];
  
          if(count($existingTimeSlots)> 0){
              if (strtotime($existingTimeSlots[0]->start_times) > strtotime($dayStartTime)) {
                  $availableTimeSlots[] = [
                      'start_times' => $dayStartTime,
                      'end_times' => $existingTimeSlots[0]->start_times,
                  ];
              }
              
              for ($i = 0; $i < count($existingTimeSlots) - 1; $i++) {
                  $currentEndTimeObj = new DateTime($existingTimeSlots[$i]->end_times);
                  $nextStartTimeObj = new DateTime($existingTimeSlots[$i + 1]->start_times);
                 
                  $gapStartTime = $currentEndTimeObj->format('h:i A');
                  $gapEndTime = $nextStartTimeObj->format('h:i A');
                 
                  if ($currentEndTimeObj >= $dayStartTimeObj && $nextStartTimeObj <= $dayEndTimeObj) {
                      $availableTimeSlots[] = ['start_times' => $gapStartTime, 'end_times' => $gapEndTime];
                  }
              }
             
              if (strtotime($existingTimeSlots[count($existingTimeSlots) - 1]->end_times) < strtotime($dayEndTime)) {
                  $availableTimeSlots[] = [
                      'start_times' => $existingTimeSlots[count($existingTimeSlots) - 1]->end_times,
                      'end_times' => $dayEndTime,
                  ];
              }

              return response()->json([
                "success" => true,
                "status" => 200,
                "message" => "Particular get successfully.",
                "available_time" => $availableTimeSlots
            ],200);

          }else{

            $availableTimeSlots = array(array(
                "start_times"=>"09:00 AM",
                "end_times"=>"06:00 PM",
            ));
              
              return response()->json([
                "success" => true,
                "status" => 200,
                "message" => "Particular get successfully.",
                "available_time" => $availableTimeSlots
            ],200);
          }
          
      }

      public function getEmployeeByDept(Request $request){
        $input = $request->all();
        $deptId = $input['department_id'];
        
        try {

            $employeeInfo = DB::table('npoly_employees')
                        ->select('employee_id','employee_name','card_no')
                        ->where('department_id',$deptId)
                        ->where('active_status',1)
                        ->orderBy('user_serial_no','asc')
                        ->get();

            return response()->json([
                "success" => true,
                "status" => 200,
                "message" => "Particular get successfully.",
                "employee_list" => $employeeInfo
            ],200);
            
            } catch (\Exception $e) {
            
                return response()->json([
                    "success" => false,
                    "status" => 500,
                    "message" => "Somethings Went Wrong !.",
                ],500);
            }
      }

      public function meetingCreate(Request $request){
        $input = $request->all();

        $startTime = strtotime($input['start_time']) - strtotime('today');
        $endTime = strtotime($input['end_time']) - strtotime('today');

        $participentId = implode(',',$input['employee_id'] ? $input['employee_id'] :[]);
        $particular_id = implode(',',$input['particular_id'] ? $input['particular_id']: []);
        $employeeId = $input['created_by'];
        $userInfo = DB::table('users')->select('*')->where('employee_number',$employeeId)->first();

        $insertInfo = DB::table('meeting_room_booking')->insert([
            "room_id"=> $input['room_id'],
            "meeting_title"=> $input['meeting_title'],
            "meeting_desc"=> $input['meeting_desc'],
            "meeting_date"=> date('Y-m-d',strtotime($input['meeting_date'])),
            "start_time"=> $startTime,
            "end_time"=> $endTime,
            "participant_id"=> $participentId,
            "guest"=>$input['guest'],
            "no_of_guest"=>$input['guest_no'] ? $input['guest_no'] : 0 ,
            "particular_id"=> $particular_id,
           // "remarks"=> $request->remarks,meeting_date
            "active_status"=> 1,
            "meeting_status"=> 0,
            "created_by"=> $userInfo->id,
           ]);

           // insert participent info
           $participents = $request->employee_id;
           $lastMeetingId = DB::selectOne("SELECT max(meeting_id) meeting_id FROM meeting_room_booking");
           foreach($participents as $key => $value){
            $insertInfo = DB::table('meeting_participent')->insert([
                "room_id"=> $input['room_id'],
                "meeting_id"=> $lastMeetingId->meeting_id,
                "meeting_date"=> date('Y-m-d',strtotime($input['meeting_date'])),
                "start_time"=> $startTime,
                "end_time"=> $endTime,
                "participant_id"=> $value,
                "active_status"=> 1,
                //"created_by"=> Auth::user()->id,
               ]);
    
           }
           
        $data['title'] =$input['meeting_title'];
        $data['description'] =$input['meeting_desc'];
        $data['meeting_date'] = date('d-M-Y',strtotime($input['meeting_date']));
        $data['start_time'] =  $input['start_time'];
        $data['end_time'] =  $input['end_time'];
        $data['name'] = $userInfo->name;
        $data['department_name'] = $userInfo->department_name;
        $data['designation_name'] = $userInfo->designation_name;
        $data['email_address'] = $userInfo->email_address;
        $data['contact_no'] = $userInfo->contact_no;

        $data['room_no'] = DB::table('sa_lookup_data')->select('lookup_data_name')->where('lookup_data_id',$input['room_id'])->first()->lookup_data_name;

        $to_mail = 'admnpil@nationalpolymer.net';
        //$to_mail = 'azam.ali@nationalpolymer.net';
        $sent = Mail::send('emails.admin_meeting_mail', $data, function ($email) use ($data, $to_mail) {
         $email->subject($data['title']);
         $email->from('ticket@nationalpolymer.net');
         $email->to($to_mail);
         //$email->cc($ccToMail);
         //$email->bcc($report_bcc_to_mail);
     });

           return response()->json([
            "success" => true,
            "status" => 200,
            "message" => "Meeting create successfully.",
        ],200);

      }
      public function meetingUpdate(Request $request){
        $input = $request->all();

        $startTime = strtotime($input['start_time']) - strtotime('today');
        $endTime = strtotime($input['end_time']) - strtotime('today');

        $participentId = implode(',',$input['employee_id'] ? $input['employee_id']: []);
        $particular_id = implode(',',$input['particular_id'] ? $input['particular_id']: []);
        $meetingId = $input['meeting_id'];

        $insertInfo = DB::table('meeting_room_booking')->where('meeting_id',$meetingId)->update([
            "room_id"=> $input['room_id'],
            "meeting_title"=> $input['meeting_title'],
            "meeting_desc"=> $input['meeting_desc'],
            "meeting_date"=> date('Y-m-d',strtotime($input['meeting_date'])),
            "start_time"=> $startTime,
            "end_time"=> $endTime,
            "participant_id"=> $participentId,
            "guest"=>$input['guest'],
            "no_of_guest"=>$input['guest_no'] ?$input['guest_no'] : 0,
            "particular_id"=> $particular_id,
           // "remarks"=> $request->remarks,meeting_date
            "active_status"=>$input['status'],
            //"created_by"=> Auth::user()->id,
           ]);

           // insert participent info
           $deleteParticipent = DB::table('meeting_participent')->where('meeting_id',$meetingId)->delete();
           $participents = $request->employee_id;
           foreach($participents as $key => $value){
            $insertInfo = DB::table('meeting_participent')->insert([
                "room_id"=> $input['room_id'],
                "meeting_id"=> $meetingId,
                "meeting_date"=> date('Y-m-d',strtotime($input['meeting_date'])),
                "start_time"=> $startTime,
                "end_time"=> $endTime,
                "participant_id"=> $value,
                "active_status"=> 1,
                //"created_by"=> Auth::user()->id,
               ]);
    
           }
           // mail send to participant
        //    $participantMail = DB::select("select email from npoly_employees where employee_id in ($participentId) and active_status = 1");
        //    $array_values= [];
        //    foreach($participantMail as $array)
        //    {
        //        $array_values[]=$array->email;
        //    }

        //    $ccToMail =  array_values($array_values);
        //    $data['title'] = $input['meeting_title'];
        //    $data['description'] = $input['meeting_desc'];
        //    $data['meeting_date'] = date('d-M-Y',strtotime($input['meeting_date']));
        //    $data['start_time'] = $input['start_time'];
        //    $data['end_time'] = $input['end_time'];
        //    $data['update_meeting'] = 1;
        //    $data['room_no'] = DB::table('sa_lookup_data')->select('lookup_data_name')->where('lookup_data_id',$input['room_id'])->first()->lookup_data_name;

        //    $to_mail = 'azam.ali@nationalpolymer.net';
        //    $sent = Mail::send('emails.meeting_mail', $data, function ($email) use ($data, $to_mail,$ccToMail) {
        //     $email->subject($data['title']);
        //     $email->from('ticket@nationalpolymer.net');
        //     $email->to($to_mail);
        //     $email->cc($ccToMail);
        //     $email->bcc($report_bcc_to_mail);
        // });
           // end
           return response()->json([
            "success" => true,
            "status" => 200,
            "message" => "Meeting updated successfully.",
        ],200);

      }

      static function isTimeRangeOverlap($start1, $end1, $ranges) {
        //$range1_start = $start1;
       // $range1_end = $end1;
    
        foreach ($ranges as $range) {
            $range_start = $range->start_time;
            $range_end = $range->end_time;
    
            // Check if the ranges overlap
            //if ($range1_start < $range_end && $range1_end > $range_start) {
            if ($start1 < $range_end && $end1 > $range_start) {
                return true;
            }
        }
    
        return false;
    }

      public function checkEmpMeeting(Request $request){
        $input = $request->all();
        $employeeId = $input['employee_id'];
        $meetingDate = date('Y-m-d',strtotime($input['create_date']));
        $startTime = strtotime($input['start_time']) - strtotime('today');
        $endTime = strtotime($input['end_time']) - strtotime('today');
        //$startTime = $request->startSecond;
        //$endTime = $request->endSecond;

        $ranges = DB::table('meeting_participent')
                          ->select('start_time','end_time')
                          ->where('meeting_date',$meetingDate)
                          ->where('participant_id',$employeeId)
                          ->where('active_status',1)
                          ->where('meeting_status',1)
                          ->get();

        if ($this::isTimeRangeOverlap($startTime, $endTime, $ranges)) {
            return response()->json([
                "success" => true,
                "status" => 200,
                "meeting" => 1,
            ],200);
        } else {
            return response()->json([
                "success" => true,
                "status" => 200,
                "meeting" => 2,
            ],200);
        }

      }

      public function getSelfMeeting(Request $request){
        $input = $request->all();
        $employeeId = $input['employee_id'];

        $userInfo = DB::table('users')->select('employee_id')->where('employee_number',$employeeId)->first();
        
        $meeting_info = DB::select("SELECT mb.meeting_id,mp.meeting_date,TIME_FORMAT(SEC_TO_TIME(mp.start_time), '%h:%i %p') as start_time ,TIME_FORMAT(SEC_TO_TIME(mp.end_time), '%h:%i %p') as end_time ,mb.meeting_title,mb.meeting_desc,mb.particular_id,
        (SELECT COUNT(participant_id) FROM meeting_participent WHERE meeting_id = mb.meeting_id) as total_participent,mb.guest,mb.no_of_guest,lkp.lookup_data_name as room_no,mb.meeting_status,mb.created_by
        FROM meeting_participent as mp, meeting_room_booking mb,sa_lookup_data as lkp
        WHERE mp.meeting_id = mb.meeting_id
        AND mb.room_id = lkp.lookup_data_id
        and mp.participant_id =$userInfo->employee_id
        and mb.active_status = 1
        ORDER by mp.meeting_id desc");

         foreach( $meeting_info as $key => $meeting ) {
                    
            $meeting_info[ $key]->participent = DB::select("SELECT mp.participant_id,emp.employee_name FROM meeting_participent as mp, npoly_employees as emp
            WHERE mp.participant_id = emp.employee_id
            AND mp.meeting_id = $meeting->meeting_id
            ORDER BY emp.user_serial_no");
            $particularIdIn = $meeting->particular_id?$meeting->particular_id:0;
            $meeting_info[ $key]->services = DB::select("SELECT par.particular_id,par.name,par.icon  FROM meeting_particular par 
            WHERE par.particular_id in ($particularIdIn)");

        }

        return response()->json([
            "success" => true,
            "status" => 200,
            "meeting_info" => $meeting_info,
        ],200);
      }

      public function getMeetingInfoById(Request $request){
        $input = $request->all();
        $meetingId = $input['meeting_id'];

       // $results = DB::table('meeting_room_booking')->select('*')->where('meeting_id',$meetingId)->first();
        $results = DB::select("SELECT meeting_id,room_id,meeting_title,meeting_desc,meeting_date,guest,no_of_guest,TIME_FORMAT(SEC_TO_TIME(start_time), '%h:%i %p') as start_time,TIME_FORMAT(SEC_TO_TIME(end_time), '%h:%i %p') as end_time,participant_id,particular_id  FROM meeting_room_booking
        WHERE meeting_id = $meetingId");

        foreach($results as $key=> $result){
            $results[ $key]->participent_info = DB::select("select employee_id,employee_name,card_no from npoly_employees where employee_id in($result->participant_id) order by user_serial_no");
        }

        $roomInfo = DB::table('sa_lookup_data')
        ->select('lookup_data_id','lookup_data_name')
        ->where('lookup_grp_id',46)
        ->where('active_flag',1)
        ->get();

        $departmentInfo = DB::table('set_department')
                    ->select('id as department_id','department_name')
                    ->where('active_status',1)
                    ->get();

        $particular = DB::table('meeting_particular')
                        ->select('particular_id','name','icon')  
                        ->where('active_status',1)
                        ->get();

            return response()->json([
                "success" => true,
                "status" => 200,
                "message" => "Data get successfully.",
                "meeting_info" => $results,
                "roomInfo" => $roomInfo,
                "departmentInfo" => $departmentInfo,
                "particular" => $particular,
            ],200);
       
      }

      public function checkMeetingRoorm(Request $request){
        $input = $request->all();
        $roomId = $input['roomId'];
        $meetingDate = date('Y-m-d',strtotime($input['meetingDate']));
        $startTime = strtotime($input['startTime']) - strtotime('today');
        $endTime = strtotime($input['endTime']) - strtotime('today');

        $ranges = DB::table('meeting_room_booking')
                        ->select('start_time','end_time')
                        ->where('room_id',$roomId)
                        ->where('meeting_date',$meetingDate)
                        ->where('active_status',1)
                        ->where('meeting_status',1)
                        ->get();
        if ($this::isTimeRangeOverlap($startTime, $endTime, $ranges)) {
            return response()->json([
                "success" => true,
                "status" => 200,
                "meeting" => 1,
            ],200);
            } else {
                return response()->json([
                    "success" => true,
                    "status" => 200,
                    "meeting" => 2,
                ],200);
            }
      }
}
