<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
use DateTime;

class MealController extends Controller
{
    public function getSeflMealInfo(Request $request){
        $input = $request->all();
        $employeeId = $input['employeeId'];
        //dd($employeeId);
        $userInfo = DB::table('users')->select('employee_id')->where('employee_number',$employeeId)->first();
        try {
            //$from = date('Y-m-01');
            //$to = date('Y-m-d', strtotime("+1 day"));
            $from = date('Y-m-d',strtotime($input['start_date']));
            $to = date('Y-m-d',strtotime($input['end_date']));
           
            $results = DB::table('employee_meal')->select('meal_id','meal_date','meal_status')
                        ->where('employee_id',$userInfo->employee_id)
                        ->whereBetween('meal_date', [$from, $to])
                        ->get();
                        
            $reguralStatus = DB::selectOne("SELECT COALESCE((SELECT meal_status FROM employee_meal_setting WHERE employee_id = $userInfo->employee_id),0) AS meal_status");
            

            return response()->json([
                "success" => true,
                "message" => "Data get successfully.",
                "regular_status" => $reguralStatus->meal_status,
                "data" => $results
            ],200);
          
          } catch (\Exception $e) {
          
            return response()->json([
                "success" => false,
                "message" => "Somethings went wrong",
            ],500);
          }
    }
    public function getMealInfo(Request $request){
        $input = $request->all();
        $mealDate = date('Y-m-d',strtotime($input['meal_date']));
        $employeeNumber = $input['employee_number'];
        $userInfo = DB::table('users')->select('employee_id','id','loaction')->where('employee_number',$employeeNumber)->first();
        $loaction =  $userInfo->loaction;
        $today = date('Y-m-d');

        
           
        
        try {
            $today = date('Y-m-d');
            // $results = DB::table('employee_meal as m')
            //             ->leftJoin('npoly_employees as emp','emp.employee_id','=','m.employee_id')
            //             ->leftJoin('sa_lookup_data as lkp','lkp.lookup_data_id','=','emp.department_id')
            //             ->leftJoin('sa_lookup_data as lkp1','lkp1.lookup_data_id','=','emp.designation_id')
            //             ->select('m.meal_id','m.meal_date','m.meal_status','emp.employee_name','emp.email','lkp.lookup_data_name as department_name','lkp1.lookup_data_name as designation_name')
            //             ->where('m.meal_date',$mealDate)    
            //             ->orderBy('emp.user_serial_no')    
            //             ->get(); 

            $results = DB::table('employee_meal as m')
            ->leftJoin('users as usr','usr.employee_id','=','m.employee_id')
            ->leftJoin('npoly_employees as emp','emp.employee_id','=','m.employee_id')
            ->leftJoin('set_department as dept','dept.id','=','usr.department_id')
            ->leftJoin('set_designation as desig','desig.id','=','usr.designation')
            ->select('m.meal_id','m.meal_date','m.meal_status','emp.employee_name','emp.email','dept.department_name','desig.designation_name','usr.religion')
            ->where('m.meal_date',$mealDate)    
            ->where('usr.loaction',$loaction)    
            ->get(); 

            $guestMeal = DB::selectOne("select count(total_meal) as guest_meal from guest_meal where meal_date = '$mealDate' and request_status = 1 ")->guest_meal;
           
            return response()->json([
                "success" => true,
                "message" => "Data get successfully.",
                "guest_meal" => $guestMeal,
                "staff_meal" => 2,
                "data" => $results,
            ],200);
          
          } catch (\Exception $e) {
          
            return response()->json([
                "success" => false,
                "message" => "Somethings went wrong",
            ],500);
          }
    }

    public function storeGuestMeal(Request $request){
       $input = $request->all();
       $mealDate = $input['meal_date'];
       $total_meal = $input['total_meal'];
       $request_reason = $input['request_reason'];
       $employeeNumber = $input['employee_number'];
       $userInfo = DB::table('users')->select('employee_id','id','department_id')->where('employee_number',$employeeNumber)->first();
            DB::table('guest_meal')->insert([
                "request_emp" => $userInfo->employee_id,
                "department_id" => $userInfo->department_id,
                "meal_date" => date('Y-m-d',strtotime($mealDate)),
                "total_meal" =>$total_meal,
                "request_reason" =>$request_reason,
                "request_status" =>1,
                "active_status" =>1,
                "created_by"=>$userInfo->id,
                "created_at" => date('Y-m-d h:i:s A')
            ]);

            return response()->json([
                "success" => true,
                "message" => "Request created  successfully."
            ],200);  
        
    }

    public function guestMealEdit(Request $request){

            $input = $request->all();
            $guestMealId = $input['guest_meal_id'];
            $guestMealInfo = DB::table('guest_meal')->select('*')->where('id',$guestMealId)->where('request_status',1)->first();

            return response()->json([
                "success" => true,
                "status" => 200,
                "message" => "Request created  successfully.",
                "data" => $guestMealInfo
            ],200); 

    }
    public function guestMealUpdate(Request $request){
        $input = $request->all();
        $guestMealId = $input['guest_meal_id'];
        $mealDate = $input['meal_date'];
        $total_meal = $input['total_meal'];
        $status = $input['status'];
        $request_reason = $input['request_reason'];
        $updated_by = $input['updated_by'];

        try {

           $updateGusetMealInfo = DB::table('guest_meal')->where('id',$guestMealId)->update([
                "meal_date" => date('Y-m-d',strtotime($mealDate)),
                "total_meal" =>$total_meal,
                "request_reason" =>$request_reason,
                "updated_by" =>$updated_by,
                "active_status" =>$status =='0'?0:1,
                "updated_at" =>date('Y-m-d h:i A'),
           ]);
           return response()->json([
            "success" => true,
            "status" => 200,
            "message" => "Request update  successfully."
        ],200); 
          
          } catch (\Exception $e) {
            return response()->json([
                "success" => true,
                "status" => 500,
                "message" => "Somethings went wrong !"
            ],500); 
             
          }
    }

    public function guestMealIndex(Request $request){
        $input = $request->all();
        $employeeNumber = $input['employee_number'];
        $userInfo = DB::table('users')->select('employee_id','userlvl_id','department_id')->where('employee_number',$employeeNumber)->first();

        $userLvlId = $userInfo->userlvl_id;
        $employeeId = $userInfo->employee_id;
        $departmentId = $userInfo->department_id;

        if($userLvlId =='7'){ // employee
            $results = DB::table('guest_meal as gmeal')
            ->leftJoin('npoly_employees as emp','emp.employee_id','=','gmeal.request_emp')
            ->leftJoin('set_department as dept','dept.id','=','gmeal.department_id')
            ->select('gmeal.id','gmeal.meal_date','gmeal.total_meal','gmeal.request_reason','gmeal.request_status','emp.employee_name','dept.department_name','emp.employee_number')
            ->where('request_emp',$employeeId)
            ->where('gmeal.active_status',1)
            ->where('gmeal.department_id', $departmentId)
            ->orderBy('gmeal.id','desc')
            ->get();
        }else if($userLvlId =='6'){
            $results = DB::table('guest_meal as gmeal')
            ->leftJoin('npoly_employees as emp','emp.employee_id','=','gmeal.request_emp')
            ->leftJoin('set_department as dept','dept.id','=','gmeal.department_id')
            ->select('gmeal.id','gmeal.meal_date','gmeal.total_meal','gmeal.request_reason','gmeal.request_status','emp.employee_name','dept.department_name','emp.employee_number')
            ->where('gmeal.active_status',1)
           // ->where('gmeal.request_status','!=',1)
            ->orderBy('gmeal.id','desc')
            ->get();
        }else if($userLvlId =='16'){
            $results = DB::table('guest_meal as gmeal')
            ->leftJoin('npoly_employees as emp','emp.employee_id','=','gmeal.request_emp')
            ->leftJoin('set_department as dept','dept.id','=','gmeal.department_id')
            ->select('gmeal.id','gmeal.meal_date','gmeal.total_meal','gmeal.request_reason','gmeal.request_status','emp.employee_name','dept.department_name','emp.employee_number')
            ->where('gmeal.active_status',1)
            ->where('gmeal.department_id', $departmentId)
           // ->where('gmeal.request_status','!=',1)
            ->orderBy('gmeal.id','desc')
            ->get();
        }else{
            $results = DB::table('guest_meal as gmeal')
            ->leftJoin('npoly_employees as emp','emp.employee_id','=','gmeal.request_emp')
            ->leftJoin('set_department as dept','dept.id','=','gmeal.department_id')
            ->select('gmeal.id','gmeal.meal_date','gmeal.total_meal','gmeal.request_reason','gmeal.request_status','emp.employee_name','dept.department_name','emp.employee_number')
            ->where('gmeal.department_id', $departmentId)
            ->where('gmeal.active_status',1)
            ->orderBy('gmeal.id','desc')
            ->get();
        }

        return response()->json([
            "success" => true,
            "message" => "Request created  successfully.",
            "user_lvel_id" => $userLvlId,
            "data" => $results,
            
        ],200);  
    }

    public function serachGuestMeal(Request $request){
        $input = $request->all();

        $from = date('Y-m-d',strtotime($input['from_date']));
        $to = date('Y-m-d',strtotime($input['to_date']));

        $results = DB::table('guest_meal as gmeal')
            ->leftJoin('npoly_employees as emp','emp.employee_id','=','gmeal.request_emp')
            ->leftJoin('users as usr','emp.employee_number','=','usr.employee_number')
            ->leftJoin('set_department as dept','dept.id','=','gmeal.department_id')
            ->select('gmeal.id','gmeal.meal_date','gmeal.total_meal','gmeal.request_reason','gmeal.request_status','emp.employee_name','dept.department_name','usr.contact_no')
            ->where('gmeal.active_status',1)
            ->where('gmeal.request_status','!=',1)
            ->whereBetween('gmeal.meal_date', [$from, $to])
            ->orderBy('gmeal.id','desc')
            ->get();

            return response()->json([
                "success" => true,
                "status" => 200,
                "message" => "Request created  successfully.",
                "data" => $results,
                
            ],200);  
    }

    public function guestMealStatusChange(Request $request){

        $input = $request->all();
        $guestMealId = $input['guest_meal_id'];
        $request_status = $input['request_status'];
        $employee_number = $input['employee_number'];

        $updateStatus = DB::table('guest_meal')->where('id',$guestMealId)->update([
            "request_status"=> $request_status,
            "admin_approve_id"=> $request_status =='3'? $employee_number:"",
            "admin_approve_date"=> $request_status =='3'? date('Y-m-d h:i A'):"",
            "respective_person_id"=> $request_status =='2'? $employee_number:"",
            "request_approve_date"=> $request_status =='2'? date('Y-m-d h:i A'):"",
            "cancle_by"=> $request_status =='0'?$employee_number:"",
            "cancle_date"=> $request_status =='0'? date('Y-m-d h:i A'):"",
        ]);

        return response()->json([
            "success" => true,
            "message" => "Status change successfully."
            
        ],200);  

    }

    public function searchEmpMealByDate(Request $request){

        $input = $request->all();
        $from = date('Y-m-d',strtotime($input['fromDate']));
        $to = date('Y-m-d',strtotime($input['toDate']));
        $employeeId = !empty($input['employeeId'])?$input['employeeId']:"";
        
        $condition = '';
        if(!empty($employeeId)){
            $condition .=" and m.employee_id = $employeeId";
        }

        try {

            $results = DB::select("select m.meal_id,m.meal_date,m.meal_status,emp.employee_name, lkp.lookup_data_name as department_name,lkp1.lookup_data_name as designation_name from employee_meal as m
                                    left join npoly_employees as emp on emp.employee_id = m.employee_id 
                                    left join sa_lookup_data as lkp on lkp.lookup_data_id = emp.department_id 
                                    left join sa_lookup_data as lkp1 on lkp1.lookup_data_id = emp.designation_id 
                                    where m.meal_date between '$from' and '$to'
                                    $condition
                                    and m.active_status = 1
                                    order by emp.user_serial_no
                                    ");
        return response()->json([
            "success" => true,
            "message" => "Data get successfully.",
            "data" => $results
        ],200);
          
          } catch (\Exception $e) {
          
            return response()->json([
                "success" => false,
                "message" => "Somethings went wrong",
            ],500);
          }
    }

    public function getTomorrowMeal(Request $request){

        $tomorrow = date('Y-m-d', strtotime("+1 day"));
        
        try {

            $results = DB::table('employee_meal as m')
            ->leftJoin('npoly_employees as emp','emp.employee_id','=','m.employee_id')
            ->leftJoin('sa_lookup_data as lkp','lkp.lookup_data_id','=','emp.department_id')
            ->leftJoin('sa_lookup_data as lkp1','lkp1.lookup_data_id','=','emp.designation_id')
            ->select('m.meal_id','m.meal_date','m.meal_status','emp.employee_name','lkp.lookup_data_name as department_name','lkp1.lookup_data_name as designation_name')
            ->where('m.meal_date',$tomorrow)    
            ->orderBy('emp.user_serial_no')    
            ->get(); 
            return response()->json([
                "success" => true,
                "message" => "Data get successfully.",
                "data" => $results
            ],200);
          
          } catch (\Exception $e) {
          
            return response()->json([
                "success" => false,
                "message" => "Somethings went wrong",
            ],500);
          }
    }

    public function monthWiseMeal(Request $request){
        $input = $request->all();

        $fromDate = date('Y-m-d',strtotime($input['fromDate']));
        $toDate = date('Y-m-d',strtotime($input['toDate']));

        $employeeNumber = $input['employee_number'];
        $userInfo = DB::table('users')->select('employee_id','id','loaction')->where('employee_number',$employeeNumber)->first();
        $loaction =  $userInfo->loaction;

        
        

        try {

            // $results = DB::select("SELECT DISTINCT m.employee_id,emp.employee_name,emp.email,lkp.lookup_data_name as department_name, lkp1.lookup_data_name as designation_name
            //                                         FROM employee_meal as m, npoly_employees as emp,sa_lookup_data as lkp, sa_lookup_data as lkp1
            //                                         WHERE m.employee_id = emp.employee_id
            //                                         AND emp.department_id = lkp.lookup_data_id
            //                                         AND emp.designation_id = lkp1.lookup_data_id
            //                                         AND m.meal_date BETWEEN '$fromDate' AND '$toDate'
            //                                         ORDER BY emp.user_serial_no");
            //dd($results);

            $results = DB::select("select DISTINCT m.employee_id,emp.employee_name,emp.email,dept.department_name,desig.designation_name from employee_meal as m, npoly_employees as emp,set_department as dept,set_designation as desig
            WHERE m.employee_id = emp.employee_id
            AND emp.department_id = dept.id
            AND emp.designation_id = desig.id
            AND m.meal_date BETWEEN '$fromDate' AND '$toDate'");

            foreach ($results as $key => $value) {
                    $results[ $key]->total_meal = DB::selectOne("SELECT COUNT(meal_id) TOTAL_MEAL FROM employee_meal WHERE meal_status = 1 AND employee_id = $value->employee_id AND meal_date BETWEEN '$fromDate' AND '$toDate'")->TOTAL_MEAL;
            }
            return response()->json([
                "success" => true,
                "message" => "Data get successfully.",
                "data" => $results
            ],200);
          
          } catch (\Exception $e) {
          
              return $e->getMessage();
          }
    }

    public function getMealStatus(Request $request){

        $input = $request->all();
        $employeeId = $input['employeeId'];
        $tomorrow = date('Y-m-d', strtotime("+1 day"));

        $continueMealStatus = DB::table('employee_meal_setting')->select('meal_status')->where('employee_id',$employeeId)->first();
        $tomorrow = DB::table('employee_meal')->select('meal_status')->where('meal_date',$tomorrow)->where('employee_id',$employeeId)->first();


        return response()->json([
            "success" => true,
            "message" => "Data get successfully.",
            "continue" =>!empty($continueMealStatus)? $continueMealStatus->meal_status :0,
            "tomorrow" =>!empty($tomorrow)? $tomorrow->meal_status :0,
        ],200);
        
    }

    public function changeMealStatus(Request $request){

        $input = $request->all();
        $employeeId = $input['employeeId'];
        $mealStatus = $input['meal_status'];
        $reqFor = $input['req_for'];
        $tomorrow = date('Y-m-d', strtotime("+1 day"));
        $userInfo = DB::table('users')->select('employee_id','id')->where('employee_number',$employeeId)->first();
        if($reqFor =='T'){
            $checkTmroMeal = DB::table('employee_meal')->select('meal_id')->where('employee_id',$userInfo->employee_id)->where('meal_date',$tomorrow)->first();
            //dd($checkTmroMeal);
            if(!empty($checkTmroMeal->meal_id)){
                DB::table('employee_meal')->where('meal_id',$checkTmroMeal->meal_id)->where('meal_date',$tomorrow)->update([
                    "meal_status" =>$mealStatus,
                    "updated_by" =>$userInfo->id,
                    "updated_at" =>date('Y-m-d h:i:s A'),
                ]);
            }else{
                DB::table('employee_meal')->insert([
                    "employee_id" =>$userInfo->employee_id,
                    "meal_date" =>$tomorrow,
                    "meal_status" =>$mealStatus,
                    "active_status" =>1,
                    "created_by" =>$userInfo->id,
                    "created_at" =>date('Y-m-d h:i:s A'),
                ]);
            }
           
            return response()->json([
                "success" => true,
                "message" => "Data update successfully.",
            ],200);
        }else{
            
            $cheeckMealSetting = DB::table('employee_meal_setting')->select('id')->where('employee_id',$userInfo->employee_id)->first();
            if(!empty($cheeckMealSetting->id)){
                DB::table('employee_meal_setting')->where('employee_id',$userInfo->employee_id)->update([
                    "meal_status" =>$mealStatus,
                    "updated_by" =>$userInfo->id,
                    "updated_at" =>date('Y-m-d h:i:s A'),
                ]);
            }else{
                DB::table('employee_meal_setting')->insert([
                    "employee_id" =>$userInfo->employee_id,
                    "meal_status" =>$mealStatus,
                    "created_by" =>$userInfo->id,
                    "active_status" =>1,
                    "action_from" =>1,
                    "created_at" =>date('Y-m-d h:i:s A'),
                ]);
            }
            return response()->json([
                "success" => true,
                "message" => "Data update successfully.",
            ],200);
        }


    }

    static  function getDatesExcludingFriday($startDate, $endDate) {
        $dates = array();
    
        $currentDate = new DateTime($startDate);
        $endDate = new DateTime($endDate);
    
        while ($currentDate <= $endDate) {
            // Check if the current day is not a Friday (5 is the index for Friday in PHP)
            if ($currentDate->format('N') != 5) {
                $dates[] = $currentDate->format('Y-m-d');
            }
    
            // Move to the next day
            $currentDate->modify('+1 day');
        }
    
        return $dates;
    }
    public function checkPrePlan(Request $request){
        $input = $request->all();
        $employeeNumber = $input['employee_number'];
        $userInfo = DB::table('users')->select('id','employee_id')->where('employee_number',$employeeNumber)->first();

        $tomorrow = strtotime("+1 day");
        $tomorrowDate = date("Y-m-d", $tomorrow);
        $lastDayOfMonth = date('Y-m-t');
        $today = date('Y-m-d');

        // $checkMealWithPrePlan =  DB::select("select meal_id from employee_meal where employee_id = $userInfo->employee_id
        //        and meal_date between '$tomorrowDate' and '$lastDayOfMonth' and pre_plan_meal = 1");
        $checkMealWithPrePlan =  DB::select("select meal_id from employee_meal where employee_id = $userInfo->employee_id
        and meal_date > '$today' and pre_plan_meal = 1");
        if(!empty($checkMealWithPrePlan)){
            return response()->json([
                "success" => true,
                "pre_plan_meal" => 1,
            ],200); 
        }else{
            return response()->json([
                "success" => true,
                "pre_plan_meal" => 0,
            ],200); 
        }

    }
    public function selfMealCreate(Request $request){
        $input = $request->all();
        $employeeNumber = $input['employee_number'];
        $userInfo = DB::table('users')->select('id','employee_id','loaction')->where('employee_number',$employeeNumber)->first();
        //dd($userInfo);
        $mealType = $input['regular_meal'];
        $changePrePlanMeal = $input['cheange_pre_plan'];

        // change meal setting info
        $checkEmpMealSetting = DB::table('employee_meal_setting')->select('id')->where('employee_id',$userInfo->employee_id)->first();
        if(!empty($checkEmpMealSetting)){
            $update = DB::table('employee_meal_setting')->where('id',$checkEmpMealSetting->id)->update([
                "meal_status"=>$mealType,
                "updated_by"=>$userInfo->id,
                "updated_at"=>date('Y-m-d H:i:s A'),
            ]);
        }else{
            $update = DB::table('employee_meal_setting')->insert([
                "employee_id"=>$userInfo->employee_id,
                "meal_status"=>$mealType,
                "action_from"=>1,
                "active_status"=>1,
                "created_by"=>$userInfo->id,
                "created_at"=>date('Y-m-d H:i:s A'),
            ]);
        }
       

        ///
        
        $tomorrow = strtotime("+1 day");
        $tomorrowDate = date("Y-m-d", $tomorrow);
        $lastDayOfMonth = date('Y-m-t');
        $today = date('Y-m-d');

        // $mealDate = DB::select("select meal_id, meal_date,meal_status from employee_meal where employee_id = $userInfo->employee_id
        // and meal_date between '$tomorrowDate' and '$lastDayOfMonth'");

        //
        $mealDate = DB::select("select meal_id, meal_date,meal_status from employee_meal where employee_id = $userInfo->employee_id
        and meal_date > '$today'");

        if($mealType =="1"){
            if($changePrePlanMeal=='0'){ // o means no changes pre plan meal
                // regular on no change pre plan meal
            //    $checkMealWithouPrePlan =  DB::select("select meal_id, meal_date,meal_status from employee_meal where employee_id = $userInfo->employee_id
            //    and meal_date between '$tomorrowDate' and '$lastDayOfMonth' and pre_plan_meal = 0");

               $checkMealWithouPrePlan =  DB::select("select meal_id, meal_date,meal_status from employee_meal where employee_id = $userInfo->employee_id
               and meal_date > '$today' and pre_plan_meal = 0");
               if(!empty($checkMealWithouPrePlan)){
                foreach ($checkMealWithouPrePlan as $key => $value) {
                    // without pre plan meal status update
                    $updateMeal = DB::table('employee_meal')->where('employee_id',$userInfo->employee_id)->where('meal_date',$value->meal_date)->update([
                        //"meal_status"=>$value->meal_status == 1 ? 0: 1, 
                        "meal_status"=>1, 
                        "active_status"=>1, 
                        "updated_by"=>$userInfo->id, 
                        "updated_at"=>date('Y-m-d H:i:s A'), 
                    ]);
                  
                }
                  
                return response()->json([
                    "success" => true,
                    "message" => "Meal Update successfully.",
                ],200);
               }else{
                $fromDate = date('Y-m-d', strtotime('+1 day'));
                $toDate = date('Y-m-t'); 
                $mealDateExpectFir = $this::getDatesExcludingFriday($fromDate,$toDate);
                foreach($mealDateExpectFir as $value){
                    // 
                    $insertMeal = DB::table('employee_meal')->insert([
                        "employee_id"=>$userInfo->employee_id, 
                        "loaction"=>$userInfo->loaction, 
                        "meal_date"=>$value, 
                        "meal_status"=>1, 
                        "active_status"=>1, 
                        "created_by"=>$userInfo->id, 
                        "created_at"=>date('Y-m-d H:i:s A'), 
                    ]);
                }
                return response()->json([
                    "success" => true,
                    "message" => "Meal Create successfully.",
                ],200);   
               }

            }else{
                if(!empty($mealDate)){
                    foreach ($mealDate as $key => $value) {
                        $updateMeal = DB::table('employee_meal')->where('employee_id',$userInfo->employee_id)->where('meal_date',$value->meal_date)->update([
                            "meal_status"=>1, 
                            "pre_plan_meal"=>0, 
                            "active_status"=>1, 
                            "updated_by"=>$userInfo->id, 
                            "updated_at"=>date('Y-m-d H:i:s A'), 
                        ]); 
                    }
                    return response()->json([
                        "success" => true,
                        "message" => "Meal Update successfully.",
                    ],200);
                }else{
                $fromDate = date('Y-m-d', strtotime('+1 day'));
                $toDate = date('Y-m-t'); 
                $mealDateExpectFir = $this::getDatesExcludingFriday($fromDate,$toDate);
                foreach($mealDateExpectFir as $value){
                    $insertMeal = DB::table('employee_meal')->insert([
                        "employee_id"=>$userInfo->employee_id,
                        "loaction"=>$userInfo->loaction, 
                        "meal_date"=>$value, 
                        "meal_status"=>1, 
                        "active_status"=>1, 
                        "created_by"=>$userInfo->id, 
                        "created_at"=>date('Y-m-d H:i:s A'), 
                    ]);
                }
                return response()->json([
                    "success" => true,
                    "message" => "Meal Create successfully.",
                ],200);      
                }
            };

        }else if($mealType=="0"){
            if($changePrePlanMeal=='0'){
            //     $checkMealWithouPrePlan =  DB::select("select meal_id, meal_date,meal_status from employee_meal where employee_id = $userInfo->employee_id
            //    and meal_date between '$tomorrowDate' and '$lastDayOfMonth' and pre_plan_meal = 0");

               $checkMealWithouPrePlan =  DB::select("select meal_id, meal_date,meal_status from employee_meal where employee_id = $userInfo->employee_id
               and meal_date > '$today' and pre_plan_meal = 0");

                if(!empty($mealDate)){
                    foreach ($checkMealWithouPrePlan as $key => $value) {
                        $updateMeal = DB::table('employee_meal')->where('employee_id',$userInfo->employee_id)->where('meal_date',$value->meal_date)->update([
                           // "meal_status"=>$value->meal_status == 1 ? 0: 1,
                            "meal_status"=>$value->meal_status == 0,
                            "active_status"=>1, 
                            "updated_by"=>$userInfo->id, 
                            "updated_at"=>date('Y-m-d H:i:s A'), 
                        ]); 
                    }
                }
                return response()->json([
                    "success" => true,
                    "message" => "Meal Updated successfully.",
                ],200); 
            }else{
               if(!empty($mealDate)){
                foreach ($mealDate as $key => $value) {
                    $updateMeal = DB::table('employee_meal')->where('employee_id',$userInfo->employee_id)->where('meal_date',$value->meal_date)->update([
                        "meal_status"=>0, 
                        "pre_plan_meal"=>0, 
                        "active_status"=>1, 
                        "updated_by"=>$userInfo->id, 
                        "updated_at"=>date('Y-m-d H:i:s A'), 
                    ]); 
                }
                return response()->json([
                    "success" => true,
                    "message" => "Meal Updated successfully.",
                ],200);   
               }
            };
        }
    }

    public function mealReport(Request $request){

        $input = $request->all();
        $fromDate = date('Y-m-d',strtotime($input['fromDate']));
        $toDate = date('Y-m-d',strtotime($input['toDate']));

        $results = DB::select("SELECT DISTINCT meal.employee_id,emp.employee_name,
        (select COUNT(meal_id) FROM employee_meal  WHERE employee_id =meal.employee_id and meal_date BETWEEN '$fromDate' AND '$toDate' AND meal_status = 1) total_meal,lkp.LOOKUP_DATA_NAME as department_name,lkp1.lookup_data_name as desingantio_name
        FROM employee_meal as meal,npoly_employees as emp, sa_lookup_data as lkp,sa_lookup_data as lkp1
        WHERE meal.employee_id = emp.employee_id
        and emp.department_id = lkp.LOOKUP_DATA_ID
        and emp.designation_id = lkp1.LOOKUP_DATA_ID
        and meal_date BETWEEN '$fromDate' AND '$toDate'
        ORDER BY emp.user_serial_no");

        return response()->json([
            "success" => true,
            "message" =>"Data get successfully",
            "data" => $results,
        ],200); 

    }

    // public function selfMealCreate1(Request $request){
    //     $input = $request->all();
    //     $employeeNumber = $input['employee_number'];
    //     $userInfo = DB::table('users')->select('id','employee_id')->where('employee_number',$employeeNumber)->first();
    //     $mealType = $input['regular_meal'];
    //     //$changePrePlanMeal = $input['cheange_pre_plan'];

    //     // change meal setting info
    //     $checkEmpMealSetting = DB::table('employee_meal_setting')->select('id')->where('employee_id',$userInfo->employee_id)->first();
    //     if(!empty($checkEmpMealSetting)){
    //         $update = DB::table('employee_meal_setting')->where('id',$checkEmpMealSetting->id)->update([
    //             "meal_status"=>$mealType,
    //             "updated_by"=>$userInfo->id,
    //             "updated_at"=>date('Y-m-d H:i:s A'),
    //         ]);
    //     }else{
    //         $update = DB::table('employee_meal_setting')->insert([
    //             "employee_id"=>$userInfo->employee_id,
    //             "meal_status"=>$mealType,
    //             "action_from"=>1,
    //             "active_status"=>1,
    //             "created_by"=>$userInfo->id,
    //             "created_at"=>date('Y-m-d H:i:s A'),
    //         ]);
    //     }
       

    //     ///
        
    //     $tomorrow = strtotime("+1 day");
    //     $tomorrowDate = date("Y-m-d", $tomorrow);
    //     $lastDayOfMonth = date('Y-m-t');

    //     $mealDate = DB::select("select meal_id, meal_date,meal_status from employee_meal where employee_id = $userInfo->employee_id
    //     and meal_date between '$tomorrowDate' and '$lastDayOfMonth'");

    //     if($mealType =="1"){
    //         if(!empty($mealDate)){
    //             foreach($mealDate as $value){
    //                 //dd($value);exit;
    //                 $updateMeal = DB::table('employee_meal')->where('meal_id',$value->meal_id)->update([
    //                     //"meal_status"=>$value->meal_status == 1 ? 0: 1, 
    //                     "meal_status"=>1, 
    //                     "active_status"=>1, 
    //                     "updated_by"=>$userInfo->id, 
    //                     "updated_at"=>date('Y-m-d H:i:s A'), 
    //                 ]);
    //             }
    //             return response()->json([
    //                 "success" => true,
    //                 "message" => "Meal Update successfully.",
    //             ],200);  
    //         }else{
    //             $fromDate = date('Y-m-d', strtotime('+1 day'));
    //             $toDate = date('Y-m-t'); 
    //             $mealDateExpectFir = $this::getDatesExcludingFriday($fromDate,$toDate);
    //             foreach($mealDateExpectFir as $value){
    //                 // 
    //                 $insertMeal = DB::table('employee_meal')->insert([
    //                     "employee_id"=>$userInfo->employee_id, 
    //                     "meal_date"=>$value, 
    //                     "meal_status"=>1, 
    //                     "active_status"=>1, 
    //                     "created_by"=>$userInfo->id, 
    //                     "created_at"=>date('Y-m-d H:i:s A'), 
    //                 ]);
    //             }
    //             return response()->json([
    //                 "success" => true,
    //                 "message" => "Meal Create successfully.",
    //             ],200);   
    //         }
    //     }else if($mealType=="0"){
    //        if(!empty($mealDate)){
    //         foreach($mealDate as $value){
    //             $updateMeal = DB::table('employee_meal')->where('employee_id',$userInfo->employee_id)->where('meal_date',$value->meal_date)->update([
    //                 //"meal_status"=>$value->meal_status == 1 ? 0: 1, 
    //                 "meal_status"=>0, 
    //                 "active_status"=>1, 
    //                 "updated_by"=>$userInfo->id, 
    //                 "updated_at"=>date('Y-m-d H:i:s A'), 
    //             ]);
    //         }
           
            
    //         return response()->json([
    //             "success" => true,
    //             "message" => "Meal Update successfully.",
    //         ],200);
    //        }
    //     }
    // }

    public function checkEmpMealStatusByDate(Request $request){
        $input = $request->all();
        $mealDate = date('Y-m-d',strtotime($input['meal_date']));
        $employeeNumber = $input['employee_number'];

        $userInfo = DB::table('users')->select('employee_id')->where('employee_number',$employeeNumber)->first();

        $mealStatus = DB::table('employee_meal')->select('meal_status')
                        ->where('employee_id',$userInfo->employee_id)
                        ->where('meal_date',$mealDate)
                        ->first();
        
        if(!empty($mealStatus)){
            return response()->json([
                "success" => true,
                "meal_status" => $mealStatus->meal_status,
            ],200);
        }else{
            return response()->json([
                "success" => true,
                "meal_status" => 3,
            ],200);
        }

        
    }
    public function updateSelfMealStatus(Request $request){

        $input = $request->all();
        $mealDate = date('Y-m-d',strtotime($input['meal_date']));
        $employeeNumber = $input['employee_number'];
        $mealStatus = $input['meal_status'];
        
        $userInfo = DB::table('users')->select('id','employee_id','loaction')->where('employee_number',$employeeNumber)->first();
        $mealInfo = DB::table('employee_meal')
                        ->select('meal_id')
                        ->where('employee_id',$userInfo->employee_id)
                        ->where('meal_date',$mealDate)
                        ->get();
     
        if(sizeof($mealInfo)> 0){
            $updateMeal = DB::table('employee_meal')
                ->where('employee_id',$userInfo->employee_id)
                ->where('meal_date',$mealDate)->update([
                    "meal_status"=> $mealStatus,
                    "pre_plan_meal"=> 1,
                ]);
                return response()->json([
                    "success" => true,
                    "message" => 'Meal Status Updated Successfully',
                ],200);
        }else{
            $insertMeal = DB::table('employee_meal')->insert([
                "employee_id"=>$userInfo->employee_id, 
                "loaction"=>$userInfo->loaction, 
                "meal_date"=>$mealDate, 
                "meal_status"=>1, 
                "active_status"=>1,
                "pre_plan_meal"=> 1, 
                "created_by"=>$userInfo->id, 
                "created_at"=>date('Y-m-d H:i:s A'), 
            ]);
            return response()->json([
                "success" => true,
                "message" => 'Meal Created Successfully',
            ],200);
        }
    }
}
