<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Image;

class AttendanceController extends Controller
{
    public function attendanceStore1(Request $request){
        {
            $request->validate([
                'image' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
            ]);
        
            $file = $request->file('image');
            $path = $file->store('uploads', 'attendance');
            $fullUrl = 'http://182.163.98.54/attendance_image/' . $path;
        
            return response()->json([
                'path' => $path,
                'url' => $fullUrl,
                'message' => 'Image uploaded successfully!',
            ]);
        }
    }

    public function attendanceStore2(Request $request){
            if ($request->hasFile('file')) {
                $file = $request->file('file');
                $fileName = time() . '_' . $file->getClientOriginalName();
                $path = $file->store('uploads', 'attendance');
                $fullUrl = 'http://182.163.98.54/attendance_image/' . $path;

                return response()->json([
                    'message' => 'File uploaded successfully',
                    'file_path' => $path,
                    'url' => $fullUrl,
                ], 200);
            }

            return response()->json(['message' => 'No file uploaded'], 400);
    }

    public function attendanceStore3(Request $request)
    {
        if ($request->hasFile('file')) {
            $file = $request->file('file');
            $originalName = $file->getClientOriginalName();
            $fileName = time() . '-' . $originalName;
    
            // Resize and save the image
            $image = Image::make($file->getRealPath());
            $image->resize(300, 300, function ($constraint) {
                $constraint->aspectRatio(); // Maintain aspect ratio
                $constraint->upsize(); // Prevent upsizing
            });
            // Set the path to save the image
            $path = $file->store('uploads', 'attendance');
            //$path = public_path('attendance_image/' . $fileName);
    
            // Save the resized image
            //$image->save($path);
    
            // Generate the full URL for the saved image
            $fullUrl = 'http://182.163.98.54/attendance_image/' . $path;
    
            return response()->json([
                'message' => 'File uploaded and resized successfully',
                'file_path' => $path,
                'url' => $fullUrl,
            ], 200);
        }
    
        //return response()->json(['message' => 'No file uploaded'], 400);
        return response()->json([
            'message' => 'File uploaded and resized successfully',
            'file_path' => '',
            'url' => '',
        ], 200);
    }

    public function attendanceStore(Request $request)
    {
        // Retrieve the external path from the filesystem config
        $externalPath = config('filesystems.disks.attendance.root');
        
        // Dump the path to check its correctness
        //dd($externalPath);  // This will show the path to the external directory
    
        if ($request->hasFile('file')) {
            $file = $request->file('file');
            $originalName = $file->getClientOriginalName();
            $fileName = time() . '-' . $originalName;
    
            // Resize the image
            $image = Image::make($file->getRealPath());
            $image->resize(300, 300, function ($constraint) {
                $constraint->aspectRatio(); // Maintain aspect ratio
                $constraint->upsize(); // Prevent upsizing
            });
    
            // Save the file to the external path
            $path = $externalPath . '/' . $fileName;
    
            try {
                $image->save($path);
            } catch (\Intervention\Image\Exception\NotWritableException $e) {
                return response()->json(['message' => 'Error saving file: ' . $e->getMessage()], 500);
            }
    
            // Generate the full URL (adjust according to your web server)
            $fullUrl = 'http://182.163.98.54/attendance_image/' . $fileName;
    
            return response()->json([
                'message' => 'File uploaded and resized successfully',
                'file_path' => $path,
                'url' => $fullUrl,
            ], 200);
        }
    
        //return response()->json(['message' => 'No file uploaded'], 400);
        return response()->json([
            'message' => 'File uploaded and resized successfully',
            'file_path' => '',
            'url' => '',
        ], 200);
    }
    

}
